/*
 * Decompiled with CFR 0.152.
 */
package hec.data.stream;

import hec.data.location.LocationTemplate;
import hec.data.stream.IStream;
import java.util.Objects;

public class StreamImpl
implements IStream {
    private Boolean _startsDownstream = null;
    private String _officeId = null;
    private String _flowsIntoStream = null;
    private Double _flowsIntoStation = null;
    private String _flowsIntoBank = null;
    private String _divertsFromStream = null;
    private Double _divertsFromStation = null;
    private String _divertsFromBank = null;
    private Double _length = null;
    private Double _slope = null;
    private String _comment = null;
    private String _id = null;
    private LocationTemplate _locationTemplate;
    private boolean _modified = false;

    public StreamImpl() {
    }

    public StreamImpl(IStream stream) {
        this._startsDownstream = stream.startsDownstream();
        this._officeId = stream.getOfficeId();
        this._flowsIntoStream = stream.getFlowsIntoStream();
        this._flowsIntoBank = stream.getFlowsIntoBank();
        this._flowsIntoStation = stream.getFlowsIntoStation();
        this._divertsFromBank = stream.getDivertsFromBank();
        this._divertsFromStation = stream.getDivertsFromStation();
        this._divertsFromStream = stream.getDivertsFromStream();
        this._length = stream.getLength();
        this._slope = stream.getAverageSlope();
        this._comment = stream.getComment();
        this._id = stream.getStreamId();
    }

    @Override
    public void setFlowsIntoStream(String stream) {
        if (!Objects.equals(this._flowsIntoStream, stream)) {
            this._flowsIntoStream = stream;
            this.setModified(true);
        }
    }

    @Override
    public String getFlowsIntoStream() {
        return this._flowsIntoStream;
    }

    @Override
    public void setFlowsIntoStation(Double station) {
        if (!Objects.equals(this._flowsIntoStation, station)) {
            this._flowsIntoStation = station;
            this.setModified(true);
        }
    }

    @Override
    public Double getFlowsIntoStation() {
        return this._flowsIntoStation;
    }

    @Override
    public void setFlowsIntoBank(String bank) {
        if (!Objects.equals(this._flowsIntoBank, bank)) {
            this._flowsIntoBank = bank;
            this.setModified(true);
        }
    }

    @Override
    public String getFlowsIntoBank() {
        return this._flowsIntoBank;
    }

    @Override
    public void setDivertsFromStream(String stream) {
        if (!Objects.equals(this._divertsFromStream, stream)) {
            this._divertsFromStream = stream;
            this.setModified(true);
        }
    }

    @Override
    public String getDivertsFromStream() {
        return this._divertsFromStream;
    }

    @Override
    public void setDivertsFromStation(Double station) {
        if (!Objects.equals(this._divertsFromStation, station)) {
            this._divertsFromStation = station;
            this.setModified(true);
        }
    }

    @Override
    public Double getDivertsFromStation() {
        return this._divertsFromStation;
    }

    @Override
    public void setDivertsFromBank(String bank) {
        if (!Objects.equals(this._divertsFromBank, bank)) {
            this._divertsFromBank = bank;
            this.setModified(true);
        }
    }

    @Override
    public String getDivertsFromBank() {
        return this._divertsFromBank;
    }

    @Override
    public void setLength(Double length) {
        if (!Objects.equals(this._length, length)) {
            this._length = length;
            this.setModified(true);
        }
    }

    @Override
    public Double getLength() {
        return this._length;
    }

    @Override
    public void setAverageSlope(Double slope) {
        if (!Objects.equals(this._slope, slope)) {
            this._slope = slope;
            this.setModified(true);
        }
    }

    @Override
    public Double getAverageSlope() {
        return this._slope;
    }

    @Override
    public void setComment(String comment) {
        if (!Objects.equals(this._comment, comment)) {
            this._comment = comment;
            this.setModified(true);
        }
    }

    @Override
    public String getComment() {
        return this._comment;
    }

    @Override
    public void setStreamId(String streamId) {
        if (!Objects.equals(this._id, streamId)) {
            this._id = streamId;
            this.setModified(true);
        }
    }

    @Override
    public String getStreamId() {
        return this._id;
    }

    @Override
    public Boolean startsDownstream() {
        return this._startsDownstream;
    }

    @Override
    public void setStartsDownstream(Boolean b) {
        if (!Objects.equals(this._startsDownstream, b)) {
            this._startsDownstream = b;
            this.setModified(true);
        }
    }

    @Override
    public String getOfficeId() {
        return this._officeId;
    }

    @Override
    public void setOfficeId(String officeId) {
        if (!Objects.equals(this._officeId, officeId)) {
            this._officeId = officeId;
            this.setModified(true);
        }
    }

    public String toString() {
        return "Stream: " + this.getLocationId() + " starts downstream: " + this.startsDownstream() + " diverts from: {loc: " + this.getDivertsFromStream() + " bank: " + this.getDivertsFromBank() + " station: " + this.getDivertsFromStation() + "} flows into: {loc: " + this.getFlowsIntoStream() + " bank: " + this.getFlowsIntoBank() + " station: " + this.getFlowsIntoStation() + "} length: " + this.getLength() + " slope: " + this.getAverageSlope() + " comment: " + this.getComment();
    }

    @Override
    public LocationTemplate getLocationTemplate() {
        if (this._locationTemplate == null) {
            this._locationTemplate = new LocationTemplate(this.getOfficeId(), this.getStreamId());
        }
        return this._locationTemplate;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StreamImpl other = (StreamImpl)obj;
        return Objects.equals((Object)this.getLocationTemplate(), (Object)other.getLocationTemplate());
    }

    public boolean deepEquals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StreamImpl stream = (StreamImpl)o;
        return Objects.equals(this._startsDownstream, stream._startsDownstream) && Objects.equals(this.getOfficeId(), stream.getOfficeId()) && Objects.equals(this.getFlowsIntoStream(), stream.getFlowsIntoStream()) && Objects.equals(this.getFlowsIntoStation(), stream.getFlowsIntoStation()) && Objects.equals(this.getFlowsIntoBank(), stream.getFlowsIntoBank()) && Objects.equals(this.getDivertsFromStream(), stream.getDivertsFromStream()) && Objects.equals(this.getDivertsFromStation(), stream.getDivertsFromStation()) && Objects.equals(this.getDivertsFromBank(), stream.getDivertsFromBank()) && Objects.equals(this.getLength(), stream.getLength()) && Objects.equals(this.getAverageSlope(), stream.getAverageSlope()) && Objects.equals(this.getComment(), stream.getComment()) && Objects.equals(this.getStreamId(), stream.getStreamId()) && Objects.equals((Object)this.getLocationTemplate(), (Object)stream.getLocationTemplate());
    }

    public int hashCode() {
        int hash = 5;
        hash = 89 * hash + Objects.hashCode((Object)this.getLocationTemplate());
        return hash;
    }

    @Override
    public boolean isModified() {
        return this._modified;
    }

    @Override
    public void setModified(boolean modified) {
        this._modified = modified;
    }
}

