/*
 * Decompiled with CFR 0.152.
 */
package hec.data.stream;

import hec.data.location.LocationTemplate;
import hec.data.stream.IStreamLocation;
import java.util.Objects;

public class StreamLocationImpl
implements IStreamLocation {
    private String _locationId;
    private String _streamId;
    private Double _station;
    private Double _publishedStation;
    private Double _navigationStation;
    private String _bank;
    private Double _lowestMeasureableStage;
    private Double _totalDrainageArea;
    private Double _ungagedDrainageArea;
    private String _officeId;
    private LocationTemplate _locationTemplate;
    private boolean _modified;

    public StreamLocationImpl() {
    }

    public StreamLocationImpl(IStreamLocation loc) {
        this._locationId = loc.getLocationId();
        this._streamId = loc.getStreamId();
        this._station = loc.getStation();
        this._publishedStation = loc.getPublishedStation();
        this._navigationStation = loc.getNavigationStation();
        this._bank = loc.getBank();
        this._lowestMeasureableStage = loc.getLowestMeasurableStage();
        this._totalDrainageArea = loc.getTotalDrainageArea();
        this._ungagedDrainageArea = loc.getUngagedDrainageArea();
        this._officeId = loc.getOfficeId();
    }

    @Override
    public void setLocationId(String locationId) {
        if (!Objects.equals(this._locationId, locationId)) {
            this._locationId = locationId;
            this.setModified(true);
        }
    }

    @Override
    public String getLocationId() {
        return this._locationId;
    }

    @Override
    public void setStreamId(String locationId) {
        if (!Objects.equals(this._streamId, locationId)) {
            this._streamId = locationId;
            this.setModified(true);
        }
    }

    @Override
    public String getStreamId() {
        return this._streamId;
    }

    @Override
    public void setStation(Double station) {
        if (!Objects.equals(this._station, station)) {
            this._station = station;
            this.setModified(true);
        }
    }

    @Override
    public Double getStation() {
        return this._station;
    }

    @Override
    public void setPublishedStation(Double station) {
        if (!Objects.equals(this._publishedStation, station)) {
            this._publishedStation = station;
            this.setModified(true);
        }
    }

    @Override
    public Double getPublishedStation() {
        return this._publishedStation;
    }

    @Override
    public void setNavigationStation(Double station) {
        if (!Objects.equals(this._navigationStation, station)) {
            this._navigationStation = station;
            this.setModified(true);
        }
    }

    @Override
    public Double getNavigationStation() {
        return this._navigationStation;
    }

    @Override
    public void setBank(String bank) {
        if (!Objects.equals(this._bank, bank)) {
            this._bank = bank;
            this.setModified(true);
        }
    }

    @Override
    public String getBank() {
        return this._bank;
    }

    @Override
    public void setLowestMeasurableStage(Double stage) {
        if (!Objects.equals(this._lowestMeasureableStage, stage)) {
            this._lowestMeasureableStage = stage;
            this.setModified(true);
        }
    }

    @Override
    public Double getLowestMeasurableStage() {
        return this._lowestMeasureableStage;
    }

    @Override
    public void setTotalDrainageArea(Double area) {
        if (!Objects.equals(this._totalDrainageArea, area)) {
            this._totalDrainageArea = area;
            this.setModified(true);
        }
    }

    @Override
    public Double getTotalDrainageArea() {
        return this._totalDrainageArea;
    }

    @Override
    public void setUngagedDrainageArea(Double area) {
        if (!Objects.equals(this._ungagedDrainageArea, area)) {
            this._ungagedDrainageArea = area;
            this.setModified(true);
        }
    }

    @Override
    public Double getUngagedDrainageArea() {
        return this._ungagedDrainageArea;
    }

    @Override
    public String getOfficeId() {
        return this._officeId;
    }

    @Override
    public void setOfficeId(String officeId) {
        if (!Objects.equals(this._officeId, officeId)) {
            this._officeId = officeId;
            this.setModified(true);
        }
    }

    public String toString() {
        return this.getLocationId();
    }

    private LocationTemplate getLocationTemplate() {
        if (this._locationTemplate == null) {
            this._locationTemplate = new LocationTemplate(this._officeId, this._locationId);
        }
        return this._locationTemplate;
    }

    public int hashCode() {
        int hash = 5;
        hash = 41 * hash + Objects.hashCode(this.getLocationId());
        hash = 41 * hash + Objects.hashCode(this.getStreamId());
        hash = 41 * hash + Objects.hashCode(this.getStation());
        hash = 41 * hash + Objects.hashCode(this.getPublishedStation());
        hash = 41 * hash + Objects.hashCode(this.getNavigationStation());
        hash = 41 * hash + Objects.hashCode(this.getBank());
        hash = 41 * hash + Objects.hashCode(this.getLowestMeasurableStage());
        hash = 41 * hash + Objects.hashCode(this.getTotalDrainageArea());
        hash = 41 * hash + Objects.hashCode(this.getUngagedDrainageArea());
        hash = 41 * hash + Objects.hashCode(this.getOfficeId());
        hash = 41 * hash + Objects.hashCode((Object)this.getLocationTemplate());
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StreamLocationImpl other = (StreamLocationImpl)obj;
        if (Objects.equals(this.getLocationId(), other.getLocationId()) && Objects.equals(this.getStreamId(), other.getStreamId()) && Objects.equals(this.getBank(), other.getBank()) && Objects.equals(this.getOfficeId(), other.getOfficeId()) && Objects.equals(this.getStation(), other.getStation()) && Objects.equals(this.getPublishedStation(), other.getPublishedStation()) && Objects.equals(this.getNavigationStation(), other.getNavigationStation()) && Objects.equals(this.getLowestMeasurableStage(), other.getLowestMeasurableStage()) && Objects.equals(this.getTotalDrainageArea(), other.getTotalDrainageArea()) && Objects.equals(this.getUngagedDrainageArea(), other.getUngagedDrainageArea()) && Objects.equals((Object)this.getLocationTemplate(), (Object)other.getLocationTemplate())) {
            return true;
        }
        return true;
    }

    @Override
    public boolean isModified() {
        return this._modified;
    }

    @Override
    public void setModified(boolean modified) {
        this._modified = modified;
    }
}

