/*
 * Decompiled with CFR 0.152.
 */
package hec.data.stream;

import hec.data.location.LocationTemplate;
import hec.data.stream.IStreamReach;
import java.util.Objects;

public class StreamReachImpl
implements IStreamReach {
    private Double _upstreamStation = null;
    private Double _downstreamStation = null;
    private String _comment = null;
    private String _reachLocation = null;
    private String _downstreamLocationId = null;
    private String _upstreamLocationId = null;
    private String _configurationId = null;
    private String _officeId = null;
    private String _streamLocation = null;
    private LocationTemplate _locationTemplate;
    private boolean _modified = false;

    public StreamReachImpl() {
    }

    public StreamReachImpl(IStreamReach r) {
        this._upstreamStation = r.getUpstreamStation();
        this._downstreamStation = r.getDownstreamStation();
        this._comment = r.getReachComments();
        this._reachLocation = r.getLocationId();
        this._upstreamLocationId = r.getUpstreamLocationId();
        this._downstreamLocationId = r.getDownstreamLocationId();
        this._configurationId = r.getConfigurationId();
        this._officeId = r.getOfficeId();
        this._streamLocation = r.getStreamId();
    }

    @Override
    public Double getUpstreamStation() {
        return this._upstreamStation;
    }

    @Override
    public void setUpstreamStation(Double station) {
        if (!Objects.equals(this._upstreamStation, station)) {
            this._upstreamStation = station;
            this.setModified(true);
        }
    }

    @Override
    public Double getDownstreamStation() {
        return this._downstreamStation;
    }

    @Override
    public void setDownstreamStation(Double station) {
        if (!Objects.equals(this._downstreamStation, station)) {
            this._downstreamStation = station;
            this.setModified(true);
        }
    }

    @Override
    public String getReachComments() {
        return this._comment;
    }

    @Override
    public void setReachComments(String comments) {
        if (!Objects.equals(this._comment, comments)) {
            this._comment = comments;
            this.setModified(true);
        }
    }

    @Override
    public String getDownstreamLocationId() {
        return this._downstreamLocationId;
    }

    @Override
    public void setDownstreamLocationId(String locationId) {
        if (!Objects.equals(this._downstreamLocationId, locationId)) {
            this._downstreamLocationId = locationId;
            this.setModified(true);
        }
    }

    @Override
    public String getUpstreamLocationId() {
        return this._upstreamLocationId;
    }

    @Override
    public void setUpstreamLocationId(String locationId) {
        if (!Objects.equals(this._upstreamLocationId, locationId)) {
            this._upstreamLocationId = locationId;
            this.setModified(true);
        }
    }

    @Override
    public void setConfigurationId(String configurationId) {
        if (!Objects.equals(this._configurationId, configurationId)) {
            this._configurationId = configurationId;
            this.setModified(true);
        }
    }

    @Override
    public String getConfigurationId() {
        return this._configurationId;
    }

    @Override
    public void setOfficeId(String officeId) {
        if (!Objects.equals(this._officeId, officeId)) {
            this._officeId = officeId;
            this.setModified(true);
        }
    }

    @Override
    public String getOfficeId() {
        return this._officeId;
    }

    @Override
    public String getLocationId() {
        return this._reachLocation;
    }

    @Override
    public void setLocationId(String reachLocation) {
        if (!Objects.equals(this._reachLocation, reachLocation)) {
            this._reachLocation = reachLocation;
            this.setModified(true);
        }
    }

    @Override
    public void setStreamId(String streamLocation) {
        if (!Objects.equals(this._streamLocation, streamLocation)) {
            this._streamLocation = streamLocation;
            this.setModified(true);
        }
    }

    @Override
    public String getStreamId() {
        return this._streamLocation;
    }

    public String toString() {
        return this.getLocationId();
    }

    public LocationTemplate getLocationTemplate() {
        if (this._locationTemplate == null) {
            this._locationTemplate = new LocationTemplate(this.getOfficeId(), this.getLocationId());
        }
        return this._locationTemplate;
    }

    public int hashCode() {
        int hash = 3;
        hash = 37 * hash + Objects.hashCode(this.getUpstreamStation());
        hash = 37 * hash + Objects.hashCode(this.getDownstreamStation());
        hash = 37 * hash + Objects.hashCode(this.getReachComments());
        hash = 37 * hash + Objects.hashCode(this.getLocationId());
        hash = 37 * hash + Objects.hashCode(this.getDownstreamLocationId());
        hash = 37 * hash + Objects.hashCode(this.getUpstreamLocationId());
        hash = 37 * hash + Objects.hashCode(this.getConfigurationId());
        hash = 37 * hash + Objects.hashCode(this.getOfficeId());
        hash = 37 * hash + Objects.hashCode(this.getStreamId());
        hash = 37 * hash + Objects.hashCode((Object)this.getLocationTemplate());
        return hash;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StreamReachImpl other = (StreamReachImpl)obj;
        return Objects.equals(this.getReachComments(), other.getReachComments()) && Objects.equals(this.getLocationId(), other.getLocationId()) && Objects.equals(this.getDownstreamLocationId(), other.getDownstreamLocationId()) && Objects.equals(this.getUpstreamLocationId(), other.getUpstreamLocationId()) && Objects.equals(this.getConfigurationId(), other.getConfigurationId()) && Objects.equals(this.getOfficeId(), other.getOfficeId()) && Objects.equals(this.getStreamId(), other.getStreamId()) && Objects.equals(this.getUpstreamStation(), other.getUpstreamStation()) && Objects.equals(this.getDownstreamStation(), other.getDownstreamStation()) && Objects.equals((Object)this.getLocationTemplate(), (Object)other.getLocationTemplate());
    }

    @Override
    public boolean isModified() {
        return this._modified;
    }

    @Override
    public void setModified(boolean modified) {
        this._modified = modified;
    }
}

