/*
 * Decompiled with CFR 0.152.
 */
package hec.data.streamflow;

import hec.data.IllegalTimeException;
import hec.data.Iso8601Time;
import hec.data.location.LocationTemplate;
import java.time.Instant;
import java.util.Date;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;

public class StreamflowMeasurementRef
implements Comparable<StreamflowMeasurementRef> {
    private LocationTemplate _locationRef;
    private String _measurementNumber;
    private Instant _instant;

    public LocationTemplate getLocationRef() {
        return this._locationRef;
    }

    public void setLocationRef(LocationTemplate locationRef) {
        this._locationRef = locationRef;
    }

    public String getMeasurementNumber() {
        return this._measurementNumber;
    }

    public void setMeasurementNumber(String measurementNumber) {
        this._measurementNumber = measurementNumber;
    }

    public int hashCode() {
        int hash = 3;
        hash = 23 * hash + Objects.hashCode((Object)this._locationRef);
        hash = 23 * hash + Objects.hashCode(this._measurementNumber);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StreamflowMeasurementRef other = (StreamflowMeasurementRef)obj;
        if (!Objects.equals((Object)this._locationRef, (Object)other._locationRef)) {
            return false;
        }
        return Objects.equals(this._measurementNumber, other._measurementNumber);
    }

    public String getOfficeId() {
        if (this._locationRef != null) {
            return this._locationRef.getOfficeId();
        }
        return null;
    }

    public void setOfficeId(String officeId) {
        if (this._locationRef == null) {
            this._locationRef = new LocationTemplate();
        }
        this._locationRef.setOfficeId(officeId);
    }

    public String getLocationId() {
        if (this._locationRef != null) {
            return this._locationRef.getLocationId();
        }
        return null;
    }

    public void setLocationId(String locationId) {
        if (this._locationRef == null) {
            this._locationRef = new LocationTemplate();
        }
        this._locationRef.setLocationId(locationId);
    }

    public void setIsoDateString(String strDate) {
        if (strDate == null) {
            this._instant = null;
            return;
        }
        try {
            long time = Iso8601Time.parseTimeString(strDate);
            this._instant = Instant.ofEpochMilli(time);
        }
        catch (IllegalTimeException e) {
            Logger.getLogger(StreamflowMeasurementRef.class.getName()).log(Level.SEVERE, "Error setting ISO date string", e);
            this._instant = null;
        }
    }

    public String getIsoDateString() {
        String output = null;
        if (this._instant != null) {
            output = Iso8601Time.toString(this._instant.toEpochMilli());
        }
        return output;
    }

    public Date getDate() {
        Date output = null;
        if (this._instant != null) {
            output = Date.from(this._instant);
        }
        return output;
    }

    public void setDate(Date date) {
        Instant instant = null;
        if (date != null) {
            instant = date.toInstant();
        }
        this._instant = instant;
    }

    public Instant getInstant() {
        return this._instant;
    }

    public void setInstant(Instant date) {
        this._instant = date;
    }

    @Override
    public int compareTo(StreamflowMeasurementRef o) {
        return this.getMeasurementNumber().compareTo(o.getMeasurementNumber());
    }
}

