/*
 * Decompiled with CFR 0.152.
 */
package hec.data.textFilter;

import hec.data.ITextFilter;
import hec.data.textFilter.TextFilterElement;
import hec.data.textFilter.TextFilterException;
import hec.util.TextUtil;
import java.util.List;
import java.util.Vector;

public class TextFilter
implements ITextFilter {
    private boolean usesRegex;
    private List<TextFilterElement> elements = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TextFilter(boolean usesRegex, List<TextFilterElement> elements) {
        TextFilter textFilter = this;
        synchronized (textFilter) {
            this.usesRegex = usesRegex;
            this.setElements(elements);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TextFilter(boolean usesRegex, String[] elements) throws TextFilterException {
        TextFilter textFilter = this;
        synchronized (textFilter) {
            this.usesRegex = usesRegex;
            this.setElements(elements);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TextFilter(boolean usesRegex, String elementsStr) throws TextFilterException {
        TextFilter textFilter = this;
        synchronized (textFilter) {
            this.usesRegex = usesRegex;
            this.setElements(elementsStr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean usesRegex() {
        TextFilter textFilter = this;
        synchronized (textFilter) {
            return this.usesRegex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setUsesRegex(boolean usesRegex) {
        TextFilter textFilter = this;
        synchronized (textFilter) {
            this.usesRegex = usesRegex;
            for (TextFilterElement element : this.elements) {
                element.setUsesRegex(usesRegex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<TextFilterElement> getElements() {
        TextFilter textFilter = this;
        synchronized (textFilter) {
            return new Vector<TextFilterElement>(this.elements);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getElementStrings() {
        TextFilter textFilter = this;
        synchronized (textFilter) {
            String[] strings = new String[this.elements.size()];
            for (int i = 0; i < strings.length; ++i) {
                strings[i] = this.elements.get(i).toString();
            }
            return strings;
        }
    }

    @Override
    public String[] getNormalizedElementStrings() {
        String[] strings = this.getElementStrings();
        String flags = this.getFlags();
        if (flags != null && flags.length() > 0) {
            String target = String.format(":flags=%s$", flags);
            String replacement = ":flags=";
            for (int i = 0; i < strings.length; ++i) {
                strings[i] = strings[i].replaceFirst(target, replacement);
            }
        }
        return strings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getElementsString() {
        TextFilter textFilter = this;
        synchronized (textFilter) {
            return TextUtil.join("\n", this.getElementStrings());
        }
    }

    @Override
    public String getNormalizedElementsString() {
        return TextUtil.join("\n", this.getNormalizedElementStrings());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setElements(List<TextFilterElement> elements) {
        TextFilter textFilter = this;
        synchronized (textFilter) {
            this.elements = new Vector<TextFilterElement>(elements);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setElements(String[] elements) throws TextFilterException {
        TextFilter textFilter = this;
        synchronized (textFilter) {
            this.elements = new Vector<TextFilterElement>(elements.length);
            for (String element : elements) {
                this.elements.add(new TextFilterElement(element, this.usesRegex));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setElements(String elementsStr) throws TextFilterException {
        TextFilter textFilter = this;
        synchronized (textFilter) {
            this.setElements(TextUtil.split(elementsStr.trim(), "\n"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setMultiLine(boolean multiLine) {
        TextFilter textFilter = this;
        synchronized (textFilter) {
            for (TextFilterElement element : this.elements) {
                element.setMultiLine(multiLine);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setDotAll(boolean dotAll) {
        TextFilter textFilter = this;
        synchronized (textFilter) {
            for (TextFilterElement element : this.elements) {
                element.setDotAll(dotAll);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setIgnoreWhitespace(boolean ignoreWhitespace) {
        TextFilter textFilter = this;
        synchronized (textFilter) {
            for (TextFilterElement element : this.elements) {
                element.setIgnoreWhitespace(ignoreWhitespace);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setIgnoreCase(boolean ignoreCase) {
        TextFilter textFilter = this;
        synchronized (textFilter) {
            for (TextFilterElement element : this.elements) {
                element.setIgnoreCase(ignoreCase);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean includes(String text) throws TextFilterException {
        TextFilter textFilter = this;
        synchronized (textFilter) {
            boolean included;
            if (this.elements == null || this.elements.size() == 0) {
                included = true;
            } else {
                included = !this.elements.get(0).isInclude();
                for (TextFilterElement element : this.elements) {
                    if (element.isInclude() == included || !element.matches(text)) continue;
                    included = !included;
                }
            }
            return included;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[][] filter(String[] text) throws TextFilterException {
        TextFilter textFilter = this;
        synchronized (textFilter) {
            Vector[] lists = new Vector[]{new Vector(), new Vector()};
            for (String item : text) {
                lists[this.includes(item) ? 0 : 1].add(item);
            }
            String[][] arrays = new String[][]{lists[0].toArray(new String[lists[0].size()]), lists[1].toArray(new String[lists[1].size()])};
            return arrays;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[][] filter(Iterable<String> text) throws TextFilterException {
        TextFilter textFilter = this;
        synchronized (textFilter) {
            Vector _text = new Vector();
            _text.addAll(_text);
            return this.filter(_text.toArray(new String[_text.size()]));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getIncluded(String[] text) throws TextFilterException {
        TextFilter textFilter = this;
        synchronized (textFilter) {
            return this.filter(text)[0];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getIncluded(Iterable<String> text) throws TextFilterException {
        TextFilter textFilter = this;
        synchronized (textFilter) {
            return this.filter(text)[0];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getExcluded(String[] text) throws TextFilterException {
        TextFilter textFilter = this;
        synchronized (textFilter) {
            return this.filter(text)[1];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getExcluded(Iterable<String> text) throws TextFilterException {
        TextFilter textFilter = this;
        synchronized (textFilter) {
            return this.filter(text)[1];
        }
    }

    @Override
    public String getFlags() {
        boolean m = true;
        boolean n = true;
        boolean x = true;
        boolean i = true;
        for (TextFilterElement element : this.elements) {
            if (m && !element.isMultiLine()) {
                m = false;
            }
            if (n && !element.isDotAll()) {
                n = false;
            }
            if (x && !element.isIgnoreWhitespace()) {
                x = false;
            }
            if (!i || element.isIgnoreCase()) continue;
            i = false;
        }
        StringBuilder sb = new StringBuilder();
        if (m) {
            sb.append('m');
        }
        if (n) {
            sb.append('n');
        }
        if (x) {
            sb.append('x');
        }
        if (i) {
            sb.append('i');
        }
        return sb.toString();
    }
}

