/*
 * Decompiled with CFR 0.152.
 */
package hec.data.textFilter;

import hec.data.textFilter.TextFilterException;
import hec.util.TextUtil;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TextFilterElement {
    public static final String TEXT_FILTER_ELEMENT_REGEX = "^((?:i(?:n(?:c(?:l(?:u(?:de?)?)?)?)?)?|e(?:x(?:c(?:l(?:u(?:de?)?)?)?)?)?)\\s*:)?(.+?)(\\s*:\\s*f(?:l(?:a(?:gs?)?)?)?\\s*=.*)?";
    public static final Pattern TEXT_FILTER_ELEMENT_PATTERN = Pattern.compile("^((?:i(?:n(?:c(?:l(?:u(?:de?)?)?)?)?)?|e(?:x(?:c(?:l(?:u(?:de?)?)?)?)?)?)\\s*:)?(.+?)(\\s*:\\s*f(?:l(?:a(?:gs?)?)?)?\\s*=.*)?", 2);
    private boolean include = true;
    private boolean usesRegex = false;
    private boolean multiLine = false;
    private boolean dotAll = false;
    private boolean ignoreWhitespace = false;
    private boolean ignoreCase = false;
    private boolean initialized = false;
    private String filterText = null;
    private String filterTextIgnoreCase = null;
    private Pattern pattern = null;

    public TextFilterElement() {
    }

    public TextFilterElement(boolean include, String filterText, boolean usesRegex, boolean multiLine, boolean dotAll, boolean ignoreWhitespace, boolean ignoreCase) {
        this.setData(include, filterText, usesRegex, multiLine, dotAll, ignoreWhitespace, ignoreCase);
    }

    public TextFilterElement(String elementText, boolean usesRegex) throws TextFilterException {
        this.setData(elementText, usesRegex);
    }

    protected boolean isInclude() {
        return this.include;
    }

    protected void setInclude(boolean include) {
        this.include = include;
    }

    protected boolean usesRegex() {
        return this.usesRegex;
    }

    protected void setUsesRegex(boolean usesRegex) {
        this.usesRegex = usesRegex;
        this.init();
    }

    protected boolean isMultiLine() {
        return this.multiLine;
    }

    protected void setMultiLine(boolean multiLine) {
        this.multiLine = multiLine;
        this.init();
    }

    protected boolean isDotAll() {
        return this.dotAll;
    }

    protected void setDotAll(boolean dotAll) {
        this.dotAll = dotAll;
        this.init();
    }

    protected boolean isIgnoreWhitespace() {
        return this.ignoreWhitespace;
    }

    protected void setIgnoreWhitespace(boolean ignoreWhitespace) {
        this.ignoreWhitespace = ignoreWhitespace;
        this.init();
    }

    protected boolean isIgnoreCase() {
        return this.ignoreCase;
    }

    protected void setIgnoreCase(boolean ignoreCase) {
        this.ignoreCase = ignoreCase;
        this.init();
    }

    protected String getFilterText() {
        return this.filterText;
    }

    protected void setFilterText(String filterText) {
        this.filterText = filterText;
        this.init();
    }

    protected void setData(boolean include, String filterText, boolean usesRegex, boolean multiLine, boolean dotAll, boolean ignoreWhitespace, boolean ignoreCase) {
        this.include = include;
        this.filterText = filterText;
        this.usesRegex = usesRegex;
        this.multiLine = multiLine;
        this.dotAll = dotAll;
        this.ignoreWhitespace = ignoreWhitespace;
        this.ignoreCase = ignoreCase;
        this.init();
    }

    protected void setData(String elementText, boolean usesRegex) throws TextFilterException {
        if (elementText == null || elementText.length() == 0) {
            this.setData(true, "", false, false, false, false, false);
        } else {
            Matcher matcher = TEXT_FILTER_ELEMENT_PATTERN.matcher(elementText);
            if (matcher.matches()) {
                boolean include = false;
                if (matcher.group(1) == null || matcher.group(1).toLowerCase().startsWith("i")) {
                    include = true;
                }
                String filterText = matcher.group(2);
                String flagStr = "";
                if (matcher.group(3) != null) {
                    flagStr = matcher.group(3).split("=", 2)[1].trim().toLowerCase();
                }
                this.setData(include, filterText, usesRegex, flagStr.indexOf(109) != -1, flagStr.indexOf(110) != -1, flagStr.indexOf(120) != -1, flagStr.indexOf(105) != -1);
            } else {
                throw new TextFilterException(String.format("Invalid text filter string: \"%s\"", elementText));
            }
        }
    }

    protected void init() {
        if (this.usesRegex) {
            this.pattern = this.ignoreWhitespace ? Pattern.compile(this.filterText.replaceAll("\\s+", ""), 0 | (this.multiLine ? 8 : 0) | (this.dotAll ? 32 : 0) | (this.ignoreCase ? 2 : 0)) : Pattern.compile(this.filterText, 0 | (this.multiLine ? 8 : 0) | (this.dotAll ? 32 : 0) | (this.ignoreCase ? 2 : 0));
        } else {
            this.filterTextIgnoreCase = this.filterText.toLowerCase();
        }
        this.initialized = true;
    }

    protected boolean matches(CharSequence str) throws TextFilterException {
        if (!this.initialized) {
            throw new TextFilterException("Text filter element is not initialized");
        }
        if (this.usesRegex) {
            return this.pattern.matcher(str).find(0);
        }
        if (this.ignoreCase) {
            return TextUtil.glob_match(str.toString().toLowerCase(), this.filterTextIgnoreCase);
        }
        return TextUtil.glob_match(str, this.filterText);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.include ? "include:" : "exclude:").append(this.filterText).append(":flags=").append(this.multiLine ? "m" : "").append(this.dotAll ? "n" : "").append(this.ignoreWhitespace ? "x" : "").append(this.ignoreCase ? "i" : "");
        return sb.toString();
    }
}

