/*
 * Decompiled with CFR 0.152.
 */
package hec.data.timeSeriesText;

import hec.data.DataSetIllegalArgumentException;
import hec.data.Duration;
import hec.data.ITimeSeriesDescription;
import hec.data.Interval;
import hec.data.IntervalOffset;
import hec.data.ParameterType;
import hec.data.Version;
import hec.data.location.LocationTemplate;
import java.util.Comparator;
import java.util.Objects;
import rma.util.lookup.Lookup;
import rma.util.lookup.Lookups;

@Deprecated(forRemoval=true)
public class TextDescriptionTx
implements ITimeSeriesDescription {
    private final String _parameterId;
    private LocationTemplate _locationRef;
    private static final String TEXT = "Text";
    private ParameterType _parameterType = null;
    private Interval _interval = null;
    private Duration _duration = null;
    private Version _version = null;
    private int _userPrivilege;
    private boolean _active;
    private IntervalOffset _utcIntervalOffset;
    private Lookup lookup = null;

    public TextDescriptionTx(String officeId, String delimString) throws DataSetIllegalArgumentException {
        String[] split = delimString.split("\\.");
        if (split.length != 6) {
            throw new DataSetIllegalArgumentException("Text time series identifier is not delimited correctly. " + delimString);
        }
        String locationId = split[0];
        String parameterId = split[1];
        String parameterTypeId = split[2];
        String intervalId = split[3];
        String durationId = split[4];
        String versionId = split[5];
        this._locationRef = new LocationTemplate(officeId, locationId);
        if (parameterId == null || !parameterId.toUpperCase().startsWith(TEXT.toUpperCase())) {
            throw new DataSetIllegalArgumentException("Text time series identifier base parameter needs to be: Text. " + delimString);
        }
        this._parameterId = parameterId;
        this._parameterType = new ParameterType(parameterTypeId);
        this._interval = new Interval(intervalId);
        this._duration = new Duration(durationId);
        this._version = new Version(versionId);
    }

    public TextDescriptionTx() {
        this._parameterId = TEXT;
    }

    public TextDescriptionTx(TextDescriptionTx textDescriptionTx) {
        this._active = textDescriptionTx._active;
        this._duration = new Duration(textDescriptionTx._duration);
        this._interval = new Interval(textDescriptionTx._interval);
        this._locationRef = new LocationTemplate(textDescriptionTx._locationRef);
        this._parameterId = textDescriptionTx._parameterId;
        this._parameterType = new ParameterType(textDescriptionTx._parameterType);
        this._userPrivilege = textDescriptionTx._userPrivilege;
        this._utcIntervalOffset = textDescriptionTx._utcIntervalOffset != null ? new IntervalOffset(textDescriptionTx._utcIntervalOffset) : null;
        this._version = new Version(textDescriptionTx._version);
    }

    private Lookup createLookup() {
        return Lookups.fixed((Object[])new Object[]{this, new TextDescriptionTxComparator()});
    }

    @Override
    public synchronized Lookup getLookup() {
        if (this.lookup == null) {
            this.lookup = this.createLookup();
        }
        return this.lookup;
    }

    @Override
    public String getOfficeId() {
        return this._locationRef.getOfficeId();
    }

    @Override
    public LocationTemplate getLocationRef() {
        return this._locationRef;
    }

    @Override
    public void setLocationRef(LocationTemplate template) {
        this._locationRef = template;
    }

    @Override
    public String getParameterId() {
        return this._parameterId;
    }

    @Override
    public ParameterType getParameterType() {
        return this._parameterType;
    }

    public void setParameterType(ParameterType parameterType) {
        this._parameterType = parameterType;
    }

    @Override
    public Interval getInterval() {
        return this._interval;
    }

    public void setInterval(Interval interval) {
        this._interval = interval;
    }

    @Override
    public Duration getDuration() {
        return this._duration;
    }

    public void setDuration(Duration duration) {
        this._duration = duration;
    }

    @Override
    public Version getVersion() {
        return this._version;
    }

    public void setVersion(Version version) {
        this._version = version;
    }

    @Override
    public int getUserPrivilege() {
        return this._userPrivilege;
    }

    @Override
    public boolean getActive() {
        return this._active;
    }

    @Override
    public boolean isRegular() {
        return this._interval.isRegular();
    }

    @Override
    public IntervalOffset getUtcIntervalOffsetObject() {
        return this._utcIntervalOffset;
    }

    public void setUtcIntervalOffset(IntervalOffset utcOffset) {
        this._utcIntervalOffset = utcOffset;
    }

    @Override
    public String getTimeSeriesId() {
        StringBuilder sb = new StringBuilder();
        sb.append(this._locationRef.getLocationId()).append(".").append(this._parameterId).append(".").append(this._parameterType.toString()).append(".").append(this._interval.toString()).append(".").append(this._duration.toString()).append(".").append(this._version.toString());
        return sb.toString();
    }

    public String toString() {
        return this.getTimeSeriesId();
    }

    @Override
    public ITimeSeriesDescription copy() {
        TextDescriptionTx copy = new TextDescriptionTx(this);
        return copy;
    }

    public int hashCode() {
        int hash = 7;
        hash = 29 * hash + Objects.hashCode((Object)this._locationRef);
        hash = 29 * hash + Objects.hashCode(this._parameterId);
        hash = 29 * hash + Objects.hashCode(this._parameterType);
        hash = 29 * hash + Objects.hashCode(this._interval);
        hash = 29 * hash + Objects.hashCode(this._duration);
        hash = 29 * hash + Objects.hashCode(this._version);
        hash = 29 * hash + Objects.hashCode(this._utcIntervalOffset);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TextDescriptionTx other = (TextDescriptionTx)obj;
        if (!Objects.equals((Object)this._locationRef, (Object)other._locationRef)) {
            return false;
        }
        if (!Objects.equals(this._parameterType, other._parameterType)) {
            return false;
        }
        if (!Objects.equals(this._interval, other._interval)) {
            return false;
        }
        if (!Objects.equals(this._duration, other._duration)) {
            return false;
        }
        if (!Objects.equals(this._version, other._version)) {
            return false;
        }
        if (!Objects.equals(this._parameterId, other._parameterId)) {
            return false;
        }
        return Objects.equals(this._utcIntervalOffset, other._utcIntervalOffset);
    }

    public static class TextDescriptionTxComparator
    implements Comparator<TextDescriptionTx> {
        @Override
        public int compare(TextDescriptionTx o1, TextDescriptionTx o2) {
            if (o1 == o2 || o1.equals(o2)) {
                return 0;
            }
            return 1;
        }
    }
}

