/*
 * Decompiled with CFR 0.152.
 */
package hec.data.turbines;

import hec.data.ParamDouble;
import hec.data.ParamDoubleSupport;
import hec.data.location.LocationTemplate;
import hec.data.operations.PhysicalStructureOperationalSetting;
import hec.data.turbines.ITurbineChangeRef;
import hec.data.turbines.ITurbineSetting;
import org.jdom.Element;

public class JDomTurbineSetting
extends PhysicalStructureOperationalSetting<ITurbineChangeRef>
implements ITurbineSetting {
    private double _oldDischarge;
    private double _newDischarge;
    private double _scheduledLoad;
    private double _realPower;

    public JDomTurbineSetting() {
    }

    public JDomTurbineSetting(ITurbineChangeRef changeRef, LocationTemplate turbineLocationRef, double oldDischarge, double newDischarge) {
        super(changeRef, turbineLocationRef);
        this.setOldDischarge(oldDischarge);
        this.setNewDischarge(newDischarge);
    }

    @Override
    public void buildElement(Element element) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public double getOldDischarge() {
        return this._oldDischarge;
    }

    @Override
    public void setOldDischarge(double oldDischarge) {
        this._oldDischarge = oldDischarge;
    }

    @Override
    public void getOldDischarge(ParamDouble pd) {
        ParamDoubleSupport.FLOW.initParamDouble(pd);
        pd.setValue(this._oldDischarge);
    }

    @Override
    public void setOldDischarge(ParamDouble pd) {
        this._oldDischarge = pd.convertToUnitSystem(2);
    }

    @Override
    public double getNewDischarge() {
        return this._newDischarge;
    }

    @Override
    public void setNewDischarge(double newDischarge) {
        this._newDischarge = newDischarge;
    }

    @Override
    public void getNewDischarge(ParamDouble pd) {
        ParamDoubleSupport.FLOW.initParamDouble(pd);
        pd.setValue(this._newDischarge);
    }

    @Override
    public void setNewDischarge(ParamDouble pd) {
        this._newDischarge = pd.convertToUnitSystem(2);
    }

    @Override
    public double getScheduledLoad() {
        return this._scheduledLoad;
    }

    @Override
    public void setScheduledLoad(double scheduledLoad) {
        this._scheduledLoad = scheduledLoad;
    }

    @Override
    public void getScheduledLoad(ParamDouble pd) {
        ParamDoubleSupport.POWER.initParamDouble(pd);
        pd.setValue(this._scheduledLoad);
    }

    @Override
    public void setScheduledLoad(ParamDouble pd) {
        this._scheduledLoad = pd.convertToUnitSystem(2);
    }

    @Override
    public double getRealPower() {
        return this._realPower;
    }

    @Override
    public void setRealPower(double realPower) {
        this._realPower = realPower;
    }

    @Override
    public void getRealPower(ParamDouble pd) {
        ParamDoubleSupport.POWER.initParamDouble(pd);
        pd.setValue(this._realPower);
    }

    @Override
    public void setRealPower(ParamDouble pd) {
        this._realPower = pd.convertToUnitSystem(2);
    }

    @Override
    public String getDischargeUnits() {
        return ParamDoubleSupport.FLOW.getSiUnits();
    }

    @Override
    public String getGenerationUnits() {
        return ParamDoubleSupport.POWER.getSiUnits();
    }
}

