/*
 * Decompiled with CFR 0.152.
 */
package hec.data.tx;

import com.google.common.flogger.FluentLogger;
import hec.data.tx.DSSTimeSeriesNoDataFoundException;
import hec.data.tx.DSSTimeSeriesReadException;
import hec.data.tx.DSSTimeSeriesUtil;
import hec.data.tx.DSSTimeSeriesWriteException;
import hec.data.tx.DataSetTxEmptyException;
import hec.data.tx.UtcIntervalOffsetMismatchException;
import hec.heclib.dss.DSSPathname;
import hec.heclib.dss.HecTimeSeries;
import hec.heclib.util.HecTime;
import hec.heclib.util.doubleArrayContainer;
import hec.heclib.util.intArrayContainer;
import hec.io.DataContainer;
import java.io.IOException;
import java.io.Serializable;
import java.time.ZoneId;
import java.util.Calendar;
import java.util.Date;
import java.util.Optional;
import java.util.SimpleTimeZone;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.function.Predicate;
import mil.army.usace.hec.data.timeseries.Quality;
import mil.army.usace.hec.data.timeseries.TimeSeries;
import mil.army.usace.hec.data.timeseries.TimeSeriesFactory;
import mil.army.usace.hec.data.timeseries.math.TimeSeriesTemplate;
import mil.army.usace.hec.metadata.DataSetException;
import mil.army.usace.hec.metadata.DataSetIllegalArgumentException;
import mil.army.usace.hec.metadata.Duration;
import mil.army.usace.hec.metadata.DurationFactory;
import mil.army.usace.hec.metadata.Interval;
import mil.army.usace.hec.metadata.IntervalFactory;
import mil.army.usace.hec.metadata.LocationID;
import mil.army.usace.hec.metadata.Parameter;
import mil.army.usace.hec.metadata.ParameterType;
import mil.army.usace.hec.metadata.UnitUtil;
import mil.army.usace.hec.metadata.Units;
import mil.army.usace.hec.metadata.Version;
import mil.army.usace.hec.metadata.VerticalDatum;
import mil.army.usace.hec.metadata.VerticalDatumContainer;
import mil.army.usace.hec.metadata.VerticalDatumException;
import mil.army.usace.hec.metadata.timeseries.DataSetTimeSeriesException;
import mil.army.usace.hec.metadata.timeseries.TimeSeriesIdentifier;
import mil.army.usace.hec.metadata.timeseries.TimeSeriesIdentifierFactory;

public class DSSTimeSeriesTranslator
extends HecTimeSeries
implements Serializable {
    private static final FluentLogger LOGGER = FluentLogger.forEnclosingClass();

    public final TimeSeries readAndChangeUnits(TimeSeriesTemplate template, TimeZone timeZone) throws DataSetException {
        return this.readAndChangeUnits(template, timeZone, (TimeZone)null);
    }

    public final TimeSeries readAndChangeUnits(TimeSeriesTemplate template, TimeZone timeZone, TimeZone timeZoneOverride) throws DataSetException {
        TimeSeriesIdentifier description = template.getTimeSeriesIdentifier();
        this.setDescription(description);
        TimeSeries tx = null;
        tx = this.readData(template.getStartTime(), template.getEndTime(), timeZone, timeZoneOverride);
        if (tx.needToChangeUnits(template.getUnits())) {
            tx.changeUnits(template.getUnits());
        }
        return tx;
    }

    public final TimeSeries readAndChangeUnits(TimeSeriesTemplate template, TimeZone timeZone, String pathname) throws DataSetException {
        return this.readAndChangeUnits(template, timeZone, null, pathname);
    }

    public final TimeSeries readAndChangeUnits(TimeSeriesTemplate template, TimeZone timeZone, TimeZone timeZoneOverride, String pathname) throws DataSetException {
        this.setPathname(pathname);
        TimeSeries tx = null;
        try {
            tx = this.readData(template, timeZone, timeZoneOverride);
            if (tx.needToChangeUnits(template.getUnits())) {
                tx.changeUnits(template.getUnits());
            }
            return tx;
        }
        catch (DSSTimeSeriesNoDataFoundException e) {
            throw new DataSetTxEmptyException("No data found for:\n" + pathname + "\nTime window: " + template.getStartTimeString() + ";  " + template.getEndTimeString());
        }
    }

    public final TimeSeries readTimeSeries(String pathname, long startTime, long endTime, TimeZone timeZone) throws DataSetException {
        this.setPathname(pathname);
        return this.readData(startTime, endTime, timeZone, null);
    }

    public final TimeSeries readTimeSeries(String pathname, long startTime, long endTime, TimeZone timeZone, TimeZone timeZoneOverride) throws DataSetException {
        this.setPathname(pathname);
        return this.readData(startTime, endTime, timeZone, timeZoneOverride);
    }

    public final TimeSeries readTimeSeries(String pathname, TimeSeriesIdentifier description, long startTime, long endTime, TimeZone timeZone) throws DataSetException {
        this.setPathname(pathname);
        return this.readData(startTime, endTime, timeZone, null, description);
    }

    public final TimeSeries readTimeSeries(String pathname, TimeSeriesIdentifier description, long startTime, long endTime, TimeZone timeZone, TimeZone timeZoneOverride) throws DataSetException {
        this.setPathname(pathname);
        return this.readData(startTime, endTime, timeZone, timeZoneOverride, description);
    }

    public final int write(TimeSeries dataSet, TimeZone timeZone, String pathname) throws DataSetIllegalArgumentException, DataSetTimeSeriesException, DSSTimeSeriesWriteException {
        boolean intervalMatches;
        this.setPathname(pathname);
        Interval interval = dataSet.getTimeSeriesIdentifier().getInterval();
        if (this.ePart().startsWith("IR-")) {
            intervalMatches = interval.equals(IntervalFactory.irregular());
        } else {
            boolean bl = intervalMatches = interval.getMinutes() == this.interval();
        }
        if (!intervalMatches) {
            throw new DataSetTimeSeriesException("Intervals not equal: " + interval + " != " + interval);
        }
        return this.writeTx(dataSet, timeZone, null);
    }

    public final int write(TimeSeries dataSet, TimeZone timeZone, String pathname, String dssType) throws DataSetIllegalArgumentException, DataSetTimeSeriesException, DSSTimeSeriesWriteException {
        this.setPathname(pathname);
        String e = this.ePart();
        Interval dssInterval = (Interval)IntervalFactory.findAnyDss((Predicate)IntervalFactory.equalsName((String)e)).orElseThrow(() -> new DataSetIllegalArgumentException("No DSS interval found matching: " + e));
        Interval interval = dssInterval.isRegular() ? (Interval)IntervalFactory.findAny(IntervalFactory.equalsSeconds((int)dssInterval.getSeconds()).and(Interval::isRegular)).orElseThrow(() -> new DataSetIllegalArgumentException("No CWMS interval found matching: " + dssInterval.getSeconds() + " seconds")) : IntervalFactory.irregular();
        if (!dataSet.getTimeSeriesIdentifier().describesSameDataAs(interval)) {
            throw new DataSetTimeSeriesException("DSS interval: " + e + " does not describe the same data as CWMS interval: " + dataSet.getTimeSeriesIdentifier().getInterval());
        }
        return this.writeTx(dataSet, timeZone, dssType);
    }

    public final int write(TimeSeries dataSet, TimeZone timeZone, DSSPathname writePathname) throws DataSetIllegalArgumentException, DataSetTimeSeriesException, DSSTimeSeriesWriteException {
        return this.write(dataSet, timeZone, writePathname.pathname());
    }

    public final int write(TimeSeries dataSet, TimeZone timeZone) throws DataSetTxEmptyException, DSSTimeSeriesWriteException {
        TimeSeriesIdentifier description = dataSet.getTimeSeriesIdentifier();
        this.setDescription(description);
        return this.writeTx(dataSet, timeZone, null);
    }

    private final String getStandardId(int millisRawOffset) {
        Object strMinutes;
        int offset = millisRawOffset / 1000;
        offset = Math.abs(offset);
        int hours = offset / 3600;
        int remainder = offset % 3600;
        int minutes = remainder / 60;
        StringBuffer sb = new StringBuffer();
        Object strHours = Integer.toString(hours);
        if (((String)strHours).length() == 1) {
            strHours = "0" + (String)strHours;
        }
        if (((String)(strMinutes = Integer.toString(minutes))).length() == 1) {
            strMinutes = "0" + (String)strMinutes;
        }
        sb.append("GMT");
        if (millisRawOffset < 0) {
            sb.append("-");
        }
        sb.append((String)strHours).append(":").append((String)strMinutes);
        return sb.toString();
    }

    private int writeTx(TimeSeries dataSet, TimeZone timeZone, String dssType) throws DataSetTxEmptyException, DSSTimeSeriesWriteException {
        int status = 0;
        int numberValues = dataSet.getNumberValues();
        if (numberValues <= 0) {
            throw new DataSetTxEmptyException("No data given for: " + this.pathname());
        }
        double[] values = dataSet.getValues();
        double[] dssValues = new double[values.length];
        long[] milliTimes = dataSet.getTimes();
        int[] minTimes = new int[numberValues];
        int[] quality = new int[numberValues];
        HecTime temp = new HecTime();
        Optional qualityTx = dataSet.getQuality();
        if (!qualityTx.isPresent()) {
            for (int i = 0; i < numberValues; ++i) {
                quality[i] = 0;
            }
        }
        ((FluentLogger.Api)LOGGER.atFine()).log("DSSTimeSeries===> Prepping " + numberValues + " values for write to: " + this.pathname());
        int m = -1;
        int valuesDiscarded = 0;
        int bestValuesIndex = 0;
        Calendar cal = Calendar.getInstance();
        boolean regular = dataSet.getTimeSeriesIdentifier().getInterval().isRegular();
        if (regular && timeZone.useDaylightTime()) {
            int millisRawOffset = timeZone.getRawOffset();
            String id = this.getStandardId(millisRawOffset);
            timeZone = new SimpleTimeZone(millisRawOffset, id);
        }
        cal.setTimeZone(timeZone);
        for (int i = 0; i < numberValues; ++i) {
            cal.setTimeInMillis(milliTimes[i]);
            temp.set(cal);
            int tempVal = temp.value();
            int nextMinuteIndex = 0;
            bestValuesIndex = i;
            if (((FluentLogger.Api)LOGGER.atFiner()).isEnabled()) {
                ((FluentLogger.Api)LOGGER.atFiner()).log("DSSTimeSeries===> " + i + " " + values[i] + " " + new Date(milliTimes[i]));
                ((FluentLogger.Api)LOGGER.atFiner()).log("DSSTimeSeries===> " + i + "   tempVal=" + tempVal + "  minTimes[" + m + "]=" + minTimes[m]);
            }
            if (i > 0 && tempVal <= minTimes[m]) {
                if (((FluentLogger.Api)LOGGER.atFiner()).isEnabled()) {
                    ((FluentLogger.Api)LOGGER.atFiner()).log("DSSTimeSeries===>    Warning, more than one value for this minute, or out of order");
                    ((FluentLogger.Api)LOGGER.atFiner()).log("DSSTimeSeries===>    Looking ahead to find a new minute:");
                }
                nextMinuteIndex = 0;
                bestValuesIndex = i - 1;
                int lastMinTime = minTimes[m];
                boolean bestQualityIsOK = false;
                if (qualityTx.isPresent() && ((Quality)qualityTx.get()).isOkay(bestValuesIndex)) {
                    bestQualityIsOK = true;
                }
                for (int k = i - 1; k < numberValues && nextMinuteIndex == 0; ++k) {
                    cal.setTimeInMillis(milliTimes[k]);
                    temp.set(cal);
                    if (((FluentLogger.Api)LOGGER.atFiner()).isEnabled()) {
                        ((FluentLogger.Api)LOGGER.atFiner()).log("DSSTimeSeries===>       k,dataSetT,dataSetV: " + k + ", " + new Date(milliTimes[k]) + ", " + values[k]);
                        ((FluentLogger.Api)LOGGER.atFiner()).log("DSSTimeSeries===>       temp.value()=" + temp.value() + "  lastMinTime=" + lastMinTime);
                    }
                    if (temp.value() > lastMinTime) {
                        nextMinuteIndex = k;
                        valuesDiscarded += nextMinuteIndex - i;
                        if (!((FluentLogger.Api)LOGGER.atFiner()).isEnabled()) continue;
                        ((FluentLogger.Api)LOGGER.atFiner()).log("DSSTimeSeries===>          The minute changes at index " + k);
                        continue;
                    }
                    if (((FluentLogger.Api)LOGGER.atFiner()).isEnabled()) {
                        ((FluentLogger.Api)LOGGER.atFiner()).log("DSSTimeSeries===>          Still the same minute at index " + k);
                    }
                    if (values[k] == -3.4028234663852886E38) continue;
                    if (((FluentLogger.Api)LOGGER.atFiner()).isEnabled()) {
                        ((FluentLogger.Api)LOGGER.atFiner()).log("DSSTimeSeries===>          A potentially useful number at index " + k);
                    }
                    if (values[bestValuesIndex] == -3.4028234663852886E38) {
                        if (((FluentLogger.Api)LOGGER.atFiner()).isEnabled()) {
                            ((FluentLogger.Api)LOGGER.atFiner()).log("DSSTimeSeries===>          Replacing previous junk number with value from index " + k);
                        }
                        bestValuesIndex = k;
                        continue;
                    }
                    if (((FluentLogger.Api)LOGGER.atFiner()).isEnabled()) {
                        ((FluentLogger.Api)LOGGER.atFiner()).log("DSSTimeSeries===>          Previous best number is not junk");
                    }
                    if (qualityTx.isPresent()) {
                        if (((FluentLogger.Api)LOGGER.atFiner()).isEnabled()) {
                            ((FluentLogger.Api)LOGGER.atFiner()).log("DSSTimeSeries===>          DataSet has quality, see if OK");
                        }
                        if (((Quality)qualityTx.get()).isOkay(k)) {
                            if (((FluentLogger.Api)LOGGER.atFiner()).isEnabled()) {
                                ((FluentLogger.Api)LOGGER.atFiner()).log("DSSTimeSeries===>          This one has OK and newer, so use index " + k + " as best so far.");
                            }
                            bestValuesIndex = k;
                            bestQualityIsOK = true;
                        }
                        if (bestValuesIndex == k) continue;
                        if (((FluentLogger.Api)LOGGER.atFiner()).isEnabled()) {
                            ((FluentLogger.Api)LOGGER.atFiner()).log("DSSTimeSeries===>          Quality at index " + k + " is not OK");
                        }
                        if (bestQualityIsOK) {
                            if (!((FluentLogger.Api)LOGGER.atFiner()).isEnabled()) continue;
                            ((FluentLogger.Api)LOGGER.atFiner()).log("DSSTimeSeries===>          will keep index " + bestValuesIndex + " as best so far.");
                            continue;
                        }
                        if (((FluentLogger.Api)LOGGER.atFiner()).isEnabled()) {
                            ((FluentLogger.Api)LOGGER.atFiner()).log("DSSTimeSeries===>          previous best value did not have OK quailty either, so use index " + k + " as best so far.");
                        }
                        bestValuesIndex = k;
                        continue;
                    }
                    if (((FluentLogger.Api)LOGGER.atFiner()).isEnabled()) {
                        ((FluentLogger.Api)LOGGER.atFiner()).log("DSSTimeSeries===>          DataSet has no quality, set best value from number at index " + k);
                    }
                    bestValuesIndex = k;
                }
                if (nextMinuteIndex == 0) {
                    nextMinuteIndex = numberValues;
                    valuesDiscarded += nextMinuteIndex - i;
                    if (((FluentLogger.Api)LOGGER.atFiner()).isEnabled()) {
                        ((FluentLogger.Api)LOGGER.atFiner()).log("DSSTimeSeries===>          The data since index " + i + " is for same minute.");
                    }
                }
            }
            if (nextMinuteIndex == 0) {
                ++m;
            }
            minTimes[m] = tempVal;
            dssValues[m] = values[bestValuesIndex];
            if (dssValues[m] == -3.4028234663852886E38) {
                dssValues[m] = -3.4028234663852886E38;
            }
            if (((FluentLogger.Api)LOGGER.atFiner()).isEnabled()) {
                ((FluentLogger.Api)LOGGER.atFiner()).log("DSSTimeSeries===> at index " + m + " using " + dssValues[m]);
            }
            if (qualityTx.isPresent()) {
                quality[m] = ((Quality)qualityTx.get()).getIntegerAt(i);
            }
            if (nextMinuteIndex == 0) continue;
            if (((FluentLogger.Api)LOGGER.atFiner()).isEnabled()) {
                ((FluentLogger.Api)LOGGER.atFiner()).log("DSSTimeSeries===> ms= " + m + "  valuesDiscarded=" + valuesDiscarded + " nextMinuteIndex=" + nextMinuteIndex + "  i=" + i);
            }
            i = --nextMinuteIndex;
        }
        if (((FluentLogger.Api)LOGGER.atFine()).isEnabled()) {
            ((FluentLogger.Api)LOGGER.atFine()).log("DSSTimeSeries===> array lengths= " + (m + 1) + "  valuesDiscarded=" + valuesDiscarded);
        }
        if (valuesDiscarded > 0) {
            int al = m + 1;
            double[] dssValuesClean = new double[al];
            System.arraycopy(dssValues, 0, dssValuesClean, 0, al);
            dssValues = dssValuesClean;
            int[] minTimesClean = new int[al];
            System.arraycopy(minTimes, 0, minTimesClean, 0, al);
            minTimes = minTimesClean;
            int[] qualityClean = new int[al];
            System.arraycopy(quality, 0, qualityClean, 0, al);
            quality = qualityClean;
        }
        this.clear();
        this.setTimeZone(timeZone);
        this.setStartTime(new HecTime());
        this.setEndTime(new HecTime());
        this.setTimes(minTimes);
        this.setData(dssValues);
        this.setFlags(quality);
        this.setUnits(dataSet.getUnits().toString());
        if (dssType != null) {
            this.setType(dssType);
        } else {
            this.setType(DSSTimeSeriesUtil.getDSSType(dataSet.getTimeSeriesIdentifier()));
        }
        try {
            this.insertVerticalDatum(dataSet);
        }
        catch (Exception e) {
            throw new DSSTimeSeriesWriteException("Error during write when inserting Vertical Datum for: " + this.pathname(), e);
        }
        status = this.write(true);
        if (status < 0) {
            throw new DSSTimeSeriesWriteException("Error during write for: " + this.pathname());
        }
        if (valuesDiscarded > 0) {
            throw new DSSTimeSeriesWriteException("Warning, discarded " + valuesDiscarded + " values because the timestamps were within the same minute or out of order for: " + this.pathname());
        }
        return status;
    }

    private void insertVerticalDatum(TimeSeries dataSetTx) throws VerticalDatumException, IOException {
        boolean writingToElevRecord = new DSSPathname(this.pathname()).getCPart().toUpperCase().startsWith("ELEV");
        if (dataSetTx instanceof VerticalDatum && writingToElevRecord) {
            VerticalDatumContainer vdc = ((VerticalDatum)dataSetTx).getVerticalDatumContainer();
            DataContainer dataContainer = new DataContainer();
            dataContainer.supplementalInfo = this.getSupplementalInfo();
            dataContainer.insertVerticalDatum(vdc);
            this._recordData.supplementalInfo = dataContainer.supplementalInfo;
        }
    }

    private TimeSeries readData(long startTime, long endTime, TimeZone timeZone, TimeZone timeZoneOverride) throws DataSetException {
        return this.readData(startTime, endTime, timeZone, timeZoneOverride, null);
    }

    private TimeSeries readData(TimeSeriesTemplate template, TimeZone timeZone, TimeZone timeZoneOverride) throws DataSetException {
        return this.readData(template.getStartTime(), template.getEndTime(), timeZone, timeZoneOverride, template.getTimeSeriesIdentifier());
    }

    private TimeSeries readData(long startTime, long endTime, TimeZone tz, TimeZone tzOverride, TimeSeriesIdentifier descriptionIn) throws DSSTimeSeriesNoDataFoundException, DSSTimeSeriesReadException, DataSetTimeSeriesException, UtcIntervalOffsetMismatchException, DataSetIllegalArgumentException, DataSetException {
        Object quality;
        double[] valueArray;
        long[] milliTimes;
        TimeZone dssTz;
        TimeZone timeZone;
        this.clear();
        this.setStartTime(new HecTime());
        this.setEndTime(new HecTime());
        TimeZone timeZone2 = timeZone = tzOverride != null ? tzOverride : tz;
        if (timeZone == null) {
            timeZone = TimeZone.getDefault();
        }
        boolean regular = descriptionIn.getInterval().isRegular();
        if (tzOverride == null && regular && timeZone.useDaylightTime()) {
            int millisRawOffset = timeZone.getRawOffset();
            String id = this.getStandardId(millisRawOffset);
            timeZone = new SimpleTimeZone(millisRawOffset, id);
        }
        Calendar startCal = Calendar.getInstance(timeZone);
        startCal.setTimeInMillis(startTime);
        Calendar endCal = Calendar.getInstance(timeZone);
        endCal.setTimeInMillis(endTime);
        HecTime stime = new HecTime();
        stime.set(startCal);
        this.setStartTime(stime);
        HecTime etime = new HecTime();
        etime.set(endCal);
        this.setEndTime(etime);
        int status = this.read();
        if (status <= 0) {
            if (status == -2 || status == 0) {
                throw new DSSTimeSeriesNoDataFoundException("No data found for: " + this.pathname() + "\nTime window: " + this.startTime().toString() + ";  " + this.endTime().toString());
            }
            if (status != -1) {
                throw new DSSTimeSeriesReadException("Error during read for: " + this.pathname());
            }
        }
        if ((dssTz = this.getTimeZone()) != null && tzOverride == null && !dssTz.hasSameRules(timeZone)) {
            startCal.setTimeZone(dssTz);
            startCal.setTimeInMillis(startTime);
            endCal.setTimeZone(dssTz);
            endCal.setTimeInMillis(endTime);
            stime = new HecTime();
            stime.set(startCal);
            this.setStartTime(stime);
            etime = new HecTime();
            etime.set(endCal);
            this.setEndTime(etime);
            status = this.read();
            if (status <= 0) {
                if (status == -2 || status == 0) {
                    throw new DSSTimeSeriesNoDataFoundException("No data found for: " + this.pathname() + "\nTime window: " + this.startTime().toString() + ";  " + this.endTime().toString());
                }
                if (status != -1) {
                    throw new DSSTimeSeriesReadException("Error during read for: " + this.pathname());
                }
            }
        }
        TimeSeries dataSet = null;
        TimeSeriesIdentifier description = null;
        if (descriptionIn == null) {
            description = this.getTimeSeriesIdentifier();
        } else {
            StringBuilder sb;
            description = descriptionIn;
            TimeSeriesIdentifier dssTimeSeriesIdentifier = DSSTimeSeriesUtil.getDefaultDescription(this.pathname(), this.type(), description);
            if (!dssTimeSeriesIdentifier.describesSameDataAs(description) && (sb = DSSTimeSeriesUtil.getDescriptionDifferences(dssTimeSeriesIdentifier, this.pathname(), this.type(), descriptionIn)) != null) {
                sb.insert(0, "\nData read for pathname: " + this.pathname() + "\n   is not described by: " + description);
                throw new DataSetTimeSeriesException(sb.toString());
            }
        }
        doubleArrayContainer data = new doubleArrayContainer();
        int numberValues = this.getData(data);
        intArrayContainer timeOfData = new intArrayContainer();
        this.getTimes(timeOfData);
        intArrayContainer flags = new intArrayContainer();
        int flagsUsed = this.getFlags(flags);
        Units units = null;
        try {
            units = new Units(UnitUtil.getBestMatch((String)this.units()));
        }
        catch (DataSetIllegalArgumentException dataSetIllegalArgumentException) {
            // empty catch block
        }
        HecTime temp = new HecTime();
        if (tzOverride != null) {
            TreeMap<Date, TimeSeriesRow> overrideMap = new TreeMap<Date, TimeSeriesRow>();
            for (int i = 0; i < numberValues; ++i) {
                temp.set(timeOfData.array[i]);
                long milliTime = temp.getTimeInMillis(startCal);
                Date date = new Date(milliTime);
                TimeSeriesRow row = new TimeSeriesRow();
                row.setDateTime(date);
                double value = data.array[i];
                if (value == -3.4028234663852886E38) {
                    value = -3.4028234663852886E38;
                }
                row.setValue(value);
                if (flagsUsed > 0) {
                    row.setQuality(flags.array[i]);
                }
                overrideMap.put(date, row);
            }
            int size = overrideMap.size();
            milliTimes = new long[size];
            valueArray = new double[size];
            quality = flagsUsed > 0 ? new Quality(size) : null;
            int ii = 0;
            for (TimeSeriesRow row : overrideMap.values()) {
                milliTimes[ii] = row.getDateTime().getTime();
                valueArray[ii] = row.getValue();
                if (flagsUsed > 0) {
                    quality.setIntegerAt(row.getQuality(), ii);
                }
                ++ii;
            }
        } else {
            if (dssTz != null) {
                startCal.setTimeZone(dssTz);
            }
            milliTimes = new long[numberValues];
            quality = flagsUsed > 0 ? new Quality(numberValues) : null;
            for (int i = 0; i < numberValues; ++i) {
                temp.set(timeOfData.array[i]);
                milliTimes[i] = temp.getTimeInMillis(startCal);
                if (data.array[i] == -3.4028234663852886E38) {
                    data.array[i] = -3.4028234663852886E38;
                }
                if (flagsUsed <= 0) continue;
                quality.setIntegerAt(flags.array[i], i);
            }
            valueArray = data.array;
        }
        dataSet = description.getInterval().isIrregular() ? TimeSeriesFactory.buildTimeSeries((TimeSeriesTemplate)new TimeSeriesTemplate(description, units), (long[])milliTimes, (double[])valueArray, (Quality)quality) : TimeSeriesFactory.buildTimeSeries((TimeSeriesTemplate)new TimeSeriesTemplate(description, units), (long)milliTimes[0], (double[])valueArray, (Quality)quality);
        try {
            dataSet = this.expandVerticalDatum(dataSet);
        }
        catch (IOException | VerticalDatumException e) {
            throw new DSSTimeSeriesReadException("Error when expanding vertical datum for: " + this.pathname(), (Exception)e);
        }
        return dataSet;
    }

    private TimeSeries expandVerticalDatum(TimeSeries dataSetTx) throws VerticalDatumException, IOException {
        DataContainer dataContainer = new DataContainer();
        dataContainer.supplementalInfo = this.getSupplementalInfo();
        VerticalDatumContainer vdc = dataContainer.extractVerticalDatum();
        if (vdc != null) {
            dataSetTx = TimeSeriesFactory.buildTimeSeries((TimeSeries)dataSetTx, (VerticalDatumContainer)vdc);
        }
        return dataSetTx;
    }

    public final void setDescription(TimeSeriesIdentifier description) {
        this.setAPart("");
        this.setBPart(description.getLocationId().toString());
        this.setCPart(description.getParameter().getParameter() + "--" + description.getParameterType().toString());
        if (!description.getParameterType().toString().equalsIgnoreCase("Inst") && description.getInterval().getMinutes() != description.getDuration().getMinutes()) {
            this.setCPart(description.getParameter().getParameter() + "--" + description.getParameterType().toString() + "-" + description.getDuration().toString());
        }
        this.setFPart(description.getVersion().toString());
        int interval = description.getInterval().getMinutes();
        if (interval == 0) {
            this.setEPart("IR-MONTH");
        } else {
            this.setInterval(interval);
        }
    }

    public final TimeSeriesIdentifier getTimeSeriesIdentifier() throws DataSetIllegalArgumentException {
        String durationStr;
        Interval interval;
        ZoneId zoneId = null;
        if (this.getTimeZone() != null) {
            zoneId = this.getTimeZone().toZoneId();
        }
        LocationID location = new LocationID(this.bPart(), zoneId);
        Parameter parameter = new Parameter(this.cPart());
        String param = parameter.getParameter();
        int index = -1;
        index = param.indexOf("--");
        if (index > 0) {
            parameter = new Parameter(param.substring(0, index));
        }
        if (this.ePart().startsWith("IR-")) {
            interval = IntervalFactory.irregular();
        } else {
            Predicate<Interval> intervalMatches = IntervalFactory.equalsMinutes((int)this.interval()).or(IntervalFactory.equalsName((String)this.ePart()).and(i -> !i.isIrregular()));
            interval = (Interval)IntervalFactory.findAny(intervalMatches).orElseThrow(() -> new DataSetIllegalArgumentException("Unknown interval minutes: " + this.interval()));
        }
        Version version = new Version(this.fPart());
        String dssType = this.type();
        ParameterType parameterType = DSSTimeSeriesUtil.getParameterType(dssType);
        if (parameterType == null) {
            parameterType = ParameterType.from((String)dssType);
        }
        String tmp = null;
        index = param.indexOf("--");
        if (index > 0 && (index = (param = param.substring(index + 2)).indexOf("-")) > 0) {
            tmp = param.substring(index + 1);
        }
        Duration duration = (durationStr = tmp) != null ? (Duration)DurationFactory.findAny(DurationFactory.equalsName(durationStr).and(DurationFactory.isEOP())).orElseThrow(() -> new DataSetIllegalArgumentException("Unknown duration: " + durationStr)) : (dssType.startsWith("PER") ? (Duration)DurationFactory.findAny(DurationFactory.equalsMinutes((int)this.interval()).and(DurationFactory.isEOP())).orElseThrow(() -> new DataSetIllegalArgumentException("Unknown duration minutes: " + this.interval())) : DurationFactory.noDuration());
        return TimeSeriesIdentifierFactory.from((LocationID)location, (Parameter)parameter, (ParameterType)parameterType, (Interval)interval, (Duration)duration, (Version)version);
    }

    private static class TimeSeriesRow {
        private Date dateTime;
        private double value;
        private int quality;

        private TimeSeriesRow() {
        }

        public Date getDateTime() {
            return this.dateTime;
        }

        public void setDateTime(Date dateTime) {
            this.dateTime = dateTime;
        }

        public double getValue() {
            return this.value;
        }

        public void setValue(double value) {
            this.value = value;
        }

        public int getQuality() {
            return this.quality;
        }

        public void setQuality(int quality) {
            this.quality = quality;
        }
    }
}

