/*
 * Decompiled with CFR 0.152.
 */
package hec.data.tx;

import hec.heclib.dss.DSSPathname;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Optional;
import java.util.function.Predicate;
import mil.army.usace.hec.data.timeseries.math.TimeSeriesTemplate;
import mil.army.usace.hec.metadata.DataSetIllegalArgumentException;
import mil.army.usace.hec.metadata.Duration;
import mil.army.usace.hec.metadata.DurationFactory;
import mil.army.usace.hec.metadata.Interval;
import mil.army.usace.hec.metadata.IntervalFactory;
import mil.army.usace.hec.metadata.IntervalOffset;
import mil.army.usace.hec.metadata.LocationID;
import mil.army.usace.hec.metadata.OfficeId;
import mil.army.usace.hec.metadata.Parameter;
import mil.army.usace.hec.metadata.ParameterType;
import mil.army.usace.hec.metadata.Version;
import mil.army.usace.hec.metadata.timeseries.TimeSeriesIdentifier;
import mil.army.usace.hec.metadata.timeseries.TimeSeriesIdentifierFactory;

public final class DSSTimeSeriesUtil {
    private static final int LOCATION_ID_STR_LEN = 64;
    private static final int BASE_LOCATION_STR_LEN = 16;
    private static final int SUB_LOCATION_STR_LEN = 32;
    private static final int SUB_PARAMETER_STR_LEN = 32;
    private static final int VERSION_STR_LEN = 32;

    private DSSTimeSeriesUtil() {
        throw new AssertionError((Object)"Utility class");
    }

    public static int getLocationIdStrLen() {
        return 64;
    }

    public static int getBaseLocationStrLen() {
        return 16;
    }

    public static int getSubLocationStrLen() {
        return 32;
    }

    public static int getSubParameterStrLen() {
        return 32;
    }

    public static int getVersionStrLen() {
        return 32;
    }

    public static String getDefaultPathname(TimeSeriesTemplate dataSetTxTemplate) {
        return DSSTimeSeriesUtil.getDefaultPathname(dataSetTxTemplate.getTimeSeriesIdentifier());
    }

    public static String getDefaultPathname(TimeSeriesIdentifier description) {
        Object ePart;
        StringBuilder sb = new StringBuilder("//");
        sb.append(description.getLocationId().toString()).append("/");
        sb.append(description.getParameter().getParameter());
        int[] status = new int[1];
        Interval metaDataInterval = description.getInterval();
        if (metaDataInterval.equals(IntervalFactory.irregular())) {
            ePart = "IR-MONTH";
        } else {
            if (metaDataInterval.isIrregular()) {
                Predicate filter = IntervalFactory.equalsName((String)metaDataInterval.getInterval()).and(IntervalFactory.isIrregular().negate());
                metaDataInterval = IntervalFactory.findAny(filter).orElse(metaDataInterval);
            }
            ePart = DSSPathname.getRegularTsEPartFromInterval(6, metaDataInterval.getMinutes(), status);
            if (metaDataInterval.getInterval().startsWith("~")) {
                ePart = "~" + (String)ePart;
            } else if (metaDataInterval.getInterval().endsWith("Local")) {
                ePart = (String)ePart + "Local";
            }
            if (status[0] != 0) {
                ePart = "";
            }
        }
        sb.append("//").append((String)ePart).append("/");
        sb.append(description.getVersion().toString()).append("/");
        return sb.toString();
    }

    public static ParameterType getParameterType(String dssType) {
        ParameterType parameterType = null;
        if ("INST-VAL".equalsIgnoreCase(dssType) || "INST-CUM".equalsIgnoreCase(dssType)) {
            parameterType = ParameterType.instantaneousType();
        } else if ("PER-AVER".equalsIgnoreCase(dssType)) {
            parameterType = ParameterType.averageType();
        } else if ("PER-AVE".equalsIgnoreCase(dssType)) {
            parameterType = ParameterType.averageType();
        } else if ("PER-CUM".equalsIgnoreCase(dssType)) {
            parameterType = ParameterType.totalType();
        } else if ("PER-MAX".equalsIgnoreCase(dssType)) {
            parameterType = ParameterType.maximumType();
        } else if ("PER-MIN".equalsIgnoreCase(dssType)) {
            parameterType = ParameterType.mininmumType();
        } else if ("CONST".equalsIgnoreCase(dssType)) {
            parameterType = ParameterType.constantType();
        }
        return parameterType;
    }

    public static String getDSSType(TimeSeriesIdentifier description) {
        return DSSTimeSeriesUtil.getDSSType(description.getParameter(), description.getParameterType());
    }

    public static String getDSSType(Parameter parameter, ParameterType parameterType) {
        String dssType = "Unk";
        String txType = parameterType.toString();
        if (txType.equalsIgnoreCase("Inst")) {
            dssType = parameter.getBaseParameter().equalsIgnoreCase("Precip") ? "INST-CUM" : "INST-VAL";
        } else if (txType.equalsIgnoreCase("Ave")) {
            dssType = "PER-AVER";
        } else if (txType.equalsIgnoreCase("Total")) {
            dssType = "PER-CUM";
        } else if (txType.equalsIgnoreCase("Max")) {
            dssType = "PER-MAX";
        } else if (txType.equalsIgnoreCase("Min")) {
            dssType = "PER-MIN";
        }
        return dssType;
    }

    public static TimeSeriesIdentifier getDefaultDescription(String dssPath, String dssType, TimeSeriesIdentifier similarDesc) throws DataSetIllegalArgumentException {
        String duraTest;
        String excep;
        String excep2;
        String excep3;
        Interval interval;
        DSSPathname dssPathname = new DSSPathname(dssPath);
        Object locStr = dssPathname.bPart().replace('.', '_').replace(';', '_');
        if (((String)locStr).indexOf("#") == 0) {
            locStr = ((String)locStr).substring(1);
        }
        if (((String)locStr).indexOf("-") > 17 || !((String)locStr).contains("-") && ((String)locStr).length() > 16) {
            locStr = ((String)locStr).substring(0, 16) + "-" + ((String)locStr).substring(16);
        }
        if (((String)locStr).length() - ((String)locStr).indexOf("-") > 32 && ((String)locStr).contains("-")) {
            locStr = ((String)locStr).substring(0, ((String)locStr).indexOf("-") + 32);
        }
        if (((String)locStr).length() > 64) {
            locStr = ((String)locStr).substring(0, 63);
        }
        ZoneId zoneId = null;
        if (similarDesc != null) {
            zoneId = similarDesc.getLocationId().getZoneId().orElse(null);
        }
        LocationID location = new LocationID(new LocationID((String)locStr, zoneId));
        ArrayList<DataSetIllegalArgumentException> exceptionList = new ArrayList<DataSetIllegalArgumentException>();
        Parameter parameter = null;
        String param = dssPathname.cPart().replace('.', '_').replace(';', '_');
        if (param.length() - param.indexOf("-") > 32 && param.contains("-")) {
            param = param.substring(0, param.indexOf("-") + 32);
        }
        int index = param.indexOf("--");
        try {
            parameter = index > 0 ? new Parameter(param.substring(0, index)) : new Parameter(param);
        }
        catch (DataSetIllegalArgumentException e) {
            if (similarDesc != null) {
                parameter = similarDesc.getParameter();
            }
            String excep4 = " DSS Parameter: \"" + param + "\" is not recognized\" in C-Part.";
            exceptionList.add(new DataSetIllegalArgumentException(excep4));
        }
        ParameterType paramType = null;
        String ePart = dssPathname.ePart();
        try {
            Interval dssInterval;
            interval = similarDesc != null && similarDesc.getInterval().getInterval().equalsIgnoreCase(ePart) ? similarDesc.getInterval() : ((dssInterval = (Interval)IntervalFactory.findAnyDss((Predicate)IntervalFactory.equalsName((String)ePart)).orElseThrow(() -> new DataSetIllegalArgumentException("No DSS interval found matching: " + ePart))).isRegular() ? (Interval)IntervalFactory.findAny(IntervalFactory.equalsSeconds((int)dssInterval.getSeconds()).and(Interval::isRegular)).orElseThrow(() -> new DataSetIllegalArgumentException("No CWMS interval found matching: " + dssInterval.getSeconds() + " seconds")) : IntervalFactory.irregular());
        }
        catch (DataSetIllegalArgumentException e) {
            String excep5 = " DSS Interval \"" + ePart + "\" is not recognized in the DSS E-Part!";
            exceptionList.add(new DataSetIllegalArgumentException(excep5));
            interval = null;
        }
        String verStr = dssPathname.fPart().replace('.', '_').replace(';', '_');
        if (verStr.length() > 32) {
            verStr = verStr.substring(0, 32);
        }
        Version version = new Version(verStr);
        Duration duration = null;
        String tmp = null;
        try {
            index = param.indexOf("--");
            if (index > 0) {
                if ((index = (param = param.substring(index + 2)).indexOf("-")) > 0) {
                    tmp = param.substring(index + 1);
                    paramType = ParameterType.from((String)param.substring(0, index));
                } else {
                    paramType = ParameterType.from((String)param);
                }
            }
            if (dssType != null) {
                paramType = DSSTimeSeriesUtil.getParameterType(dssType);
            }
        }
        catch (DataSetIllegalArgumentException dataSetIllegalArgumentException) {
            // empty catch block
        }
        if (paramType == null) {
            if (similarDesc != null) {
                paramType = similarDesc.getParameterType();
            } else if (dssType == null) {
                exceptionList.add(new DataSetIllegalArgumentException(" DSS data type could not be determined."));
            } else if (dssType.trim().length() == 0) {
                exceptionList.add(new DataSetIllegalArgumentException(" DSS data type was not set."));
            } else {
                excep3 = " DSS data type: \"" + dssType + "\" is not recognized";
                exceptionList.add(new DataSetIllegalArgumentException(excep3));
            }
        }
        if (tmp != null) {
            Optional find = DurationFactory.findAny((Predicate)DurationFactory.equalsName(tmp));
            if (find.isPresent()) {
                duration = (Duration)find.get();
            } else {
                excep2 = " Duration: \"" + tmp + "\" is not recognized\" as encoded in C-Part.";
                exceptionList.add(new DataSetIllegalArgumentException(excep2));
            }
        } else if (paramType != null && paramType.getParameterType().equals("Inst")) {
            duration = DurationFactory.noDuration();
        } else {
            String durationStr = interval.getInterval().replace("~", "").replace("Local", "");
            Optional find = DurationFactory.findAny((Predicate)DurationFactory.equalsName((String)durationStr));
            if (find.isPresent()) {
                duration = (Duration)find.get();
            } else {
                excep = " Duration: \"" + tmp + "\" is not recognized\" as encoded in C-Part.";
                exceptionList.add(new DataSetIllegalArgumentException(excep));
            }
        }
        if (similarDesc != null && paramType != null && ((duraTest = similarDesc.getDuration().toString()).equals("0") && paramType.toString().equals("Inst") || !duraTest.equals("0") && !paramType.toString().equals("Inst"))) {
            try {
                duration = (Duration)DurationFactory.findAny((Predicate)DurationFactory.equalsName((String)duraTest)).orElseThrow(() -> new DataSetIllegalArgumentException("No duration found matching: " + duraTest));
            }
            catch (DataSetIllegalArgumentException e) {
                exceptionList.add(e);
            }
        }
        if (!exceptionList.isEmpty()) {
            excep3 = "Unable to describe time series using DSS Pathame:\n\"" + dssPath;
            exceptionList.add(0, new DataSetIllegalArgumentException(excep3));
            throw new DataSetIllegalArgumentException(exceptionList);
        }
        TimeSeriesIdentifier newDescription = null;
        try {
            if (similarDesc == null) {
                newDescription = TimeSeriesIdentifierFactory.from((LocationID)location, (Parameter)parameter, (ParameterType)paramType, (Interval)interval, (Duration)duration, (Version)version);
            } else {
                IntervalOffset intervalOffset = similarDesc.getIntervalOffset();
                OfficeId officeId = similarDesc.getOfficeId().orElse(null);
                newDescription = TimeSeriesIdentifierFactory.from((OfficeId)officeId, (LocationID)location, (Parameter)parameter, (ParameterType)paramType, (Interval)interval, (Duration)duration, (Version)version, (IntervalOffset)intervalOffset);
            }
        }
        catch (DataSetIllegalArgumentException e) {
            excep = "Resulting " + e.getMessage();
            exceptionList.add(new DataSetIllegalArgumentException(excep));
        }
        if (!exceptionList.isEmpty()) {
            excep2 = "Unable to describe time series using DSS Pathame:\n\"" + dssPath;
            exceptionList.add(0, new DataSetIllegalArgumentException(excep2));
            throw new DataSetIllegalArgumentException(exceptionList);
        }
        return newDescription;
    }

    public static StringBuilder getDescriptionDifferences(TimeSeriesIdentifier desc1, TimeSeriesIdentifier desc2) {
        return DSSTimeSeriesUtil.getDescriptionDifferences(desc1, null, null, desc2, null, null);
    }

    public static StringBuilder getDescriptionDifferences(TimeSeriesIdentifier desc1, String desc1DssType, TimeSeriesIdentifier desc2) {
        return DSSTimeSeriesUtil.getDescriptionDifferences(desc1, null, desc1DssType, desc2, null, null);
    }

    public static StringBuilder getDescriptionDifferences(TimeSeriesIdentifier desc1, TimeSeriesIdentifier desc2, String desc2DssType) {
        return DSSTimeSeriesUtil.getDescriptionDifferences(desc1, null, null, desc2, null, desc2DssType);
    }

    public static StringBuilder getDescriptionDifferences(TimeSeriesIdentifier desc1, String pathname1, String desc1DssType, TimeSeriesIdentifier desc2) {
        return DSSTimeSeriesUtil.getDescriptionDifferences(desc1, pathname1, desc1DssType, desc2, null, null);
    }

    public static StringBuilder getDescriptionDifferences(TimeSeriesIdentifier desc1, TimeSeriesIdentifier desc2, String pathname2, String desc2DssType) {
        return DSSTimeSeriesUtil.getDescriptionDifferences(desc1, null, null, desc2, pathname2, desc2DssType);
    }

    public static StringBuilder getDescriptionDifferences(TimeSeriesIdentifier desc1, String pathname1, String dssType1, TimeSeriesIdentifier desc2, String pathname2, String dssType2) {
        Object dssIntervalLab2;
        Object dssIntervalLab1;
        String notEquals = " != ";
        if (pathname1 == null) {
            dssIntervalLab1 = "";
        } else {
            DSSPathname pn = new DSSPathname(pathname1);
            dssIntervalLab1 = "(" + pn.ePart() + ")";
        }
        if (pathname2 == null) {
            dssIntervalLab2 = "";
        } else {
            DSSPathname pn = new DSSPathname(pathname2);
            dssIntervalLab2 = "(" + pn.ePart() + ")";
        }
        Object dssTypeLab1 = dssType1 == null ? "" : "(" + dssType1 + ")";
        Object dssTypeLab2 = dssType2 == null ? "" : "(" + dssType2 + ")";
        StringBuilder sb = null;
        if (!desc1.describesSameDataAs(desc2)) {
            sb = new StringBuilder();
            if (!desc1.getParameter().getBaseParameter().equals(desc2.getParameter().getBaseParameter())) {
                sb.append("\n   Parameters not equal: ").append(desc1.getParameter().getBaseParameter()).append(notEquals).append(desc2.getParameter().getBaseParameter());
            }
            if (!desc1.getParameterType().equals((Object)desc2.getParameterType())) {
                sb.append("\n   Parameter types not equal: ").append(desc1.getParameterType().toString()).append((String)dssTypeLab1).append(notEquals).append(desc2.getParameterType().toString()).append((String)dssTypeLab2);
            }
            if (!desc1.getInterval().equals(desc2.getInterval())) {
                sb.append("\n   Intervals not equal: ").append(desc1.getInterval().toString()).append((String)dssIntervalLab1).append(notEquals).append(desc2.getInterval().toString()).append((String)dssIntervalLab2);
            }
            if (!desc1.getDuration().equals((Object)desc2.getDuration())) {
                sb.append("\n   Durations not equal: ").append(desc1.getDuration().toString()).append(notEquals).append(desc2.getDuration().toString());
            }
            if (!desc1.getIntervalOffset().equals((Object)desc2.getIntervalOffset())) {
                sb.append("\n   Interval Offsets not equal: ").append(desc1.getDuration().toString()).append(notEquals).append(desc2.getDuration().toString());
            }
        }
        return sb;
    }
}

