/*
 * Decompiled with CFR 0.152.
 */
package hec.data.tx;

import hec.data.DataSetException;
import hec.data.DataSetIllegalArgumentException;
import hec.data.Interval;
import hec.data.Units;
import hec.data.UnitsConversionException;
import hec.data.tx.DataSetTxDeriveException;
import hec.data.tx.DataSetTxException;
import hec.data.tx.DataSetTxIllegalArgumentException;
import hec.data.tx.DataSetTxTemplate;
import hec.data.tx.DescriptionTx;
import hec.data.tx.LocalRegularTime;
import hec.data.tx.QualityTx;
import hec.data.tx.UtcIntervalOffsetMismatchException;
import hec.heclib.util.HecTime;
import hec.io.TimeSeriesContainer;
import hec.io.TimeSeriesContainerFactory;
import hec.io.TimeSeriesContainerQualityUtil;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Date;
import java.util.NavigableMap;
import java.util.Objects;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.function.BiFunction;
import java.util.logging.Level;
import java.util.logging.Logger;
import mil.army.usace.hec.data.timeseries.DataSetTimeSeriesDeriveException;
import mil.army.usace.hec.data.timeseries.Quality;
import mil.army.usace.hec.data.timeseries.TimeSeries;
import mil.army.usace.hec.data.timeseries.TimeSeriesFactory;
import mil.army.usace.hec.data.timeseries.TimeSeriesPrinter;
import mil.army.usace.hec.data.timeseries.comparator.TimeSeriesQualityComparator;
import mil.army.usace.hec.data.timeseries.comparator.TimeSeriesTimesComparator;
import mil.army.usace.hec.data.timeseries.comparator.TimeSeriesValuesComparator;
import mil.army.usace.hec.data.timeseries.math.TimeComparisonMethod;
import mil.army.usace.hec.data.timeseries.math.TimeSeriesCombine;
import mil.army.usace.hec.data.timeseries.math.TimeSeriesDerive;
import mil.army.usace.hec.data.timeseries.math.TimeSeriesTemplate;
import mil.army.usace.hec.metadata.constants.NumericalConstants;
import mil.army.usace.hec.metadata.constants.TimeSeriesStoreRule;
import mil.army.usace.hec.metadata.timeseries.DataSetTimeSeriesException;
import mil.army.usace.hec.metadata.timeseries.DataSetTimeSeriesIllegalArgumentException;
import mil.army.usace.hec.metadata.timeseries.IntervalOffsetMismatchException;

@Deprecated
public class DataSetTx
extends DataSetTxTemplate
implements Serializable {
    private static final long serialVersionUID = -2433409267445035932L;
    private static final Logger LOGGER = Logger.getLogger(DataSetTx.class.getName());
    public static final int COMPARE_NORMAL_TIMES = TimeComparisonMethod.COMPARE_NORMAL_TIMES.getValue();
    public static final int COMPARE_TRUNCATED_TIMES = TimeComparisonMethod.COMPARE_TRUNCATED_TIMES.getValue();
    public static final int COMPARE_ROUNDED_TIMES = TimeComparisonMethod.COMPARE_ROUNDED_TIMES.getValue();
    public static final int COMPARE_NEAR_TIMES = TimeComparisonMethod.COMPARE_NEAR_TIMES.getValue();
    public static final double ORACLE_PRECISION = 1.0E-14;
    private TimeSeries _timeSeries;

    public DataSetTx(DescriptionTx description, long startTime, double[] values, Units units, QualityTx quality) throws DataSetTxException, UtcIntervalOffsetMismatchException, DataSetIllegalArgumentException, DataSetTxIllegalArgumentException {
        super(description, startTime, Long.MIN_VALUE, units);
        try {
            Quality qualityMetaData = null;
            if (quality != null) {
                qualityMetaData = quality.getQualityMetaData();
            }
            this.setTimeSeries(TimeSeriesFactory.buildTimeSeries((TimeSeriesTemplate)this.getTimeSeriesTemplate(), (long)startTime, (double[])values, (Quality)qualityMetaData));
        }
        catch (mil.army.usace.hec.metadata.DataSetException e) {
            throw new DataSetTxException((Exception)((Object)e));
        }
    }

    public DataSetTx(DescriptionTx description, long[] times, double[] values, Units units, QualityTx quality) throws DataSetTxException, UtcIntervalOffsetMismatchException, DataSetIllegalArgumentException, DataSetTxIllegalArgumentException {
        super(description, Long.MIN_VALUE, Long.MIN_VALUE, units);
        try {
            Quality qualityMetaData = null;
            if (quality != null) {
                qualityMetaData = quality.getQualityMetaData();
            }
            this.setTimeSeries(TimeSeriesFactory.buildTimeSeries((TimeSeriesTemplate)this.getTimeSeriesTemplate(), (long[])times, (double[])values, (Quality)qualityMetaData));
        }
        catch (mil.army.usace.hec.metadata.DataSetException e) {
            throw new DataSetTxException((Exception)((Object)e));
        }
    }

    public DataSetTx(DataSetTxTemplate template, long[] times, double[] values, QualityTx quality, Units units) throws DataSetTxException, UtcIntervalOffsetMismatchException, DataSetIllegalArgumentException {
        super(template);
        if (units != null && !units.isSetToUndefined() && (this.getTimeSeriesTemplate().getUnits() == null || this.getTimeSeriesTemplate().getUnits().isSetToUndefined())) {
            this.getTimeSeriesTemplate().setUnits(units.getUnitsMetaData());
        }
        try {
            Quality qualityMetaData = null;
            if (quality != null) {
                qualityMetaData = quality.getQualityMetaData();
            }
            this.setTimeSeries(TimeSeriesFactory.buildTimeSeries((TimeSeriesTemplate)this.getTimeSeriesTemplate(), (long[])times, (double[])values, (Quality)qualityMetaData));
        }
        catch (mil.army.usace.hec.metadata.DataSetException e) {
            throw new DataSetTxException((Exception)((Object)e));
        }
        this._timeSeries.setUnits(this.getUnits().getUnitsMetaData());
        if (this.needToChangeUnits(template)) {
            this.changeUnits(template);
        }
    }

    public DataSetTx(DataSetTxTemplate template, long startValuesTime, double[] values, QualityTx quality, Units units) throws DataSetTxException, UtcIntervalOffsetMismatchException, DataSetIllegalArgumentException {
        super(template);
        if (units != null && !units.isSetToUndefined() && (this.getTimeSeriesTemplate().getUnits() == null || this.getTimeSeriesTemplate().getUnits().isSetToUndefined())) {
            this.getTimeSeriesTemplate().setUnits(units.getUnitsMetaData());
        }
        try {
            Quality qualityMetaData = null;
            if (quality != null) {
                qualityMetaData = quality.getQualityMetaData();
            }
            this.setTimeSeries(TimeSeriesFactory.buildTimeSeries((TimeSeriesTemplate)this.getTimeSeriesTemplate(), (long)startValuesTime, (double[])values, (Quality)qualityMetaData));
        }
        catch (mil.army.usace.hec.metadata.DataSetException e) {
            throw new DataSetTxException((Exception)((Object)e));
        }
        this._timeSeries.setUnits(this.getUnits().getUnitsMetaData());
        if (this.needToChangeUnits(template)) {
            this.changeUnits(template);
        }
    }

    @Deprecated
    public DataSetTx(TimeSeriesContainer tsc) throws DataSetException, DataSetTxIllegalArgumentException, DataSetIllegalArgumentException {
        this(DataSetTx.toTimeSeries(tsc));
    }

    @Deprecated
    public DataSetTx(String officeId, TimeSeriesContainer tsc) throws DataSetException, DataSetIllegalArgumentException, DataSetTxIllegalArgumentException {
        this(tsc, new DescriptionTx(officeId, tsc.getFullName()));
    }

    @Deprecated
    public DataSetTx(TimeSeriesContainer tsc, DescriptionTx descriptionTx) throws DataSetException, DataSetIllegalArgumentException, DataSetTxIllegalArgumentException {
        this(DataSetTx.toTimeSeries(tsc, descriptionTx));
    }

    private static TimeSeries toTimeSeries(TimeSeriesContainer tsc) throws DataSetTxException {
        try {
            return TimeSeriesContainerFactory.toTimeSeries(tsc, NumericalConstants.UTC_ZONEID);
        }
        catch (DataSetTimeSeriesException e) {
            throw new DataSetTxException((Exception)((Object)e));
        }
    }

    private static TimeSeries toTimeSeries(TimeSeriesContainer tsc, DescriptionTx descriptionTx) throws DataSetTxException {
        try {
            return TimeSeriesContainerFactory.toTimeSeries(tsc, descriptionTx.getTimeSeriesIdentifierMetaData());
        }
        catch (DataSetTimeSeriesException e) {
            throw new DataSetTxException((Exception)((Object)e));
        }
    }

    public DataSetTx(DescriptionTx description, Units units) throws DataSetTxException, DataSetTxIllegalArgumentException {
        super(description, Long.MIN_VALUE, Long.MIN_VALUE, units);
        try {
            this.setTimeSeries(TimeSeriesFactory.buildTimeSeries((TimeSeriesTemplate)this.getTimeSeriesTemplate()));
        }
        catch (mil.army.usace.hec.metadata.DataSetException e) {
            throw new DataSetTxException((Exception)((Object)e));
        }
    }

    public DataSetTx() {
    }

    public DataSetTx(DataSetTx dataSetTx) {
        this(dataSetTx._timeSeries);
    }

    public DataSetTx(TimeSeries timeSeries) throws DataSetTxIllegalArgumentException {
        super(DataSetTx.buildTemplate(timeSeries));
        try {
            this.setTimeSeries(TimeSeriesFactory.copy((TimeSeries)timeSeries));
        }
        catch (mil.army.usace.hec.metadata.DataSetException e) {
            throw new DataSetTxIllegalArgumentException((Exception)((Object)e));
        }
    }

    public final TimeSeries getTimeSeries() {
        return this._timeSeries;
    }

    private static TimeSeriesTemplate buildTemplate(TimeSeries timeSeries) throws DataSetTxIllegalArgumentException {
        long startTime = Long.MIN_VALUE;
        long endTime = Long.MIN_VALUE;
        if (timeSeries.getNumberValues() > 0) {
            startTime = timeSeries.getStartTime().toInstant().toEpochMilli();
            endTime = timeSeries.getEndTime().toInstant().toEpochMilli();
        }
        try {
            return new TimeSeriesTemplate(timeSeries.getTimeSeriesIdentifier(), startTime, endTime, timeSeries.getUnits(), timeSeries.getPreserveRejectedAndMissingValues(), timeSeries.getMaxTimeGap());
        }
        catch (DataSetTimeSeriesException e) {
            throw new DataSetTxIllegalArgumentException((Exception)((Object)e));
        }
    }

    void setTimeSeries(TimeSeries timeSeries) {
        try {
            this.setTimeSeriesTemplate(new TimeSeriesTemplate(timeSeries.getTimeSeriesIdentifier(), timeSeries.getStartTime().toInstant().toEpochMilli(), timeSeries.getEndTime().toInstant().toEpochMilli(), timeSeries.getUnits(), timeSeries.getPreserveRejectedAndMissingValues(), timeSeries.getMaxTimeGap()));
            this._timeSeries = timeSeries;
        }
        catch (DataSetTimeSeriesIllegalArgumentException e) {
            LOGGER.log(Level.SEVERE, "Template should already be valid", e);
        }
    }

    @Override
    public void setStartTime(long startTime) throws DataSetTxIllegalArgumentException {
        if (this.getDescriptionTx().isRegular() && this._timeSeries.getValues() != null && this._timeSeries.getValues().length > 0) {
            throw new DataSetTxIllegalArgumentException("Cannot set start time for a regular interval DataSetTx that has values");
        }
        super.setStartTimeInternal(startTime);
    }

    @Override
    public void setEndTime(long endTime) throws DataSetTxIllegalArgumentException {
        super.setEndTimeInternal(endTime);
    }

    @Override
    public void clearTimeWindow() throws DataSetTxIllegalArgumentException {
        if (this.getDescriptionTx().isRegular() && this._timeSeries.getValues() != null && this._timeSeries.getValues().length > 0) {
            throw new DataSetTxIllegalArgumentException("Cannot clear start time for a regular interval DataSetTx that has values");
        }
        super.clearTimeWindowInternal();
    }

    public long getFirstTime() {
        return this._timeSeries.getStartTime().toInstant().toEpochMilli();
    }

    public void setCountMissing(boolean bStart, boolean bEnd) {
        this._timeSeries.getTimeSeriesStatistics().setCountMissing(bStart, bEnd);
    }

    public void set(long[] times, double[] values, QualityTx quality) throws DataSetTxIllegalArgumentException, UtcIntervalOffsetMismatchException, DataSetIllegalArgumentException {
        try {
            Quality qualityMetaData = null;
            if (quality != null) {
                qualityMetaData = quality.getQualityMetaData();
            }
            this._timeSeries.set(times, values, qualityMetaData);
            this.updateTemplate();
        }
        catch (DataSetTimeSeriesIllegalArgumentException e) {
            throw new DataSetTxIllegalArgumentException((Exception)((Object)e));
        }
        catch (IntervalOffsetMismatchException e) {
            throw new UtcIntervalOffsetMismatchException((Exception)((Object)e));
        }
        catch (mil.army.usace.hec.metadata.DataSetIllegalArgumentException e) {
            throw new DataSetIllegalArgumentException((Exception)((Object)e));
        }
    }

    @Deprecated
    public TimeSeriesContainer getTimeSeriesContainer() {
        try {
            return TimeSeriesContainerFactory.toTimeSeriesContainer(this.getTimeSeries());
        }
        catch (DataSetTimeSeriesException e) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.WARNING, e, () -> "Unable to convert time series: " + this + " to TimeSeriesContainer");
            } else {
                LOGGER.log(Level.WARNING, () -> "Unable to convert time series: " + this.getDescriptionTx() + " to TimeSeriesContainer");
            }
            return null;
        }
    }

    @Override
    public String toString() {
        return this._timeSeries.toString();
    }

    public void tabulateValues(TimeZone timeZone) {
        TimeSeriesPrinter timeSeriesPrinter = new TimeSeriesPrinter(this._timeSeries);
        timeSeriesPrinter.tabulateValues(timeZone);
    }

    public void tabulateValues(TimeZone timeZone, String numberFormatPattern) {
        TimeSeriesPrinter timeSeriesPrinter = new TimeSeriesPrinter(this._timeSeries);
        timeSeriesPrinter.tabulateValues(timeZone, numberFormatPattern);
    }

    public void tabulateValues() {
        TimeSeriesPrinter timeSeriesPrinter = new TimeSeriesPrinter(this._timeSeries);
        timeSeriesPrinter.tabulateValues();
    }

    public void tabulateStatistics(TimeZone timeZone) {
        TimeSeriesPrinter timeSeriesPrinter = new TimeSeriesPrinter(this._timeSeries);
        timeSeriesPrinter.tabulateStatistics(timeZone);
    }

    public void tabulateStatistics(TimeZone timeZone, String numberFormatPattern) {
        TimeSeriesPrinter timeSeriesPrinter = new TimeSeriesPrinter(this._timeSeries);
        timeSeriesPrinter.tabulateStatistics(timeZone, numberFormatPattern);
    }

    public void tabulateStatistics() {
        TimeSeriesPrinter timeSeriesPrinter = new TimeSeriesPrinter(this._timeSeries);
        timeSeriesPrinter.tabulateStatistics();
    }

    public NavigableMap<Date, Double> getDateValueNavigableMap() {
        return this._timeSeries.getDateValueNavigableMap();
    }

    public NavigableMap<Date, String> getQualitySymbols() {
        return this._timeSeries.getQuality().map(q -> q.getQualitySymbols(this.getTimes())).orElse(new TreeMap());
    }

    public NavigableMap<Date, Integer> getQualityIntegers() {
        return this._timeSeries.getQuality().map(q -> q.getQualityIntegers(this.getTimes())).orElse(new TreeMap());
    }

    @Deprecated
    public NavigableMap<Date, byte[]> getQualityBytes() {
        return this.getQualityMap(QualityTx::getElementAt);
    }

    private <V> NavigableMap<Date, V> getQualityMap(BiFunction<QualityTx, Integer, V> qualityExtractor) {
        TreeMap<Date, V> retval = new TreeMap<Date, V>();
        long[] timesArray = this.getTimes();
        QualityTx qualityTx = this.getQualityTx();
        if (qualityTx != null) {
            for (int i = 0; i < timesArray.length; ++i) {
                Date date = new Date(timesArray[i]);
                retval.put(date, qualityExtractor.apply(qualityTx, i));
            }
        }
        return retval;
    }

    public double[] getValues() {
        return this._timeSeries.getValues();
    }

    public double[] getValuesWithQualityFlagsApplied() {
        return this._timeSeries.getValuesWithQualityFlagsApplied();
    }

    public int getIndexOfLatestValidValue() {
        return this._timeSeries.getIndexOfLatestValidValue();
    }

    public QualityTx getQualityTx() {
        return this._timeSeries.getQuality().map(QualityTx::new).orElse(null);
    }

    public boolean hasQuality() {
        return this._timeSeries.hasQuality();
    }

    public void addEmptyQualityTx() {
        this._timeSeries.addEmptyQualityTx();
    }

    public int[] getIntTimes() {
        double[] values = this.getValues();
        int[] itimes = new int[values.length];
        if (values.length == 0) {
            return itimes;
        }
        HecTime hecTime = new HecTime();
        Interval interval = this.getDescriptionTx().getInterval();
        if (interval.isRegular()) {
            long ltime = this.getStartTime();
            hecTime.setTimeInMillis(ltime, 0);
            itimes[0] = hecTime.value();
            TimeZone tz = utcTz;
            try {
                for (int i = 1; i < values.length; ++i) {
                    long newltime = Interval.getNextIntervalTime(ltime, interval, tz);
                    hecTime.setTimeInMillis(newltime, 0);
                    itimes[i] = hecTime.value();
                    ltime = newltime;
                }
            }
            catch (Exception e) {
                itimes = null;
            }
        } else {
            long[] times = this.getTimes();
            for (int i = 0; i < values.length; ++i) {
                long newltime = times[i];
                hecTime.setTimeInMillis(newltime, 0);
                itimes[i] = hecTime.value();
            }
        }
        return itimes;
    }

    public long[] getTimes() {
        return this._timeSeries.getTimes();
    }

    @Deprecated
    public static long[] getTimes(long startValuesTime, double[] values, Interval interval) {
        return DataSetTx.getTimes(startValuesTime, values, interval, utcTz);
    }

    @Deprecated
    public static long[] getTimes(long startValuesTime, double[] values, Interval interval, TimeZone tz) {
        long[] times = new long[values.length];
        if (values.length == 0) {
            return times;
        }
        times[0] = startValuesTime;
        try {
            if (tz.equals(utcTz)) {
                for (int i = 1; i < values.length; ++i) {
                    times[i] = Interval.getNextIntervalTime(times[i - 1], interval, tz);
                }
            } else {
                LocalRegularTime lrTime = new LocalRegularTime(tz, interval);
                for (int i = 1; i < values.length; ++i) {
                    times[i] = lrTime.getTimeAtNextInterval(times[i - 1]);
                }
            }
        }
        catch (DataSetIllegalArgumentException e) {
            times = null;
        }
        return times;
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof DataSetTx) {
            return this.equals((DataSetTx)object);
        }
        return super.equals(object);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.getTimeSeries());
    }

    public boolean equals(DataSetTx dataSetTx) {
        return Objects.equals(this._timeSeries, dataSetTx._timeSeries);
    }

    public boolean identicalTimesValuesQuality(DataSetTx dataSetTx, double precision) {
        return new TimeSeriesValuesComparator(precision).compare(this._timeSeries, dataSetTx._timeSeries) == 0 && new TimeSeriesQualityComparator().compare(this._timeSeries, dataSetTx._timeSeries) == 0 && new TimeSeriesTimesComparator().compare(this._timeSeries, dataSetTx._timeSeries) == 0;
    }

    public boolean isOkay(int index) {
        return this._timeSeries.isOkay(index);
    }

    public boolean isNotOkay(int index) {
        return !this.isOkay(index);
    }

    public boolean isMissing(int index) {
        return this._timeSeries.isMissing(index);
    }

    public boolean isNotMissing(int index) {
        return !this.isMissing(index);
    }

    public boolean isProtected(int index) {
        return this._timeSeries.getQuality().map(q -> q.isProtected(index)).orElse(false);
    }

    public boolean isNotProtected(int index) {
        return this._timeSeries.getQuality().map(q -> q.isProtected(index)).orElse(true);
    }

    public boolean isReject(int index) {
        return this._timeSeries.getQuality().map(q -> q.isReject(index)).orElse(false);
    }

    public boolean isNotReject(int index) {
        return this._timeSeries.getQuality().map(q -> q.isNotReject(index)).orElse(true);
    }

    public boolean isQuestion(int index) {
        return this._timeSeries.getQuality().map(q -> q.isQuestion(index)).orElse(false);
    }

    public boolean isNotQuestion(int index) {
        return this._timeSeries.getQuality().map(q -> q.isNotQuestion(index)).orElse(true);
    }

    public boolean isScreened(int index) {
        return this._timeSeries.getQuality().map(q -> q.isScreened(index)).orElse(false);
    }

    public boolean isNotScreened(int index) {
        return this._timeSeries.getQuality().map(q -> q.isNotScreened(index)).orElse(true);
    }

    public void updateStatistics() {
        this._timeSeries.getTimeSeriesStatistics().setOutOfDate();
        this._timeSeries.getTimeSeriesStatistics().getMaxValue();
    }

    public int getNumberValuesOkay() {
        return this._timeSeries.getTimeSeriesStatistics().getNumberValuesOkay();
    }

    public int getNumberValuesMissing() {
        return this._timeSeries.getTimeSeriesStatistics().getNumberValuesMissing();
    }

    @Deprecated
    public static int getNumberValuesMissing(TimeSeriesContainer tsc) {
        return TimeSeriesContainerQualityUtil.getNumberValuesMissing(tsc);
    }

    public int getNumberValuesReject() {
        return this._timeSeries.getTimeSeriesStatistics().getNumberValuesReject();
    }

    @Deprecated
    public static int getNumberValuesReject(TimeSeriesContainer tsc) {
        return TimeSeriesContainerQualityUtil.getNumberValuesReject(tsc);
    }

    public int getNumberValuesQuestion() {
        return this._timeSeries.getTimeSeriesStatistics().getNumberValuesQuestion();
    }

    @Deprecated
    public static int getNumberValuesQuestion(TimeSeriesContainer tsc) {
        return TimeSeriesContainerQualityUtil.getNumberValuesQuestion(tsc);
    }

    public int getNumberValuesProtected() {
        return this._timeSeries.getTimeSeriesStatistics().getNumberValuesProtected();
    }

    public int getNumberValues() {
        return this._timeSeries.getNumberValues();
    }

    public int getIntervalOffsetFromUTCBaseSec() {
        return this._timeSeries.getTimeSeriesIdentifier().getIntervalOffset().getOffsetSeconds();
    }

    public double getMaxValue() {
        return this._timeSeries.getTimeSeriesStatistics().getMaxValue();
    }

    public long getMaxValueTime() {
        return this._timeSeries.getTimeSeriesStatistics().getMaxValueTime();
    }

    public long getMinValueTime() {
        return this._timeSeries.getTimeSeriesStatistics().getMinValueTime();
    }

    public double getMinValue() {
        return this._timeSeries.getTimeSeriesStatistics().getMinValue();
    }

    public double getAbsMinNonZeroValue() {
        return this._timeSeries.getTimeSeriesStatistics().getAbsMinNonZeroValue();
    }

    public double getAveValue() {
        return this._timeSeries.getTimeSeriesStatistics().getAveValue();
    }

    public boolean isSameTimeWindow(DataSetTx dataSetTx) {
        return this._timeSeries.isSameTimeWindow(dataSetTx._timeSeries);
    }

    public void combine(DataSetTx dataSetTx, int storeRule, boolean overrideProtection) throws DataSetException {
        try {
            this.setTimeSeries(TimeSeriesCombine.combine((TimeSeries)this._timeSeries, (TimeSeries)dataSetTx._timeSeries, (TimeSeriesStoreRule)DataSetTx.toTimeSeriesStoreRule(storeRule), (boolean)overrideProtection));
        }
        catch (mil.army.usace.hec.metadata.DataSetException e) {
            throw new DataSetException(e);
        }
    }

    public void combine(DataSetTx dataSetTx, int storeRule, boolean overrideProtection, long timeComparisonInterval, int timeComparisonMethod) throws DataSetIllegalArgumentException, DataSetException {
        try {
            this.setTimeSeries(TimeSeriesCombine.combine((TimeSeries)this._timeSeries, (TimeSeries)dataSetTx._timeSeries, (TimeSeriesStoreRule)DataSetTx.toTimeSeriesStoreRule(storeRule), (boolean)overrideProtection, (long)timeComparisonInterval, (TimeComparisonMethod)DataSetTx.toTimeComparisonMethod(timeComparisonMethod)));
        }
        catch (mil.army.usace.hec.metadata.DataSetException e) {
            throw new DataSetException(e);
        }
    }

    private static TimeComparisonMethod toTimeComparisonMethod(long timeComparisonInterval) {
        return Arrays.stream(TimeComparisonMethod.values()).filter(v -> (long)v.getValue() == timeComparisonInterval).findAny().orElseThrow(() -> new IllegalArgumentException("Invalid comparison strategy: " + timeComparisonInterval));
    }

    private static TimeSeriesStoreRule toTimeSeriesStoreRule(int storeRule) {
        return Arrays.stream(TimeSeriesStoreRule.values()).filter(v -> v.getRuleConstant() == storeRule).findAny().orElseThrow(() -> new IllegalArgumentException("Invalid store rule: " + storeRule));
    }

    public void combine(long time, double value, byte[] qualityBytes, int storeRule, boolean overrideProtection) throws DataSetException {
        this.combine(time, value, qualityBytes, storeRule, overrideProtection, 0L, COMPARE_NORMAL_TIMES);
    }

    public void combine(long time, double value, byte[] qualityBytes, int storeRule, boolean overrideProtection, long timeComparisonInterval, int timeComparisonMethod) throws DataSetException {
        try {
            this.setTimeSeries(TimeSeriesCombine.combine((TimeSeries)this._timeSeries, (long)time, (double)value, (byte[])qualityBytes, (TimeSeriesStoreRule)DataSetTx.toTimeSeriesStoreRule(storeRule), (boolean)overrideProtection, (long)timeComparisonInterval, (TimeComparisonMethod)DataSetTx.toTimeComparisonMethod(timeComparisonInterval)));
        }
        catch (mil.army.usace.hec.metadata.DataSetException e) {
            throw new DataSetException(e);
        }
    }

    public void derive(DataSetTxTemplate dataSetTxTemplate) throws DataSetIllegalArgumentException, DataSetException {
        try {
            TimeSeriesDerive timeSeriesDerive = new TimeSeriesDerive();
            TimeSeriesTemplate timeSeriesTemplate = dataSetTxTemplate.getTimeSeriesTemplate();
            if ((timeSeriesTemplate.getUnits() == null || timeSeriesTemplate.getUnits().isSetToUndefined()) && this._timeSeries.getUnits() != null && !this._timeSeries.getUnits().isSetToUndefined()) {
                timeSeriesTemplate.setUnits(this._timeSeries.getUnits());
            }
            TimeSeries newTimeSeries = timeSeriesDerive.derive(this._timeSeries, timeSeriesTemplate);
            this.setTimeSeries(newTimeSeries);
            this.updateTemplate();
        }
        catch (mil.army.usace.hec.metadata.DataSetException e) {
            throw new DataSetException(e);
        }
    }

    public boolean needToChangeUnits(DataSetTxTemplate dataSetTxTemplate) throws DataSetTxDeriveException {
        if (this.getUnits() == null) {
            throw new DataSetTxDeriveException("Units are null for Dataset: \n" + this.getDescriptionTx().toString());
        }
        if (dataSetTxTemplate.getUnits() == null) {
            throw new DataSetTxDeriveException("Units are null for Dataset: \n" + dataSetTxTemplate.getDescriptionTx().toString());
        }
        try {
            return this._timeSeries.needToChangeUnits(dataSetTxTemplate.getUnits().getUnitsMetaData());
        }
        catch (DataSetTimeSeriesDeriveException e) {
            throw new DataSetTxDeriveException((Exception)((Object)e));
        }
    }

    public boolean needToChangeUnits(Units toUnits) throws DataSetTxDeriveException {
        try {
            return this._timeSeries.needToChangeUnits(toUnits.getUnitsMetaData());
        }
        catch (DataSetTimeSeriesDeriveException e) {
            throw new DataSetTxDeriveException((Exception)((Object)e));
        }
    }

    public void changeUnits(DataSetTxTemplate dataSetTxTemplate) throws DataSetTxDeriveException {
        try {
            this._timeSeries.changeUnits(dataSetTxTemplate.getUnits().getUnitsMetaData());
            this.updateTemplate();
        }
        catch (DataSetTimeSeriesDeriveException | DataSetTimeSeriesIllegalArgumentException e) {
            throw new DataSetTxDeriveException((Exception)e);
        }
    }

    public void changeUnits(Units toUnits) throws DataSetTxDeriveException {
        try {
            this._timeSeries.changeUnits(toUnits.getUnitsMetaData());
            this.updateTemplate();
        }
        catch (DataSetTimeSeriesDeriveException | DataSetTimeSeriesIllegalArgumentException e) {
            throw new DataSetTxDeriveException((Exception)e);
        }
    }

    private void updateTemplate() throws DataSetTimeSeriesIllegalArgumentException {
        this.setTimeSeriesTemplate(DataSetTx.buildTemplate(this._timeSeries));
    }

    public void changeUnitSystem(String unitSystem) throws DataSetTxException, UnitsConversionException, DataSetIllegalArgumentException {
        try {
            this._timeSeries.changeUnitSystem(unitSystem);
            this.updateTemplate();
        }
        catch (DataSetTimeSeriesException e) {
            throw new DataSetTxException((Exception)((Object)e));
        }
        catch (mil.army.usace.hec.metadata.UnitsConversionException e) {
            throw new UnitsConversionException((Exception)((Object)e));
        }
        catch (mil.army.usace.hec.metadata.DataSetIllegalArgumentException e) {
            throw new DataSetIllegalArgumentException((Exception)((Object)e));
        }
    }

    public void changeUnitSystem(int unitSystemId) throws DataSetTxException, UnitsConversionException, DataSetIllegalArgumentException {
        try {
            this._timeSeries.changeUnitSystem(unitSystemId);
            this.updateTemplate();
        }
        catch (DataSetTimeSeriesException e) {
            throw new DataSetTxException((Exception)((Object)e));
        }
        catch (mil.army.usace.hec.metadata.UnitsConversionException e) {
            throw new UnitsConversionException((Exception)((Object)e));
        }
        catch (mil.army.usace.hec.metadata.DataSetIllegalArgumentException e) {
            throw new DataSetIllegalArgumentException((Exception)((Object)e));
        }
    }

    public void window(DataSetTxTemplate dataSetTxTemplate) throws DataSetTxDeriveException {
        try {
            this._timeSeries.window(dataSetTxTemplate.getTimeSeriesTemplate());
            this.updateTemplate();
        }
        catch (DataSetTimeSeriesDeriveException | DataSetTimeSeriesIllegalArgumentException e) {
            throw new DataSetTxDeriveException((Exception)e);
        }
    }

    public void fillTails(DataSetTxTemplate template) throws DataSetTxException, DataSetIllegalArgumentException {
        try {
            this._timeSeries.fillTails(template.getTimeSeriesTemplate());
            this.updateTemplate();
        }
        catch (DataSetTimeSeriesException e) {
            throw new DataSetTxException((Exception)((Object)e));
        }
        catch (mil.army.usace.hec.metadata.DataSetIllegalArgumentException e) {
            throw new DataSetIllegalArgumentException((Exception)((Object)e));
        }
    }

    public void trimTail() {
        this._timeSeries.trimTail();
    }

    public void trim() throws DataSetTxIllegalArgumentException {
        try {
            this._timeSeries.trim();
            this.updateTemplate();
        }
        catch (DataSetTimeSeriesIllegalArgumentException e) {
            throw new DataSetTxIllegalArgumentException((Exception)((Object)e));
        }
    }

    public boolean cannotCombine(DataSetTx dataSetTx) {
        return TimeSeriesCombine.cannotCombine((TimeSeries)this._timeSeries, (TimeSeries)dataSetTx._timeSeries);
    }

    public boolean canCombine(DataSetTx dataSetTx) {
        return TimeSeriesCombine.canCombine((TimeSeries)this._timeSeries, (TimeSeries)dataSetTx._timeSeries);
    }

    public boolean cannotCombine(DataSetTxTemplate dataSetTxTemplate) {
        return TimeSeriesCombine.cannotCombine((TimeSeries)this._timeSeries, (TimeSeriesTemplate)dataSetTxTemplate.getTimeSeriesTemplate());
    }

    public boolean canCombine(DataSetTxTemplate dataSetTxTemplate) {
        return TimeSeriesCombine.canCombine((TimeSeries)this._timeSeries, (TimeSeriesTemplate)dataSetTxTemplate.getTimeSeriesTemplate());
    }

    public boolean cannotDerive(DataSetTxTemplate dataSetTx) {
        return new TimeSeriesDerive().cannotDerive(this._timeSeries, dataSetTx.getTimeSeriesTemplate());
    }

    public boolean canDerive(DataSetTxTemplate dataSetTx) {
        return new TimeSeriesDerive().canDerive(this._timeSeries, dataSetTx.getTimeSeriesTemplate());
    }

    public DataSetTx generateDifferences(DataSetTx filterData) throws DataSetException {
        try {
            TimeSeries timeSeries = this._timeSeries.generateDifferences(filterData._timeSeries);
            if (timeSeries != null) {
                return new DataSetTx(timeSeries);
            }
            return null;
        }
        catch (mil.army.usace.hec.metadata.DataSetException e) {
            throw new DataSetException(e);
        }
    }
}

