/*
 * Decompiled with CFR 0.152.
 */
package hec.data.tx;

import hec.data.DataSetIllegalArgumentException;
import hec.data.Units;
import hec.data.Version;
import hec.data.tx.AbstractDataSetT;
import hec.data.tx.DataSetTxIllegalArgumentException;
import hec.data.tx.DescriptionTx;
import java.io.Serializable;
import java.util.Objects;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;
import mil.army.usace.hec.data.timeseries.math.TimeSeriesTemplate;
import mil.army.usace.hec.metadata.OfficeId;
import mil.army.usace.hec.metadata.timeseries.DataSetTimeSeriesIllegalArgumentException;
import mil.army.usace.hec.metadata.timeseries.TimeSeriesIdentifier;
import mil.army.usace.hec.metadata.timeseries.TimeSeriesIdentifierBuilder;

@Deprecated
public class DataSetTxTemplate
extends AbstractDataSetT
implements Serializable {
    private static final long serialVersionUID = -6665000036135286183L;
    private static final Logger LOGGER = Logger.getLogger(DataSetTxTemplate.class.getName());
    private TimeSeriesTemplate _timeSeriesTemplate;

    public DataSetTxTemplate() {
        this._timeSeriesTemplate = new TimeSeriesTemplate();
    }

    public DataSetTxTemplate(DescriptionTx description) throws DataSetTxIllegalArgumentException {
        this(description, Long.MIN_VALUE, Long.MIN_VALUE, new Units(), true, 0L);
    }

    public DataSetTxTemplate(DescriptionTx description, long startTime, long endTime) throws DataSetTxIllegalArgumentException {
        this(description, startTime, endTime, new Units(), true, 0L);
    }

    public DataSetTxTemplate(DescriptionTx description, Units units) throws DataSetTxIllegalArgumentException {
        this(description, Long.MIN_VALUE, Long.MIN_VALUE, units, true, 0L);
    }

    public DataSetTxTemplate(DescriptionTx description, long startTime, long endTime, Units units) throws DataSetTxIllegalArgumentException {
        this(description, startTime, endTime, units, true, 0L);
    }

    public DataSetTxTemplate(DescriptionTx description, long startTime, long endTime, Units units, boolean preserveRejectedAndMissingValues, int maxTimeGapDefinedByIntervals) throws DataSetTxIllegalArgumentException {
        this(description, startTime, endTime, units, preserveRejectedAndMissingValues, 0L);
        this.setMaxTimeGapDefinedByIntervals(maxTimeGapDefinedByIntervals);
    }

    public DataSetTxTemplate(DescriptionTx description, long startTime, long endTime, Units units, boolean preserveRejectedAndMissingValues, long maxTimeGap) throws DataSetTxIllegalArgumentException {
        if (startTime == Long.MAX_VALUE) {
            startTime = Long.MIN_VALUE;
        }
        if (endTime == Long.MAX_VALUE) {
            endTime = Long.MIN_VALUE;
        }
        if (startTime != Long.MIN_VALUE && endTime != Long.MIN_VALUE && startTime > endTime) {
            throw new DataSetTxIllegalArgumentException("Can not instantiate a Time Series with the start time greater than the end time.");
        }
        units = units == null ? new Units() : new Units(units);
        try {
            this._timeSeriesTemplate = new TimeSeriesTemplate(description.getTimeSeriesIdentifierMetaData(), startTime, endTime, units.getUnitsMetaData(), preserveRejectedAndMissingValues, maxTimeGap);
        }
        catch (DataSetTimeSeriesIllegalArgumentException e) {
            throw new DataSetTxIllegalArgumentException((Exception)((Object)e));
        }
    }

    public DataSetTxTemplate(DataSetTxTemplate dstxt) {
        this._timeSeriesTemplate = new TimeSeriesTemplate(dstxt._timeSeriesTemplate);
    }

    public DataSetTxTemplate(TimeSeriesTemplate timeSeriesTemplate) {
        this._timeSeriesTemplate = timeSeriesTemplate;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DataSetTxTemplate that = (DataSetTxTemplate)o;
        return Objects.equals(this.getTimeSeriesTemplate(), that.getTimeSeriesTemplate());
    }

    public int hashCode() {
        return Objects.hash(this.getTimeSeriesTemplate());
    }

    void setTimeSeriesTemplate(TimeSeriesTemplate timeSeriesTemplate) {
        this._timeSeriesTemplate = timeSeriesTemplate;
    }

    public final TimeSeriesTemplate getTimeSeriesTemplate() {
        return this._timeSeriesTemplate;
    }

    public boolean equals(DataSetTxTemplate dataSetTxTemplate) {
        return this._timeSeriesTemplate.equals((Object)dataSetTxTemplate._timeSeriesTemplate);
    }

    public String toString() {
        return this._timeSeriesTemplate.toString();
    }

    public String toString(String timeZone) {
        return this._timeSeriesTemplate.toString(TimeZone.getTimeZone(timeZone));
    }

    public Units getUnits() {
        try {
            return new Units(this._timeSeriesTemplate.getUnits().toString());
        }
        catch (DataSetIllegalArgumentException e) {
            LOGGER.log(Level.SEVERE, "Units should already be valid", e);
            return null;
        }
    }

    public final void setUnits(Units units) throws DataSetTxIllegalArgumentException {
        try {
            this._timeSeriesTemplate = new TimeSeriesTemplate(this._timeSeriesTemplate.getTimeSeriesIdentifier(), this._timeSeriesTemplate.getStartTime(), this._timeSeriesTemplate.getEndTime(), units.getUnitsMetaData(), this._timeSeriesTemplate.getPreserveRejectedAndMissingValues(), this._timeSeriesTemplate.getMaxTimeGapMillis());
        }
        catch (DataSetTimeSeriesIllegalArgumentException e) {
            throw new DataSetTxIllegalArgumentException((Exception)((Object)e));
        }
    }

    public void setPreserveRejectedAndMissingValues(boolean preserveRejectedAndMissingValues) {
        this._timeSeriesTemplate.setPreserveRejectedAndMissingValues(preserveRejectedAndMissingValues);
    }

    public boolean getPreserveRejectedAndMissingValues() {
        return this._timeSeriesTemplate.getPreserveRejectedAndMissingValues();
    }

    public void setMaxTimeGap(long maxTimeGap) {
        this._timeSeriesTemplate.setMaxTimeGap(maxTimeGap);
    }

    public void setMaxTimeGapDefinedByIntervals(int maxTimeGapDefinedByIntervals) {
        this._timeSeriesTemplate.setMaxTimeGapDefinedByIntervals(maxTimeGapDefinedByIntervals);
    }

    public void setMaxTimeGapDefinedByMinutes(int maxTimeGapDefinedByMinutes) {
        this._timeSeriesTemplate.setMaxTimeGapDefinedByMinutes(maxTimeGapDefinedByMinutes);
    }

    public void setMaxTimeGapDefinedByHours(int maxTimeGapDefinedByHours) {
        this._timeSeriesTemplate.setMaxTimeGapDefinedByHours(maxTimeGapDefinedByHours);
    }

    public long getMaxTimeGap() {
        return this._timeSeriesTemplate.getMaxTimeGapMillis();
    }

    public String getStartTimeString() {
        return this._timeSeriesTemplate.getStartTimeString();
    }

    public String getStartTimeString(String timeZone) {
        return this._timeSeriesTemplate.getStartTimeString(timeZone);
    }

    public String getEndTimeString() {
        return this._timeSeriesTemplate.getEndTimeString();
    }

    public String getEndTimeString(String timeZone) {
        return this._timeSeriesTemplate.getEndTimeString(timeZone);
    }

    public long getStartTime() {
        return this._timeSeriesTemplate.getStartTime();
    }

    public long getEndTime() {
        return this._timeSeriesTemplate.getEndTime();
    }

    public void clearTimeWindow() {
        this._timeSeriesTemplate.clearTimeWindow();
    }

    protected void clearTimeWindowInternal() {
        this._timeSeriesTemplate.clearTimeWindow();
    }

    public void setStartTime(long startTime) throws DataSetTxIllegalArgumentException {
        try {
            this._timeSeriesTemplate.setStartTime(startTime);
        }
        catch (DataSetTimeSeriesIllegalArgumentException e) {
            throw new DataSetTxIllegalArgumentException((Exception)((Object)e));
        }
    }

    protected void setStartTimeInternal(long startTime) throws DataSetTxIllegalArgumentException {
        try {
            this._timeSeriesTemplate.setStartTime(startTime);
        }
        catch (DataSetTimeSeriesIllegalArgumentException e) {
            throw new DataSetTxIllegalArgumentException((Exception)((Object)e));
        }
    }

    public void setEndTime(long endTime) throws DataSetTxIllegalArgumentException {
        try {
            this._timeSeriesTemplate.setEndTime(endTime);
        }
        catch (DataSetTimeSeriesIllegalArgumentException e) {
            throw new DataSetTxIllegalArgumentException((Exception)((Object)e));
        }
    }

    protected void setEndTimeInternal(long endTime) throws DataSetTxIllegalArgumentException {
        try {
            this._timeSeriesTemplate.setEndTime(endTime);
        }
        catch (DataSetTimeSeriesIllegalArgumentException e) {
            throw new DataSetTxIllegalArgumentException((Exception)((Object)e));
        }
    }

    public static boolean isTemplate(DataSetTxTemplate dataSetTxTemplate) {
        return DataSetTxTemplate.class.getName().equals(dataSetTxTemplate.getClass().getName());
    }

    public DescriptionTx getDescriptionTx() {
        return new DescriptionTx(this._timeSeriesTemplate.getTimeSeriesIdentifier());
    }

    public String getOfficeId() {
        return this._timeSeriesTemplate.getTimeSeriesIdentifier().getOfficeId().map(OfficeId::getOfficeId).orElse("");
    }

    public void setOfficeId(String officeId) {
        try {
            TimeSeriesIdentifier oldIdentifier = this._timeSeriesTemplate.getTimeSeriesIdentifier();
            OfficeId office = new OfficeId(officeId, oldIdentifier.getOfficeId().map(OfficeId::getOfficeName).orElse(""));
            TimeSeriesIdentifier newIdentifier = new TimeSeriesIdentifierBuilder(oldIdentifier).withOfficeId(office).build();
            this._timeSeriesTemplate = new TimeSeriesTemplate(newIdentifier, this._timeSeriesTemplate.getStartTime(), this._timeSeriesTemplate.getEndTime(), this._timeSeriesTemplate.getUnits(), this._timeSeriesTemplate.getPreserveRejectedAndMissingValues(), this._timeSeriesTemplate.getMaxTimeGapMillis());
        }
        catch (mil.army.usace.hec.metadata.DataSetIllegalArgumentException | DataSetTimeSeriesIllegalArgumentException e) {
            LOGGER.log(Level.SEVERE, "Template should already be valid", e);
        }
    }

    public Version getVersion() {
        return new Version(this._timeSeriesTemplate.getTimeSeriesIdentifier().getVersion().getVersion());
    }

    public void setVersion(Version version) {
        try {
            TimeSeriesIdentifier oldIdentifier = this._timeSeriesTemplate.getTimeSeriesIdentifier();
            TimeSeriesIdentifier newIdentifier = new TimeSeriesIdentifierBuilder(oldIdentifier).withVersion(version.getVersionMetaData()).build();
            this._timeSeriesTemplate = new TimeSeriesTemplate(newIdentifier, this._timeSeriesTemplate.getStartTime(), this._timeSeriesTemplate.getEndTime(), this._timeSeriesTemplate.getUnits(), this._timeSeriesTemplate.getPreserveRejectedAndMissingValues(), this._timeSeriesTemplate.getMaxTimeGapMillis());
        }
        catch (mil.army.usace.hec.metadata.DataSetIllegalArgumentException | DataSetTimeSeriesIllegalArgumentException e) {
            LOGGER.log(Level.SEVERE, "Template should already be valid", e);
        }
    }

    public void show() {
        String strTz = this._timeSeriesTemplate.getTimeSeriesIdentifier().getIntervalZoneId().toString();
        if (strTz == null) {
            strTz = "UTC";
        }
        this.show(strTz);
    }

    public void show(String timeZone) {
        System.out.println("\n=====>Tabulation of Template for: <" + this._timeSeriesTemplate.getTimeSeriesIdentifier().toString() + ">");
        System.out.println(this.toString());
    }
}

