/*
 * Decompiled with CFR 0.152.
 */
package hec.data.tx;

import hec.data.tx.DataSetTx;
import hec.heclib.util.HecTime;
import java.util.Vector;
import javax.swing.table.AbstractTableModel;
import rma.util.RMAIO;

public class DataTxTableModel
extends AbstractTableModel {
    protected double[] _vals = null;
    protected long[] _times = null;
    private Vector colLabels = new Vector();
    private int dblPrecision = 4;

    public DataTxTableModel(DataSetTx tsds) {
        this(tsds.getTimes(), tsds.getValues());
    }

    public DataTxTableModel(long[] times, double[] vals) {
        this();
        this._times = times;
        this._vals = vals;
    }

    public DataTxTableModel() {
        this.colLabels.addElement(new String("Date"));
        this.colLabels.addElement(new String("Value"));
        this.colLabels.addElement(new String("Quality"));
    }

    public void setValuePrecision(int num) {
        this.dblPrecision = num;
    }

    public int getValuePrecision() {
        return this.dblPrecision;
    }

    @Override
    public int findColumn(String columnName) {
        int idx = this.colLabels.indexOf(columnName);
        return idx;
    }

    public Class getColumnClass(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return String.class;
            }
            case 1: {
                return String.class;
            }
            case 2: {
                return String.class;
            }
        }
        return null;
    }

    @Override
    public int getColumnCount() {
        return this.colLabels.size();
    }

    @Override
    public int getRowCount() {
        if (this._vals == null) {
            return 0;
        }
        return this._vals.length;
    }

    @Override
    public String getColumnName(int col) {
        if (col >= this.colLabels.size()) {
            return new String("");
        }
        return this.colLabels.elementAt(col).toString();
    }

    @Override
    public Object getValueAt(int row, int col) {
        if (this._vals == null) {
            return null;
        }
        if (row < 0 || col < 0) {
            return new String("");
        }
        if (row >= this._vals.length || col >= this.colLabels.size()) {
            return new String("");
        }
        switch (col) {
            case 0: {
                HecTime hectime = new HecTime();
                hectime.setTimeInMillis(this._times[row]);
                String strTime = hectime.dateAndTime();
                return strTime;
            }
            case 1: {
                double val = this._vals[row];
                String strVal = RMAIO.setPrecision2(val, this.dblPrecision);
                return strVal;
            }
            case 2: {
                return new String("");
            }
        }
        return new String("");
    }

    public String getRowName(int row) {
        return new String("");
    }
}

