/*
 * Decompiled with CFR 0.152.
 */
package hec.data.tx;

import hec.data.DataSetIllegalArgumentException;
import hec.data.Duration;
import hec.data.ITimeSeriesDescription;
import hec.data.IllegalIntervalOffsetException;
import hec.data.Interval;
import hec.data.IntervalOffset;
import hec.data.LocationID;
import hec.data.Parameter;
import hec.data.ParameterType;
import hec.data.Version;
import hec.data.location.LocationTemplate;
import hec.data.tx.AbstractDataSetT;
import hec.data.tx.DSSTimeSeries;
import hec.data.tx.IllegalLocalRegularTimeZoneException;
import hec.data.tx.UtcIntervalOffsetMismatchException;
import hec.io.TimeSeriesContainer;
import java.io.Serializable;
import java.time.DateTimeException;
import java.time.ZoneId;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import mil.army.usace.hec.metadata.DurationFactory;
import mil.army.usace.hec.metadata.IntervalFactory;
import mil.army.usace.hec.metadata.OfficeId;
import mil.army.usace.hec.metadata.constants.NumericalConstants;
import mil.army.usace.hec.metadata.timeseries.TimeSeriesIdentifier;
import mil.army.usace.hec.metadata.timeseries.TimeSeriesIdentifierBuilder;
import mil.army.usace.hec.metadata.timeseries.TimeSeriesIdentifierFactory;
import mil.army.usace.hec.metadata.timeseries.TimeSeriesIdentifierParts;
import rma.util.lookup.Lookup;
import rma.util.lookup.Lookups;

@Deprecated
public class DescriptionTx
extends AbstractDataSetT
implements Serializable,
ITimeSeriesDescription {
    private static final long serialVersionUID = 7486397734803491575L;
    private static final Logger LOGGER = Logger.getLogger(DescriptionTx.class.getName());
    private TimeSeriesIdentifier _timeSeriesIdentifier;
    private Lookup _lookup = null;

    public DescriptionTx(String delimString) throws DataSetIllegalArgumentException {
        try {
            mil.army.usace.hec.metadata.IntervalOffset extractIntervalOffset = this.extractIntervalOffset(delimString);
            this._timeSeriesIdentifier = TimeSeriesIdentifierFactory.from((OfficeId)new OfficeId(""), (String)delimString, (mil.army.usace.hec.metadata.IntervalOffset)extractIntervalOffset, (ZoneId)NumericalConstants.UTC_ZONEID);
        }
        catch (mil.army.usace.hec.metadata.DataSetIllegalArgumentException e) {
            throw new DataSetIllegalArgumentException((Exception)((Object)e));
        }
    }

    public DescriptionTx(String officeId, String delimString) throws DataSetIllegalArgumentException {
        try {
            mil.army.usace.hec.metadata.IntervalOffset extractIntervalOffset = this.extractIntervalOffset(delimString);
            this._timeSeriesIdentifier = TimeSeriesIdentifierFactory.from((OfficeId)new OfficeId(officeId), (String)delimString, (mil.army.usace.hec.metadata.IntervalOffset)extractIntervalOffset, (ZoneId)NumericalConstants.UTC_ZONEID);
        }
        catch (mil.army.usace.hec.metadata.DataSetIllegalArgumentException e) {
            throw new DataSetIllegalArgumentException((Exception)((Object)e));
        }
    }

    public DescriptionTx(LocationID location, Parameter parameter, ParameterType parameterType, Interval interval, Duration duration, Version version) throws DataSetIllegalArgumentException {
        try {
            this._timeSeriesIdentifier = TimeSeriesIdentifierFactory.from((OfficeId)new OfficeId(""), (mil.army.usace.hec.metadata.LocationID)location.getLocationIDMetaData(), (mil.army.usace.hec.metadata.Parameter)parameter, (mil.army.usace.hec.metadata.ParameterType)parameterType.getParameterTypeMetaData(), (mil.army.usace.hec.metadata.Interval)interval.getMetaDataInterval(), (mil.army.usace.hec.metadata.Duration)duration.getMetaDataDuration(), (mil.army.usace.hec.metadata.Version)version.getVersionMetaData());
        }
        catch (mil.army.usace.hec.metadata.DataSetIllegalArgumentException e) {
            throw new DataSetIllegalArgumentException((Exception)((Object)e));
        }
    }

    public DescriptionTx(String officeId, LocationID location, Parameter parameter, ParameterType parameterType, Interval interval, Duration duration, Version version) throws DataSetIllegalArgumentException {
        try {
            this._timeSeriesIdentifier = TimeSeriesIdentifierFactory.from((OfficeId)new OfficeId(officeId), (mil.army.usace.hec.metadata.LocationID)location.getLocationIDMetaData(), (mil.army.usace.hec.metadata.Parameter)parameter, (mil.army.usace.hec.metadata.ParameterType)parameterType.getParameterTypeMetaData(), (mil.army.usace.hec.metadata.Interval)interval.getMetaDataInterval(), (mil.army.usace.hec.metadata.Duration)duration.getMetaDataDuration(), (mil.army.usace.hec.metadata.Version)version.getVersionMetaData());
        }
        catch (mil.army.usace.hec.metadata.DataSetIllegalArgumentException e) {
            throw new DataSetIllegalArgumentException((Exception)((Object)e));
        }
    }

    protected DescriptionTx() {
    }

    public DescriptionTx(TimeSeriesIdentifier timeSeriesIdentifier) {
        this._timeSeriesIdentifier = timeSeriesIdentifier;
    }

    public DescriptionTx(DescriptionTx descriptionTx) {
        this._timeSeriesIdentifier = descriptionTx._timeSeriesIdentifier;
    }

    private mil.army.usace.hec.metadata.IntervalOffset extractIntervalOffset(String delimString) throws mil.army.usace.hec.metadata.DataSetIllegalArgumentException {
        try {
            TimeSeriesIdentifierParts.extractInterval((String)delimString, (mil.army.usace.hec.metadata.IntervalOffset)mil.army.usace.hec.metadata.IntervalOffset.noOffset());
            return mil.army.usace.hec.metadata.IntervalOffset.noOffset();
        }
        catch (mil.army.usace.hec.metadata.DataSetIllegalArgumentException e) {
            TimeSeriesIdentifierParts.extractInterval((String)delimString, (mil.army.usace.hec.metadata.IntervalOffset)mil.army.usace.hec.metadata.IntervalOffset.undefinedOffset());
            return mil.army.usace.hec.metadata.IntervalOffset.undefinedOffset();
        }
    }

    public void fillTimeSeriesContainer(TimeSeriesContainer tsc) {
        tsc.setFullName(this.toString());
        tsc.location = this.getLocationID().getBaseLocation();
        tsc.subLocation = this.getLocationID().getSubLocation();
        tsc.parameter = this.getParameter().getBaseParameter();
        tsc.subParameter = this.getParameter().getSubParameter();
        tsc.version = this.getVersion().toString();
        tsc.interval = this.getInterval().getMinutes();
        tsc.setType(DSSTimeSeries.getDSSType(this));
        ZoneId zoneId = this.getTimeSeriesIdentifierMetaData().getIntervalZoneId().orElse(ZoneId.of("UTC"));
        tsc.setTimeZoneID(zoneId.getId());
    }

    public TimeSeriesIdentifier getTimeSeriesIdentifierMetaData() {
        return this._timeSeriesIdentifier;
    }

    @Override
    public synchronized Lookup getLookup() {
        if (this._lookup == null) {
            this._lookup = Lookups.fixed((Object[])new Object[]{this, new DescriptionTxComparator()});
        }
        return this._lookup;
    }

    protected void set(LocationID location, Parameter parameter, ParameterType parameterType, Interval interval, Duration duration, Version version) throws DataSetIllegalArgumentException {
        try {
            this._timeSeriesIdentifier = TimeSeriesIdentifierFactory.from((OfficeId)new OfficeId(this.getOfficeId()), (mil.army.usace.hec.metadata.LocationID)location.getLocationIDMetaData(), (mil.army.usace.hec.metadata.Parameter)parameter, (mil.army.usace.hec.metadata.ParameterType)parameterType.getParameterTypeMetaData(), (mil.army.usace.hec.metadata.Interval)interval.getMetaDataInterval(), (mil.army.usace.hec.metadata.Duration)duration.getMetaDataDuration(), (mil.army.usace.hec.metadata.Version)version.getVersionMetaData(), (mil.army.usace.hec.metadata.IntervalOffset)this.getIntervalOffset(), (boolean)this.getActive(), (int)this.getUserPrivilege());
        }
        catch (mil.army.usace.hec.metadata.DataSetIllegalArgumentException e) {
            throw new DataSetIllegalArgumentException((Exception)((Object)e));
        }
    }

    protected void set(String loc, String param, String type, String interv, String durat, String ver) throws DataSetIllegalArgumentException {
        try {
            Optional interval;
            mil.army.usace.hec.metadata.IntervalOffset intervalOffset = mil.army.usace.hec.metadata.IntervalOffset.undefinedOffset();
            if (IntervalFactory.findAny(IntervalFactory.equalsName((String)interv).and(mil.army.usace.hec.metadata.Interval::isIrregular)).isPresent()) {
                intervalOffset = mil.army.usace.hec.metadata.IntervalOffset.noOffset();
            }
            if (!(interval = intervalOffset.isNoOffset() ? IntervalFactory.findAny(IntervalFactory.equalsName((String)interv).and(IntervalFactory.isIrregular())) : IntervalFactory.findAny(IntervalFactory.equalsName((String)interv).and(IntervalFactory.isIrregular().negate()))).isPresent()) {
                throw new mil.army.usace.hec.metadata.DataSetIllegalArgumentException("Interval not found in the standard set of intervals: " + interv + " with interval offset: " + intervalOffset);
            }
            Optional duration = DurationFactory.findAny((Predicate)DurationFactory.equalsName((String)durat));
            if (!duration.isPresent()) {
                throw new mil.army.usace.hec.metadata.DataSetIllegalArgumentException("Interval not found in the standard set of durations: " + durat);
            }
            this._timeSeriesIdentifier = TimeSeriesIdentifierFactory.from((mil.army.usace.hec.metadata.LocationID)new mil.army.usace.hec.metadata.LocationID(loc), (mil.army.usace.hec.metadata.Parameter)new mil.army.usace.hec.metadata.Parameter(param), (mil.army.usace.hec.metadata.ParameterType)mil.army.usace.hec.metadata.ParameterType.from((String)type), (mil.army.usace.hec.metadata.Interval)((mil.army.usace.hec.metadata.Interval)interval.get()), (mil.army.usace.hec.metadata.Duration)((mil.army.usace.hec.metadata.Duration)duration.get()), (mil.army.usace.hec.metadata.Version)new mil.army.usace.hec.metadata.Version(ver));
        }
        catch (mil.army.usace.hec.metadata.DataSetIllegalArgumentException e) {
            throw new DataSetIllegalArgumentException((Exception)((Object)e));
        }
    }

    public static Map<Parts, String> parse(String descriptionStr) throws DataSetIllegalArgumentException {
        HashMap<Parts, String> retval = new HashMap<Parts, String>();
        String delim = ".";
        StringTokenizer st = new StringTokenizer(descriptionStr, delim);
        int countDescItems = st.countTokens();
        if (descriptionStr.endsWith(delim)) {
            ++countDescItems;
        }
        if (countDescItems != 6) {
            throw new DataSetIllegalArgumentException("Time Series Description is not valid:\n" + descriptionStr + "\n  " + countDescItems + " description items are present.\n  Six description items delimited by periods are required.");
        }
        String loc = new String();
        if (st.hasMoreTokens()) {
            loc = st.nextToken();
        }
        String param = new String();
        if (st.hasMoreTokens()) {
            param = st.nextToken();
        }
        String type = new String();
        if (st.hasMoreTokens()) {
            type = st.nextToken();
        }
        String interv = new String();
        if (st.hasMoreTokens()) {
            interv = st.nextToken();
        }
        String durat = new String();
        if (st.hasMoreTokens()) {
            durat = st.nextToken();
        }
        String ver = new String();
        if (st.hasMoreTokens()) {
            ver = st.nextToken();
        }
        retval.put(Parts.LocationID, loc);
        retval.put(Parts.Parameter, param);
        retval.put(Parts.ParameterType, type);
        retval.put(Parts.Interval, interv);
        retval.put(Parts.Duration, durat);
        retval.put(Parts.Version, ver);
        return retval;
    }

    public void setIntervalName(String intervalName) throws DataSetIllegalArgumentException {
        if (this._timeSeriesIdentifier == null) {
            throw new DataSetIllegalArgumentException("Interval not initialized!");
        }
        try {
            Optional interval = this.getIntervalOffset().isNoOffset() ? IntervalFactory.findAny(IntervalFactory.equalsName((String)intervalName).and(IntervalFactory.isIrregular())) : IntervalFactory.findAny(IntervalFactory.equalsName((String)intervalName).and(IntervalFactory.isIrregular().negate()));
            if (!interval.isPresent()) {
                throw new mil.army.usace.hec.metadata.DataSetIllegalArgumentException("Interval not found in the standard set of intervals: " + intervalName + " with interval offset: " + this.getIntervalOffset());
            }
            this._timeSeriesIdentifier = new TimeSeriesIdentifierBuilder(this._timeSeriesIdentifier).withInterval((mil.army.usace.hec.metadata.Interval)interval.get()).build();
        }
        catch (mil.army.usace.hec.metadata.DataSetIllegalArgumentException e) {
            throw new DataSetIllegalArgumentException((Exception)((Object)e));
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DescriptionTx other = (DescriptionTx)obj;
        return Objects.equals(this._timeSeriesIdentifier, other._timeSeriesIdentifier);
    }

    public int hashCode() {
        return this._timeSeriesIdentifier.hashCode();
    }

    public boolean describesSameDataAs(DescriptionTx descriptionTx) {
        return this._timeSeriesIdentifier.describesSameDataAs(descriptionTx._timeSeriesIdentifier);
    }

    @Override
    public String getOfficeId() {
        return this._timeSeriesIdentifier.getOfficeId().map(OfficeId::getOfficeId).orElse("");
    }

    public void setOfficeId(String officeId) {
        if (this._timeSeriesIdentifier != null) {
            try {
                OfficeId office = new OfficeId(officeId);
                this._timeSeriesIdentifier = new TimeSeriesIdentifierBuilder(this._timeSeriesIdentifier).withOfficeId(office).build();
            }
            catch (mil.army.usace.hec.metadata.DataSetIllegalArgumentException e) {
                LOGGER.log(Level.SEVERE, "Identifier should already be valid", e);
            }
        }
    }

    public void setUserPrivilege(int userPrivilege) {
        if (this._timeSeriesIdentifier != null) {
            try {
                this._timeSeriesIdentifier = new TimeSeriesIdentifierBuilder(this._timeSeriesIdentifier).withUserPrivilege(userPrivilege).build();
            }
            catch (mil.army.usace.hec.metadata.DataSetIllegalArgumentException e) {
                LOGGER.log(Level.SEVERE, "Identifier should already be valid", e);
            }
        }
    }

    public void setActive(boolean active) {
        if (this._timeSeriesIdentifier != null) {
            try {
                this._timeSeriesIdentifier = new TimeSeriesIdentifierBuilder(this._timeSeriesIdentifier).withActive(active).build();
            }
            catch (mil.army.usace.hec.metadata.DataSetIllegalArgumentException e) {
                LOGGER.log(Level.SEVERE, "Identifier should already be valid", e);
            }
        }
    }

    public void setUtcIntervalOffset(String offsetString) throws DataSetIllegalArgumentException {
        IntervalOffset intervalOffset = new IntervalOffset();
        intervalOffset.setIntervalOffset(offsetString);
        intervalOffset.setInterval(this.getInterval());
        if (this._timeSeriesIdentifier != null) {
            try {
                Optional interval = intervalOffset.getIntervalOffsetMetaData().isNoOffset() ? IntervalFactory.findAny(IntervalFactory.equalsName((String)this.getIntervalName()).and(IntervalFactory.isIrregular())) : IntervalFactory.findAny(IntervalFactory.equalsName((String)this.getIntervalName()).and(IntervalFactory.isIrregular().negate()));
                if (!interval.isPresent()) {
                    throw new DataSetIllegalArgumentException("Interval not found in the standard set of intervals: " + this.getIntervalName() + " with interval offset: " + intervalOffset);
                }
                this._timeSeriesIdentifier = new TimeSeriesIdentifierBuilder(this._timeSeriesIdentifier).withIntervalOffset(intervalOffset.getIntervalOffsetMetaData()).withInterval((mil.army.usace.hec.metadata.Interval)interval.get()).build();
            }
            catch (mil.army.usace.hec.metadata.DataSetIllegalArgumentException e) {
                LOGGER.log(Level.SEVERE, "Identifier should already be valid", e);
            }
        }
    }

    public void setUtcIntervalOffset(int offset) throws DataSetIllegalArgumentException {
        mil.army.usace.hec.metadata.IntervalOffset intervalOffset = mil.army.usace.hec.metadata.IntervalOffset.fromSeconds((int)offset);
        if (this._timeSeriesIdentifier != null) {
            try {
                Optional interval = intervalOffset.isNoOffset() ? IntervalFactory.findAny(IntervalFactory.equalsName((String)this.getIntervalName()).and(IntervalFactory.isIrregular())) : IntervalFactory.findAny(IntervalFactory.equalsName((String)this.getIntervalName()).and(IntervalFactory.isIrregular().negate()));
                if (!interval.isPresent()) {
                    throw new DataSetIllegalArgumentException("Interval not found in the standard set of intervals: " + this.getIntervalName() + " with interval offset: " + intervalOffset);
                }
                this._timeSeriesIdentifier = new TimeSeriesIdentifierBuilder(this._timeSeriesIdentifier).withIntervalOffset(intervalOffset).withInterval((mil.army.usace.hec.metadata.Interval)interval.get()).build();
            }
            catch (mil.army.usace.hec.metadata.DataSetIllegalArgumentException e) {
                throw new DataSetIllegalArgumentException((Exception)((Object)e));
            }
        }
    }

    public int getUtcIntervalOffset() {
        return this._timeSeriesIdentifier.getIntervalOffset().getOffsetSeconds();
    }

    public int getUtcIntervalOffsetInMinutes() {
        return (int)TimeUnit.SECONDS.toMinutes(this._timeSeriesIdentifier.getIntervalOffset().getOffsetSeconds());
    }

    public String getUtcIntervalOffsetString() {
        return this._timeSeriesIdentifier.getIntervalOffset().getIntervalOffsetString();
    }

    public void checkUtcIntervalOffset(long time) throws UtcIntervalOffsetMismatchException {
    }

    @Override
    public LocationTemplate getLocationRef() {
        return new LocationTemplate(this._timeSeriesIdentifier.getLocationRef());
    }

    @Override
    public void setLocationRef(LocationTemplate template) {
        if (template != null && this._timeSeriesIdentifier != null) {
            try {
                OfficeId officeId = this._timeSeriesIdentifier.getOfficeId().orElse(null);
                if (template.getOfficeId() != null && !template.getOfficeId().isEmpty()) {
                    officeId = new OfficeId(template.getOfficeId());
                }
                String locationId = template.getLocationId();
                mil.army.usace.hec.metadata.LocationID locationID = new mil.army.usace.hec.metadata.LocationID(locationId, (ZoneId)this._timeSeriesIdentifier.getIntervalZoneId().orElse(null));
                this._timeSeriesIdentifier = new TimeSeriesIdentifierBuilder(this._timeSeriesIdentifier).withOfficeId(officeId).withLocationId(locationID).build();
            }
            catch (mil.army.usace.hec.metadata.DataSetIllegalArgumentException e) {
                LOGGER.log(Level.SEVERE, "TSID should already be valid", e);
            }
        }
    }

    public LocationID getLocationID() {
        return new LocationID(this._timeSeriesIdentifier.getLocationId());
    }

    public Parameter getParameter() {
        return new Parameter(this._timeSeriesIdentifier.getParameter());
    }

    @Override
    public Duration getDuration() {
        try {
            return new Duration(this._timeSeriesIdentifier.getDuration().getMinutes(), this._timeSeriesIdentifier.getDuration().isEndOfPeriod());
        }
        catch (DataSetIllegalArgumentException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public Interval getInterval() {
        return new Interval(this._timeSeriesIdentifier.getInterval());
    }

    public String getIntervalName() {
        return this._timeSeriesIdentifier.getInterval().getInterval();
    }

    @Override
    public Version getVersion() {
        return new Version(this._timeSeriesIdentifier.getVersion().getVersion());
    }

    private mil.army.usace.hec.metadata.IntervalOffset getIntervalOffset() {
        return this._timeSeriesIdentifier.getIntervalOffset();
    }

    public void setVersion(Version version) {
        try {
            this._timeSeriesIdentifier = new TimeSeriesIdentifierBuilder(this._timeSeriesIdentifier).withVersion(version.getVersionMetaData()).build();
        }
        catch (mil.army.usace.hec.metadata.DataSetIllegalArgumentException e) {
            LOGGER.log(Level.SEVERE, "TSID should already be valid", e);
        }
    }

    @Override
    public ParameterType getParameterType() {
        try {
            return new ParameterType(this._timeSeriesIdentifier.getParameterType().getParameterType());
        }
        catch (DataSetIllegalArgumentException e) {
            LOGGER.log(Level.SEVERE, "ParameterType should already be valid", e);
            return null;
        }
    }

    public int getMinutes() {
        return this._timeSeriesIdentifier.getInterval().getMinutes();
    }

    @Override
    public boolean isRegular() {
        return this.getInterval().isRegular();
    }

    public String toString() {
        return this._timeSeriesIdentifier.toString();
    }

    public void setLocalRegularTimeZone(String strLocalRegularTimeZone) throws IllegalLocalRegularTimeZoneException {
        try {
            String locationId = this.getLocationID().getLocation();
            ZoneId zoneId = null;
            if (strLocalRegularTimeZone != null) {
                zoneId = DescriptionTx.toZoneId(strLocalRegularTimeZone, locationId);
            }
            mil.army.usace.hec.metadata.LocationID locationID = new mil.army.usace.hec.metadata.LocationID(locationId, zoneId);
            this._timeSeriesIdentifier = new TimeSeriesIdentifierBuilder(this._timeSeriesIdentifier).withLocationId(locationID).build();
        }
        catch (mil.army.usace.hec.metadata.DataSetIllegalArgumentException e) {
            LOGGER.log(Level.SEVERE, "TSID should already be valid", e);
        }
    }

    private static ZoneId toZoneId(String zoneId, String locationId) {
        ZoneId retval = null;
        if (zoneId != null) {
            try {
                retval = ZoneId.of(zoneId);
            }
            catch (DateTimeException e) {
                if ("Unknown or Not Applicable".equalsIgnoreCase(zoneId)) {
                    LOGGER.log(Level.FINE, e, () -> "Location " + locationId + " has an undefined time zone");
                }
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.WARNING, e, () -> "Location " + locationId + " has an invalid location time zone: " + zoneId);
                }
                LOGGER.log(Level.WARNING, () -> "Location " + locationId + " has an invalid location time zone: " + zoneId);
            }
        }
        return retval;
    }

    public TimeZone getLocalRegularTimeZone() {
        return this.getLocationID().getLocationIDMetaData().getZoneId().map(TimeZone::getTimeZone).orElse(null);
    }

    public String getLocalRegularTimeZoneString() {
        return this.getLocalRegularTimeZone().toString();
    }

    @Override
    public boolean getActive() {
        return this._timeSeriesIdentifier.getActive();
    }

    @Override
    public int getUserPrivilege() {
        return this._timeSeriesIdentifier.getUserPrivilege();
    }

    @Override
    public String getParameterId() {
        return this._timeSeriesIdentifier.getParameter().getParameter();
    }

    @Override
    public IntervalOffset getUtcIntervalOffsetObject() {
        try {
            return new IntervalOffset(this._timeSeriesIdentifier.getIntervalOffset().getOffsetSeconds(), this.getInterval().getSeconds());
        }
        catch (IllegalIntervalOffsetException e) {
            LOGGER.log(Level.SEVERE, "TSID should already be valid", e);
            return null;
        }
    }

    @Override
    public String getTimeSeriesId() {
        return this.toString();
    }

    @Override
    public ITimeSeriesDescription copy() {
        return new DescriptionTx(this);
    }

    public static class DescriptionTxComparator
    implements Comparator<DescriptionTx> {
        @Override
        public int compare(DescriptionTx o1, DescriptionTx o2) {
            if (o1 == o2) {
                return 0;
            }
            if (o1 == null) {
                return 1;
            }
            if (o2 == null) {
                return -1;
            }
            int retval = o1.toString().compareToIgnoreCase(o2.toString());
            return retval;
        }
    }

    public static enum Parts {
        LocationID,
        Parameter,
        ParameterType,
        Interval,
        Duration,
        Version;

    }
}

