/*
 * Decompiled with CFR 0.152.
 */
package hec.data.tx;

import hec.data.Duration;
import hec.data.Interval;
import hec.data.LocationID;
import hec.data.Parameter;
import hec.data.ParameterType;
import hec.data.Version;
import hec.data.tx.DescriptionTx;
import java.io.Serializable;

public class DescriptionTxColumnModel
implements Serializable {
    DescriptionTx _description;

    public DescriptionTxColumnModel() {
    }

    public DescriptionTxColumnModel(DescriptionTx d) {
        this();
        this._description = d;
    }

    public static int getNumColumns() {
        return 6;
    }

    public static String getColumnLabel(int col) {
        switch (col) {
            case 0: {
                return "Location";
            }
            case 1: {
                return "Parameter";
            }
            case 2: {
                return "Parameter Type";
            }
            case 3: {
                return "Interval";
            }
            case 4: {
                return "Duration";
            }
            case 5: {
                return "Version";
            }
        }
        return null;
    }

    public DescriptionTx getDescriptionTx() {
        return this._description;
    }

    public void setDescriptionTx(DescriptionTx d) {
        this._description = d;
    }

    public String toString() {
        return this._description.toString();
    }

    public Object getColumn(int col) {
        switch (col) {
            case 0: {
                return this._description.getLocationID();
            }
            case 1: {
                return this._description.getParameter();
            }
            case 2: {
                return this._description.getParameterType();
            }
            case 3: {
                return this._description.getInterval();
            }
            case 4: {
                return this._description.getDuration();
            }
            case 5: {
                return this._description.getVersion();
            }
        }
        return null;
    }

    public boolean setColumn(Object o, int col) {
        if (o == null || o.toString().trim().equals("")) {
            return false;
        }
        LocationID l = this._description.getLocationID();
        Parameter p = this._description.getParameter();
        ParameterType t = this._description.getParameterType();
        Interval i = this._description.getInterval();
        Duration d = this._description.getDuration();
        Version v = this._description.getVersion();
        try {
            switch (col) {
                case 0: {
                    l = new LocationID(o.toString().trim());
                    break;
                }
                case 1: {
                    p = new Parameter(o.toString().trim());
                    break;
                }
                case 2: {
                    t = new ParameterType(o.toString().trim());
                    break;
                }
                case 3: {
                    i = new Interval(o.toString().trim());
                    break;
                }
                case 4: {
                    d = new Duration(o.toString().trim());
                    break;
                }
                case 5: {
                    v = new Version(o.toString().trim());
                    break;
                }
                default: {
                    return false;
                }
            }
            this._description = new DescriptionTx(l, p, t, i, d, v);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public boolean setLocationID(Object o) {
        return this.setColumn(o, 0);
    }

    public boolean setParameter(Object o) {
        return this.setColumn(o, 1);
    }

    public boolean setParameterType(Object o) {
        return this.setColumn(o, 2);
    }

    public boolean setInterval(Object o) {
        return this.setColumn(o, 3);
    }

    public boolean setDuration(Object o) {
        return this.setColumn(o, 4);
    }

    public boolean setVersion(Object o) {
        return this.setColumn(o, 5);
    }

    public Object getLocationID() {
        return this.getColumn(0);
    }

    public Object getParameter() {
        return this.getColumn(1);
    }

    public Object getParameterType() {
        return this.getColumn(2);
    }

    public Object getInterval() {
        return this.getColumn(3);
    }

    public Object getDuration() {
        return this.getColumn(4);
    }

    public Object getVersion() {
        return this.getColumn(5);
    }
}

