/*
 * Decompiled with CFR 0.152.
 */
package hec.data.tx;

import hec.data.tx.TimeSeriesCategoryRef;
import hec.data.tx.TimeSeriesGroupRef;
import hec.lang.NamedType;
import hec.util.XMLUtilities;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.NavigableSet;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jdom.Element;

public class TimeSeriesCategory
extends NamedType {
    public static final Logger logger = Logger.getLogger(TimeSeriesCategory.class.getName());
    public static final String DESCRIPTION = "description";
    private final NavigableSet<TimeSeriesGroupRef> groups = new TreeSet<TimeSeriesGroupRef>();
    private TimeSeriesCategoryRef categoryRef;

    public TimeSeriesCategory(String officeId, String categoryId, String description) {
        this(new TimeSeriesCategoryRef(officeId, categoryId), description);
    }

    public TimeSeriesCategory(TimeSeriesCategoryRef catRef, String description) {
        super(catRef.getId(), description);
        this.categoryRef = catRef;
    }

    public TimeSeriesCategory(Element element) {
        super(null, null);
        if (element != null) {
            this.categoryRef = new TimeSeriesCategoryRef(element);
            this.setName(this.categoryRef.getId());
            Element descElement = element.getChild(DESCRIPTION);
            if (descElement != null) {
                this.setDescription(descElement.getText());
            }
            String groupId = element.getAttributeValue("id");
            this.setName(groupId);
        }
    }

    public void buildElement(Element element) {
        if (element != null) {
            if (this.categoryRef != null) {
                this.categoryRef.buildElement(element);
            }
            Element descElement = XMLUtilities.getOrCreateChild(element, DESCRIPTION);
            descElement.setText(this.getDescription() == null ? "" : this.getDescription());
        }
    }

    public String getId() {
        return this.getName();
    }

    public String getOfficeId() {
        if (this.categoryRef != null) {
            return this.categoryRef.getOfficeId();
        }
        return null;
    }

    public TimeSeriesCategoryRef getCategoryRef() {
        return this.categoryRef;
    }

    public TimeSeriesGroupRef addGroup(String groupOfficeId, String groupId) {
        TimeSeriesCategoryRef refToThis = this.getCategoryRef();
        TimeSeriesGroupRef timeseriesGroupRef = new TimeSeriesGroupRef(refToThis, groupOfficeId, groupId);
        this.groups.add(timeseriesGroupRef);
        return timeseriesGroupRef;
    }

    public TimeSeriesGroupRef addGroup(TimeSeriesGroupRef input) {
        return this.addGroup(input.getDbOfficeId(), input.getId());
    }

    public TimeSeriesGroupRef addGroup(String groupId) {
        return this.addGroup(this.getOfficeId(), groupId);
    }

    public void removeGroup(TimeSeriesGroupRef toRemove) {
        this.groups.remove(toRemove);
    }

    public void setGroups(Collection<TimeSeriesGroupRef> newGroups) {
        this.groups.clear();
        if (newGroups != null) {
            for (TimeSeriesGroupRef newGroup : newGroups) {
                this.addGroup(newGroup);
            }
        }
    }

    public int size() {
        return this.groups.size();
    }

    public Collection<TimeSeriesGroupRef> values() {
        if (this.groups instanceof TreeSet) {
            TreeSet asTree = (TreeSet)this.groups;
            return (Collection)asTree.clone();
        }
        return new ArrayList<TimeSeriesGroupRef>(this.groups);
    }

    public String toXmlString() {
        String retval = null;
        Element element = new Element("timeseries_group");
        this.buildElement(element);
        try {
            retval = XMLUtilities.toXmlString(element);
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "toXmlString:Caught XmlException.", e);
        }
        return retval;
    }

    @Override
    public String toString() {
        if (this.categoryRef == null) {
            return "";
        }
        return this.categoryRef.toString();
    }
}

