/*
 * Decompiled with CFR 0.152.
 */
package hec.data.tx;

import hec.data.DbOfficeId;
import hec.util.XMLUtilities;
import org.jdom.Element;

public class TimeSeriesCategoryRef
implements Comparable<TimeSeriesCategoryRef> {
    public static final String ID = "id";
    private double version = 1.0;
    private final String officeId;
    private final String id;

    public TimeSeriesCategoryRef(String dbOfficeId, String categoryId) {
        this.officeId = dbOfficeId;
        this.id = categoryId;
    }

    public TimeSeriesCategoryRef() {
        this.officeId = null;
        this.id = null;
    }

    public TimeSeriesCategoryRef(Element element) {
        if (element != null) {
            String idStr;
            DbOfficeId dbOfficeId = DbOfficeId.parse(element.getChild("db_office_id"));
            this.officeId = dbOfficeId != null ? dbOfficeId.getOfficeId() : null;
            this.id = idStr = element.getAttributeValue(ID);
        } else {
            this.officeId = null;
            this.id = null;
        }
    }

    public void buildElement(Element element) {
        if (element != null) {
            element.setAttribute("version", String.valueOf(this.version));
            Element dbOfficeElement = XMLUtilities.getOrCreateChild(element, "db_office_id");
            DbOfficeId dbOfficeId = new DbOfficeId(this.officeId);
            dbOfficeId.buildElement(dbOfficeElement);
            element.setAttribute(ID, this.getId());
        }
    }

    @Override
    public int compareTo(TimeSeriesCategoryRef otherObj) {
        int c2;
        int BEFORE = -1;
        boolean EQUAL = false;
        boolean AFTER = true;
        if (this == otherObj) {
            return 0;
        }
        if (otherObj == null) {
            return 1;
        }
        if (this.getClass() != otherObj.getClass()) {
            return 1;
        }
        TimeSeriesCategoryRef other = otherObj;
        if (this.officeId == null) {
            if (other.officeId != null) {
                return -1;
            }
        } else if (other.officeId != null && (c2 = this.officeId.compareTo(other.officeId)) != 0) {
            return c2;
        }
        if (this.getId() == null) {
            if (other.getId() != null) {
                return -1;
            }
        } else if (other.getId() != null && (c2 = this.getId().toUpperCase().compareTo(other.getId().toUpperCase())) != 0) {
            return c2;
        }
        return 0;
    }

    public String getId() {
        return this.id;
    }

    public String getOfficeId() {
        return this.officeId;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.getId() == null ? 0 : this.getId().toUpperCase().hashCode());
        result = 31 * result + (this.officeId == null ? 0 : this.officeId.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TimeSeriesCategoryRef other = (TimeSeriesCategoryRef)obj;
        if (this.getId() == null ? other.getId() != null : !this.getId().toUpperCase().equals(other.getId().toUpperCase())) {
            return false;
        }
        return !(this.officeId == null ? other.officeId != null : !this.officeId.equals(other.officeId));
    }

    public String toString() {
        return this.getOfficeId() + "-" + this.getId();
    }
}

