/*
 * Decompiled with CFR 0.152.
 */
package hec.data.tx;

import hec.data.DbOfficeId;
import hec.data.tx.AssignedTimeSeries;
import hec.data.tx.TimeSeriesCategoryRef;
import hec.data.tx.TimeSeriesGroupRef;
import hec.lang.NamedType;
import hec.util.XMLUtilities;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jdom.Content;
import org.jdom.Element;

public class TimeSeriesGroup
extends NamedType {
    private static final Logger logger = Logger.getLogger(TimeSeriesGroup.class.getName());
    public static final String DESCRIPTION = "description";
    private static final String SHARED_TS_REF = "shared_ts_ref";
    private static final String SHARED_TS_ALIAS_ID = "shared_ts_alias_id";
    public static final String TS_GROUP_REF = "ts_group_ref";
    public static final String ASSIGNED_TS_SET = "assigned_timeseries_set";
    public static final String ASSIGNED_TS = "assigned_timeseries";
    public static final String TS_REF = "timeseries_ref";
    public static final String ELEMENT = "timeseries_group";
    private double version = 1.0;
    private TimeSeriesGroupRef groupRef = null;
    private NavigableSet<AssignedTimeSeries> assignedTimeSeries = new TreeSet<AssignedTimeSeries>(new AttributeComparator());
    private String sharedTsAliasId;
    private String sharedTsRef;

    public TimeSeriesGroup() {
    }

    public TimeSeriesGroup(String groupId, TimeSeriesCategoryRef categoryRef, String groupDescription, String dbOfficeId, String sharedLocAliasId, String sharedTimeSeriesRef) {
        this(new TimeSeriesGroupRef(categoryRef, dbOfficeId, groupId), groupDescription, sharedLocAliasId, sharedTimeSeriesRef);
    }

    public TimeSeriesGroup(TimeSeriesGroupRef group, String groupDescription, String locAliasId, String timeSeriesRef) {
        super(group.getId(), groupDescription);
        this.groupRef = group;
        this.sharedTsAliasId = locAliasId;
        this.sharedTsRef = timeSeriesRef;
    }

    public TimeSeriesGroup(Element element) {
        if (element != null) {
            this._ignoreModifiedEvents = true;
            this.groupRef = new TimeSeriesGroupRef(element);
            this.setName(this.groupRef.getId());
            this.sharedTsAliasId = element.getAttributeValue(SHARED_TS_ALIAS_ID);
            this.sharedTsRef = element.getAttributeValue(SHARED_TS_REF);
            this.setDescription(element.getChildText(DESCRIPTION));
            this.assignedTimeSeries = this.parseAssignedTimeSeries(element.getChild(ASSIGNED_TS_SET));
            this._ignoreModifiedEvents = false;
        }
    }

    public TimeSeriesGroupRef getTimeSeriesGroupRef() {
        return this.groupRef;
    }

    public void setTimeSeriesGroupRef(TimeSeriesGroupRef tsGroupRef) {
        this.groupRef = tsGroupRef;
        if (tsGroupRef == null) {
            this.setName("");
        } else {
            this.setName(this.groupRef.getId());
        }
    }

    private NavigableSet<AssignedTimeSeries> parseAssignedTimeSeries(Element child) {
        TreeSet<AssignedTimeSeries> timeseriesSet = new TreeSet<AssignedTimeSeries>(new AttributeComparator());
        List children = child.getChildren(ASSIGNED_TS);
        for (Element assignedTsElement : children) {
            AssignedTimeSeries ats = this.buildAssignedTimeSeries(assignedTsElement);
            timeseriesSet.add(ats);
        }
        return timeseriesSet;
    }

    protected AssignedTimeSeries buildAssignedTimeSeries(Element element) {
        AssignedTimeSeries ats = null;
        if (element != null) {
            String officeId = null;
            DbOfficeId dbOfficeId = DbOfficeId.parse(element.getChild("db_office_id"));
            if (dbOfficeId != null) {
                officeId = dbOfficeId.getOfficeId();
            }
            TimeSeriesGroupRef theGroupRef = new TimeSeriesGroupRef(element.getChild("group"));
            String tsId = element.getAttributeValue("id");
            String attributeString = element.getAttributeValue("attribute");
            Integer attribute = null;
            attribute = attributeString == null || attributeString.isEmpty() ? null : Integer.valueOf(attributeString);
            String aliasId = element.getAttributeValue("alias_id");
            ats = new AssignedTimeSeries();
            ats.setOfficeId(officeId);
            ats.setCategoryId(theGroupRef.getCategoryRef().getId());
            ats.setGroupId(theGroupRef.getId());
            ats.setId(tsId);
            ats.setAttribute(attribute);
            ats.setAliasId(aliasId);
        }
        return ats;
    }

    public void buildElement(Element element) {
        if (element != null) {
            element.setAttribute("version", Double.toString(this.version));
            if (this.groupRef != null) {
                this.groupRef.buildElement(element);
            }
            Element descElement = XMLUtilities.getOrCreateChild(element, DESCRIPTION);
            descElement.setText(this.getDescription() == null ? "" : this.getDescription());
            Element assignLocSetElement = XMLUtilities.getOrCreateChild(element, ASSIGNED_TS_SET);
            this.buildAssignedTimeSeriesSetElement(assignLocSetElement);
            if (this.sharedTsAliasId != null) {
                element.setAttribute(SHARED_TS_ALIAS_ID, this.sharedTsAliasId);
            } else {
                element.removeAttribute(SHARED_TS_ALIAS_ID);
            }
            if (this.sharedTsRef != null) {
                element.setAttribute(SHARED_TS_REF, this.sharedTsRef);
            } else {
                element.removeAttribute(SHARED_TS_REF);
            }
        }
    }

    private void buildAssignedTimeSeriesSetElement(Element assignTsSetElement) {
        List children = assignTsSetElement.getChildren(ASSIGNED_TS);
        HashMap<String, Map<String, Element>> existingAssignedTimeSeries = new HashMap<String, Map<String, Element>>();
        if (!this.assignedTimeSeries.isEmpty()) {
            for (Element child : children) {
                AssignedTimeSeries ats = this.buildAssignedTimeSeries(child);
                String officeId = ats.getOfficeId();
                String tsId = ats.getId();
                HashMap<String, Element> map = (HashMap<String, Element>)existingAssignedTimeSeries.get(officeId);
                if (map == null) {
                    map = new HashMap<String, Element>();
                    existingAssignedTimeSeries.put(officeId, map);
                }
                map.put(tsId, child);
            }
        }
        ArrayList<Element> assignedTimeSeriesElements = new ArrayList<Element>();
        for (AssignedTimeSeries assignedTs : this.assignedTimeSeries) {
            Element locRefElement = this.findOrBuildAssignedTsElement(assignedTs, assignTsSetElement, existingAssignedTimeSeries);
            this.buildElement(locRefElement, assignedTs);
            locRefElement.detach();
            assignedTimeSeriesElements.add(locRefElement);
        }
        assignTsSetElement.removeContent();
        assignTsSetElement.addContent(assignedTimeSeriesElements);
    }

    private void buildElement(Element element, AssignedTimeSeries ats) {
        if (element != null) {
            Element dbOfficeElement = XMLUtilities.getOrCreateChild(element, "db_office_id");
            DbOfficeId dbOfficeId = new DbOfficeId(ats.getOfficeId());
            dbOfficeId.buildElement(dbOfficeElement);
            if (this.groupRef != null) {
                Element grpRefElement = XMLUtilities.getOrCreateChild(element, "group");
                this.groupRef.buildElement(grpRefElement);
            } else {
                element.removeChild("group");
            }
            String ALIAS_ID = "alias_id";
            String ATTRIBUTE = "attribute";
            String tsId = this.getId();
            if (tsId == null) {
                element.removeAttribute("id");
            } else {
                element.setAttribute("id", tsId);
            }
            Integer attribute = ats.getAttribute();
            if (attribute == null) {
                element.removeAttribute(ATTRIBUTE);
            } else {
                element.setAttribute(ATTRIBUTE, attribute.toString());
            }
            String aliasId = ats.getAliasId();
            if (aliasId == null) {
                element.removeAttribute(ALIAS_ID);
            } else {
                element.setAttribute(ALIAS_ID, aliasId);
            }
        }
    }

    private Element findOrBuildAssignedTsElement(AssignedTimeSeries assignedTs, Element assignLocSetElement, Map<String, Map<String, Element>> existingAssignedTimeSeries) {
        Element retval;
        String officeId = assignedTs.getOfficeId();
        String tsId = assignedTs.getId();
        Map<String, Element> map = existingAssignedTimeSeries.get(officeId);
        if (map != null && (retval = map.get(tsId)) != null) {
            return retval;
        }
        retval = new Element(ASSIGNED_TS);
        assignLocSetElement.addContent((Content)retval);
        return retval;
    }

    public String getGroupDescription() {
        return this.getDescription();
    }

    public void setGroupDescription(String groupDescription) {
        this.setDescription(groupDescription);
    }

    public String getId() {
        if (this.groupRef == null) {
            return null;
        }
        return this.groupRef.getId();
    }

    public void setId(String groupId) {
        TimeSeriesGroupRef newRef;
        TimeSeriesGroupRef curRef = this.groupRef;
        if (curRef == null) {
            curRef = new TimeSeriesGroupRef();
        }
        if (!(newRef = new TimeSeriesGroupRef(curRef.getCategoryRef(), curRef.getDbOfficeId(), groupId)).equals(curRef)) {
            this.groupRef = newRef;
            this.setName(this.groupRef.getId());
        }
    }

    public String getDbOfficeId() {
        if (this.groupRef == null) {
            return null;
        }
        return this.groupRef.getDbOfficeId();
    }

    public void setDbOfficeId(String dbOfficeId) {
        TimeSeriesGroupRef newRef;
        TimeSeriesGroupRef curRef = this.groupRef;
        if (curRef == null) {
            curRef = new TimeSeriesGroupRef();
        }
        if (!(newRef = new TimeSeriesGroupRef(curRef.getCategoryRef(), dbOfficeId, curRef.getId())).equals(curRef)) {
            this.groupRef = newRef;
        }
    }

    public TimeSeriesCategoryRef getCategoryRef() {
        if (this.groupRef == null) {
            return null;
        }
        return this.groupRef.getCategoryRef();
    }

    public void setCategoryRef(TimeSeriesCategoryRef categoryRef) {
        TimeSeriesGroupRef newRef;
        TimeSeriesGroupRef curRef = this.groupRef;
        if (this.groupRef == null) {
            curRef = new TimeSeriesGroupRef();
        }
        this.groupRef = newRef = new TimeSeriesGroupRef(categoryRef, curRef.getDbOfficeId(), curRef.getId());
    }

    public String getSharedTsAliasId() {
        return this.sharedTsAliasId;
    }

    public void setSharedTsAliasId(String aliasId) {
        this.sharedTsAliasId = aliasId;
    }

    public String getSharedTsRef() {
        return this.sharedTsRef;
    }

    public void setSharedTsRef(String sharedLocRef) {
        this.sharedTsRef = sharedLocRef;
    }

    public Set<AssignedTimeSeries> getAssignedTimeSeries() {
        return this.assignedTimeSeries;
    }

    public List<AssignedTimeSeries> getAssignedTimeSeriesSorted() {
        ArrayList<AssignedTimeSeries> locList = new ArrayList<AssignedTimeSeries>();
        if (this.assignedTimeSeries != null && !this.assignedTimeSeries.isEmpty()) {
            locList.addAll(this.assignedTimeSeries);
            if (!(this.assignedTimeSeries instanceof NavigableSet)) {
                Collections.sort(locList, new AttributeComparator());
            }
        }
        return locList;
    }

    public void setAssignedTimeSeries(Set<AssignedTimeSeries> newSeries) {
        this.assignedTimeSeries.clear();
        this.assignedTimeSeries.addAll(newSeries);
    }

    public void addAssignedTimeSeries(AssignedTimeSeries newTimeSeries) {
        this.assignedTimeSeries.add(newTimeSeries);
    }

    public void addAssignedTimeSeriesToEnd(Collection<AssignedTimeSeries> after) {
        if (after != null && !after.isEmpty()) {
            for (AssignedTimeSeries ats : after) {
                this.addAssignedTimeSeriesToEnd(ats);
            }
        }
    }

    public void addAssignedTimeSeriesToEnd(AssignedTimeSeries newTimeSeries) {
        Integer highestAttribute = this.getHighestAttribute();
        if (newTimeSeries.getAttribute() == null || newTimeSeries.getAttribute() <= highestAttribute) {
            Integer newAtributeVal = highestAttribute + 1;
            int q = newAtributeVal / 10;
            newAtributeVal = 10 * (q + 1);
            newTimeSeries.setAttribute(newAtributeVal);
            newTimeSeries.setModified(true);
        }
        this.addAssignedTimeSeries(newTimeSeries);
    }

    private Integer getHighestAttribute() {
        Integer retval = -1;
        List<AssignedTimeSeries> sorted = this.getAssignedTimeSeriesSorted();
        if (sorted != null && !sorted.isEmpty()) {
            AssignedTimeSeries lastAssLoc = sorted.get(sorted.size() - 1);
            retval = lastAssLoc.getAttribute();
        }
        return retval;
    }

    public String toXmlString() {
        String retval = null;
        Element element = new Element(ELEMENT);
        this.buildElement(element);
        try {
            retval = XMLUtilities.toXmlString(element);
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "toXmlString:Caught XmlException.", e);
        }
        return retval;
    }

    public String getCategoryId() {
        String retval = null;
        if (this.groupRef != null && this.groupRef.getCategoryRef() != null) {
            retval = this.groupRef.getCategoryRef().getId();
        }
        return retval;
    }

    public AssignedTimeSeries removeTimeSeries(String tsId) {
        if (tsId == null) {
            return null;
        }
        for (AssignedTimeSeries ats : this.assignedTimeSeries) {
            String id = ats.getId();
            if (!tsId.equals(id)) continue;
            this.assignedTimeSeries.remove(ats);
            return ats;
        }
        return null;
    }

    public boolean containsTimeSeriesRef(String tsId) {
        for (AssignedTimeSeries ats : this.assignedTimeSeries) {
            String id = ats.getId();
            if (id == null || !id.equals(tsId)) continue;
            return true;
        }
        return false;
    }

    private AssignedTimeSeries getAssignedTimeSeries(String tsId) {
        AssignedTimeSeries retval = null;
        if (tsId != null) {
            for (AssignedTimeSeries ats : this.assignedTimeSeries) {
                String id = ats.getId();
                if (!tsId.equals(id)) continue;
                retval = ats;
                break;
            }
        }
        return retval;
    }

    @Override
    public String toString() {
        if (this.groupRef == null) {
            return "";
        }
        return this.groupRef.toString();
    }

    public void moveUp(String tsId) {
        AssignedTimeSeries toMove = this.getAssignedTimeSeries(tsId);
        this.moveUp(toMove);
    }

    private void moveUp(AssignedTimeSeries toMove) {
        if (toMove != null) {
            TreeSet<AssignedTimeSeries> after = new TreeSet<AssignedTimeSeries>(new AttributeComparator());
            after.addAll(this.assignedTimeSeries.tailSet(toMove, false));
            AssignedTimeSeries itemBeforeToMove = this.assignedTimeSeries.lower(toMove);
            if (itemBeforeToMove != null) {
                NavigableSet<AssignedTimeSeries> headSet = this.assignedTimeSeries.headSet(itemBeforeToMove, false);
                TreeSet<AssignedTimeSeries> beforeThat = new TreeSet<AssignedTimeSeries>(new AttributeComparator());
                if (headSet != null) {
                    beforeThat.addAll(headSet);
                }
                this.assignedTimeSeries.retainAll(beforeThat);
                toMove.setAttribute(this.getHighestAttribute() + 1);
                this.addAssignedTimeSeriesToEnd(toMove);
                this.addAssignedTimeSeriesToEnd(itemBeforeToMove);
                this.addAssignedTimeSeriesToEnd(after);
                this.setModified(true);
            }
        }
    }

    public void moveDown(String tsId) {
        AssignedTimeSeries toMove = this.getAssignedTimeSeries(tsId);
        this.moveDown(toMove);
    }

    private void moveDown(AssignedTimeSeries toMove) {
        AssignedTimeSeries itemAfterToMove;
        if (toMove != null && (itemAfterToMove = this.assignedTimeSeries.higher(toMove)) != null) {
            TreeSet<AssignedTimeSeries> before = new TreeSet<AssignedTimeSeries>(new AttributeComparator());
            before.addAll(this.assignedTimeSeries.headSet(toMove, false));
            NavigableSet<AssignedTimeSeries> tailSet = this.assignedTimeSeries.tailSet(itemAfterToMove, false);
            TreeSet<AssignedTimeSeries> afterThat = new TreeSet<AssignedTimeSeries>(new AttributeComparator());
            if (tailSet != null) {
                afterThat.addAll(tailSet);
            }
            this.assignedTimeSeries.retainAll(before);
            this.addAssignedTimeSeriesToEnd(itemAfterToMove);
            toMove.setAttribute(this.getHighestAttribute() + 1);
            this.addAssignedTimeSeriesToEnd(toMove);
            this.addAssignedTimeSeriesToEnd(afterThat);
            this.setModified(true);
        }
    }

    public static class AttributeComparator
    implements Comparator<AssignedTimeSeries> {
        @Override
        public int compare(AssignedTimeSeries firstTs, AssignedTimeSeries secondTs) {
            int retval = -1;
            if (firstTs == secondTs) {
                retval = 0;
            } else if (firstTs != null && secondTs != null) {
                retval = AttributeComparator.compareAttributes(firstTs.getAttribute(), secondTs.getAttribute());
                if (retval == 0) {
                    retval = AttributeComparator.compareAlias(firstTs.getAliasId(), secondTs.getAliasId());
                }
                if (retval == 0) {
                    retval = AttributeComparator.compareId(firstTs.getId(), secondTs.getId());
                }
                if (retval == 0) {
                    retval = -1;
                }
            } else if (firstTs == null && secondTs != null) {
                retval = 1;
            }
            return retval;
        }

        public static int compareAttributes(Integer attribute1, Integer attribute2) {
            int retval = -1;
            if (attribute1 != null && attribute2 != null) {
                retval = attribute1 - attribute2;
            } else if (attribute1 == null && attribute2 == null) {
                retval = 0;
            } else if (attribute1 == null && attribute2 != null) {
                retval = 1;
            }
            return retval;
        }

        public static int compareAlias(String alias1, String alias2) {
            int retval = alias1 == null && alias2 == null ? 0 : (alias1 == null ? 1 : (alias2 == null ? -1 : alias1.compareTo(alias2)));
            return retval;
        }

        public static int compareId(String id1, String id2) {
            int retval = id1 == null && id2 == null ? 0 : (id1 == null ? 1 : (id2 == null ? -1 : id1.compareTo(id2)));
            return retval;
        }
    }
}

