/*
 * Decompiled with CFR 0.152.
 */
package hec.data.tx;

import hec.data.DbOfficeId;
import hec.data.tx.TimeSeriesCategoryRef;
import hec.util.XMLUtilities;
import org.jdom.Element;

public class TimeSeriesGroupRef
implements Comparable<TimeSeriesGroupRef> {
    private static final long serialVersionUID = -3183387991220642737L;
    public static final String ID = "id";
    public static final String TS_CAT_REF = "ts_category_ref";
    private final String officeId;
    private final TimeSeriesCategoryRef categoryRef;
    private final String id;

    public TimeSeriesGroupRef(TimeSeriesCategoryRef catRef, String groupOfficeId, String groupId) {
        this.id = groupId;
        this.categoryRef = catRef;
        this.officeId = groupOfficeId;
    }

    public TimeSeriesGroupRef(String categoryId, String catOfficeId, String groupOfficeId, String groupId) {
        this(new TimeSeriesCategoryRef(catOfficeId, categoryId), groupOfficeId, groupId);
    }

    public TimeSeriesGroupRef() {
        this.categoryRef = null;
        this.officeId = null;
        this.id = null;
    }

    public TimeSeriesGroupRef(Element element) {
        if (element != null) {
            String groupId;
            String groupOfficeId;
            DbOfficeId dbOfficeId = DbOfficeId.parse(element.getChild("db_office_id"));
            this.officeId = groupOfficeId = dbOfficeId.getOfficeId();
            TimeSeriesCategoryRef catRef = null;
            Element child = element.getChild(TS_CAT_REF);
            if (child != null) {
                catRef = new TimeSeriesCategoryRef(child);
            }
            this.categoryRef = catRef;
            this.id = groupId = element.getAttributeValue(ID);
        } else {
            this.officeId = null;
            this.categoryRef = null;
            this.id = null;
        }
    }

    public void buildElement(Element element) {
        DbOfficeId dbOfficeId = new DbOfficeId(this.officeId);
        Element dbOfficeElement = XMLUtilities.getOrCreateChild(element, "db_office_id");
        dbOfficeId.buildElement(dbOfficeElement);
        if (this.categoryRef != null) {
            Element catRefElement = XMLUtilities.getOrCreateChild(element, TS_CAT_REF);
            this.categoryRef.buildElement(catRefElement);
        } else {
            element.removeChild(TS_CAT_REF);
        }
        element.setAttribute(ID, this.getId() == null ? "" : this.getId());
    }

    @Override
    public int compareTo(TimeSeriesGroupRef otherObj) {
        int c2;
        int BEFORE = -1;
        boolean EQUAL = false;
        boolean AFTER = true;
        if (this == otherObj) {
            return 0;
        }
        if (otherObj == null) {
            return 1;
        }
        if (this.getClass() != otherObj.getClass()) {
            return 1;
        }
        TimeSeriesGroupRef other = otherObj;
        if (this.categoryRef == null) {
            if (other.categoryRef != null) {
                return -1;
            }
        } else if (other.categoryRef != null && (c2 = this.categoryRef.compareTo(other.categoryRef)) != 0) {
            return c2;
        }
        if (this.officeId == null) {
            if (other.officeId != null) {
                return -1;
            }
        } else if (other.officeId != null && (c2 = this.officeId.compareTo(other.officeId)) != 0) {
            return c2;
        }
        if (this.id == null) {
            if (other.id != null) {
                return -1;
            }
        } else if (other.id != null && (c2 = this.id.toUpperCase().compareTo(other.id.toUpperCase())) != 0) {
            return c2;
        }
        return 0;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.officeId == null ? 0 : this.officeId.hashCode());
        result = 31 * result + (this.categoryRef == null ? 0 : this.categoryRef.hashCode());
        result = 31 * result + (this.id == null ? 0 : this.id.toUpperCase().hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TimeSeriesGroupRef other = (TimeSeriesGroupRef)obj;
        if (this.categoryRef == null ? other.categoryRef != null : !this.categoryRef.equals(other.categoryRef)) {
            return false;
        }
        if (this.officeId == null ? other.officeId != null : !this.officeId.equals(other.officeId)) {
            return false;
        }
        return !(this.id == null ? other.id != null : !this.id.toUpperCase().equals(other.id.toUpperCase()));
    }

    public String getDbOfficeId() {
        return this.officeId;
    }

    public TimeSeriesCategoryRef getCategoryRef() {
        return this.categoryRef;
    }

    public String getCategoryId() {
        if (this.categoryRef != null) {
            return this.categoryRef.getId();
        }
        return null;
    }

    public String getId() {
        return this.id;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.categoryRef != null) {
            sb.append(this.categoryRef.getId());
            sb.append("-");
        }
        sb.append(this.getId());
        return sb.toString();
    }
}

