/*
 * Decompiled with CFR 0.152.
 */
package hec.data.tx;

import hec.data.meta.Catalog;
import hec.data.tx.TsGroup;
import java.util.List;
import java.util.TreeMap;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;

public class TsCategoryMap
extends AbstractListModel
implements ComboBoxModel {
    private TreeMap<String, TsGroup> _groupList = new TreeMap();
    private TsGroup _selectedItem;

    public TsCategoryMap(Catalog tsGroupCatalog) {
        this.addParsedCatalog(tsGroupCatalog, true);
    }

    private void addParsedCatalog(Catalog tsGroupCatalog, boolean b) {
        int categoryIdIdx = tsGroupCatalog.getColumnIndex("TS_CATEGORY_ID");
        int categoryDescIdx = tsGroupCatalog.getColumnIndex("TS_CATEGORY_DESC");
        int categoryOfficeIdx = tsGroupCatalog.getColumnIndex("CAT_DB_OFFICE_ID");
        int tsGroupIdIdx = tsGroupCatalog.getColumnIndex("TS_GROUP_ID");
        int tsGroupDescIdx = tsGroupCatalog.getColumnIndex("TS_GROUP_DESC");
        int tsGroupOfficeIdx = tsGroupCatalog.getColumnIndex("GRP_DB_OFFICE_ID");
        for (int rowidx = 0; rowidx < tsGroupCatalog.size(); ++rowidx) {
            List row = tsGroupCatalog.getRow(rowidx);
            String categoryId = (String)row.get(categoryIdIdx);
            String categoryDesc = (String)row.get(categoryDescIdx);
            String categoryOffice = (String)row.get(categoryOfficeIdx);
            String groupId = (String)row.get(tsGroupIdIdx);
            String groupDesc = (String)row.get(tsGroupDescIdx);
            String groupOfficeId = (String)row.get(tsGroupOfficeIdx);
            TsGroup tsGroup = new TsGroup();
            tsGroup.setCategoryId(categoryId);
            tsGroup.setCategoryOfficeId(categoryOffice);
            tsGroup.setGroupId(groupId);
            tsGroup.setGroupOfficeId(groupOfficeId);
            this._groupList.put(categoryId + "-" + groupId, tsGroup);
        }
    }

    @Override
    public int getSize() {
        return this._groupList.size();
    }

    @Override
    public Object getElementAt(int index) {
        int count = 0;
        for (TsGroup tsGroup : this._groupList.values()) {
            if (count++ != index) continue;
            return tsGroup;
        }
        return null;
    }

    @Override
    public void setSelectedItem(Object anItem) {
        this._selectedItem = anItem instanceof TsGroup ? (TsGroup)anItem : (anItem != null ? this.find(anItem.toString()) : null);
        this.fireContentsChanged(this, -1, -1);
    }

    private TsGroup find(String string) {
        return this._groupList.get(string);
    }

    @Override
    public Object getSelectedItem() {
        return this._selectedItem;
    }

    public Object[] getTsGroupList() {
        TsGroup[] tsGroupList = new TsGroup[this._groupList.size()];
        return this._groupList.values().toArray(tsGroupList);
    }
}

