/*
 * Decompiled with CFR 0.152.
 */
package hec.data.tx;

import hec.data.location.LocationGroup;
import hec.data.meta.Catalog;
import hec.data.tx.TsCategory;
import hec.data.tx.TsGroup;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;

public class TsCategoryMap1
extends AbstractListModel
implements ComboBoxModel {
    private Map<String, TsCategory> categoryMap = new TreeMap<String, TsCategory>();
    private TsGroup selectedItem;

    public TsCategoryMap1(Catalog tsGroupCatalog) {
        this.categoryMap.clear();
        this.addParsedCatalog(tsGroupCatalog, true);
    }

    public TsCategoryMap1() {
    }

    private void addParsedCatalog(Catalog tsGroupCatalog, boolean addNullEntry) {
        int categoryIdIdx = tsGroupCatalog.getColumnIndex("TS_CATEGORY_ID");
        int categoryDescIdx = tsGroupCatalog.getColumnIndex("TS_CATEGORY_DESC");
        int categoryOfficeIdx = tsGroupCatalog.getColumnIndex("CAT_DB_OFFICE_ID");
        int tsGroupIdIdx = tsGroupCatalog.getColumnIndex("TS_GROUP_ID");
        int tsGroupDescIdx = tsGroupCatalog.getColumnIndex("TS_GROUP_DESC");
        int tsGroupOfficeIdx = tsGroupCatalog.getColumnIndex("GRP_DB_OFFICE_ID");
        int tsGroupAliasIdx = tsGroupCatalog.getColumnIndex("SHARED_TS_ALIAS_ID");
        int tsGroupRefIdx = tsGroupCatalog.getColumnIndex("SHARED_TS_REF_ID");
        for (int rowidx = 0; rowidx < tsGroupCatalog.size(); ++rowidx) {
            List row = tsGroupCatalog.getRow(rowidx);
            String categoryId = (String)row.get(categoryIdIdx);
            String categoryDesc = (String)row.get(categoryDescIdx);
            String categoryOffice = (String)row.get(categoryOfficeIdx);
            String groupId = (String)row.get(tsGroupIdIdx);
            String groupDesc = (String)row.get(tsGroupDescIdx);
            String groupOfficeId = (String)row.get(tsGroupOfficeIdx);
            String groupAlias = (String)row.get(tsGroupAliasIdx);
            String groupRefId = (String)row.get(tsGroupRefIdx);
            if (categoryId == null) continue;
            TsCategory category = this.categoryMap.get(categoryId);
            if (category == null) {
                category = new TsCategory(categoryId);
                category.setDescription(categoryDesc);
                this.categoryMap.put(categoryId, category);
            }
            if (groupId == null) continue;
            category.addGroup(groupId, groupDesc, categoryOffice, groupOfficeId, groupAlias, groupRefId);
        }
    }

    @Override
    public Object getSelectedItem() {
        return this.selectedItem;
    }

    @Override
    public void setSelectedItem(Object anItem) {
        this.selectedItem = anItem instanceof LocationGroup ? (TsGroup)anItem : (anItem != null ? this.find(anItem.toString()) : null);
        this.fireContentsChanged(this, -1, -1);
    }

    private TsGroup find(String string) {
        StringTokenizer st = new StringTokenizer("-");
        if (st.countTokens() < 2) {
            return null;
        }
        String strCategory = st.nextToken();
        String strGroup = st.nextToken();
        TsCategory category = this.categoryMap.get(strCategory);
        if (category == null) {
            return null;
        }
        TsGroup group = category.get(strGroup);
        return group;
    }

    @Override
    public Object getElementAt(int index) {
        int ii = 0;
        for (TsCategory tsCategory : this.categoryMap.values()) {
            int size = tsCategory.size();
            if (index > ii + size) {
                ii += size;
                continue;
            }
            for (TsGroup tsGroup : tsCategory.values()) {
                if (ii == index) {
                    return tsGroup;
                }
                ++ii;
            }
        }
        return null;
    }

    @Override
    public int getSize() {
        return this.size();
    }

    public int size() {
        int size = 0;
        for (TsCategory tsCategory : this.categoryMap.values()) {
            size += tsCategory.size();
        }
        return size;
    }

    public void addCategory(TsCategory category) {
        this.categoryMap.put(category.getId(), category);
    }

    public void addGroup(TsGroup tsGroup) {
        TsCategory tsCategory = this.categoryMap.get(tsGroup.getCategoryId());
        tsCategory.addGroup(tsGroup);
    }

    public TsCategory getCategory(String name) {
        return this.categoryMap.get(name);
    }

    public TsCategory[] getTsCategories() {
        TsCategory[] tsCategories = new TsCategory[this.categoryMap.values().size()];
        int i = 0;
        for (TsCategory tsCategory : this.categoryMap.values()) {
            tsCategories[i++] = tsCategory;
        }
        return tsCategories;
    }

    public TsGroup[] getTsGroups() {
        ArrayList<TsGroup> tsGroupArray = new ArrayList<TsGroup>();
        for (TsCategory tsCategory : this.categoryMap.values()) {
            for (TsGroup tsGroup : tsCategory.values()) {
                tsGroupArray.add(tsGroup);
            }
        }
        TsGroup[] returnArray = new TsGroup[tsGroupArray.size()];
        tsGroupArray.toArray(returnArray);
        return returnArray;
    }
}

