/*
 * Decompiled with CFR 0.152.
 */
package hec.data.tx.comparator;

import hec.data.Units;
import hec.data.tx.DataSetTx;
import hec.data.tx.comparator.DataSetTxComparator;
import java.util.Comparator;
import rma.util.RMAIO;

public class DataSetTxValuesComparator
implements Comparator<DataSetTx> {
    private static final double EPSILON = 1.0E-5;

    @Override
    public int compare(DataSetTx ds1, DataSetTx ds2) {
        Units ds2Units;
        double[] ds2Values;
        if (DataSetTxComparator.nullCompare(ds1, ds2) != Integer.MIN_VALUE) {
            return DataSetTxComparator.nullCompare(ds1, ds2);
        }
        double[] ds1Values = ds1.getValues();
        if (DataSetTxComparator.nullCompare(ds1Values, ds2Values = ds2.getValues()) != Integer.MIN_VALUE) {
            return DataSetTxComparator.nullCompare(ds1Values, ds2Values);
        }
        if (Integer.compare(ds1Values.length, ds2Values.length) != 0) {
            return Integer.compare(ds1Values.length, ds2Values.length);
        }
        Units ds1Units = ds1.getUnits();
        if (DataSetTxComparator.nullCompare(ds1Units, ds2Units = ds2.getUnits()) != Integer.MIN_VALUE) {
            return DataSetTxComparator.nullCompare(ds1Units, ds2Units);
        }
        return this.compareValueArrays(ds1Values, ds2Values);
    }

    private int compareValueArrays(double[] ds1Values, double[] ds2Values) {
        int retVal = 0;
        for (int i = 0; i < ds1Values.length; ++i) {
            int comp = RMAIO.compareTo(ds1Values[i], ds2Values[i], 1.0E-5);
            if (comp == 0) continue;
            retVal = comp;
            break;
        }
        return retVal;
    }
}

