/*
 * Decompiled with CFR 0.152.
 */
package hec.data.watersupply;

import hec.data.DataObjectException;
import hec.data.TimeWindow;
import hec.data.TimeWindowMap;
import hec.data.location.LocationTemplate;
import hec.data.watersupply.IContractWaterSupplyAccounting;
import hec.data.watersupply.IWaterSupplyPumpAccounting;
import hec.data.watersupply.IWaterUserContractRef;
import hec.data.watersupply.JDomWaterSupplyPumpAccountingImpl;
import hec.lang.NamedType;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import rma.lang.Modifiable;

public class JDomContractWaterSupplyAccounting
extends NamedType
implements IContractWaterSupplyAccounting,
Modifiable {
    private IWaterUserContractRef _contractRef;
    private Map<LocationTemplate, NavigableMap<Date, IWaterSupplyPumpAccounting>> _pumpLocMap = new HashMap<LocationTemplate, NavigableMap<Date, IWaterSupplyPumpAccounting>>();
    private Map<LocationTemplate, TimeWindowMap> _pumpTimeWindowMap = new HashMap<LocationTemplate, TimeWindowMap>();

    public JDomContractWaterSupplyAccounting() {
    }

    public JDomContractWaterSupplyAccounting(IWaterUserContractRef contractRef) {
        this._contractRef = contractRef;
    }

    @Override
    public IWaterUserContractRef getWaterUserContractRef() {
        return this._contractRef;
    }

    public void setWaterUserContractRef(IWaterUserContractRef contractRef) {
        this._contractRef = contractRef;
    }

    @Override
    public synchronized Map<LocationTemplate, NavigableMap<Date, IWaterSupplyPumpAccounting>> getAllPumpAccounting() {
        HashMap<LocationTemplate, NavigableMap<Date, IWaterSupplyPumpAccounting>> output = new HashMap<LocationTemplate, NavigableMap<Date, IWaterSupplyPumpAccounting>>();
        for (Map.Entry<LocationTemplate, NavigableMap<Date, IWaterSupplyPumpAccounting>> entry : this._pumpLocMap.entrySet()) {
            output.put(entry.getKey(), new TreeMap(entry.getValue()));
        }
        return output;
    }

    @Override
    public int size() {
        int size = 0;
        Collection<NavigableMap<Date, IWaterSupplyPumpAccounting>> values = this._pumpLocMap.values();
        for (NavigableMap<Date, IWaterSupplyPumpAccounting> value : values) {
            size += value.size();
        }
        return size;
    }

    @Override
    public Map<LocationTemplate, NavigableMap<Date, IWaterSupplyPumpAccounting>> getAllPumpAccounting(Date startDate, Date endDate) {
        HashMap<LocationTemplate, NavigableMap<Date, IWaterSupplyPumpAccounting>> pumpSubMaps = new HashMap<LocationTemplate, NavigableMap<Date, IWaterSupplyPumpAccounting>>();
        Set<Map.Entry<LocationTemplate, NavigableMap<Date, IWaterSupplyPumpAccounting>>> entrySet = this._pumpLocMap.entrySet();
        for (Map.Entry<LocationTemplate, NavigableMap<Date, IWaterSupplyPumpAccounting>> entry : entrySet) {
            NavigableMap<Date, IWaterSupplyPumpAccounting> value = entry.getValue();
            pumpSubMaps.put(entry.getKey(), value.subMap(startDate, true, endDate, true));
        }
        return pumpSubMaps;
    }

    @Override
    public NavigableMap<Date, IWaterSupplyPumpAccounting> getPumpAccounting(LocationTemplate pumpLocRef) {
        NavigableMap<Date, IWaterSupplyPumpAccounting> map = this._pumpLocMap.get((Object)pumpLocRef);
        if (map == null) {
            map = this.buildPumpAccounting(pumpLocRef);
        }
        return map;
    }

    @Override
    public NavigableMap<Date, IWaterSupplyPumpAccounting> getPumpAccounting(LocationTemplate pumpLocRef, Date startDate, Date endDate) {
        NavigableMap<Date, IWaterSupplyPumpAccounting> map = this._pumpLocMap.get((Object)pumpLocRef);
        if (map == null) {
            map = this.buildPumpAccounting(pumpLocRef);
            return map;
        }
        return map.subMap(startDate, true, endDate, true);
    }

    public NavigableMap<Date, IWaterSupplyPumpAccounting> buildPumpAccounting(LocationTemplate pumpLocationRef) {
        NavigableMap<Date, IWaterSupplyPumpAccounting> accountingMap = this._pumpLocMap.get((Object)pumpLocationRef);
        if (accountingMap != null) {
            return accountingMap;
        }
        accountingMap = new TreeMap<Date, IWaterSupplyPumpAccounting>();
        this._pumpLocMap.put(pumpLocationRef, accountingMap);
        return accountingMap;
    }

    @Override
    public void mergeAccounting(LocationTemplate pumpLocRef, NavigableMap<Date, IWaterSupplyPumpAccounting> accountingMap, boolean generateModifiedTimeWindow, boolean preserveModifiedData) {
        TimeWindowMap pumpTwMap;
        if (pumpLocRef == null || accountingMap == null || accountingMap.isEmpty()) {
            return;
        }
        NavigableMap<Date, IWaterSupplyPumpAccounting> cacheMap = this._pumpLocMap.get((Object)pumpLocRef);
        if (cacheMap == null) {
            this._pumpLocMap.put(pumpLocRef, new TreeMap<Date, IWaterSupplyPumpAccounting>((SortedMap<Date, IWaterSupplyPumpAccounting>)accountingMap));
            if (generateModifiedTimeWindow) {
                TimeWindowMap timeWindowMap = this._pumpTimeWindowMap.get((Object)pumpLocRef);
                if (timeWindowMap == null) {
                    timeWindowMap = new TimeWindowMap();
                    this._pumpTimeWindowMap.put(pumpLocRef, timeWindowMap);
                }
                if (!accountingMap.isEmpty()) {
                    try {
                        timeWindowMap.addTimeWindow((Date)accountingMap.firstKey(), true, (Date)accountingMap.lastKey(), true);
                    }
                    catch (IllegalArgumentException ex) {
                        Logger.getLogger(JDomContractWaterSupplyAccounting.class.getName()).log(Level.SEVERE, "Start time cannot be after end time.", ex);
                    }
                }
            }
            return;
        }
        if (preserveModifiedData && (pumpTwMap = this.getTimeWindowMap(pumpLocRef)) != null && pumpTwMap.size() > 0) {
            Set<TimeWindow> timeWindowSet = pumpTwMap.getTimeWindowSet();
            for (TimeWindow timeWindow : timeWindowSet) {
                Date mtwEndDate;
                Date date = timeWindow.getStartDate();
                NavigableMap<Date, IWaterSupplyPumpAccounting> modSet = accountingMap.subMap(date, true, mtwEndDate = timeWindow.getEndDate(), true);
                if (modSet == null || modSet.isEmpty()) continue;
                HashSet modSetKeys = new HashSet(modSet.keySet());
                accountingMap.keySet().removeAll(modSetKeys);
            }
        }
        NavigableMap<Date, IWaterSupplyPumpAccounting> tempCache = new TreeMap<Date, IWaterSupplyPumpAccounting>((SortedMap<Date, IWaterSupplyPumpAccounting>)cacheMap);
        boolean valuesRemoved = (tempCache = tempCache.subMap((Date)accountingMap.firstKey(), true, (Date)accountingMap.lastKey(), true)).keySet().removeAll(accountingMap.keySet());
        if (valuesRemoved) {
            Set entrySet = tempCache.entrySet();
            for (Map.Entry entry : entrySet) {
                TimeWindowMap pumpTwMap2;
                Date key = (Date)entry.getKey();
                if (preserveModifiedData && (pumpTwMap2 = this.getTimeWindowMap(pumpLocRef)) != null && pumpTwMap2.containedInTimeWindow(key, true)) continue;
                IWaterSupplyPumpAccounting value = (IWaterSupplyPumpAccounting)entry.getValue();
                value.setUndefined();
            }
        }
        cacheMap.putAll(accountingMap);
        if (generateModifiedTimeWindow) {
            TimeWindowMap timeWindowMap = this._pumpTimeWindowMap.get((Object)pumpLocRef);
            if (timeWindowMap == null) {
                timeWindowMap = new TimeWindowMap();
                this._pumpTimeWindowMap.put(pumpLocRef, timeWindowMap);
            }
            try {
                timeWindowMap.addTimeWindow((Date)accountingMap.firstKey(), true, (Date)accountingMap.lastKey(), true);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                Logger.getLogger(JDomContractWaterSupplyAccounting.class.getName()).log(Level.SEVERE, "Start time cannot be after end time.", illegalArgumentException);
            }
        }
    }

    @Override
    public void mergeAccounting(IContractWaterSupplyAccounting contractAccounting, boolean generateModifiedTimeWindow, boolean preserveModifiedData) throws DataObjectException {
        if (!this.getWaterUserContractRef().equals(contractAccounting.getWaterUserContractRef())) {
            throw new DataObjectException("Cannot merge accountings for different contracts.");
        }
        Map<LocationTemplate, NavigableMap<Date, IWaterSupplyPumpAccounting>> allPumpAccounting = contractAccounting.getAllPumpAccounting();
        Set<Map.Entry<LocationTemplate, NavigableMap<Date, IWaterSupplyPumpAccounting>>> entrySet = allPumpAccounting.entrySet();
        for (Map.Entry<LocationTemplate, NavigableMap<Date, IWaterSupplyPumpAccounting>> entry : entrySet) {
            this.mergeAccounting(entry.getKey(), entry.getValue(), generateModifiedTimeWindow, preserveModifiedData);
        }
    }

    public void removeUndefinedValues() {
        Set<Map.Entry<LocationTemplate, NavigableMap<Date, IWaterSupplyPumpAccounting>>> entrySet = this._pumpLocMap.entrySet();
        for (Map.Entry<LocationTemplate, NavigableMap<Date, IWaterSupplyPumpAccounting>> entry : entrySet) {
            NavigableMap<Date, IWaterSupplyPumpAccounting> pumpAccounting = entry.getValue();
            Set entrySet1 = pumpAccounting.entrySet();
            HashSet<Date> removeKeys = new HashSet<Date>();
            for (Map.Entry entry1 : entrySet1) {
                IWaterSupplyPumpAccounting value1 = (IWaterSupplyPumpAccounting)entry1.getValue();
                if (value1.isValid()) continue;
                removeKeys.add((Date)entry1.getKey());
            }
            pumpAccounting.keySet().removeAll(removeKeys);
        }
    }

    @Override
    public Map<LocationTemplate, TimeWindowMap> getPumpTimeWindowMap() {
        return this._pumpTimeWindowMap;
    }

    @Override
    public void clearPumpTimeWindowMaps() {
        Set<Map.Entry<LocationTemplate, TimeWindowMap>> entrySet = this._pumpTimeWindowMap.entrySet();
        for (Map.Entry<LocationTemplate, TimeWindowMap> entry : entrySet) {
            entry.getValue().clear();
        }
    }

    @Override
    public TimeWindowMap getTimeWindowMap(LocationTemplate pumpLocRef) {
        return this._pumpTimeWindowMap.get((Object)pumpLocRef);
    }

    @Override
    public IContractWaterSupplyAccounting windowAndLimit(Date startTime, Date endTime, boolean headFlag, int rowLimit) {
        JDomContractWaterSupplyAccounting dst = new JDomContractWaterSupplyAccounting(this.getWaterUserContractRef());
        Map<LocationTemplate, NavigableMap<Date, IWaterSupplyPumpAccounting>> allPumpAccounting = this.getAllPumpAccounting(startTime, endTime);
        if (allPumpAccounting == null || allPumpAccounting.isEmpty()) {
            return dst;
        }
        Set<Map.Entry<LocationTemplate, NavigableMap<Date, IWaterSupplyPumpAccounting>>> entrySet = allPumpAccounting.entrySet();
        block0: for (Map.Entry<LocationTemplate, NavigableMap<Date, IWaterSupplyPumpAccounting>> entry : entrySet) {
            LocationTemplate pumpLocRef = entry.getKey();
            NavigableMap<Date, IWaterSupplyPumpAccounting> dstPumpAccounting = dst.buildPumpAccounting(pumpLocRef);
            NavigableMap<Date, IWaterSupplyPumpAccounting> srcPumpAccounting = entry.getValue();
            if (srcPumpAccounting.isEmpty()) continue;
            Set<Object> keySet = headFlag ? srcPumpAccounting.keySet() : srcPumpAccounting.descendingKeySet();
            int ii = 0;
            for (Date key : keySet) {
                if (ii >= rowLimit) continue block0;
                IWaterSupplyPumpAccounting srcVal = (IWaterSupplyPumpAccounting)srcPumpAccounting.get(key);
                JDomWaterSupplyPumpAccountingImpl srcClone = new JDomWaterSupplyPumpAccountingImpl(srcVal);
                dstPumpAccounting.put(key, srcClone);
                ++ii;
            }
        }
        return dst;
    }
}

