/*
 * Decompiled with CFR 0.152.
 */
package hec.data.watersupply;

import hec.data.AbstractJDomDataObject;
import hec.data.JDomDataObjectFactory;
import hec.data.ParamDouble;
import hec.data.Parameter;
import hec.data.location.LocationTemplate;
import hec.data.lookup.ILookupType;
import hec.data.lookup.JDomLookupTypeImpl;
import hec.data.watersupply.IWaterSupplyPumpAccounting;
import hec.data.watersupply.IWaterUserContractRef;
import hec.data.watersupply.JDomWaterUserContractRef;
import hec.lang.annotation.EntityBean;
import hec.lang.annotation.EntityBeanMap;
import hec.lang.annotation.EntityBeanType;
import hec.util.XMLUtilities;
import java.util.Date;
import java.util.logging.Logger;
import org.jdom.Element;
import rma.util.RMAConst;

@EntityBeanType(beanType="usace.rowcps.db.oracle.WaterUserContractAccountingObjTUser")
public class JDomWaterSupplyPumpAccountingImpl
extends AbstractJDomDataObject
implements IWaterSupplyPumpAccounting {
    public static final Logger logger = Logger.getLogger(JDomWaterSupplyPumpAccountingImpl.class.getName());
    private JDomWaterUserContractRef _contractRef;
    private LocationTemplate _pumpLocationRef;
    private Date _transferStartDatetime;
    private JDomLookupTypeImpl _physicalTransferType;
    private double _accountingFlow;
    private String _accountingRemarks;
    private static final String _accountingFlowUnits = Parameter.getUnitsStringForSystem(Parameter.PARAMID_FLOW, 2);

    public JDomWaterSupplyPumpAccountingImpl() {
    }

    public JDomWaterSupplyPumpAccountingImpl(IWaterSupplyPumpAccounting contractAccounting) {
        this(JDomDataObjectFactory.getRootElement(contractAccounting.toXmlString()));
    }

    public JDomWaterSupplyPumpAccountingImpl(Element element) {
        if (element != null) {
            this._contractRef = new JDomWaterUserContractRef(element.getChild("water_user_contract"));
            this._pumpLocationRef = LocationTemplate.parse(element.getChild("pump_location"));
            this._transferStartDatetime = JDomWaterSupplyPumpAccountingImpl.getXmlDate(element, "transfer_start_datetime", "ddMMMyyyy");
            this._physicalTransferType = new JDomLookupTypeImpl(element.getChild("physical_transfer_type"));
            ParamDouble paramDouble = new ParamDouble();
            this._accountingFlow = JDomWaterSupplyPumpAccountingImpl.getXmlValue(paramDouble, element, "accounting_flow", Parameter.PARAMID_FLOW);
            this._accountingRemarks = element.getChildText("accounting_remarks");
        }
    }

    public JDomWaterSupplyPumpAccountingImpl(IWaterUserContractRef contractRef, LocationTemplate pumpLocRef, Date transferStartDateTime) {
        this._pumpLocationRef = pumpLocRef;
        this._transferStartDatetime = transferStartDateTime;
        this.setWaterUserContractRef(contractRef);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this._contractRef == null ? 0 : this._contractRef.hashCode());
        result = 31 * result + (this._pumpLocationRef == null ? 0 : this._pumpLocationRef.hashCode());
        result = 31 * result + (this._transferStartDatetime == null ? 0 : this._transferStartDatetime.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        JDomWaterSupplyPumpAccountingImpl other = (JDomWaterSupplyPumpAccountingImpl)obj;
        if (this._contractRef == null ? other._contractRef != null : !this._contractRef.equals(other._contractRef)) {
            return false;
        }
        if (this._pumpLocationRef == null ? other._pumpLocationRef != null : !this._pumpLocationRef.equals((Object)other._pumpLocationRef)) {
            return false;
        }
        return !(this._transferStartDatetime == null ? other._transferStartDatetime != null : !this._transferStartDatetime.equals(other._transferStartDatetime));
    }

    @Override
    @EntityBeanMap(attributeName="AccountingRemarks")
    public String getAccountingRemarks() {
        return this._accountingRemarks;
    }

    @Override
    @EntityBean(attributeName="PhysicalTransferType")
    public JDomLookupTypeImpl getPhysicalTransferType() {
        return this._physicalTransferType;
    }

    @Override
    @EntityBeanMap(attributeName="TransferStartDatetime")
    public Date getTransferStartDatetime() {
        return this._transferStartDatetime;
    }

    @Override
    @EntityBean(attributeName="WaterUserContractRef")
    public JDomWaterUserContractRef getWaterUserContractRef() {
        return this._contractRef;
    }

    @Override
    public void setAccountingRemarks(String accountingRemarks) {
        this._accountingRemarks = accountingRemarks;
    }

    @Override
    public void setPhysicalTransferType(ILookupType physicalTransferType) {
        this._physicalTransferType = new JDomLookupTypeImpl(physicalTransferType);
    }

    @Override
    public void setTransferStartDatetime(Date transferStartDatetime) {
        this._transferStartDatetime = transferStartDatetime;
    }

    public void setWaterUserContractRef(IWaterUserContractRef wusrContractAcctContr) {
        this._contractRef = wusrContractAcctContr instanceof JDomWaterUserContractRef ? (JDomWaterUserContractRef)wusrContractAcctContr : new JDomWaterUserContractRef(wusrContractAcctContr);
    }

    @Override
    public void buildElement(Element element) {
        if (element != null) {
            Element wuc = XMLUtilities.getOrCreateChild(element, "water_user_contract");
            if (this.getWaterUserContractRef() != null) {
                this.getWaterUserContractRef().buildElement(wuc);
            }
            Element pumpLocElement = XMLUtilities.getOrCreateChild(element, "pump_location");
            if (this.getPumpLocationRef() != null) {
                this.getPumpLocationRef().buildElement(pumpLocElement);
            } else {
                pumpLocElement.removeContent();
            }
            JDomWaterSupplyPumpAccountingImpl.setXmlDate(element, "transfer_start_datetime", "ddMMMyyyy", this.getTransferStartDatetime());
            Element ptt = XMLUtilities.getOrCreateChild(element, "physical_transfer_type");
            if (this.getPhysicalTransferType() != null) {
                this.getPhysicalTransferType().buildElement(ptt);
            }
            ParamDouble paramDouble = new ParamDouble();
            JDomWaterSupplyPumpAccountingImpl.setXmlValue(paramDouble, element, "accounting_flow", this.getAccountingFlow(), Parameter.PARAMID_FLOW);
            XMLUtilities.getOrCreateChild(element, "accounting_remarks").setText(this.getAccountingRemarks());
        }
    }

    @Override
    @EntityBean(attributeName="PumpLocationRef")
    public LocationTemplate getPumpLocationRef() {
        return this._pumpLocationRef;
    }

    public void setPumpLocationRef(LocationTemplate loc) {
        this._pumpLocationRef = loc;
    }

    @Override
    public void getAccountingFlow(ParamDouble paramDouble) {
        paramDouble.setParameterId(Parameter.PARAMID_FLOW);
        paramDouble.setUnitSystem(2);
        paramDouble.setValue(this._accountingFlow);
    }

    @Override
    public void setAccountingFlow(ParamDouble paramDouble) {
        this._accountingFlow = paramDouble.convertToUnitSystem(2);
    }

    @Override
    @EntityBeanMap(attributeName="PumpFlow")
    public double getAccountingFlow() {
        return this._accountingFlow;
    }

    @Override
    public String getAccountingFlowUnits() {
        return _accountingFlowUnits;
    }

    @Override
    public void setAccountingFlow(double accountingFlow) {
        this._accountingFlow = accountingFlow;
    }

    @Override
    public void setUndefined() {
        this._accountingFlow = Double.NEGATIVE_INFINITY;
    }

    @Override
    public boolean isValid() {
        return RMAConst.isValidValue(this._accountingFlow);
    }
}

