/*
 * Decompiled with CFR 0.152.
 */
package hec.data.watersupply;

import hec.data.AbstractJDomDataObject;
import hec.data.JDomDataObjectFactory;
import hec.data.ParamDouble;
import hec.data.Parameter;
import hec.data.location.Location;
import hec.data.location.LocationTemplate;
import hec.data.lookup.ILookupType;
import hec.data.lookup.JDomLookupTypeImpl;
import hec.data.watersupply.IWaterSupplyPump;
import hec.data.watersupply.IWaterUser;
import hec.data.watersupply.IWaterUserContract;
import hec.data.watersupply.IWaterUserContractRef;
import hec.data.watersupply.JDomWaterSupplyPump;
import hec.data.watersupply.JDomWaterUserContractRef;
import hec.data.watersupply.JDomWaterUserImpl;
import hec.data.watersupply.PumpType;
import hec.lang.annotation.EntityBean;
import hec.lang.annotation.EntityBeanMap;
import hec.lang.annotation.EntityBeanType;
import hec.util.XMLUtilities;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.jdom.Element;

@EntityBeanType(beanType="usace.rowcps.db.oracle.WaterUserContractObjTUser")
public class JDomWaterUserContractImpl
extends AbstractJDomDataObject
implements IWaterUserContract {
    private JDomWaterUserContractRef _contractRef;
    private double _contractedStorage = Double.NEGATIVE_INFINITY;
    private double _futureUseAllocation = Double.NEGATIVE_INFINITY;
    private double _futureUsePercentActivated = Double.NEGATIVE_INFINITY;
    private double _initialUseAllocation = Double.NEGATIVE_INFINITY;
    private double _totalAllocPercentActivated = Double.NEGATIVE_INFINITY;
    private Date _effectiveDate;
    private Date _expirationDate;
    private JDomLookupTypeImpl _contractType;
    private JDomWaterSupplyPump _pumpOutBelow;
    private JDomWaterSupplyPump _pumpOut;
    private JDomWaterSupplyPump _pumpIn;

    public JDomWaterUserContractImpl() {
        this._contractRef = new JDomWaterUserContractRef();
        this.setName(this._contractRef.getName());
    }

    public JDomWaterUserContractImpl(Element element) {
        this._contractRef = new JDomWaterUserContractRef(element);
        this.setName(this._contractRef.getName());
        if (element != null) {
            ParamDouble paramDouble = new ParamDouble();
            this._contractedStorage = JDomWaterUserContractImpl.getXmlValue(paramDouble, element, "contracted_storage", Parameter.PARAMID_STOR);
            this._futureUseAllocation = JDomWaterUserContractImpl.getXmlValue(paramDouble, element, "future_use_allocation", Parameter.PARAMID_STOR);
            this._futureUsePercentActivated = JDomWaterUserContractImpl.getXmlValue(paramDouble, element, "future_use_percent_activated", Parameter.PARAMID_PERCENT);
            this._initialUseAllocation = JDomWaterUserContractImpl.getXmlValue(paramDouble, element, "initial_use_allocation", Parameter.PARAMID_STOR);
            this._totalAllocPercentActivated = JDomWaterUserContractImpl.getXmlValue(paramDouble, element, "total_alloc_percent_activated", Parameter.PARAMID_PERCENT);
            LocationTemplate parentLocationRef = null;
            JDomWaterUserImpl waterUser = this._contractRef.getWaterUser();
            if (waterUser != null) {
                parentLocationRef = waterUser.getParentLocationRef();
            }
            Location pumpOutBelowLocation = Location.parseElement(element.getChild("pump_out_below_location"));
            Location pumpOutLocation = Location.parseElement(element.getChild("pump_out_location"));
            Location pumpInLocation = Location.parseElement(element.getChild("pump_in_location"));
            if (pumpOutBelowLocation != null) {
                this._pumpOutBelow = new JDomWaterSupplyPump(parentLocationRef, pumpOutBelowLocation, PumpType.PumpOutBelow);
            }
            if (pumpOutLocation != null) {
                this._pumpOut = new JDomWaterSupplyPump(parentLocationRef, pumpOutLocation, PumpType.PumpOut);
            }
            if (pumpInLocation != null) {
                this._pumpIn = new JDomWaterSupplyPump(parentLocationRef, pumpInLocation, PumpType.PumpIn);
            }
            this._effectiveDate = JDomWaterUserContractImpl.getXmlDate(element, "ws_contract_effective_date", "ddMMMyyyy");
            this._expirationDate = JDomWaterUserContractImpl.getXmlDate(element, "ws_contract_expiration_date", "ddMMMyyyy");
            this._contractType = new JDomLookupTypeImpl(element.getChild("ws_contract_type"));
        }
    }

    public JDomWaterUserContractImpl(IWaterUserContract wuc) {
        this(JDomDataObjectFactory.getRootElement(wuc.toXmlString()));
    }

    @Override
    public void buildElement(Element element) {
        if (element != null) {
            Element child;
            if (this._contractRef != null) {
                this._contractRef.buildElement(element);
            }
            ParamDouble paramDouble = new ParamDouble();
            JDomWaterUserContractImpl.setXmlValue(paramDouble, element, "contracted_storage", this.getContractedStorage(), Parameter.PARAMID_STOR);
            JDomWaterUserContractImpl.setXmlValue(paramDouble, element, "future_use_allocation", this.getFutureUseAllocation(), Parameter.PARAMID_STOR);
            JDomWaterUserContractImpl.setXmlValue(paramDouble, element, "future_use_percent_activated", this.getFutureUsePercentActivated(), Parameter.PARAMID_PERCENT);
            JDomWaterUserContractImpl.setXmlValue(paramDouble, element, "initial_use_allocation", this.getInitialUseAllocation(), Parameter.PARAMID_STOR);
            JDomWaterUserContractImpl.setXmlValue(paramDouble, element, "total_alloc_percent_activated", this.getTotalAllocPercentActivated(), Parameter.PARAMID_PERCENT);
            if (this.getPumpOutBelowLocation() != null) {
                child = XMLUtilities.getOrCreateChild(element, "pump_out_below_location");
                this.getPumpOutBelowLocation().buildElement(child);
            }
            if (this.getPumpOutLocation() != null) {
                child = XMLUtilities.getOrCreateChild(element, "pump_out_location");
                this.getPumpOutLocation().buildElement(child);
            }
            if (this.getPumpInLocation() != null) {
                child = XMLUtilities.getOrCreateChild(element, "pump_in_location");
                this.getPumpInLocation().buildElement(child);
            }
            JDomWaterUserContractImpl.setXmlDate(element, "ws_contract_effective_date", "ddMMMyyyy", this.getEffectiveDate());
            JDomWaterUserContractImpl.setXmlDate(element, "ws_contract_expiration_date", "ddMMMyyyy", this.getExpirationDate());
            if (this._contractType != null) {
                this._contractType.buildElement(XMLUtilities.getOrCreateChild(element, "ws_contract_type"));
            }
        }
    }

    @Override
    @EntityBeanMap(attributeName="ContractedStorage")
    public double getContractedStorage() {
        return this._contractedStorage;
    }

    @Override
    public void setContractedStorage(double contractedStorage) {
        this._contractedStorage = contractedStorage;
    }

    @Override
    @EntityBeanMap(attributeName="FutureUseAllocation")
    public double getFutureUseAllocation() {
        return this._futureUseAllocation;
    }

    @Override
    public void setFutureUseAllocation(double futureUseAllocation) {
        this._futureUseAllocation = futureUseAllocation;
    }

    @Override
    @EntityBeanMap(attributeName="FutureUsePercentActivated")
    public double getFutureUsePercentActivated() {
        return this._futureUsePercentActivated;
    }

    @Override
    public void setFutureUsePercentActivated(double futureUsePercentActivated) {
        this._futureUsePercentActivated = futureUsePercentActivated;
    }

    @Override
    @EntityBeanMap(attributeName="InitialUseAllocation")
    public double getInitialUseAllocation() {
        return this._initialUseAllocation;
    }

    @Override
    public void setInitialUseAllocation(double initialUseAllocation) {
        this._initialUseAllocation = initialUseAllocation;
    }

    @Override
    @EntityBeanMap(attributeName="TotalAllocPercentActivated")
    public double getTotalAllocPercentActivated() {
        return this._totalAllocPercentActivated;
    }

    @Override
    public void setTotalAllocPercentActivated(double totalAllocPercentActivated) {
        this._totalAllocPercentActivated = totalAllocPercentActivated;
    }

    @Override
    public Date getEffectiveDate() {
        return this._effectiveDate;
    }

    @Override
    public void setEffectiveDate(Date wsContractEffectiveDate) {
        this._effectiveDate = wsContractEffectiveDate;
    }

    @EntityBeanMap(attributeName="WsContractEffectiveDate")
    public Timestamp getEffectiveDateObject() {
        Timestamp timestamp = null;
        if (this._effectiveDate != null) {
            timestamp = new Timestamp(this.getEffectiveDate().getTime());
        }
        return timestamp;
    }

    public void setEffectiveDateObject(Timestamp wsContractEffectiveDate) {
        this._effectiveDate = wsContractEffectiveDate;
    }

    @Override
    public Date getExpirationDate() {
        return this._expirationDate;
    }

    @Override
    public void setExpirationDate(Date wsContractExpirationDate) {
        this._expirationDate = wsContractExpirationDate;
    }

    @EntityBeanMap(attributeName="WsContractExpirationDate")
    public Timestamp getExpirationDateObject() {
        Timestamp timestamp = null;
        if (this._expirationDate != null) {
            timestamp = new Timestamp(this.getExpirationDate().getTime());
        }
        return timestamp;
    }

    public void setExpirationDateObject(Timestamp wsContractExpirationDate) {
        this._expirationDate = wsContractExpirationDate;
    }

    @Override
    public IWaterUserContractRef getWaterUserContractRef() {
        return this.getJDomWaterUserContractRef();
    }

    @Override
    public void setWaterUserContractRef(IWaterUserContractRef waterUserContractRef) {
        if (waterUserContractRef instanceof JDomWaterUserContractRef) {
            this.setJDomWaterUserContractRef((JDomWaterUserContractRef)waterUserContractRef);
        } else {
            JDomWaterUserContractRef jdom = new JDomWaterUserContractRef(waterUserContractRef);
            this.setJDomWaterUserContractRef(jdom);
        }
    }

    @EntityBean(attributeName="WaterUserContractRef")
    public JDomWaterUserContractRef getJDomWaterUserContractRef() {
        return this._contractRef;
    }

    public void setJDomWaterUserContractRef(JDomWaterUserContractRef waterUserContractRef) {
        this._contractRef = waterUserContractRef;
        if (this._contractRef != null) {
            this.setName(this._contractRef.getName());
            LocationTemplate parentLocationRef = this.getParentLocationRef();
            if (parentLocationRef != null) {
                if (this._pumpIn != null) {
                    this._pumpIn.setParentLocationRef(parentLocationRef);
                }
                if (this._pumpOut != null) {
                    this._pumpOut.setParentLocationRef(parentLocationRef);
                }
                if (this._pumpOutBelow != null) {
                    this._pumpOutBelow.setParentLocationRef(parentLocationRef);
                }
            }
        }
    }

    @Override
    public ILookupType getContractType() {
        return this.getJDomContractType();
    }

    @Override
    public void setContractType(ILookupType wsContractType) {
        if (wsContractType instanceof JDomLookupTypeImpl) {
            this.setJDomContractType((JDomLookupTypeImpl)wsContractType);
        } else {
            this.setJDomContractType(new JDomLookupTypeImpl(wsContractType));
        }
    }

    @EntityBean(attributeName="WaterSupplyContractType")
    public JDomLookupTypeImpl getJDomContractType() {
        return this._contractType;
    }

    public void setJDomContractType(JDomLookupTypeImpl wsContractType) {
        this._contractType = wsContractType;
    }

    @Override
    public void setContractName(String contractName) {
        if (this._contractRef == null && (contractName == null || contractName.isEmpty())) {
            return;
        }
        if (this._contractRef == null) {
            this._contractRef = new JDomWaterUserContractRef(contractName, null);
        } else {
            this._contractRef.setContractName(contractName);
        }
        this.setName(this._contractRef.getName());
    }

    @Override
    public String getContractName() {
        if (this._contractRef == null) {
            return null;
        }
        return this._contractRef.getContractName();
    }

    @Override
    public void setWaterUser(IWaterUser contractWaterUser) {
        if (this._contractRef == null && contractWaterUser == null) {
            return;
        }
        JDomWaterUserImpl waterUserImpl = null;
        if (contractWaterUser instanceof JDomWaterUserImpl) {
            waterUserImpl = (JDomWaterUserImpl)contractWaterUser;
        } else if (contractWaterUser != null) {
            waterUserImpl = new JDomWaterUserImpl(contractWaterUser);
        }
        if (this._contractRef == null) {
            this._contractRef = new JDomWaterUserContractRef(null, waterUserImpl);
        } else {
            this._contractRef.setWaterUser(contractWaterUser);
        }
    }

    @Override
    public IWaterUser getWaterUser() {
        return this._contractRef.getWaterUser();
    }

    @Override
    public void getContractedStorage(ParamDouble paramDouble) {
        paramDouble.setParameterId(Parameter.PARAMID_STOR);
        paramDouble.setUnitSystem(2);
        paramDouble.setValue(this._contractedStorage);
    }

    @Override
    public void setContractedStorage(ParamDouble paramDouble) {
        this._contractedStorage = paramDouble.convertToUnitSystem(2);
    }

    @Override
    public void getFutureUseAllocation(ParamDouble paramDouble) {
        paramDouble.setParameterId(Parameter.PARAMID_STOR);
        paramDouble.setUnitSystem(2);
        paramDouble.setValue(this._futureUseAllocation);
    }

    @Override
    public void setFutureUseAllocation(ParamDouble paramDouble) {
        this._futureUseAllocation = paramDouble.convertToUnitSystem(2);
    }

    @Override
    public void getFutureUsePercentActivated(ParamDouble paramDouble) {
        paramDouble.setParameterId(Parameter.PARAMID_PERCENT);
        paramDouble.setUnitSystem(2);
        paramDouble.setValue(this._futureUsePercentActivated);
    }

    @Override
    public void setFutureUsePercentActivated(ParamDouble paramDouble) {
        this._futureUsePercentActivated = paramDouble.convertToUnitSystem(2);
    }

    @Override
    public void getInitialUseAllocation(ParamDouble paramDouble) {
        paramDouble.setParameterId(Parameter.PARAMID_STOR);
        paramDouble.setUnitSystem(2);
        paramDouble.setValue(this._initialUseAllocation);
    }

    @Override
    public void setInitialUseAllocation(ParamDouble paramDouble) {
        this._initialUseAllocation = paramDouble.convertToUnitSystem(2);
    }

    @Override
    public void getTotalAllocPercentActivated(ParamDouble paramDouble) {
        paramDouble.setParameterId(Parameter.PARAMID_PERCENT);
        paramDouble.setUnitSystem(2);
        paramDouble.setValue(this._totalAllocPercentActivated);
    }

    @Override
    public void setTotalAllocPercentActivated(ParamDouble paramDouble) {
        this._totalAllocPercentActivated = paramDouble.convertToUnitSystem(2);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        IWaterUser waterUser = this.getWaterUser();
        String contractName = this.getContractName();
        result = 31 * result + (waterUser == null ? 0 : waterUser.hashCode());
        result = 31 * result + (contractName == null ? 0 : contractName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (obj instanceof JDomWaterUserContractImpl) {
            JDomWaterUserContractImpl obj2 = (JDomWaterUserContractImpl)obj;
            IWaterUser waterUser = this.getWaterUser();
            String contractName = this.getContractName();
            return waterUser.equals(obj2.getWaterUser()) && contractName.equals(obj2.getContractName());
        }
        return false;
    }

    @EntityBean(attributeName="PumpOutBelowLocation")
    public Location getPumpOutBelowLocation() {
        if (this._pumpOutBelow == null) {
            return null;
        }
        return this._pumpOutBelow.getLocation();
    }

    public void setPumpOutBelowLocation(Location location) {
        if (this._pumpOutBelow == null) {
            this._pumpOutBelow = new JDomWaterSupplyPump(this.getParentLocationRef(), location, PumpType.PumpOutBelow);
        } else {
            this._pumpOutBelow.setLocation(location);
        }
    }

    @EntityBean(attributeName="PumpOutLocation")
    public Location getPumpOutLocation() {
        if (this._pumpOut == null) {
            return null;
        }
        return this._pumpOut.getLocation();
    }

    public void setPumpOutLocation(Location location) {
        if (this._pumpOut == null) {
            this._pumpOut = new JDomWaterSupplyPump(this.getParentLocationRef(), location, PumpType.PumpOut);
        } else {
            this._pumpOut.setLocation(location);
        }
    }

    @EntityBean(attributeName="PumpInLocation")
    public Location getPumpInLocation() {
        if (this._pumpIn == null) {
            return null;
        }
        return this._pumpIn.getLocation();
    }

    public void setPumpInLocation(Location location) {
        if (this._pumpIn == null) {
            this._pumpIn = new JDomWaterSupplyPump(this.getParentLocationRef(), location, PumpType.PumpIn);
        } else {
            this._pumpIn.setLocation(location);
        }
    }

    @Override
    public void setPumpOut(IWaterSupplyPump waterSupplyPump) {
        if (waterSupplyPump == null) {
            this._pumpOut = null;
        } else if (waterSupplyPump instanceof JDomWaterSupplyPump) {
            this._pumpOut = (JDomWaterSupplyPump)waterSupplyPump;
            this._pumpOut.setPumpType(PumpType.PumpOut);
        } else {
            this._pumpOut = new JDomWaterSupplyPump(waterSupplyPump, PumpType.PumpOut);
        }
    }

    @Override
    public IWaterSupplyPump getPumpOut() {
        return this._pumpOut;
    }

    @Override
    public IWaterSupplyPump getPumpIn() {
        return this._pumpIn;
    }

    @Override
    public void setPumpIn(IWaterSupplyPump waterSupplyPump) {
        if (waterSupplyPump == null) {
            this._pumpIn = null;
        } else if (waterSupplyPump instanceof JDomWaterSupplyPump) {
            this._pumpIn = (JDomWaterSupplyPump)waterSupplyPump;
            this._pumpIn.setPumpType(PumpType.PumpIn);
        } else {
            this._pumpIn = new JDomWaterSupplyPump(waterSupplyPump, PumpType.PumpIn);
        }
    }

    @Override
    public void setPumpOutBelow(IWaterSupplyPump waterSupplyPump) {
        if (waterSupplyPump == null) {
            this._pumpOutBelow = null;
        } else if (waterSupplyPump instanceof JDomWaterSupplyPump) {
            this._pumpOutBelow = (JDomWaterSupplyPump)waterSupplyPump;
            this._pumpOutBelow.setPumpType(PumpType.PumpOutBelow);
        } else {
            this._pumpOutBelow = new JDomWaterSupplyPump(waterSupplyPump, PumpType.PumpOutBelow);
        }
    }

    @Override
    public IWaterSupplyPump getPumpOutBelow() {
        return this._pumpOutBelow;
    }

    private LocationTemplate getParentLocationRef() {
        if (this._contractRef == null) {
            return null;
        }
        JDomWaterUserImpl waterUser = this._contractRef.getWaterUser();
        if (waterUser == null) {
            return null;
        }
        return waterUser.getParentLocationRef();
    }

    @Override
    public List<IWaterSupplyPump> getPumpList() {
        ArrayList<IWaterSupplyPump> retval = new ArrayList<IWaterSupplyPump>();
        if (this.getPumpIn() != null) {
            retval.add(this.getPumpIn());
        }
        if (this.getPumpOut() != null) {
            retval.add(this.getPumpOut());
        }
        if (this.getPumpOutBelow() != null) {
            retval.add(this.getPumpOutBelow());
        }
        return retval;
    }

    @Override
    public void setPump(IWaterSupplyPump pump, PumpType pumpType) {
        switch (pumpType) {
            case PumpIn: {
                this.setPumpIn(pump);
                break;
            }
            case PumpOut: {
                this.setPumpOut(pump);
                break;
            }
            case PumpOutBelow: {
                this.setPumpOutBelow(pump);
            }
        }
    }

    @Override
    public IWaterSupplyPump getPump(PumpType pumpType) {
        switch (pumpType) {
            case PumpIn: {
                return this.getPumpIn();
            }
            case PumpOut: {
                return this.getPumpOut();
            }
            case PumpOutBelow: {
                return this.getPumpOutBelow();
            }
        }
        return null;
    }
}

