/*
 * Decompiled with CFR 0.152.
 */
package hec.data.watersupply;

import hec.data.AbstractJDomDataObject;
import hec.data.JDomDataObjectFactory;
import hec.data.watersupply.IWaterUser;
import hec.data.watersupply.IWaterUserContractRef;
import hec.data.watersupply.JDomWaterUserImpl;
import hec.lang.annotation.EntityBean;
import hec.lang.annotation.EntityBeanMap;
import hec.lang.annotation.EntityBeanType;
import hec.util.XMLUtilities;
import java.util.logging.Logger;
import org.jdom.Element;

@EntityBeanType(beanType="usace.rowcps.db.oracle.WaterUserContractRefTUser")
public class JDomWaterUserContractRef
extends AbstractJDomDataObject
implements IWaterUserContractRef {
    private static final Logger logger = Logger.getLogger(JDomWaterUserContractRef.class.getName());
    private String _contractName;
    private JDomWaterUserImpl _waterUser;

    public JDomWaterUserContractRef() {
    }

    public JDomWaterUserContractRef(String contractName, JDomWaterUserImpl waterUser) {
        this._contractName = contractName;
        this.setName(contractName);
        this._waterUser = waterUser;
    }

    public JDomWaterUserContractRef(Element element) {
        if (element != null) {
            this._contractName = element.getChildText("contract_name");
            this.setName(this._contractName);
            this._waterUser = new JDomWaterUserImpl(element.getChild("contract_water_user"));
        }
    }

    public JDomWaterUserContractRef(IWaterUserContractRef ref) {
        this(JDomDataObjectFactory.getRootElement(ref.toXmlString()));
    }

    @Override
    public void buildElement(Element element) {
        if (element != null) {
            XMLUtilities.getOrCreateChild(element, "contract_name").setText(this.getContractName());
            JDomWaterUserImpl waterUser = this.getWaterUser();
            if (waterUser != null) {
                waterUser.buildElement(XMLUtilities.getOrCreateChild(element, "contract_water_user"));
            }
        }
    }

    @Override
    @EntityBeanMap(attributeName="ContractName")
    public String getContractName() {
        return this._contractName;
    }

    @Override
    public void setContractName(String contractName) {
        this._contractName = contractName;
        this.setName(contractName);
    }

    @Override
    @EntityBean(attributeName="WaterUser")
    public JDomWaterUserImpl getWaterUser() {
        return this._waterUser;
    }

    public void setWaterUser(JDomWaterUserImpl waterUser) {
        this._waterUser = waterUser;
    }

    @Override
    public void setWaterUser(IWaterUser waterUser) {
        this._waterUser = waterUser instanceof JDomWaterUserImpl ? (JDomWaterUserImpl)waterUser : new JDomWaterUserImpl(waterUser);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this._contractName == null ? 0 : this._contractName.hashCode());
        result = 31 * result + (this._waterUser == null ? 0 : this._waterUser.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        JDomWaterUserContractRef other = (JDomWaterUserContractRef)obj;
        if (this._contractName == null ? other._contractName != null : !this._contractName.equals(other._contractName)) {
            return false;
        }
        return !(this._waterUser == null ? other._waterUser != null : !this._waterUser.equals(other._waterUser));
    }
}

