/*
 * Decompiled with CFR 0.152.
 */
package hec.data.watersupply;

import hec.data.AbstractJDomDataObject;
import hec.data.JDomDataObjectFactory;
import hec.data.location.LocationTemplate;
import hec.data.watersupply.IWaterUser;
import hec.lang.annotation.EntityBean;
import hec.lang.annotation.EntityBeanMap;
import hec.lang.annotation.EntityBeanType;
import hec.util.XMLUtilities;
import org.jdom.Element;

@EntityBeanType(beanType="usace.rowcps.db.oracle.WaterUserObjTUser")
public class JDomWaterUserImpl
extends AbstractJDomDataObject
implements IWaterUser {
    private String _entityName = null;
    private String _waterRight = null;
    private LocationTemplate _waterUserProjectLoc = null;

    public JDomWaterUserImpl() {
    }

    public JDomWaterUserImpl(String entityName, String waterRight, LocationTemplate waterUserProjectLoc) {
        this._entityName = entityName;
        this.setName(this._entityName);
        this._waterRight = waterRight;
        this.setDescription(this._waterRight);
        this._waterUserProjectLoc = waterUserProjectLoc;
    }

    @Override
    @EntityBeanMap(attributeName="EntityName")
    public String getEntityName() {
        return this._entityName;
    }

    @Override
    public void setEntityName(String entityName) {
        this._entityName = entityName;
        this.setName(this._entityName);
    }

    @Override
    @EntityBeanMap(attributeName="WaterRight")
    public String getWaterRight() {
        return this._waterRight;
    }

    @Override
    public void setWaterRight(String waterRight) {
        this._waterRight = waterRight;
        this.setDescription(this._waterRight);
    }

    @Override
    @EntityBean(attributeName="ProjectLocationRef")
    public LocationTemplate getParentLocationRef() {
        return this._waterUserProjectLoc;
    }

    @Override
    public void setParentLocationRef(LocationTemplate waterUserProjectLoc) {
        this._waterUserProjectLoc = waterUserProjectLoc;
    }

    public JDomWaterUserImpl(Element element) {
        if (element != null) {
            LocationTemplate waterUserProjectLoc;
            String waterRight;
            String entityName;
            this._entityName = entityName = element.getChildText("entity_name");
            this.setName(this._entityName);
            this._waterRight = waterRight = element.getChildText("water_right");
            this.setDescription(this._waterRight);
            this._waterUserProjectLoc = waterUserProjectLoc = LocationTemplate.parse(element.getChild("water_user_project_location"));
        }
    }

    public JDomWaterUserImpl(IWaterUser contractWaterUser) {
        this(JDomDataObjectFactory.getRootElement(contractWaterUser.toXmlString()));
    }

    @Override
    public void buildElement(Element element) {
        XMLUtilities.getOrCreateChild(element, "entity_name").setText(this.getEntityName());
        XMLUtilities.getOrCreateChild(element, "water_right").setText(this.getWaterRight());
        Element waterUserProjLoc = XMLUtilities.getOrCreateChild(element, "water_user_project_location");
        if (this.getParentLocationRef() != null) {
            this.getParentLocationRef().buildElement(waterUserProjLoc);
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        LocationTemplate waterUserProjectLoc = this.getParentLocationRef();
        String entityName = this.getEntityName();
        result = 31 * result + (waterUserProjectLoc == null ? 0 : waterUserProjectLoc.hashCode());
        result = 31 * result + (entityName == null ? 0 : entityName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        JDomWaterUserImpl other = (JDomWaterUserImpl)obj;
        if (this._waterUserProjectLoc == null ? other._waterUserProjectLoc != null : !this._waterUserProjectLoc.equals((Object)other._waterUserProjectLoc)) {
            return false;
        }
        return !(this._entityName == null ? other._entityName != null : !this._entityName.equals(other._entityName));
    }
}

