/*
 * Decompiled with CFR 0.152.
 */
package hec.dataTable;

import hec.dataTable.PairedDataCurve;
import hec.dataTable.PairedDataModel;
import hec.heclib.util.HecDouble;
import hec.heclib.util.HecDoubleArray;
import hec.io.ArrayContainer;
import hec.io.PairedDataContainer;
import java.util.List;
import java.util.Vector;
import javax.swing.JOptionPane;

public class ArrayModel
extends PairedDataModel {
    private static final long serialVersionUID = 1L;

    public ArrayModel() {
        this.setNumberHeaderRows(0);
    }

    @Override
    public int setData(List dataSets, boolean showCommas) {
        this._showCommas = showCommas;
        this._dataColumns = new Vector();
        this._xArray = new HecDoubleArray();
        this._pairedModels = new Vector();
        this._pairedModelColumns = new Vector();
        boolean haveData = false;
        for (int i = 0; i < dataSets.size(); ++i) {
            if (!(dataSets.get(i) instanceof ArrayContainer)) continue;
            ArrayContainer arrayContainer = (ArrayContainer)dataSets.get(i);
            PairedDataContainer pairedDataContainer = arrayContainer.getPairedDataContainer();
            PairedDataCurve pairedDataCurve = new PairedDataCurve(pairedDataContainer);
            this._pairedModels.addElement(pairedDataCurve);
            for (int j = 0; j < pairedDataCurve.getColumnCount(); ++j) {
                this._dataColumns.add(j);
                this._pairedModelColumns.add(pairedDataCurve);
            }
            if (pairedDataCurve.getNumberValues() <= 0) continue;
            haveData = true;
        }
        this.orderData();
        if (haveData) {
            return 0;
        }
        return -1;
    }

    @Override
    public int getColumnCount() {
        return this._map.length + 1;
    }

    @Override
    public int getDataColumnCount() {
        return this._map.length;
    }

    @Override
    public int getRowCount() {
        return this._xArray.numberElements();
    }

    @Override
    public String getColumnName(int col) {
        if (col == 0) {
            return "Position";
        }
        return "Value";
    }

    @Override
    public String getNominalName() {
        return this.inColumn(0).getNominalName();
    }

    @Override
    public Object getValueAt(int row, int column) {
        if (column < 0 || column >= this.getColumnCount()) {
            return null;
        }
        if (row < 0 || row >= this.getRowCount()) {
            return null;
        }
        if (column == 0) {
            return row + 1;
        }
        return this.getModelValue(row, column);
    }

    @Override
    public Object getModelValue(int row, int column) {
        PairedDataCurve curve = (PairedDataCurve)this._pairedModelColumns.elementAt(--column);
        int col = this.columnCurveNumber(column);
        int r = this.unMap(row, column);
        if (r == -1) {
            return new HecDouble();
        }
        return curve.getHecDouble(r, col);
    }

    @Override
    public int setModelValue(Object value, int row, int column) {
        Object obj;
        PairedDataCurve curve = (PairedDataCurve)this._pairedModelColumns.elementAt(--column);
        int col = this.columnCurveNumber(column);
        int r = this.unMap(row, column);
        if (r == -1) {
            if (value.toString().trim().length() == 0) {
                return 0;
            }
            int curveRow = this.unMapToNextValidRow(row, column);
            if (curveRow != -1) {
                curve.insertRowsBefore(curveRow, 1);
                curve.setXValue(this._xArray.element(row), curveRow);
            }
            for (int i = 0; i < this._pairedModelColumns.size(); ++i) {
                PairedDataCurve pdc = (PairedDataCurve)this._pairedModelColumns.elementAt(i);
                if (pdc != curve) continue;
                this.map(i, row, -1);
                this.reMap(i);
            }
            r = this.unMap(row, column);
            if (r == -1) {
                return -1;
            }
        }
        if (!((obj = this.inColumn(column).getHecDouble(r, col)) instanceof HecDouble)) {
            return -1;
        }
        HecDouble number = (HecDouble)obj;
        int status = 0;
        if (value instanceof HecDouble) {
            number.set((HecDouble)value);
        } else {
            status = number.set(value.toString());
        }
        if (status != 0 && value.toString().length() > 0) {
            String message = "Invalid number: " + value.toString() + ";  ordinate = " + row;
            System.out.println(message);
            JOptionPane.showMessageDialog(null, message, "", 2);
            return -1;
        }
        curve.setValue(number, r, col);
        return 0;
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return this._isEditable && column != 0 && (column != 1 || row != 0);
    }

    @Override
    public int setValue(Object value, int row, int column) {
        if (column < 1 || column >= this.getColumnCount()) {
            return -1;
        }
        if (row < 0 || row >= this.getRowCount()) {
            return -1;
        }
        return this.setModelValue(value, row, column);
    }
}

