/*
 * Decompiled with CFR 0.152.
 */
package hec.dataTable;

import hec.dataTable.HecDataTable;
import hec.dataTable.PlotProvider;
import hec.gfx2d.G2dDialog;
import hec.heclib.util.HecDouble;
import hec.heclib.util.HecTime;
import hec.heclib.util.intArrayContainer;
import java.awt.Dimension;
import java.awt.Frame;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;

abstract class DataModel
extends AbstractTableModel {
    protected boolean _isEditable = false;
    protected boolean _isExtendable = false;
    protected boolean _hasBeenExtended = false;
    protected boolean _showCommas = false;
    protected boolean _pasteMode = false;
    protected boolean _showTimes = true;
    protected boolean _showTimeAsBeginning = false;
    protected boolean _showFullDefinition = false;
    protected StringBuffer _firstPasteError = null;
    protected Vector _dataColumns;
    protected intArrayContainer[] _map;
    protected final int NULL_MAP_VAL = -1;
    protected final int UNDEFINED_MAP_VAL = -2;
    protected DefaultTableCellRenderer _headerRenderer = new DefaultTableCellRenderer();
    protected DefaultTableCellRenderer _integerRenderer = null;
    protected DefaultTableCellRenderer _doubleRenderer = null;
    private int _numberHeaderRows = 3;
    protected int _numberBlankRows = 0;
    private PlotProvider _plotProvider = null;

    public DataModel() {
        this._headerRenderer.setHorizontalAlignment(0);
        this._integerRenderer = new DefaultTableCellRenderer();
        this._integerRenderer.setHorizontalAlignment(4);
        this._doubleRenderer = new DefaultTableCellRenderer();
        this._doubleRenderer.setHorizontalAlignment(4);
    }

    public void setPlotProvider(PlotProvider plotProvider) {
        this._plotProvider = plotProvider;
    }

    protected void increaseMap(int column, int rows) {
        int nrows = 0;
        for (int i = 0; i < this._map[column].length; ++i) {
            if (this._map[column].array[i] != -2) continue;
            this._map[column].array[i] = -1;
            if (++nrows > rows) break;
        }
        if (rows > nrows) {
            int start = this._map[column].length;
            int additional = rows - nrows;
            int newLen = start + additional + 20;
            this._map[column].resize(newLen);
            int n = 0;
            for (int i = start; i < newLen; ++i) {
                if (n < additional) {
                    this._map[column].array[i] = -1;
                    ++n;
                    continue;
                }
                this._map[column].array[i] = -2;
            }
        }
    }

    protected void map(int column, int masterRow, int columnRow) {
        if (masterRow < this._map[column].size()) {
            this._map[column].array[masterRow] = columnRow;
        }
    }

    protected int unMap(int row, int column) {
        if (column < 0 || column >= this._map.length) {
            return -1;
        }
        if (row < 0 || row >= this._map[column].size()) {
            return -1;
        }
        return this._map[column].array[row];
    }

    protected int unMapToNextValidRow(int row, int column) {
        if (column < 0 || column >= this._map.length) {
            return -1;
        }
        if (row < 0 || row >= this._map[column].size()) {
            return -1;
        }
        for (int i = row; i < this._map[column].array.length; ++i) {
            int val = this.unMap(row, column);
            if (val <= -1) continue;
            return val;
        }
        return -1;
    }

    public void setEditable(boolean isEditable) {
        this._isEditable = isEditable;
    }

    public void setExtendable(boolean extendable, int numberBlankRows) {
        this._isExtendable = extendable;
        this._numberBlankRows = numberBlankRows;
    }

    public void setPasteMode(boolean pasteMode) {
        this._pasteMode = pasteMode;
        if (this._pasteMode) {
            this._firstPasteError = new StringBuffer();
        } else {
            if (this._firstPasteError != null && this._firstPasteError.length() > 2) {
                JOptionPane.showMessageDialog(null, "First Error: " + this._firstPasteError, "Error during paste operation", 2);
            }
            this._firstPasteError = null;
        }
    }

    public boolean getPasteMode() {
        return this._pasteMode;
    }

    public void initializeEntryStartTime() {
    }

    public Object getSortValueAt(int row, int column) {
        return this.getValueAt(row, column);
    }

    public void appendRows(int numberRows) {
    }

    public boolean hasDataChanged() {
        return false;
    }

    public void setDataChanged(boolean dataChanged) {
    }

    public void saveAs(Object parent) {
    }

    public void setCommas(boolean showCommas) {
        this._showCommas = showCommas;
    }

    public boolean getCommas() {
        return this._showCommas;
    }

    public void setShowTimes(boolean showTimes) {
        this._showTimes = showTimes;
    }

    public boolean getShowTimes() {
        return this._showTimes;
    }

    public void showTimeAsBeginningOfDay(boolean showTimeAsBeginning) {
        this._showTimeAsBeginning = showTimeAsBeginning;
    }

    public boolean getshowTimeAsBeginningOfDay() {
        return this._showTimeAsBeginning;
    }

    public void setShowFullDefinition(boolean showFullDefinition) {
        this._showFullDefinition = showFullDefinition;
    }

    public boolean getShowFullDefinition() {
        return this._showFullDefinition;
    }

    public void setNumberHeaderRows(int number) {
        this._numberHeaderRows = number;
    }

    public int getNumberHeaderRows() {
        return this._numberHeaderRows;
    }

    public void save(Object parent) {
    }

    public void plot(JFrame parent) {
        Vector dataContainers = this.getDataSets();
        if (dataContainers.size() == 0) {
            return;
        }
        G2dDialog gfxdlg = null;
        gfxdlg = this._plotProvider != null ? this._plotProvider.getPlotDialog(parent, "", false, dataContainers) : new G2dDialog((Frame)parent, "", false, dataContainers);
        gfxdlg.setVisible(true);
    }

    public Vector getDataSets() {
        return new Vector();
    }

    public void setDecimalPosition(int position) {
    }

    public void setDecimalPosition(int column, int position) {
    }

    public int getDecimalPosition() {
        return -1;
    }

    public int getDecimalPosition(int column) {
        return -1;
    }

    public String getNominalName() {
        return "";
    }

    public String getName() {
        return "";
    }

    public int getDataColumnCount() {
        return this.getColumnCount();
    }

    public void deleteColumn(int col) {
    }

    public boolean canDeleteColumn(int col) {
        return false;
    }

    public boolean canInsertColumn(int col, boolean append) {
        return false;
    }

    public void addColumn(int col, boolean append) {
    }

    public int updateContainers(int[] firstError) {
        return 0;
    }

    public Vector getDataContainers() {
        return new Vector();
    }

    public boolean search(String findStr, int startingRow, int startingColumn, int firstColumn, boolean wholeWordOnly, boolean down, Dimension rowCol) {
        int nrows = this.getRowCount();
        int ncols = this.getColumnCount();
        boolean hasComma = findStr.indexOf(",") > 0;
        if (down) {
            for (int i = startingRow; i < nrows; ++i) {
                for (int j = firstColumn; j < ncols; ++j) {
                    if (i == startingRow && j < startingColumn) continue;
                    Object obj = this.getValueAt(i, j);
                    String cell = !hasComma && obj instanceof HecDouble ? ((HecDouble)obj).string(false) : obj.toString();
                    if (cell.indexOf(findStr) < 0 || wholeWordOnly && !cell.equals(findStr)) continue;
                    rowCol.width = j;
                    rowCol.height = i;
                    return true;
                }
            }
        } else {
            for (int i = startingRow; i >= 0; --i) {
                for (int j = ncols - 1; j >= firstColumn; --j) {
                    String cell;
                    if (i == startingRow && j > startingColumn || (cell = (String)this.getValueAt(i, j)) == null || cell.indexOf(findStr) < 0 || wholeWordOnly && !cell.equals(findStr)) continue;
                    rowCol.width = j;
                    rowCol.height = i;
                    return true;
                }
            }
        }
        return false;
    }

    public int setValue(Object value, int row, int column) {
        return 0;
    }

    @Override
    public void setValueAt(Object value, int row, int column) {
        String gvalue;
        String svalue = value.toString().trim();
        if (svalue == null) {
            return;
        }
        Object obj = this.getValueAt(row, column);
        if (obj != null && svalue.equals(gvalue = obj.toString().trim())) {
            return;
        }
        this.setValue(value, row, column);
    }

    public boolean isPasteString(String pstring, int column) {
        if (pstring.length() > 50) {
            return true;
        }
        if (pstring.length() < 5) {
            return false;
        }
        byte[] bvalues = pstring.getBytes();
        boolean lpaste = false;
        int nperiod = 0;
        int nblanks = 0;
        for (int i = 0; i < bvalues.length; ++i) {
            if (bvalues[i] == 9) {
                lpaste = true;
                break;
            }
            if (bvalues[i] == 10) {
                lpaste = true;
                break;
            }
            if (bvalues[i] == 32 && i > 0 && bvalues[i - 1] != 32) {
                ++nblanks;
            }
            if (bvalues[i] != 46 || ++nperiod < 2 || pstring.indexOf(",") <= 0) continue;
            lpaste = true;
            break;
        }
        if (lpaste) {
            return true;
        }
        if (nblanks > 0) {
            HecTime hecTime;
            lpaste = nblanks == 1 && bvalues.length < 11 ? !this.isQualityColumn(column) : true;
            if (lpaste && column < 2 && nblanks < 4 && (hecTime = new HecTime(pstring)).isDefined()) {
                lpaste = false;
            }
        }
        return lpaste;
    }

    protected boolean isQualityColumn(int column) {
        return false;
    }

    protected int[] getNextEditableCell(int row, int column) {
        int ncolumns = this.getColumnCount();
        int nrows = this.getRowCount();
        int[] next = new int[2];
        if (++column < ncolumns) {
            for (int i = column; i < ncolumns; ++i) {
                if (!this.isCellEditable(row, i)) continue;
                next[0] = row;
                next[1] = i;
                return next;
            }
        }
        if (++row >= nrows) {
            return null;
        }
        for (int r = row; r < nrows; ++r) {
            for (int c2 = 0; c2 < ncolumns; ++c2) {
                if (!this.isCellEditable(r, c2)) continue;
                next[0] = r;
                next[1] = c2;
                return next;
            }
        }
        next = null;
        return null;
    }

    public String getSelectedDataString(int[] selection, int minColumn, int maxColumn) {
        int nColumns = maxColumn - minColumn + 1;
        StringBuffer dataString = new StringBuffer(selection.length * nColumns * 8);
        for (int k = 0; k < selection.length; ++k) {
            int i = selection[k];
            if (i == 0) {
                dataString.append(this.getColumnHeaderString());
            }
            for (int j = minColumn; j < maxColumn + 1; ++j) {
                dataString.append(this.getValueAt(i, j));
                if (j >= maxColumn) continue;
                dataString.append(" \t");
            }
            if (k >= selection.length - 1) continue;
            dataString.append('\n');
        }
        return dataString.toString();
    }

    public String allDataString() {
        int nRows = this.getRowCount();
        int nColumns = this.getColumnCount();
        StringBuffer dataString = new StringBuffer(nRows * nColumns * 8);
        dataString.append(this.getColumnHeaderString());
        dataString.append('\n');
        for (int i = 0; i < nRows; ++i) {
            for (int j = 0; j < nColumns; ++j) {
                dataString.append(this.getValueAt(i, j));
                if (j >= nColumns - 1) continue;
                dataString.append(" \t");
            }
            if (i >= nRows - 1) continue;
            dataString.append('\n');
        }
        return dataString.toString();
    }

    protected String getColumnHeaderString() {
        StringBuffer headerString = new StringBuffer();
        int nColumns = this.getColumnCount();
        Vector[] headers = new Vector[nColumns];
        int maxLines = 0;
        for (int j = 0; j < nColumns; ++j) {
            headers[j] = new Vector();
            Object header = this.getColumnName(j);
            ((String)header).trim();
            if (!((String)header).endsWith("\n")) {
                header = this.getColumnName(j) + "\n";
            }
            int k = 0;
            int max = 0;
            int position = 0;
            while (k >= 0) {
                k = ((String)header).indexOf("\n", position);
                if (k == 0) {
                    position = 1;
                }
                if (k <= 0) continue;
                if (k - position > 0) {
                    headers[j].add(((String)header).substring(position, k));
                } else {
                    headers[j].add("");
                }
                position = k + 1;
                ++max;
            }
            if (max <= maxLines) continue;
            maxLines = max;
        }
        for (int i = 0; i < maxLines; ++i) {
            for (int j = 0; j < nColumns; ++j) {
                if (headers[j].size() > i) {
                    headerString.append((String)headers[j].elementAt(i));
                }
                if (j < nColumns - 1) {
                    headerString.append("\t");
                    continue;
                }
                headerString.append("\n");
            }
        }
        return headerString.toString();
    }

    protected TableCellRenderer getCellRenderer(HecDataTable table, int row, int column) {
        return null;
    }

    public void setColumnWidths(TableColumnModel columnModel) {
        columnModel.getColumn(0).setPreferredWidth(60);
        for (int i = 1; i < columnModel.getColumnCount(); ++i) {
            columnModel.getColumn(i).setPreferredWidth(90);
        }
    }

    public String printString() {
        int rows = this.getRowCount();
        int columns = this.getColumnCount();
        Object line = "\t" + this.getNominalName();
        String s = this.fillTabs((String)line) + "\n";
        line = "";
        for (int j = 0; j < columns; ++j) {
            line = (String)line + "\t" + this.getColumnName(j);
        }
        s = s + this.fillTabs((String)line) + "\n";
        for (int i = 0; i < rows; ++i) {
            line = "";
            for (int j = 0; j < columns; ++j) {
                line = (String)line + "\t" + this.getValueAt(i, j).toString();
            }
            s = s + this.fillTabs((String)line) + "\n";
        }
        return s;
    }

    public String fillTabs(String line) {
        Object answer = "";
        StringTokenizer parser = new StringTokenizer(line, "\t", true);
        int number = parser.countTokens();
        try {
            for (int i = 0; i < number; ++i) {
                String token = parser.nextToken();
                answer = token.equals("\t") ? (String)answer + this.tabPos(((String)answer).length()) : (String)answer + token;
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        return answer;
    }

    public String tabPos(int position) {
        String blanks = "                  ";
        if (position < 3) {
            int diff = 3 - position;
            return blanks.substring(0, diff);
        }
        int loc = position / 15;
        int diff = 15 - (position - (loc *= 15));
        return blanks.substring(0, diff);
    }
}

