/*
 * Decompiled with CFR 0.152.
 */
package hec.dataTable;

import hec.dataTable.ArrayModel;
import hec.dataTable.DataModel;
import hec.dataTable.HecDataTableQualityEditor;
import hec.dataTable.PairedDataCurve;
import hec.dataTable.PairedDataModel;
import hec.dataTable.TimeSeriesColumnBase;
import hec.dataTable.TimeSeriesDataModel;
import hec.dataTable.TimeSeriesQualityColumn;
import hec.gfx2d.TimeSeriesDataSet;
import hec.heclib.util.HecDouble;
import hec.heclib.util.HecTime;
import hec.heclib.util.HecTimeArray;
import hec.heclib.util.intContainer;
import hec.io.ArrayContainer;
import hec.io.DataContainer;
import hec.io.PairedDataContainer;
import hec.io.TimeSeriesCollectionContainer;
import hec.io.TimeSeriesContainer;
import hec.util.TimeWindowExtensionDialog;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.util.Comparator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.function.IntUnaryOperator;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.RowSorter;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import javax.swing.text.Document;
import rma.swing.InsertDlg;
import rma.swing.RmaJTable;
import rma.swing.table.RmaCellEditor;
import rma.swing.table.RmaCellRenderer;
import rma.swing.table.TableExportOptions;
import rma.swing.table.ToolTipHeader;
import rma.util.RMAIO;

public class HecDataTable
extends RmaJTable
implements TableModelListener {
    static final Color DISABLED_COLOR = new Color(225, 225, 225);
    protected boolean _editMode = false;
    protected DataModel _tableData;
    protected boolean _allowSort = true;
    protected boolean _hasBeenSorted = false;
    protected Component _parentFrame = null;
    protected boolean _ignoreNextEditingStopped = false;
    private HecDataTableQualityEditor _qualityEditor;

    public HecDataTable(Component parentFrame) {
        this(parentFrame, true);
    }

    public HecDataTable(Component parentFrame, boolean allowSort) {
        super(parentFrame);
        this._parentFrame = parentFrame;
        this._allowSort = allowSort;
        this.init();
    }

    protected void init() {
        this.setSelectionMode(2);
        this.setAddRemoveEnabled(false);
        this.setColumnSelectionAllowed(true);
        this.setRowSelectionAllowed(true);
        this.setCellSelectionEnabled(true);
        TableDocumentListener tableDocumentListener = new TableDocumentListener();
        RmaCellEditor cellEditor = (RmaCellEditor)this.getDefaultEditor(String.class);
        cellEditor.setClickCountToStart(1);
        TableCellRenderer renderer = this.getDefaultRenderer(String.class);
        if (renderer instanceof RmaCellRenderer) {
            ((RmaCellRenderer)renderer).setHorizontalAlignment(4);
        }
        JTextField textField = (JTextField)cellEditor.getComponent();
        textField.getDocument().addDocumentListener(tableDocumentListener);
        super.setEditable(false);
        this.setUseDefaultPrintHeader(false);
    }

    public int setData(List dataSets, boolean showCommas, int qualityStyle) {
        if (dataSets.size() == 0) {
            return -1;
        }
        Object dataSet = dataSets.get(0);
        if (dataSet instanceof PairedDataContainer) {
            this._tableData = new PairedDataModel();
            int status = ((PairedDataModel)this._tableData).setData(dataSets, showCommas);
        } else if (dataSet instanceof TimeSeriesContainer || dataSet instanceof TimeSeriesCollectionContainer) {
            this._tableData = new TimeSeriesDataModel();
            int status = ((TimeSeriesDataModel)this._tableData).setData(dataSets, showCommas, qualityStyle);
        } else if (dataSet instanceof TimeSeriesDataSet) {
            Vector<TimeSeriesContainer> v = new Vector<TimeSeriesContainer>();
            for (int i = 0; i < dataSets.size(); ++i) {
                Object obj = dataSets.get(i);
                if (!(obj instanceof TimeSeriesDataSet)) continue;
                TimeSeriesContainer tsc = ((TimeSeriesDataSet)obj)._timeSeries;
                v.addElement(tsc);
            }
            this._tableData = new TimeSeriesDataModel();
            int status = ((TimeSeriesDataModel)this._tableData).setData(v, showCommas, qualityStyle);
        } else if (dataSet instanceof ArrayContainer) {
            this._tableData = new ArrayModel();
            int status = ((ArrayModel)this._tableData).setData(dataSets, false);
        } else {
            System.out.println("Data type not recognized. ");
            return -1;
        }
        this.setupModel();
        return 0;
    }

    public void setupModel() {
        this.setModel(this._tableData);
        this.setSorter();
        this.setMlHeaderRenderer();
        this.setToolTipHeaders();
        this.setPopupMenu();
    }

    private void setPopupMenu() {
        if (this._tableData instanceof TimeSeriesDataModel) {
            this.buildPopup();
            this._qualityEditor = new HecDataTableQualityEditor(new MyQualityCallback());
            this._qualityEditor.updateQualityMenuItems();
        }
    }

    protected void setToolTipHeaders() {
        if (this.getTableHeader() instanceof ToolTipHeader) {
            if (this._tableData instanceof PairedDataModel) {
                Vector columns = ((PairedDataModel)this._tableData)._pairedModelColumns;
                String[] toolTips = new String[columns.size() + 2];
                for (int i = 0; i < columns.size(); ++i) {
                    toolTips[i + 2] = ((PairedDataCurve)columns.get((int)i)).getDataContainer().fullName;
                }
                ((ToolTipHeader)this.getTableHeader()).setToolTipStrings(toolTips);
            } else if (this._tableData instanceof TimeSeriesDataModel) {
                Vector columns = ((TimeSeriesDataModel)this._tableData)._dataColumns;
                int count = this.getColumnCount();
                String[] toolTips = new String[count];
                int diff = 2;
                if (((TimeSeriesDataModel)this._tableData).getDateTimeAsTwoColumns()) {
                    ++diff;
                }
                for (int i = 0; i < columns.size(); ++i) {
                    toolTips[i + diff] = ((TimeSeriesColumnBase)columns.get((int)i)).getDataContainer().fullName;
                }
                ((ToolTipHeader)this.getTableHeader()).setToolTipStrings(toolTips);
            }
        }
    }

    protected void setSorter() {
        if (this._allowSort) {
            TableRowSorter<DataModel> sorter = new TableRowSorter<DataModel>(this._tableData);
            HecDataTableComparator comparator = new HecDataTableComparator();
            for (int i = 0; i < this.getColumnCount(); ++i) {
                sorter.setComparator(i, comparator);
            }
            this.setRowSorter(sorter);
        } else {
            this.setRowSorter(null);
        }
    }

    public int setData(DataContainer container, boolean showCommas, int qualityStyle) {
        Vector<DataContainer> t = new Vector<DataContainer>(1);
        t.add(container);
        if (container instanceof TimeSeriesContainer) {
            this._tableData = new TimeSeriesDataModel();
            int n = ((TimeSeriesDataModel)this._tableData).setData(t, showCommas, qualityStyle);
        } else if (container instanceof PairedDataContainer) {
            this._tableData = new PairedDataModel();
            int n = ((PairedDataModel)this._tableData).setData(t, showCommas);
        }
        this.setupModel();
        return 0;
    }

    @Override
    public void setEditable(boolean isEditable) {
        this._editMode = isEditable;
        boolean enableAddRemoveRows = false;
        if (this._tableData != null) {
            if (isEditable) {
                this.allowSort(false);
            }
            this._tableData.setEditable(isEditable);
            if (isEditable) {
                this.setTabToEditCell(true);
                if (this._tableData instanceof TimeSeriesDataModel) {
                    TimeSeriesDataModel tsdm = (TimeSeriesDataModel)this._tableData;
                    if (tsdm.getDataColumnCount() == 1) {
                        intContainer interval = new intContainer();
                        tsdm.getMinMaxIntervals(interval, interval);
                        if (interval.value == 0) {
                            enableAddRemoveRows = true;
                        }
                    }
                } else {
                    this.addMouseListenerToHeaderInTable(this);
                    TableColumnModel columnModel = this.getColumnModel();
                    ListSelectionModel lsm = columnModel.getSelectionModel();
                    lsm.setSelectionMode(0);
                }
            } else {
                this.setSelectionMode(2);
                this.setTabToEditCell(false);
            }
            this.setMenusEnabled(isEditable);
            this.setEditBackground(isEditable);
        }
        this.setAddRemoveEnabled(enableAddRemoveRows);
        if (this._qualityEditor != null) {
            this._qualityEditor.updateQualityMenuItems();
        }
    }

    protected void selectColumnHeader(int column) {
        JTableHeader th = this.getTableHeader();
        ListSelectionModel csm = th.getColumnModel().getSelectionModel();
        this.updateSelectionModel(csm, column, false, false);
        th.repaint();
    }

    public void setDateStyle(int dateStyle) {
        if (this._tableData instanceof TimeSeriesDataModel) {
            ((TimeSeriesDataModel)this._tableData).setDateStyle(dateStyle);
            if (this.isVisible()) {
                this._tableData.fireTableDataChanged();
            }
        }
    }

    public void setColumnWidths() {
        TableColumnModel columnModel = this.getColumnModel();
        if (columnModel != null && this._tableData != null) {
            this._tableData.setColumnWidths(columnModel);
        }
    }

    public void setExtendable(boolean extendable, int numberBlankRows) {
        if (this._tableData != null) {
            this._tableData.setExtendable(extendable, numberBlankRows);
        }
        this.setPasteAddsRows(true);
    }

    public void setDateTimeAsTwoColumns(boolean dateTimeAsTwoColumns) {
        if (this._tableData != null && this._tableData instanceof TimeSeriesDataModel) {
            ListSelectionModel selectionModel = this.getSelectionModel();
            selectionModel.clearSelection();
            ((TimeSeriesDataModel)this._tableData).setDateTimeAsTwoColumns(dateTimeAsTwoColumns);
            if (this.isVisible()) {
                if (dateTimeAsTwoColumns) {
                    TableColumnModel model = this.getColumnModel();
                    model.addColumn(new TableColumn());
                }
                this._tableData.fireTableStructureChanged();
                this.setToolTipHeaders();
            }
            this.setMlHeaderRenderer();
        }
    }

    public DataModel getTableModel() {
        return this._tableData;
    }

    public void setCommas(boolean showCommas) {
        if (this._tableData != null) {
            this._tableData.setCommas(showCommas);
            if (this.isVisible()) {
                this._tableData.fireTableDataChanged();
            }
        }
    }

    public void showTimeAsBeginningOfDay(boolean showTimeAsBeginning) {
        if (this._tableData != null) {
            this._tableData.showTimeAsBeginningOfDay(showTimeAsBeginning);
        }
    }

    public void setShowTimes(boolean showTimes) {
        if (this._tableData != null) {
            this._tableData.setShowTimes(showTimes);
        }
    }

    public boolean getShowTimes() {
        if (this._tableData != null) {
            return this._tableData.getShowTimes();
        }
        return false;
    }

    public void setShowFullDefinition(boolean showFullDefinition) {
        if (this._tableData != null) {
            this._tableData.setShowFullDefinition(showFullDefinition);
        }
    }

    public boolean getShowFullDefinition() {
        if (this._tableData != null) {
            return this._tableData.getShowFullDefinition();
        }
        return false;
    }

    public void setDecimalPosition(int numberDecimals) {
        if (this._tableData != null) {
            this._tableData.setDecimalPosition(numberDecimals);
            this.setPrecision(numberDecimals);
            if (this.isVisible()) {
                this._tableData.fireTableDataChanged();
            }
        }
    }

    public void setDecimalPosition(int column, int numberDecimals) {
        if (this._tableData != null) {
            this._tableData.setDecimalPosition(column, numberDecimals);
            if (this.isVisible()) {
                this._tableData.fireTableDataChanged();
            }
        }
    }

    public void setUndefinedStyle(int undefinedStyle) {
        if (this._tableData == null) {
            return;
        }
        if (this._tableData instanceof TimeSeriesDataModel) {
            ((TimeSeriesDataModel)this._tableData).setUndefinedStyle(undefinedStyle);
            if (this.isVisible()) {
                this._tableData.fireTableDataChanged();
            }
        }
    }

    public void setNumberHeaderRows(int number) {
        if (this._tableData != null) {
            this._tableData.setNumberHeaderRows(number);
        }
    }

    public String getTableType() {
        if (this._tableData instanceof TimeSeriesDataModel) {
            return "timeseries";
        }
        if (this._tableData instanceof PairedDataModel) {
            return "paired";
        }
        return "";
    }

    public Vector getDataSets() {
        this.stopEditing();
        if (this._tableData instanceof TimeSeriesDataModel) {
            return ((TimeSeriesDataModel)this._tableData).getDataSets();
        }
        return null;
    }

    public int getDateStyle() {
        if (this._tableData instanceof TimeSeriesDataModel) {
            return ((TimeSeriesDataModel)this._tableData).getDateStyle();
        }
        return TimeSeriesDataModel.getDefaultDateStyle();
    }

    public boolean getDateTimeAsTwoColumns() {
        if (this._tableData != null && this._tableData instanceof TimeSeriesDataModel) {
            return ((TimeSeriesDataModel)this._tableData).getDateTimeAsTwoColumns();
        }
        return false;
    }

    public int getDecimalPosition() {
        if (this._tableData != null) {
            return this._tableData.getDecimalPosition();
        }
        return -1;
    }

    public int getDecimalPosition(int column) {
        if (this._tableData != null) {
            return this._tableData.getDecimalPosition(column);
        }
        return -1;
    }

    @Override
    public int getRowCount() {
        if (this._tableData == null) {
            return 0;
        }
        return this._tableData.getRowCount();
    }

    @Override
    public int getColumnCount() {
        if (this._tableData == null) {
            return 0;
        }
        return this._tableData.getColumnCount();
    }

    public int getDataColumnCount() {
        return this._tableData.getDataColumnCount();
    }

    public int getFirstDataColumn() {
        if (this._tableData instanceof TimeSeriesDataModel) {
            int column = 2;
            if (this.getDateTimeAsTwoColumns()) {
                ++column;
            }
            return column;
        }
        return 1;
    }

    public int getFirstDataRow() {
        return this._tableData.getNumberHeaderRows();
    }

    public String getNominalName() {
        if (this._tableData == null) {
            return "";
        }
        return this._tableData.getNominalName();
    }

    @Override
    public String getName() {
        if (this._tableData == null) {
            return "";
        }
        String name = this._tableData.getName();
        return name.replace(' ', '_');
    }

    public int getNumberHeaderRows() {
        if (this._tableData != null) {
            return this._tableData.getNumberHeaderRows();
        }
        return 0;
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        if (row < 0 || column < 0) {
            return false;
        }
        if (row >= this.getRowCount()) {
            return false;
        }
        if (column >= this.getColumnCount()) {
            return false;
        }
        return super.isCellEditable(row, column);
    }

    @Override
    public String getToolTipText(MouseEvent event) {
        if (!this.hasQuality()) {
            return super.getToolTipText(event);
        }
        Point p = event.getPoint();
        int column = this.columnAtPoint(p);
        int row = this.rowAtPoint(p);
        if (row > 0 && column > 1) {
            return ((TimeSeriesDataModel)this._tableData).getToolTipText(row, column);
        }
        return super.getToolTipText(event);
    }

    public String getSelectedDataString() {
        int maxColumn;
        int minColumn;
        int maxRow;
        int minRow;
        this.stopEditing();
        ListSelectionModel listModel = this.getSelectionModel();
        if (listModel.isSelectionEmpty()) {
            minRow = 0;
            maxRow = this.getRowCount() - 1;
            minColumn = 0;
            maxColumn = this.getColumnCount() - 1;
        } else {
            minRow = listModel.getMinSelectionIndex();
            maxRow = listModel.getMaxSelectionIndex();
            TableColumnModel columnModel = this.getColumnModel();
            int[] cols = columnModel.getSelectedColumns();
            int len = cols.length;
            if (len == 0) {
                return "";
            }
            minColumn = cols[0];
            maxColumn = cols[len - 1];
        }
        int nRows = maxRow - minRow + 1;
        int[] selection = new int[nRows];
        int j = 0;
        for (int i = minRow; i < maxRow + 1; ++i) {
            selection[j++] = this.convertRowIndexToModel(i);
        }
        return this._tableData.getSelectedDataString(selection, minColumn, maxColumn);
    }

    public int addData(TimeSeriesContainer timeSeriesContainer) {
        int status = -1;
        if (this._tableData == null) {
            this._tableData = new TimeSeriesDataModel();
        }
        if (this._tableData instanceof TimeSeriesDataModel) {
            TimeSeriesDataModel tdm = (TimeSeriesDataModel)this._tableData;
            Vector v = tdm.getDataSets();
            v.add(timeSeriesContainer);
            status = tdm.setData(v, tdm.getCommas(), tdm.getQualityStyle());
        }
        this.setupModel();
        return status;
    }

    public TableCellRenderer xgetCellRenderer(int row, int column) {
        if (this._tableData == null) {
            return null;
        }
        TableCellRenderer renderer = this._tableData.getCellRenderer(this, row, column);
        if (renderer == null) {
            return super.getCellRenderer(row, column);
        }
        return renderer;
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        super.tableChanged(e);
        if (e.getFirstRow() == -1) {
            this.setSorter();
        }
        if (!this.isVisible()) {
            return;
        }
        if (this._editMode) {
            int end;
            int start = e.getFirstRow();
            if (start < 0) {
                start = 0;
            }
            if ((end = e.getLastRow()) >= this.getRowCount()) {
                end = this.getRowCount() - 1;
            }
            this.setDisableBackground(true, start, end, 0, this.getColumnCount() - 1);
        }
    }

    public void export(String filename) {
        super.exportData(filename, new TableExportOptions());
    }

    public void export(String filename, TableExportOptions exportOptions) {
        super.exportData(filename, exportOptions);
    }

    public void stopEditing() {
        this.cellEditor = this.getCellEditor();
        if (this.cellEditor != null) {
            this.cellEditor.stopCellEditing();
        }
    }

    public void initializeEntryStartTime() {
        this.stopEditing();
        if (this._tableData != null) {
            this._tableData.initializeEntryStartTime();
        }
    }

    public void allowSort(boolean doSort) {
        this._allowSort = doSort;
        if (doSort) {
            if (this.getRowSorter() == null) {
                this.setSorter();
            }
        } else {
            this.setRowSorter(null);
        }
    }

    public void numberOfPairedCurvesChanged(int newNumber) {
        this.commitEdit(true);
        if (this._tableData instanceof PairedDataModel) {
            ListSelectionModel selectionModel = this.getSelectionModel();
            selectionModel.clearSelection();
            int change = newNumber - this._tableData.getDataColumnCount();
            if (change > 0) {
                for (int i = 0; i < change; ++i) {
                    this.addColumn(new TableColumn());
                }
            }
            ((PairedDataModel)this._tableData).numberOfPairedCurvesChanged(newNumber);
            this.setMlHeaderRenderer();
        }
    }

    public boolean hasDataChanged() {
        this.stopEditing();
        if (this._tableData == null) {
            return false;
        }
        return this._tableData.hasDataChanged();
    }

    public void setDataChanged(boolean dataChanged) {
        this._tableData.setDataChanged(dataChanged);
    }

    public boolean hasQuality() {
        if (this._tableData instanceof TimeSeriesDataModel) {
            return ((TimeSeriesDataModel)this._tableData).hasQuality();
        }
        return false;
    }

    public int updateContainers(int[] firstError) {
        this.stopEditing();
        return this._tableData.updateContainers(firstError);
    }

    public Vector getDataContainers() {
        return this._tableData.getDataContainers();
    }

    public void save(Object parent) {
        this.stopEditing();
        if (this._tableData != null) {
            this._tableData.save(parent);
        }
    }

    public void saveAs(Object parent) {
        this.stopEditing();
        if (this._tableData != null) {
            this._tableData.saveAs(parent);
        }
    }

    public void plot(JFrame parent) {
        this.stopEditing();
        if (this._tableData != null) {
            this._tableData.plot(parent);
        }
    }

    public String printString() {
        this.stopEditing();
        if (this._tableData == null) {
            return "";
        }
        return this._tableData.printString();
    }

    public boolean find(String findStr, int startingRow, int startingColumn, int firstColumn, boolean wholeWordOnly, boolean down, Dimension rowCol) {
        return this._tableData.search(findStr, startingRow, startingColumn, firstColumn, wholeWordOnly, down, rowCol);
    }

    public String allDataString() {
        this.stopEditing();
        if (this._tableData == null) {
            return "";
        }
        return this._tableData.allDataString();
    }

    public boolean isSorted() {
        if (this._hasBeenSorted) {
            return true;
        }
        RowSorter<? extends TableModel> sorter = this.getRowSorter();
        if (sorter == null) {
            return false;
        }
        List<RowSorter.SortKey> list = sorter.getSortKeys();
        if (list.isEmpty()) {
            return false;
        }
        this._hasBeenSorted = true;
        return true;
    }

    @Override
    public void insertRow() {
        this.commitEdit(false);
        int selRow = this.getSelectedRow();
        selRow = this.convertRowIndexToModel(selRow);
        boolean inserted = false;
        inserted = this._tableData instanceof TimeSeriesDataModel ? this.insertTimeSeriesRow(selRow) : this.insertPairedDataRow(selRow);
        if (!inserted) {
            return;
        }
        if (selRow < 0) {
            selRow = 0;
        }
        this.revalidate();
        this.setEditBackground(true);
        this.setRowSelectionInterval(selRow, selRow);
        this.setColumnSelectionInterval(1, 1);
    }

    public boolean insertTimeSeriesRow(int selRow) {
        HecTimeArray timeArray;
        int nrows;
        if (!(this._tableData instanceof TimeSeriesDataModel)) {
            return false;
        }
        TimeSeriesDataModel model = (TimeSeriesDataModel)this._tableData;
        int interval = -1;
        boolean allIrregular = model.isAllIrregular();
        if (!allIrregular) {
            intContainer min = new intContainer();
            intContainer max = new intContainer();
            model.getMinMaxIntervals(min, max);
            interval = min.value;
        }
        if (selRow > -1) {
            selRow -= model.getNumberHeaderRows();
        }
        JFrame parentFrame = null;
        if (this._parentFrame instanceof JFrame) {
            parentFrame = (JFrame)this._parentFrame;
        }
        TimeWindowExtensionDialog extendDialog = new TimeWindowExtensionDialog(parentFrame, model.getTimeArray(), interval, allIrregular, selRow);
        extendDialog.setVisible(true);
        if (extendDialog.canceled()) {
            return false;
        }
        boolean mod = false;
        if (extendDialog.isInserted()) {
            nrows = extendDialog.getNumberInsertedRows();
            timeArray = extendDialog.getInsertedTimes();
            model.insertRowsBefore(selRow += model.getNumberHeaderRows() + 1, nrows, timeArray);
            mod = true;
        }
        if (extendDialog.isPrepended()) {
            nrows = extendDialog.getNumberPrependedRows();
            timeArray = extendDialog.getPrependedTimes();
            model.insertRowsBefore(0, nrows, timeArray);
            mod = true;
        }
        if (extendDialog.isAppended()) {
            nrows = extendDialog.getNumberAppendedRows();
            timeArray = extendDialog.getAppendedTimes();
            model.appendRows(nrows, timeArray);
            mod = true;
        }
        return mod;
    }

    public boolean insertPairedDataRow(int selRow) {
        JFrame parentFrame = null;
        if (this._parentFrame instanceof JFrame) {
            parentFrame = (JFrame)this._parentFrame;
        }
        InsertDlg dialog = new InsertDlg(parentFrame, "Insert Rows", true);
        dialog.setRowsToInsert(1);
        dialog.setBounds(this._parentFrame.getBounds());
        dialog.setVisible(true);
        if (dialog.isCanceled()) {
            return false;
        }
        int number = dialog.getRowsToInsert();
        if (selRow < 0) {
            selRow = 0;
        }
        if (this._tableData instanceof PairedDataModel) {
            PairedDataModel model = (PairedDataModel)this._tableData;
            model.insertRowsBefore(selRow, number);
        }
        return true;
    }

    public Component getParentFrame() {
        return this._parentFrame;
    }

    @Override
    public void deleteRow() {
        this.commitEdit(false);
        int[] rows = this.getSelectedRows();
        if (rows == null || rows.length == 0) {
            JOptionPane.showMessageDialog(this._parentFrame, "No data rows selected to delete", "", 2);
            return;
        }
        this.deleteRows(rows);
    }

    public void deleteRows(int[] rows) {
        this.commitEdit(false);
        if (rows == null || rows.length == 0) {
            JOptionPane.showMessageDialog(this._parentFrame, "No data rows selected to delete", "", 2);
            return;
        }
        for (int i = 0; i < rows.length; ++i) {
            rows[i] = this.convertRowIndexToModel(rows[i]);
        }
        if (this._tableData instanceof TimeSeriesDataModel) {
            TimeSeriesDataModel model = (TimeSeriesDataModel)this._tableData;
            model.deleteRows(rows);
        }
        if (this._tableData instanceof PairedDataModel) {
            PairedDataModel model = (PairedDataModel)this._tableData;
            model.deleteRows(rows);
        }
        this.revalidate();
        this.setEditBackground(true);
        int selectedRow = rows[0] + this.getNumberHeaderRows();
        if (selectedRow >= this.getRowCount()) {
            selectedRow = this.getRowCount() - 1;
        }
        this.setRowSelectionInterval(selectedRow, selectedRow);
        this.setColumnSelectionInterval(0, 0);
    }

    public void deleteColumn() {
        this.stopEditing();
        JTableHeader th = this.getTableHeader();
        ListSelectionModel csm = th.getColumnModel().getSelectionModel();
        int col = csm.getAnchorSelectionIndex();
        if (this._tableData.canDeleteColumn(col)) {
            csm.setSelectionInterval(0, 0);
            TableColumnModel tcm = this.getColumnModel();
            TableColumn tc = tcm.getColumn(col);
            this._tableData.deleteColumn(col);
            this.removeColumn(tc);
            this._tableData.fireTableStructureChanged();
            this.setMlHeaderRenderer();
        }
    }

    public void insertColumn() {
        this.insertColumn(false);
    }

    protected void appendColumn() {
        this.insertColumn(true);
    }

    public void applyQuality(IntUnaryOperator qualityFunction) {
        this.stopEditing();
        int[] selectedRows = this.getSelectedRows();
        int[] cols = this.getSelectedColumns();
        int rowStart = this.getFirstDataRow();
        int colStart = this.getFirstDataColumn();
        for (int i = 0; i < cols.length; ++i) {
            cols[i] = this.convertColumnIndexToModel(cols[i]) - colStart;
        }
        int[] rows = new int[selectedRows.length];
        for (int i = 0; i < selectedRows.length; ++i) {
            rows[i] = this.convertRowIndexToModel(selectedRows[i]) - rowStart;
        }
        ((TimeSeriesDataModel)this._tableData).applyQuality(cols, rows, qualityFunction);
        if (selectedRows.length > 0) {
            this._tableData.fireTableRowsUpdated(selectedRows[0], selectedRows[selectedRows.length - 1]);
        }
    }

    public void insertColumn(boolean append) {
        this.stopEditing();
        JTableHeader th = this.getTableHeader();
        ListSelectionModel csm = th.getColumnModel().getSelectionModel();
        int col = csm.getAnchorSelectionIndex();
        if (col <= 0) {
            col = this.getColumnCount() - 1;
            append = true;
        }
        if (this._tableData.canInsertColumn(col, append)) {
            csm.setSelectionInterval(0, 0);
            if (col < 2 && append) {
                col = this.getColumnCount() - 1;
            }
            TableColumnModel tcm = this.getColumnModel();
            TableColumn tc = tcm.getColumn(col);
            this._tableData.addColumn(col, append);
            this.addColumn(tc);
            this._tableData.fireTableStructureChanged();
            this.setMlHeaderRenderer();
        }
    }

    public boolean allowDeleteRow() {
        if (!this._editMode) {
            return false;
        }
        if (this.getTableType().startsWith("paired")) {
            return true;
        }
        if (this._tableData.getDataColumnCount() != 1) {
            return false;
        }
        if (this._tableData instanceof TimeSeriesDataModel) {
            TimeSeriesDataModel model = (TimeSeriesDataModel)this._tableData;
            return model.isAllIrregular();
        }
        return false;
    }

    @Override
    public void appendRows(int numberRows) {
        this._tableData.appendRows(numberRows);
        this.setEditBackground(true);
    }

    @Override
    public void appendRows() {
        InsertDlg dialog = null;
        Window w = SwingUtilities.windowForComponent(this);
        if (w instanceof Dialog) {
            dialog = new InsertDlg((Dialog)w, "Append Rows", true, "Enter number of rows to append:");
        } else if (w instanceof Frame) {
            dialog = new InsertDlg((Frame)w, "Append Rows", true, "Enter number of rows to append:");
        } else {
            RMAIO.postWarning(this, "Can't open Insert Row Dialog, because there is not\na valid window component parent for thistable");
            return;
        }
        dialog.setRowsToInsert(1);
        dialog.setBounds(this.getBounds());
        dialog.setVisible(true);
        if (dialog.isCanceled()) {
            return;
        }
        int number = dialog.getRowsToInsert();
        this.appendRows(number);
    }

    @Override
    public void appendRow() {
        this.commitEdit(false);
        int selRow = this.getSelectedRow();
        selRow = this.convertRowIndexToModel(selRow);
        ++selRow;
        if (this._tableData instanceof TimeSeriesDataModel) {
            TimeSeriesDataModel model = (TimeSeriesDataModel)this._tableData;
            model.insertRowsBefore(selRow, 1);
            this.revalidate();
        }
        this.setEditBackground(true);
        this.setRowSelectionInterval(selRow, selRow);
        this.setColumnSelectionInterval(1, 1);
    }

    @Override
    public void paste() {
        if (!this._editMode) {
            return;
        }
        this._tableData.setPasteMode(true);
        super.paste();
        this._tableData.setPasteMode(false);
        this._ignoreNextEditingStopped = true;
        this.repaint();
    }

    @Override
    public void editingStopped(ChangeEvent e) {
        if (this._ignoreNextEditingStopped) {
            this._ignoreNextEditingStopped = false;
            return;
        }
        super.editingStopped(e);
    }

    public void pasteData(String pasteString) {
        StringTokenizer rowsInPaste = new StringTokenizer(pasteString, "\r\n");
        int numberPaste = rowsInPaste.countTokens();
        int selRow = this.getSelectedRow();
        selRow = this.convertRowIndexToModel(selRow);
        int total = this.getRowCount();
        int rowsHave = total - selRow + 1;
        int rowsNeeded = numberPaste - rowsHave;
        if (rowsNeeded > 0 && this._tableData instanceof TimeSeriesDataModel) {
            TimeSeriesDataModel model = (TimeSeriesDataModel)this._tableData;
            model.appendRows(rowsNeeded + 1);
        }
        this.paste();
    }

    public void addMouseListenerToHeaderInTable(JTable table) {
        final JTable tableView = table;
        MouseAdapter listMouseListener = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                TableColumnModel columnModel = tableView.getColumnModel();
                int viewColumn = columnModel.getColumnIndexAtX(e.getX());
                int column = tableView.convertColumnIndexToModel(viewColumn);
                if (e.getClickCount() == 1 && column != -1) {
                    HecDataTable.this.selectColumnHeader(column);
                }
                tableView.getTableHeader().repaint();
            }
        };
        JTableHeader th = tableView.getTableHeader();
        th.addMouseListener(listMouseListener);
    }

    @Override
    public void exportAsXML(BufferedWriter writer, String title, String indent) {
        try {
            StringWriter strWriter = new StringWriter();
            BufferedWriter bufWriter = new BufferedWriter(strWriter);
            bufWriter.newLine();
            bufWriter.flush();
            String newLine = strWriter.toString();
            bufWriter.close();
            strWriter = new StringWriter();
            bufWriter = new BufferedWriter(strWriter);
            super.exportAsXML(bufWriter, title, indent);
            String baseString = strWriter.toString();
            String[] lines = baseString.split(newLine);
            boolean labelsRow = false;
            boolean unitsRow = false;
            boolean typeRow = false;
            for (int i = 0; i < lines.length; ++i) {
                if (lines[i].trim().startsWith("<ValuesRow>") && i < lines.length - 1) {
                    if (lines[i + 1].trim().startsWith("<ValuesItem>Labels<")) {
                        labelsRow = true;
                        unitsRow = false;
                        typeRow = false;
                    } else if (lines[i + 1].trim().startsWith("<ValuesItem>Units<")) {
                        labelsRow = false;
                        unitsRow = true;
                        typeRow = false;
                    } else if (lines[i + 1].trim().startsWith("<ValuesItem>Type<")) {
                        labelsRow = false;
                        unitsRow = false;
                        typeRow = true;
                    } else {
                        labelsRow = false;
                        unitsRow = false;
                        typeRow = false;
                    }
                }
                if (labelsRow) {
                    lines[i] = lines[i].replaceAll("<Values", "<Labels").replaceAll("</Values", "</Labels");
                } else if (unitsRow) {
                    lines[i] = lines[i].replaceAll("<Values", "<Units").replaceAll("</Values", "</Units");
                } else if (typeRow) {
                    lines[i] = lines[i].replaceAll("<Values", "<DataType").replaceAll("</Values", "</DataType");
                }
                writer.write(lines[i]);
                writer.newLine();
            }
            writer.flush();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    @Override
    public void exportAsHTML(BufferedWriter writer, String title, String indent) {
        try {
            StringWriter strWriter = new StringWriter();
            BufferedWriter bufWriter = new BufferedWriter(strWriter);
            super.exportAsHTML(bufWriter, title, indent);
            String baseString = strWriter.toString();
            baseString = baseString.replaceAll("<LabelsRow>", "<TR ALIGN=\"RIGHT\">");
            baseString = baseString.replaceAll("</LabelsRow>", "</TR>");
            baseString = baseString.replaceAll("LabelsItem>", "TH>");
            baseString = baseString.replaceAll("<UnitsRow>", "<TR ALIGN=\"RIGHT\">");
            baseString = baseString.replaceAll("</UnitsRow>", "</TR>");
            baseString = baseString.replaceAll("UnitsItem>", "TH>");
            baseString = baseString.replaceAll("<DataTypeRow>", "<TR ALIGN=\"RIGHT\">");
            baseString = baseString.replaceAll("</DataTypeRow>", "</TR>");
            baseString = baseString.replaceAll("DataTypeItem>", "TH>");
            writer.write(baseString);
            writer.flush();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    public void setEditBackground(boolean isEditable) {
        this.clearColors();
        if (isEditable) {
            int numberColumns = this.getColumnCount();
            int numberRows = this.getRowCount();
            this.setDisableBackground(false, 0, numberRows - 1, 0, numberColumns - 1);
        }
    }

    private void setDisableBackground(boolean clear, int startRow, int endRow, int startColumn, int endColumn) {
        for (int j = startColumn; j <= endColumn; ++j) {
            for (int i = startRow; i <= endRow; ++i) {
                if (!this.isCellEditable(i, j)) {
                    this.setCellBackground(i, j, DISABLED_COLOR);
                    continue;
                }
                if (!clear) continue;
                this.setCellBackground(i, j, Color.WHITE);
            }
        }
    }

    class TableDocumentListener
    implements DocumentListener {
        TableDocumentListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            if (e.getLength() > 12) {
                try {
                    Document doc = e.getDocument();
                    String cellValues = doc.getText(0, doc.getLength());
                    if (HecDataTable.this._tableData.isPasteString(cellValues, 0)) {
                        HecDataTable.this.paste();
                        int rowSel = HecDataTable.this.getSelectedRow();
                        rowSel = HecDataTable.this.convertRowIndexToModel(rowSel);
                        int colSel = HecDataTable.this.getSelectedColumn();
                        TableCellEditor tce = HecDataTable.this.getCellEditor(rowSel, colSel);
                        tce.cancelCellEditing();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
        }
    }

    private final class MyQualityCallback
    implements HecDataTableQualityEditor.QualityCallback {
        private MyQualityCallback() {
        }

        @Override
        public boolean hasQuality() {
            return HecDataTable.this.hasQuality();
        }

        @Override
        public int getQualityStyle() {
            int retval = TimeSeriesQualityColumn.QUALITY_STYLE_NONE;
            if (this.hasQuality() && HecDataTable.this._tableData instanceof TimeSeriesDataModel) {
                retval = ((TimeSeriesDataModel)HecDataTable.this._tableData).getQualityStyle();
            }
            return retval;
        }

        @Override
        public void updateQuality(IntUnaryOperator qualityFunction) {
            if (HecDataTable.this._tableData instanceof TimeSeriesDataModel) {
                HecDataTable.this.applyQuality(qualityFunction);
            }
        }

        @Override
        public boolean isEditMode() {
            return HecDataTable.this._editMode;
        }

        @Override
        public JComponent getMenuComponent() {
            return HecDataTable.this.getPopupMenu();
        }

        @Override
        public Font getMenuItemFont() {
            return HecDataTable.this.getPopupMenuItemFont();
        }
    }

    public class HecDataTableComparator
    implements Comparator {
        public int compare(Object o1, Object o2) {
            if (o1 instanceof HecDouble) {
                if (o2 instanceof HecDouble) {
                    return ((HecDouble)o1).compare(((HecDouble)o2).value());
                }
            } else if (o1 instanceof HecTime) {
                if (o2 instanceof HecTime) {
                    return ((HecTime)o1).compareTo(o2);
                }
            } else if (o1 instanceof Integer && o2 instanceof Integer) {
                return ((Integer)o1).compareTo((Integer)o2);
            }
            if (o1 instanceof Double && o2 instanceof Double) {
                return ((Double)o1).compareTo((Double)o2);
            }
            String s1 = o1.toString();
            String s2 = o2.toString();
            return s1.compareTo(s2);
        }
    }
}

