/*
 * Decompiled with CFR 0.152.
 */
package hec.dataTable;

import hec.dataTable.DataModel;
import hec.dataTable.HecDataTable;
import hec.dataTable.HecDataTableQualityEditor;
import hec.dataTable.PairedDataCurveSelector;
import hec.dataTable.PairedDataModel;
import hec.dataTable.TableFindDialog;
import hec.dataTable.TimeSeriesDataModel;
import hec.dataTable.TimeSeriesQualityColumn;
import hec.dataTable.Title;
import hec.gfx2d.G2dMarkerProperties;
import hec.heclib.util.HecDouble;
import hec.heclib.util.HecTime;
import hec.heclib.util.HecTimeArray;
import hec.heclib.util.intContainer;
import hec.io.DataContainer;
import hec.io.PairedDataContainer;
import hec.io.TimeSeriesContainer;
import hec.lang.annotation.Scriptable;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.PrintGraphics;
import java.awt.PrintJob;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedWriter;
import java.io.EOFException;
import java.io.LineNumberReader;
import java.io.StringReader;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import java.util.function.IntUnaryOperator;
import java.util.prefs.Preferences;
import javax.swing.AbstractButton;
import javax.swing.AbstractCellEditor;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.TransferHandler;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import rma.swing.FindListener;
import rma.swing.RmaImage;
import rma.swing.RmaJFrame;
import rma.swing.table.TableExportOptions;
import rma.util.RMAIO;

public class HecDataTableFrame
extends RmaJFrame
implements ActionListener,
FindListener {
    private static String DECIMAL_PLACES_PROPERTY = "SHOW DECIMAL PLACES";
    public static String SHOW_COMMAS_PROPERTY = "SHOW COMMAS";
    public static String REVERSE_ORDER_PROPERTY = "REVERSE ORDER";
    public static String SHOW_DATE_AS_TWO_COLUMNS = "SHOW DATE AS TWO COLUMNS";
    public static String DATE_STYLE = "DATE STYLE";
    public static String QUALITY_STYLE = "QUALITY STYLE";
    public static final int TIME_SERIES = 1;
    public static final int PAIRED = 2;
    public static final int EQUAL = 1;
    public static final int GREATER = 2;
    public static final int LESS = 3;
    public static final int EQUAL_GREATER = 4;
    public static final int EQUAL_LESS = 5;
    protected Object _parent;
    protected HecDataTable _table;
    protected JPanel _tablePanel;
    protected JScrollPane _tableScrollPane;
    protected JMenuBar _menuBar;
    protected JMenu _fileMenu;
    protected JMenuItem _saveItem;
    protected JMenuItem _saveAsItem;
    protected JMenuItem _printItem;
    protected JMenuItem _printPreview;
    protected JMenuItem _export;
    protected JMenuItem _plotItem;
    protected JMenuItem _exitItem;
    protected JMenu _viewMenu;
    protected JMenu _editMenu;
    protected JMenuItem _editCut;
    protected JMenuItem _editCopy;
    protected JMenuItem _editPaste;
    protected JMenuItem _editSelectAll;
    protected JMenuItem _editCompare;
    protected JMenuItem _editFind;
    protected JMenuItem _editNextDiff;
    protected JMenuItem _editReplace;
    protected JMenuItem _editInsertRows;
    protected JMenuItem _editAppendRows;
    protected JMenuItem _editDeleteRows;
    protected JMenuItem _editInsertColumn;
    protected JMenuItem _editAppendColumn;
    protected JMenuItem _editDeleteColumn;
    protected JCheckBoxMenuItem _allowEditing;
    protected ButtonGroup _decimalGroup;
    protected ButtonGroup _qualityGroup;
    protected ButtonGroup _undefinedStyleGroup;
    protected JMenu _viewDecimals;
    protected JCheckBoxMenuItem _viewCommas;
    protected JCheckBoxMenuItem _reverseOrderMenu = new JCheckBoxMenuItem();
    protected JCheckBoxMenuItem _viewDateTimeAsTwoColumns;
    protected JCheckBoxMenuItem _viewDateWith4Digits;
    protected JMenu _viewQuality;
    protected JRadioButtonMenuItem _qualityNone;
    protected JRadioButtonMenuItem _qualitySymbol;
    protected JRadioButtonMenuItem _qualityHex;
    protected JRadioButtonMenuItem _decimalAuto;
    protected JRadioButtonMenuItem _decimal0;
    protected JRadioButtonMenuItem _decimal1;
    protected JRadioButtonMenuItem _decimal2;
    protected JRadioButtonMenuItem _decimal3;
    protected JRadioButtonMenuItem _decimal4;
    protected JRadioButtonMenuItem _decimal5;
    protected JRadioButtonMenuItem _decimal6;
    protected JMenu _undefinedStyle;
    protected JRadioButtonMenuItem _undefinedStyleBlank;
    protected JRadioButtonMenuItem _undefinedStyle901;
    protected JRadioButtonMenuItem _undefinedStyleM;
    protected JRadioButtonMenuItem _undefinedStyleDashM;
    protected Title _title;
    protected Clipboard _sysClipboard = null;
    protected TransferHandler _transferHandler = null;
    protected Preferences _preferences;
    TableFindDialog _findDialog = null;
    protected int[] _ordinatesDifferent = null;
    protected int _tableType = 0;
    static boolean _showCommas = true;
    private int _decimalPositions = -1;
    protected boolean _showDateTimeAsTwoColumns = false;
    private JMenuItem _selectPDCurvesM;
    static int _qualityStyle = TimeSeriesQualityColumn.QUALITY_STYLE_NONE;
    private HecDataTableQualityEditor _qualityEditor;

    public HecDataTableFrame(Object parent) {
        this.setParent(parent);
        this.setDefaultCloseOperation(0);
        this._sysClipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        this.getContentPane().setLayout(new BorderLayout());
        this._table = new HecDataTable(this);
        this._title = new Title(this._table);
        this._tableScrollPane = this._table.getScrollPane();
        this.getContentPane().add((Component)this._tableScrollPane, "Center");
        this.getContentPane().add((Component)this._title, "North");
        if (this._transferHandler != null) {
            this._table.setTransferHandler(this._transferHandler);
            this._table.setDragEnabled(true);
        }
        this._preferences = Preferences.userNodeForPackage(this.getClass());
    }

    public void setParent(Object parent) {
        this._parent = parent;
    }

    public static String getDecimalPlacesProp() {
        return DECIMAL_PLACES_PROPERTY;
    }

    public static HecDataTableFrame newTable() {
        return new HecDataTableFrame((Object)null);
    }

    public static HecDataTableFrame newTable(String title) {
        HecDataTableFrame frame = new HecDataTableFrame((Object)null);
        frame.setTitle(title);
        return frame;
    }

    public void showTable() {
        this.completeTable();
        this.setVisible(true);
    }

    protected void buildMenu() {
        Image image;
        if (this._menuBar != null) {
            return;
        }
        this._menuBar = new JMenuBar();
        this._fileMenu = new JMenu("File");
        this._fileMenu.setMnemonic('F');
        this._menuBar.add(this._fileMenu);
        this._saveItem = new JMenuItem("Save", 115);
        this._saveItem.setAccelerator(KeyStroke.getKeyStroke(83, 2, false));
        this._saveItem.addActionListener(this);
        this._saveItem.setEnabled(false);
        this._fileMenu.add(this._saveItem);
        this._saveAsItem = new JMenuItem("Save As...", 65);
        this._saveAsItem.addActionListener(this);
        this._fileMenu.add(this._saveAsItem);
        this._fileMenu.addSeparator();
        this._printItem = new JMenuItem("Print...", 80);
        this._printItem.setAccelerator(KeyStroke.getKeyStroke(80, 2, false));
        this._printItem.addActionListener(this);
        this._fileMenu.add(this._printItem);
        this._printPreview = new JMenuItem("Print Preview...", 80);
        this._printPreview.addActionListener(this);
        this._fileMenu.add(this._printPreview);
        this._export = new JMenuItem("Export...", 69);
        this._export.addActionListener(this);
        this._fileMenu.add(this._export);
        this._fileMenu.addSeparator();
        this._plotItem = new JMenuItem("Plot", 108);
        this._plotItem.addActionListener(this);
        this._fileMenu.add(this._plotItem);
        this._fileMenu.addSeparator();
        this._exitItem = new JMenuItem("Close", 67);
        this._exitItem.setAccelerator(KeyStroke.getKeyStroke(87, 2, false));
        this._exitItem.addActionListener(this);
        this._fileMenu.add(this._exitItem);
        this._editMenu = new JMenu("Edit");
        this._editMenu.setMnemonic('E');
        this._allowEditing = new JCheckBoxMenuItem("Allow Editing", false);
        this._allowEditing.setMnemonic('A');
        this._allowEditing.addActionListener(this);
        this._editMenu.add(this._allowEditing);
        this._editMenu.addActionListener(this);
        this._editMenu.addSeparator();
        this._editCut = new JMenuItem("Cut", 116);
        this._editCut.setAccelerator(KeyStroke.getKeyStroke(88, 2, false));
        this._editCut.setEnabled(false);
        this._editCut.addActionListener(this);
        this._editMenu.add(this._editCut);
        this._editCopy = new JMenuItem("Copy", 67);
        this._editCopy.setAccelerator(KeyStroke.getKeyStroke(67, 2, false));
        this._editCopy.setEnabled(true);
        this._editCopy.addActionListener(this);
        this._editMenu.add(this._editCopy);
        this._editPaste = new JMenuItem("Paste", 80);
        this._editPaste.setAccelerator(KeyStroke.getKeyStroke(86, 2, false));
        this._editPaste.setEnabled(false);
        this._editPaste.addActionListener(this);
        this._editMenu.add(this._editPaste);
        this._editMenu.addSeparator();
        this._editSelectAll = new JMenuItem("Select All", 83);
        this._editSelectAll.setAccelerator(KeyStroke.getKeyStroke(65, 2, false));
        this._editSelectAll.setEnabled(true);
        this._editSelectAll.addActionListener(this);
        this._editMenu.add(this._editSelectAll);
        this._editFind = new JMenuItem("Find...", 70);
        this._editFind.setAccelerator(KeyStroke.getKeyStroke("F3"));
        this._editFind.setEnabled(true);
        this._editFind.addActionListener(this);
        this._editMenu.add(this._editFind);
        this._editCompare = new JMenuItem("Compare data sets");
        this._editCompare.setEnabled(true);
        this._editCompare.addActionListener(this);
        if (this.getTableType().equals("timeseries") && this._table.getDataColumnCount() > 1) {
            this._editMenu.add(this._editCompare);
        }
        this._editNextDiff = new JMenuItem("Next Difference", 70);
        this._editFind.setAccelerator(KeyStroke.getKeyStroke("F3"));
        this._editNextDiff.setEnabled(false);
        this._editNextDiff.setVisible(false);
        this._editNextDiff.addActionListener(this);
        this._editMenu.add(this._editNextDiff);
        this._editAppendRows = new JMenuItem("Append Rows...");
        this._editDeleteRows = new JMenuItem("Delete Rows");
        this._editInsertColumn = new JMenuItem("Insert Column");
        this._editAppendColumn = new JMenuItem("Append Column");
        this._editDeleteColumn = new JMenuItem("Delete Column");
        this._menuBar.add(this._editMenu);
        this._viewMenu = new JMenu("View");
        this._viewMenu.setMnemonic('V');
        this._viewCommas = new JCheckBoxMenuItem("Commas", _showCommas);
        this._viewCommas.setMnemonic('S');
        this._viewCommas.setState(_showCommas);
        this._viewCommas.addActionListener(this);
        this._viewMenu.add(this._viewCommas);
        this._reverseOrderMenu.setText("Reverse Order");
        this._reverseOrderMenu.addActionListener(this);
        this._viewMenu.add(this._reverseOrderMenu);
        this._viewDateTimeAsTwoColumns = new JCheckBoxMenuItem("Date and Time Separately", this._showDateTimeAsTwoColumns);
        this._viewDateTimeAsTwoColumns.setMnemonic('T');
        this._viewDateTimeAsTwoColumns.setState(this._showDateTimeAsTwoColumns);
        this._viewDateTimeAsTwoColumns.addActionListener(this);
        this._viewMenu.add(this._viewDateTimeAsTwoColumns);
        boolean showDateWith4Digits = false;
        int style = TimeSeriesDataModel.getDefaultDateStyle();
        if (style < 10) {
            showDateWith4Digits = true;
        }
        this._viewDateWith4Digits = new JCheckBoxMenuItem("Date with 4 Digit Years", showDateWith4Digits);
        this._viewDateWith4Digits.setState(showDateWith4Digits);
        this._viewDateWith4Digits.addActionListener(this);
        this._viewMenu.add(this._viewDateWith4Digits);
        this._viewDecimals = new JMenu("Show Decimal Places");
        this._viewDecimals.setMnemonic('D');
        this._decimalGroup = new ButtonGroup();
        this._decimalAuto = new JRadioButtonMenuItem("auto");
        this._decimalAuto.setMnemonic('a');
        this._decimalAuto.setSelected(true);
        this._decimalGroup.add(this._decimalAuto);
        this._viewDecimals.add(this._decimalAuto);
        this._decimalAuto.addActionListener(this);
        this._decimal0 = new JRadioButtonMenuItem("0.");
        this._decimal0.setMnemonic('0');
        this._decimalGroup.add(this._decimal0);
        this._viewDecimals.add(this._decimal0);
        this._decimal0.addActionListener(this);
        this._decimal1 = new JRadioButtonMenuItem("0.0");
        this._decimal1.setMnemonic('1');
        this._decimalGroup.add(this._decimal1);
        this._viewDecimals.add(this._decimal1);
        this._decimal1.addActionListener(this);
        this._decimal2 = new JRadioButtonMenuItem("0.00");
        this._decimal2.setMnemonic('2');
        this._decimalGroup.add(this._decimal2);
        this._viewDecimals.add(this._decimal2);
        this._decimal2.addActionListener(this);
        this._decimal3 = new JRadioButtonMenuItem("0.000");
        this._decimal3.setMnemonic('3');
        this._decimalGroup.add(this._decimal3);
        this._viewDecimals.add(this._decimal3);
        this._decimal3.addActionListener(this);
        this._decimal4 = new JRadioButtonMenuItem("0.0000");
        this._decimal4.setMnemonic('4');
        this._decimalGroup.add(this._decimal4);
        this._viewDecimals.add(this._decimal4);
        this._decimal4.addActionListener(this);
        this._decimal5 = new JRadioButtonMenuItem("0.00000");
        this._decimal5.setMnemonic('5');
        this._decimalGroup.add(this._decimal5);
        this._viewDecimals.add(this._decimal5);
        this._decimal5.addActionListener(this);
        this._decimal6 = new JRadioButtonMenuItem("0.000000");
        this._decimal6.setMnemonic('6');
        this._decimalGroup.add(this._decimal6);
        this._viewDecimals.add(this._decimal6);
        this._decimal6.addActionListener(this);
        this._viewMenu.add(this._viewDecimals);
        this.selectDecimalMenu(this._decimalPositions);
        this._viewQuality = new JMenu("Quality");
        this._viewQuality.setMnemonic('Q');
        this._qualityGroup = new ButtonGroup();
        this._qualityNone = new JRadioButtonMenuItem("none");
        this._qualityNone.setMnemonic('n');
        this._qualityGroup.add(this._qualityNone);
        this._viewQuality.add(this._qualityNone);
        this._qualityNone.addActionListener(this);
        this._qualitySymbol = new JRadioButtonMenuItem("as symbol");
        this._qualitySymbol.setMnemonic('s');
        this._qualityGroup.add(this._qualitySymbol);
        this._viewQuality.add(this._qualitySymbol);
        this._qualitySymbol.addActionListener(this);
        this._qualityHex = new JRadioButtonMenuItem("as hex");
        this._qualityHex.setMnemonic('h');
        this._qualityGroup.add(this._qualityHex);
        this._viewQuality.add(this._qualityHex);
        this._qualityHex.addActionListener(this);
        if (this._table.hasQuality()) {
            this._viewMenu.addSeparator();
            this._viewMenu.add(this._viewQuality);
            this.ViewQuality_Action(_qualityStyle);
        }
        this._undefinedStyle = new JMenu("Show Missing As");
        this._undefinedStyleGroup = new ButtonGroup();
        this._undefinedStyleBlank = new JRadioButtonMenuItem("blank");
        this._undefinedStyleBlank.setSelected(true);
        this._undefinedStyleGroup.add(this._undefinedStyleBlank);
        this._undefinedStyle.add(this._undefinedStyleBlank);
        this._undefinedStyleBlank.addActionListener(this);
        this._undefinedStyle901 = new JRadioButtonMenuItem("-901.0");
        this._undefinedStyleGroup.add(this._undefinedStyle901);
        this._undefinedStyle.add(this._undefinedStyle901);
        this._undefinedStyle901.addActionListener(this);
        this._undefinedStyleM = new JRadioButtonMenuItem("   M");
        this._undefinedStyleGroup.add(this._undefinedStyleM);
        this._undefinedStyle.add(this._undefinedStyleM);
        this._undefinedStyleM.addActionListener(this);
        this._undefinedStyleDashM = new JRadioButtonMenuItem("  -M-");
        this._undefinedStyleGroup.add(this._undefinedStyleDashM);
        this._undefinedStyle.add(this._undefinedStyleDashM);
        this._undefinedStyleDashM.addActionListener(this);
        this._viewMenu.add(this._undefinedStyle);
        this._selectPDCurvesM = new JMenuItem("Select Curves...");
        this._selectPDCurvesM.setActionCommand("selectPDCurves");
        this._selectPDCurvesM.addActionListener(this);
        this._viewMenu.add(this._selectPDCurvesM);
        this._menuBar.add(this._viewMenu);
        this.setJMenuBar(this._menuBar);
        if (this._table != null && this._table.getTableType().startsWith("paired")) {
            this._undefinedStyle.setVisible(false);
            this._viewDateWith4Digits.setVisible(false);
            this._viewDateTimeAsTwoColumns.setVisible(false);
            this._reverseOrderMenu.setVisible(false);
        }
        if ((image = RmaImage.loadURLImage("Images/HecDssVue.png")) != null) {
            this.setIconImage(image);
            if (RmaJFrame.getDefaultIconImage() == null) {
                RmaJFrame.setDefaultIconImage(image);
            }
        }
        SymWindow aSymWindow = new SymWindow();
        this.addWindowListener(aSymWindow);
        this._editMenu.addMenuListener(new EditMenuListener());
        this._fileMenu.addMenuListener(new FileMenuListener());
    }

    public int setData(List dataSets) {
        int status = this._table.setData(dataSets, _showCommas, _qualityStyle);
        String type = this._table.getTableType();
        boolean curveSelectorVisible = false;
        if (type.startsWith("time")) {
            this._tableType = 1;
            if (this._reverseOrderMenu.getState()) {
                ((TimeSeriesDataModel)this._table.getModel()).setReverseOrder(true);
            }
            curveSelectorVisible = false;
        } else if (type.startsWith("paired")) {
            this._tableType = 2;
            for (int i = 0; i < dataSets.size(); ++i) {
                if (!(dataSets.get(i) instanceof PairedDataContainer)) continue;
                PairedDataContainer pdc = (PairedDataContainer)dataSets.get(i);
                if (pdc.numberCurves <= 1) continue;
                curveSelectorVisible = true;
                break;
            }
        }
        if (status == 0) {
            this._table.setDateTimeAsTwoColumns(this._showDateTimeAsTwoColumns);
            this._table.setDecimalPosition(this._decimalPositions);
            this.completeTable();
            final boolean fVisible = curveSelectorVisible;
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (HecDataTableFrame.this._selectPDCurvesM != null) {
                        HecDataTableFrame.this._selectPDCurvesM.setVisible(fVisible);
                    }
                }
            });
        }
        return status;
    }

    public int setData(DataContainer dataContainer) {
        if (dataContainer instanceof TimeSeriesContainer) {
            return this.setData((TimeSeriesContainer)dataContainer);
        }
        if (dataContainer instanceof PairedDataContainer) {
            return this.setData((PairedDataContainer)dataContainer);
        }
        return -1;
    }

    public int setData(TimeSeriesContainer timeSeriesContainer) {
        this._tableType = 1;
        int status = this._table.setData(timeSeriesContainer, _showCommas, _qualityStyle);
        if (status == 0) {
            this._table.setDateTimeAsTwoColumns(this._showDateTimeAsTwoColumns);
            if (this._reverseOrderMenu.getState()) {
                ((TimeSeriesDataModel)this._table.getModel()).setReverseOrder(true);
            }
            this.completeTable();
        }
        this._selectPDCurvesM.setVisible(false);
        return status;
    }

    public int setData(PairedDataContainer pairedDataContainer) {
        this._tableType = 2;
        int status = this._table.setData(pairedDataContainer, _showCommas, _qualityStyle);
        this.completeTable();
        if (pairedDataContainer.numberCurves == 1) {
            this._selectPDCurvesM.setVisible(false);
        }
        return status;
    }

    public int compareDataSets(List dataSets, int compareType, int precision, HecDouble compareValue, boolean ignoreMissing) {
        if (dataSets.size() < 2) {
            return -1;
        }
        int status = this._table.setData(dataSets, _showCommas, _qualityStyle);
        this._table.setDateTimeAsTwoColumns(this._showDateTimeAsTwoColumns);
        String type = this._table.getTableType();
        if (type.startsWith("time")) {
            this._tableType = 1;
        } else if (type.startsWith("paired")) {
            this._tableType = 2;
        }
        int stat = this.compareDataSets(compareType, precision, compareValue.value(), ignoreMissing);
        this.completeTable();
        return stat;
    }

    public int[] getCompareDataSetOrdinates(List dataSets, int compareType, int precision, HecDouble compareValue, boolean ignoreMissing) {
        if (dataSets.size() < 2) {
            return null;
        }
        int status = this._table.setData(dataSets, _showCommas, _qualityStyle);
        this._table.setDateTimeAsTwoColumns(this._showDateTimeAsTwoColumns);
        String type = this._table.getTableType();
        if (type.startsWith("time")) {
            this._tableType = 1;
        } else if (type.startsWith("paired")) {
            this._tableType = 2;
        }
        int[] ordinates = this.getCompareDataSetOrdinates(compareType, precision, compareValue.value(), ignoreMissing);
        this.completeTable();
        return ordinates;
    }

    public String getCompareMessage() {
        DataModel model;
        if (this._tableType == 2 && (model = this._table.getTableModel()) instanceof PairedDataModel) {
            return ((PairedDataModel)model).getCompareMessage();
        }
        return "";
    }

    @Deprecated
    public int addDisplayObject(DataContainer dc) {
        return this.addData(dc);
    }

    public int addData(DataContainer dc) {
        int status = -1;
        if (dc instanceof TimeSeriesContainer) {
            TimeSeriesContainer tsc = (TimeSeriesContainer)dc;
            status = this._table.addData(tsc);
            this._table.setDateTimeAsTwoColumns(this._showDateTimeAsTwoColumns);
        } else if (dc instanceof PairedDataContainer) {
            PairedDataContainer pdc = (PairedDataContainer)dc;
            status = this._table.setData(pdc, _showCommas, _qualityStyle);
            this._table.setDateTimeAsTwoColumns(this._showDateTimeAsTwoColumns);
        }
        return status;
    }

    @Override
    public void setTransferHandler(TransferHandler transferHandler) {
        this._transferHandler = transferHandler;
        if (this._table != null) {
            this._table.setTransferHandler(this._transferHandler);
            this._table.setDragEnabled(true);
        }
    }

    public void setCommasState(boolean showCommas) {
        if (showCommas != _showCommas) {
            _showCommas = showCommas;
            if (this._viewCommas != null) {
                this._viewCommas.setSelected(_showCommas);
                this.ViewCommas_Action();
            }
        }
    }

    public void setDecimalPlaces(int decimalPlaces) {
        if (this._decimalPositions != decimalPlaces) {
            this._decimalPositions = decimalPlaces;
            if (this._decimalGroup != null) {
                this.selectDecimalMenu(decimalPlaces);
                this.showDecimalChange(decimalPlaces);
            }
        }
    }

    private void selectDecimalMenu(int decimalPlaces) {
        Enumeration<AbstractButton> iter = this._decimalGroup.getElements();
        int count = -1;
        while (iter.hasMoreElements()) {
            AbstractButton element = iter.nextElement();
            if (count == decimalPlaces) {
                element.setSelected(true);
                break;
            }
            ++count;
        }
    }

    public boolean getCommasState() {
        return _showCommas;
    }

    public void setReverseOrderState(boolean reverseOrder) {
        if (reverseOrder != this._reverseOrderMenu.getState()) {
            this._reverseOrderMenu.setState(reverseOrder);
            this.reverseOrder_Action(false);
        }
    }

    public void disableReverseOrder() {
        this._reverseOrderMenu.setVisible(false);
        this._reverseOrderMenu.setState(false);
        this.reverseOrder_Action(false);
    }

    public void setDateTimeAsTwoColumnsState(boolean showDateTimeAsTwoColumns) {
        if (showDateTimeAsTwoColumns != this._showDateTimeAsTwoColumns) {
            this._showDateTimeAsTwoColumns = showDateTimeAsTwoColumns;
            if (this._viewDateTimeAsTwoColumns != null) {
                this._viewDateTimeAsTwoColumns.setSelected(this._showDateTimeAsTwoColumns);
                this.ViewDateTime_Action();
            }
        }
    }

    public boolean getDateTimeAsTwoColumnsState() {
        return this._showDateTimeAsTwoColumns;
    }

    public void setQualityState(int qualityStyle) {
        this.ViewQuality_Action(qualityStyle);
    }

    protected void completeTable() {
        String title = this.getTitle();
        if (title == null || title.length() == 0) {
            this.setTitle(this._table.getNominalName());
        }
        this.buildMenu();
        int prec = this._table.getDecimalPosition();
        this._table.setPrecision(prec);
        int xloc = 50;
        int yloc = 50;
        if (this._preferences != null) {
            int savedXloc = this._preferences.getInt("xloc", -1);
            int savedYloc = this._preferences.getInt("yloc", -1);
            if (savedXloc > 0 && savedXloc < 900 && savedYloc > 0 && savedXloc < 800) {
                xloc = savedXloc + 15;
                yloc = savedYloc + 15;
                this._preferences.putInt("xloc", xloc);
                this._preferences.putInt("yloc", yloc);
            }
        }
        if (!this.isVisible()) {
            this.setLocation(xloc, yloc);
            this.setSize();
            this.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent e) {
                    HecDataTableFrame.this.tableResized();
                }

                @Override
                public void componentMoved(ComponentEvent e) {
                    HecDataTableFrame.this.tableMoved();
                }
            });
        }
    }

    protected void tableResized() {
        if (this._preferences != null && this._table.getRowCount() > 49) {
            int cols = this._table.getColumnCount();
            int width = this.getWidth();
            int height = this.getHeight();
            this._preferences.putInt(cols + " width", width);
            this._preferences.putInt("height", height);
        }
    }

    protected void tableMoved() {
        if (this._preferences != null) {
            int xloc = this.getX();
            int yloc = this.getY();
            this._preferences.putInt("xloc", xloc);
            this._preferences.putInt("yloc", yloc);
        }
    }

    public void setSize() {
        int height;
        this._table.setColumnWidths();
        int rows = this._table.getRowCount();
        int width = this.getPreferredTableWidth();
        if (width > 800) {
            width = 800;
        }
        if (width < 300) {
            width = 300;
        }
        if ((height = rows * 18 + 150) < 250) {
            height = 250;
        }
        if (height > 600) {
            height = 600;
        }
        if (this._preferences != null && this._table.getRowCount() > 49) {
            int cols = this._table.getColumnCount();
            int savedWidth = this._preferences.getInt(cols + " width", width);
            int savedHeight = this._preferences.getInt("height", height);
            if (savedWidth > 300 && savedHeight > 300) {
                width = savedWidth;
                height = savedHeight;
            }
        }
        this.setSize(width, height);
    }

    protected int getPreferredTableWidth() {
        TableColumnModel model = this._table.getColumnModel();
        int rows = model.getColumnCount();
        int width = 0;
        for (int i = 0; i < rows; ++i) {
            width += model.getColumn(i).getPreferredWidth();
        }
        return width;
    }

    public void allowEditing(boolean allowEdit) {
        this._saveAsItem.setEnabled(allowEdit);
        this._saveItem.setEnabled(allowEdit);
        this._allowEditing.setEnabled(allowEdit);
    }

    public void editData(boolean doEdit) {
        this._allowEditing.setState(doEdit);
        this.Edit_Action();
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        Object object = event.getSource();
        if (object == this._exitItem) {
            this.Exit_Action();
        } else if (object == this._allowEditing) {
            this.Edit_Action();
        } else if (object == this._editInsertRows) {
            this.insertRows_Action();
        } else if (object == this._editAppendRows) {
            this.appendRows_Action();
        } else if (object == this._editDeleteRows) {
            this.deleteRows_Action();
        } else if (object == this._editInsertColumn) {
            this.insertColumn_Action();
        } else if (object == this._editAppendColumn) {
            this.appendColumn_Action();
        } else if (object == this._editDeleteColumn) {
            this.deleteColumn_Action();
        } else if (object == this._viewCommas) {
            this.ViewCommas_Action();
        } else if (object == this._reverseOrderMenu) {
            this.reverseOrder_Action(true);
        } else if (object == this._viewDateTimeAsTwoColumns) {
            this.ViewDateTime_Action();
        } else if (object == this._viewDateWith4Digits) {
            this.ViewDate4Digit_Action();
        } else if (object == this._qualityNone) {
            this.ViewQuality_Action(0);
        } else if (object == this._qualitySymbol) {
            this.ViewQuality_Action(1);
        } else if (object == this._qualityHex) {
            this.ViewQuality_Action(2);
        } else if (object == this._saveItem) {
            this.save();
        } else if (object == this._saveAsItem) {
            this.saveAs();
        } else if (object == this._printItem) {
            this.printString();
        } else if (object == this._printPreview) {
            this.printPreview();
        } else if (object == this._export) {
            this.export();
        } else if (object == this._editCut) {
            this.cutSelection();
        } else if (object == this._editCopy) {
            this.copySelection();
        } else if (object == this._editPaste) {
            this.pasteSelection();
        } else if (object == this._editSelectAll) {
            this.selectAll();
        } else if (object == this._editFind) {
            this.find(event);
        } else if (object == this._editNextDiff) {
            this.nextDifference(event);
        } else if (object == this._editCompare) {
            this.compareData(-1);
        } else if (object == this._plotItem) {
            this.plot();
        } else if (object == this._decimalAuto) {
            this.showDecimalChange(-1);
        } else if (object == this._decimal0) {
            this.showDecimalChange(0);
        } else if (object == this._decimal1) {
            this.showDecimalChange(1);
        } else if (object == this._decimal2) {
            this.showDecimalChange(2);
        } else if (object == this._decimal3) {
            this.showDecimalChange(3);
        } else if (object == this._decimal4) {
            this.showDecimalChange(4);
        } else if (object == this._decimal5) {
            this.showDecimalChange(5);
        } else if (object == this._decimal6) {
            this.showDecimalChange(6);
        } else if (object == this._undefinedStyleBlank) {
            this.showUndefinedStyle(0);
        } else if (object == this._undefinedStyle901) {
            this.showUndefinedStyle(1);
        } else if (object == this._undefinedStyleM) {
            this.showUndefinedStyle(2);
        } else if (object == this._undefinedStyleDashM) {
            this.showUndefinedStyle(3);
        } else if (object == this._selectPDCurvesM) {
            this.selectPDCurves();
        }
    }

    protected void Exit_Action() {
        this.updateEdits();
        if (this._table.hasDataChanged()) {
            int n = JOptionPane.showConfirmDialog(this, "Save changes to data set?", "Save Edited Changes", 1);
            if (n == 0) {
                int errors = this.save();
                if (errors != 0) {
                    return;
                }
            } else if (n == 1) {
                this.terminate();
            } else {
                return;
            }
        }
        this.terminate();
    }

    protected void terminate() {
        this.setVisible(false);
        this.dispose();
    }

    public int updateContainers() {
        this.updateEdits();
        int[] firstError = new int[3];
        int numberErrors = this._table.updateContainers(firstError);
        if (numberErrors > 0) {
            StringBuffer message = new StringBuffer();
            if (numberErrors > 1) {
                message.append(numberErrors + " errors found.  First Error:\n");
            }
            if (firstError[2] == 0) {
                message.append("Invalid date / time at ordinate " + (firstError[0] + 1));
            } else {
                message.append("Dates / times are not ascending");
                HecTime time = new HecTime();
                time.set(firstError[1]);
                message.append("\n    Date / time at ordinate " + firstError[0] + " is " + time);
                time.set(firstError[2]);
                message.append("\n    Date / time at ordinate " + (firstError[0] + 1) + " is " + time);
            }
            JOptionPane.showMessageDialog(this, message.toString(), "Table error", 2);
            return numberErrors;
        }
        return 0;
    }

    public void saveAs() {
        int errors = this.updateContainers();
        if (errors == 0) {
            this._table.saveAs(this._parent);
        }
    }

    public int save() {
        int errors = this.updateContainers();
        if (errors == 0) {
            this._table.save(this._parent);
        }
        return errors;
    }

    protected void Edit_Action() {
        boolean edit = this._allowEditing.getState();
        if (this._table.isSorted()) {
            edit = false;
            this._allowEditing.setState(false);
            this._allowEditing.setEnabled(false);
            System.out.println("Cannot edit a table that has been sorted.");
            JOptionPane.showMessageDialog(null, "Cannot edit a table that has been sorted.  Tabulate again and then edit.", "Sorted table", 2);
            return;
        }
        this._table.allowSort(false);
        this.disableReverseOrder();
        this._table.setEditable(edit);
        this._table.setExtendable(edit, 2);
        this._saveItem.setEnabled(edit);
        if (this._tableType == 1 && this._table.getDataColumnCount() != 1) {
            edit = false;
            DataModel model = this._table.getTableModel();
            if (model instanceof TimeSeriesDataModel) {
                intContainer minInterval = new intContainer();
                intContainer maxInterval = new intContainer();
                ((TimeSeriesDataModel)model).getMinMaxIntervals(minInterval, maxInterval);
                if (minInterval.value == maxInterval.value) {
                    edit = this._allowEditing.getState();
                }
            }
        }
        if (this._editInsertRows == null) {
            this._editMenu.addSeparator();
            this._editInsertRows = new JMenuItem("Insert Rows...");
            this._editInsertRows.setEnabled(true);
            this._editInsertRows.setVisible(false);
            this._editInsertRows.addActionListener(this);
            this._editMenu.add(this._editInsertRows);
            this._editAppendRows.setEnabled(true);
            this._editAppendRows.setVisible(false);
            this._editAppendRows.addActionListener(this);
            this._editMenu.add(this._editAppendRows);
            this._editDeleteRows.setEnabled(true);
            this._editDeleteRows.setVisible(false);
            this._editDeleteRows.addActionListener(this);
            this._editMenu.add(this._editDeleteRows);
            this._qualityEditor = new HecDataTableQualityEditor(new MyQualityCallback());
            if (this._tableType == 2) {
                this._editMenu.addSeparator();
            }
            this._editInsertColumn.setEnabled(true);
            this._editInsertColumn.setVisible(false);
            this._editInsertColumn.addActionListener(this);
            this._editMenu.add(this._editInsertColumn);
            this._editAppendColumn.setEnabled(true);
            this._editAppendColumn.setVisible(false);
            this._editAppendColumn.addActionListener(this);
            this._editMenu.add(this._editAppendColumn);
            this._editDeleteColumn.setEnabled(true);
            this._editDeleteColumn.setVisible(false);
            this._editDeleteColumn.addActionListener(this);
            this._editMenu.add(this._editDeleteColumn);
        }
        this.enableEditMenuItems(edit);
    }

    protected void enableEditMenuItems(boolean edit) {
        if (this._editInsertRows != null) {
            this._editInsertRows.setVisible(edit);
            this._editDeleteRows.setVisible(edit);
            this._editInsertColumn.setVisible(edit);
            this._editAppendColumn.setVisible(edit);
            this._editDeleteColumn.setVisible(edit);
            if (this._qualityEditor != null) {
                this._qualityEditor.updateQualityMenuItems();
            }
            if (this.getTableType().startsWith("time")) {
                edit = false;
            }
            this._editAppendRows.setVisible(edit);
            this._editInsertColumn.setVisible(edit);
            this._editAppendColumn.setVisible(edit);
            if (this._table.getColumnCount() < 4) {
                edit = false;
            }
            this._editDeleteColumn.setVisible(edit);
        }
    }

    protected void insertRows_Action() {
        this._table.insertRow();
    }

    protected void appendRows_Action() {
        this._table.appendRows();
    }

    protected void deleteRows_Action() {
        int n;
        int number = this._table.getSelectedRowCount();
        if (number > 8 && (n = JOptionPane.showConfirmDialog(this, "Are you sure you want to delete " + number + " rows?", "Delete Rows", 0)) == 1) {
            return;
        }
        this._table.deleteRow();
    }

    protected void insertColumn_Action() {
        this._table.insertColumn();
        this.enableEditMenuItems(true);
    }

    protected void appendColumn_Action() {
        this._table.appendColumn();
        this.enableEditMenuItems(true);
    }

    protected void deleteColumn_Action() {
        int c2 = this._table.getSelectedColumnCount();
        if (c2 == 0) {
            return;
        }
        int n = JOptionPane.showConfirmDialog(this, "Are you sure you want to delete the entire column?", "Delete Column", 0);
        if (n == 0) {
            this._table.deleteColumn();
            this.enableEditMenuItems(true);
        }
    }

    protected void setEditSelection() {
        boolean isSelected = false;
        if (this._table.getSelectedColumnCount() > 0) {
            isSelected = true;
        }
        boolean edit = this._allowEditing.getState();
        if (!isSelected) {
            edit = false;
        }
        if (this._tableType == 2) {
            isSelected = this._table.getSelectedColumn() > 0;
            this._editInsertColumn.setEnabled(isSelected);
            this._editAppendColumn.setEnabled(isSelected);
            this._editDeleteColumn.setEnabled(isSelected);
        }
        this._editCut.setEnabled(edit);
        this._editPaste.setEnabled(edit);
    }

    public void showDecimalChange(int numberDecimals) {
        int oldPosition = this._decimalPositions;
        this._decimalPositions = numberDecimals;
        this._table.setDecimalPosition(numberDecimals);
        this.firePropertyChange(DECIMAL_PLACES_PROPERTY, oldPosition, numberDecimals);
    }

    public void showUndefinedStyle(int undefinedStyle) {
        this._table.setUndefinedStyle(undefinedStyle);
    }

    protected void ViewCommas_Action() {
        _showCommas = this._viewCommas.getState();
        this._table.setCommas(_showCommas);
        this.firePropertyChange(SHOW_COMMAS_PROPERTY, !_showCommas, _showCommas);
    }

    protected void reverseOrder_Action(boolean setProperty) {
        TableModel dm = this._table.getModel();
        if (dm instanceof TimeSeriesDataModel) {
            ((TimeSeriesDataModel)dm).setReverseOrder(this._reverseOrderMenu.getState());
            if (this.isVisible()) {
                ((TimeSeriesDataModel)dm).fireTableDataChanged();
            }
        }
        if (setProperty) {
            this.firePropertyChange(REVERSE_ORDER_PROPERTY, !this._reverseOrderMenu.getState(), this._reverseOrderMenu.getState());
        }
    }

    protected void ViewDateTime_Action() {
        this._showDateTimeAsTwoColumns = this._viewDateTimeAsTwoColumns.getState();
        this._table.setDateTimeAsTwoColumns(this._showDateTimeAsTwoColumns);
        this.firePropertyChange(SHOW_DATE_AS_TWO_COLUMNS, !this._showDateTimeAsTwoColumns, this._showDateTimeAsTwoColumns);
        if (this._allowEditing.isSelected()) {
            this._table.setEditable(true);
        }
    }

    protected void ViewDate4Digit_Action() {
        boolean showDateWith4Digits = this._viewDateWith4Digits.getState();
        int dateStyle = showDateWith4Digits ? 7 : 17;
        int oldDateStyle = this._table.getDateStyle();
        this._table.setDateStyle(dateStyle);
        TimeSeriesDataModel.setDefaultDateStyle(dateStyle);
    }

    public String getTableType() {
        return this._table.getTableType();
    }

    public boolean addDataToExistingTable(Vector newDataContainers) {
        int newDataSize = newDataContainers.size();
        if (newDataSize == 0) {
            return false;
        }
        Vector currentDataSets = this._table.getDataSets();
        String type = this._table.getTableType();
        boolean tsTable = false;
        if (type.equals("timeseries")) {
            tsTable = true;
        }
        for (int i = 0; i < newDataContainers.size(); ++i) {
            Object obj = newDataContainers.elementAt(i);
            if (obj instanceof TimeSeriesContainer && tsTable) {
                currentDataSets.add(obj);
                continue;
            }
            if (!(obj instanceof PairedDataContainer) || tsTable) continue;
            currentDataSets.add(obj);
        }
        int numberDecimals = this._table.getDecimalPosition();
        if (currentDataSets != null) {
            boolean editing = this._allowEditing.getState();
            this.getContentPane().remove(this._tableScrollPane);
            this._table = new HecDataTable(this);
            this._table.setData(currentDataSets, _showCommas, _qualityStyle);
            this._table.setDateTimeAsTwoColumns(this._showDateTimeAsTwoColumns);
            this._table.setDecimalPosition(numberDecimals);
            this._tableScrollPane = new JScrollPane(this._table);
            this.getContentPane().add((Component)this._tableScrollPane, "Center");
            if (editing) {
                this.Edit_Action();
            }
            if (this._transferHandler != null) {
                this._table.setTransferHandler(this._transferHandler);
                this._table.setDragEnabled(true);
            }
        }
        if (this._qualityGroup != null) {
            if (_qualityStyle == TimeSeriesQualityColumn.QUALITY_STYLE_SYMBOL) {
                this._qualitySymbol.setSelected(true);
            } else if (_qualityStyle == TimeSeriesQualityColumn.QUALITY_STYLE_HEX) {
                this._qualityHex.setSelected(true);
            } else {
                this._qualityNone.setSelected(true);
            }
        }
        this.setSize();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void ViewQuality_Action(int qualityStyle) {
        int oldQualityStyle = _qualityStyle;
        if (_qualityStyle != qualityStyle) {
            _qualityStyle = qualityStyle;
            Vector dataSets = this._table.getDataSets();
            int numberDecimals = this._table.getDecimalPosition();
            if (dataSets != null) {
                boolean editing = this._allowEditing.getState();
                this.getContentPane().remove(this._tableScrollPane);
                this._table = new HecDataTable(this);
                this._table.setData(dataSets, _showCommas, _qualityStyle);
                this._table.setDateTimeAsTwoColumns(this._showDateTimeAsTwoColumns);
                this._table.setDecimalPosition(numberDecimals);
                this._tableScrollPane = new JScrollPane(this._table);
                this.getContentPane().add((Component)this._tableScrollPane, "Center");
                if (editing) {
                    this.Edit_Action();
                }
                if (this._transferHandler != null) {
                    this._table.setTransferHandler(this._transferHandler);
                    this._table.setDragEnabled(true);
                }
            }
        }
        if (this._qualityGroup != null) {
            if (qualityStyle == 1) {
                this._qualitySymbol.setSelected(true);
            } else if (qualityStyle == 2) {
                this._qualityHex.setSelected(true);
            } else {
                this._qualityNone.setSelected(true);
            }
        }
        if (this._qualityEditor != null) {
            this._qualityEditor.updateQualityMenuItems();
        }
        this.setSize();
        this.firePropertyChange(QUALITY_STYLE, oldQualityStyle, _qualityStyle);
        this.validate();
        Object object = this.getTreeLock();
        synchronized (object) {
            this.validateTree();
        }
    }

    public void printString() {
        this.updateContainers();
        this._table.printData();
    }

    public void printPreview() {
        this.updateContainers();
        this._table.printPreview();
    }

    public void export() {
        this.updateContainers();
        if (_showCommas) {
            this._table.setCommas(false);
        }
        this._table.exportData();
        if (_showCommas) {
            this.ViewCommas_Action();
        }
    }

    public void export(String fileName, TableExportOptions options) {
        this.updateContainers();
        if (_showCommas) {
            this._table.setCommas(false);
        }
        this._table.exportData(fileName, options);
        if (_showCommas) {
            this.ViewCommas_Action();
        }
    }

    public void export(BufferedWriter writer, TableExportOptions options) {
        this.updateContainers();
        if (_showCommas) {
            this._table.setCommas(false);
        }
        this._table.exportData(writer, options);
        if (_showCommas) {
            this.ViewCommas_Action();
        }
    }

    public String getExportString(TableExportOptions options) {
        this.updateContainers();
        if (_showCommas) {
            this._table.setCommas(false);
        }
        String s = this._table.getExportString(options);
        if (_showCommas) {
            this.ViewCommas_Action();
        }
        return s;
    }

    public void exportAsXML(BufferedWriter writer, String title, String indent) {
        this.updateContainers();
        if (_showCommas) {
            this._table.setCommas(false);
        }
        this._table.exportAsXML(writer, title, indent);
        if (_showCommas) {
            this.ViewCommas_Action();
        }
    }

    public void exportAsXML(BufferedWriter writer) {
        this.updateContainers();
        if (_showCommas) {
            this._table.setCommas(false);
        }
        this._table.exportAsXML(writer);
        if (_showCommas) {
            this.ViewCommas_Action();
        }
    }

    public void exportAsXML(String fileName, String title, String indent) {
        this.updateContainers();
        if (_showCommas) {
            this._table.setCommas(false);
        }
        this._table.exportAsXML(fileName, title, indent);
        if (_showCommas) {
            this.ViewCommas_Action();
        }
    }

    public void exportAsXML(String fileName) {
        this.updateContainers();
        if (_showCommas) {
            this._table.setCommas(false);
        }
        this._table.exportAsXML(fileName);
        if (_showCommas) {
            this.ViewCommas_Action();
        }
    }

    public String getXMLExportString(String title, String indent) {
        this.updateContainers();
        if (_showCommas) {
            this._table.setCommas(false);
        }
        String s = this._table.getXMLExportString(title, indent);
        if (_showCommas) {
            this.ViewCommas_Action();
        }
        return s;
    }

    public String getXMLExportString() {
        this.updateContainers();
        if (_showCommas) {
            this._table.setCommas(false);
        }
        String s = this._table.getXMLExportString();
        if (_showCommas) {
            this.ViewCommas_Action();
        }
        return s;
    }

    public void exportAsHTML(BufferedWriter writer, String title, String indent) {
        this.updateContainers();
        if (_showCommas) {
            this._table.setCommas(false);
        }
        this._table.exportAsHTML(writer, title, indent);
        if (_showCommas) {
            this.ViewCommas_Action();
        }
    }

    public void exportAsHTML(BufferedWriter writer) {
        this.updateContainers();
        if (_showCommas) {
            this._table.setCommas(false);
        }
        this._table.exportAsHTML(writer);
        if (_showCommas) {
            this.ViewCommas_Action();
        }
    }

    public void exportAsHTML(String fileName, String title, String indent) {
        this.updateContainers();
        if (_showCommas) {
            this._table.setCommas(false);
        }
        this._table.exportAsHTML(fileName, title, indent);
        if (_showCommas) {
            this.ViewCommas_Action();
        }
    }

    public void exportAsHTML(String fileName) {
        this.updateContainers();
        if (_showCommas) {
            this._table.setCommas(false);
        }
        this._table.exportAsHTML(fileName);
        if (_showCommas) {
            this.ViewCommas_Action();
        }
    }

    public String getHTMLExportString(String title, String indent) {
        this.updateContainers();
        if (_showCommas) {
            this._table.setCommas(false);
        }
        String s = this._table.getHTMLExportString(title, indent);
        if (_showCommas) {
            this.ViewCommas_Action();
        }
        return s;
    }

    public String getHTMLExportString() {
        this.updateContainers();
        if (_showCommas) {
            this._table.setCommas(false);
        }
        String s = this._table.getHTMLExportString();
        if (_showCommas) {
            this.ViewCommas_Action();
        }
        return s;
    }

    public int getColumn(String columnHeader) {
        String[] columnHeaders = this._table.getColumnLabels();
        int col = -1;
        for (int i = 0; i < columnHeaders.length; ++i) {
            if (!columnHeader.equalsIgnoreCase(columnHeaders[i])) continue;
            col = i;
            break;
        }
        return col;
    }

    public int getColumn(DataContainer dc) {
        Object header = null;
        if (dc instanceof TimeSeriesContainer) {
            TimeSeriesContainer tsc = (TimeSeriesContainer)dc;
            header = tsc.location + "\n" + tsc.parameter + "\n" + tsc.version;
        } else if (dc instanceof PairedDataContainer) {
            PairedDataContainer pd = (PairedDataContainer)dc;
            header = pd.xparameter;
        }
        return this.getColumn((String)header);
    }

    public String[] getColumnLabels() {
        return this._table.getColumnLabels();
    }

    public String getColumnLabel(int colNum) {
        return this._table.getColumnLabel(colNum);
    }

    public void setColumnLabels(String[] labels) {
        this._table.setColumnLabels(labels);
    }

    public void setColumnLabel(int colNum, String label) {
        this._table.setColumnLabel(colNum, label);
    }

    public int[] getColumnWidths() {
        return this._table.getColumnWidths();
    }

    public void setColumnWidths(int[] widths) {
        this._table.setColumnWidths(widths);
    }

    public int getColumnWidth(int col) {
        return this._table.getColumnWidth(col);
    }

    public void setColumnWidth(int col, int width) {
        this._table.setColumnWidth(col, width);
    }

    public void setColumnPrecision(int col, int precision) {
        int dataCol = col - this._table.getFirstDataColumn();
        this._table.setDecimalPosition(dataCol, precision);
        this._table.setColumnPrecision(col, precision);
    }

    public int getColumnPrecision(int col) {
        return this._table.getDecimalPosition(col);
    }

    public Color getColumnHeaderForeground(int col) {
        return this._table.getColumnHeaderForeground(col);
    }

    public String getColumnHeaderForegroundString(int col) {
        return RMAIO.color2String(this.getColumnHeaderForeground(col));
    }

    public void setColumnHeaderForeground(int colNum, Color color) {
        this._table.setColumnHeaderForeground(colNum, color);
    }

    public void setColumnHeaderForeground(int colNum, String color) {
        this._table.setColumnHeaderForeground(colNum, RMAIO.parseColorString(color));
    }

    public Color getColumnHeaderBackground(int col) {
        return this._table.getColumnHeaderBackground(col);
    }

    public String getColumnHeaderBackgroundString(int col) {
        return RMAIO.color2String(this.getColumnHeaderBackground(col));
    }

    public void setColumnHeaderBackground(int colNum, Color color) {
        this._table.setColumnHeaderBackground(colNum, color);
    }

    public void setColumnHeaderBackground(int colNum, String color) {
        this._table.setColumnHeaderBackground(colNum, RMAIO.parseColorString(color));
    }

    public Font getColumnHeaderFont(int colNum) {
        return this._table.getColumnHeaderFont(colNum);
    }

    public String getColumnHeaderFontString(int colNum) {
        return G2dMarkerProperties.font2string(this._table.getColumnHeaderFont(colNum));
    }

    public void setColumnHeaderFont(int colNum, Font font) {
        this._table.setColumnHeaderFont(colNum, font);
    }

    public void setColumnHeaderFont(int colNum, String font) {
        this._table.setColumnHeaderFont(colNum, G2dMarkerProperties.string2font(font));
    }

    public Color getRowForeground(int rowNum) {
        return this._table.getRowForeground(rowNum);
    }

    public String getRowForegroundString(int rowNum) {
        return RMAIO.color2String(this._table.getRowForeground(rowNum));
    }

    public void setRowForeground(int rowNum, Color color) {
        this._table.setRowForeground(rowNum, color);
    }

    public void setRowForeground(int rowNum, String color) {
        this._table.setRowForeground(rowNum, RMAIO.parseColorString(color));
    }

    public Color getRowBackground(int rowNum) {
        return this._table.getRowBackground(rowNum);
    }

    public String getRowBackgroundString(int rowNum) {
        return RMAIO.color2String(this._table.getRowBackground(rowNum));
    }

    public void setRowBackground(int rowNum, Color color) {
        this._table.setRowBackground(rowNum, color);
    }

    public void setRowBackground(int rowNum, String color) {
        this._table.setRowBackground(rowNum, RMAIO.parseColorString(color));
    }

    public Color getColumnForeground(int columnNum) {
        return this._table.getColumnForeground(columnNum);
    }

    public String getColumnForegroundString(int columnNum) {
        return RMAIO.color2String(this._table.getColumnForeground(columnNum));
    }

    public void setColumnForeground(int columnNum, Color color) {
        this._table.setColumnForeground(columnNum, color);
    }

    public void setColumnForeground(int columnNum, String color) {
        this._table.setColumnForeground(columnNum, RMAIO.parseColorString(color));
    }

    public Color getColumnBackground(int columnNum) {
        return this._table.getColumnBackground(columnNum);
    }

    public String getColumnBackgroundString(int columnNum) {
        return RMAIO.color2String(this._table.getColumnBackground(columnNum));
    }

    public void setColumnBackground(int columnNum, Color color) {
        this._table.setColumnBackground(columnNum, color);
    }

    public void setColumnBackground(int columnNum, String color) {
        this._table.setColumnBackground(columnNum, RMAIO.parseColorString(color));
    }

    public Color getCellForeground(int row, int col) {
        return this._table.getCellForeground(row, col);
    }

    public String getCellForegroundString(int row, int col) {
        return RMAIO.color2String(this._table.getCellForeground(row, col));
    }

    public void setCellForeground(int row, int col, Color color) {
        this._table.setCellForeground(row, col, color);
    }

    public void setCellForeground(int row, int col, String color) {
        this._table.setCellForeground(row, col, RMAIO.parseColorString(color));
    }

    public Color getCellBackground(int row, int col) {
        return this._table.getCellBackground(row, col);
    }

    public String getCellBackgroundString(int row, int col) {
        return RMAIO.color2String(this._table.getCellBackground(row, col));
    }

    public void setCellBackground(int row, int col, Color color) {
        this._table.setCellBackground(row, col, color);
    }

    public void setCellBackground(int row, int col, String color) {
        this._table.setCellBackground(row, col, RMAIO.parseColorString(color));
    }

    public void selectAll() {
        this.updateEdits();
        this._table.selectAll();
    }

    public void find(ActionEvent event) {
        boolean f3Key = false;
        if (event != null) {
            if (event.getModifiers() == 0) {
                f3Key = true;
            }
            if (f3Key && this._editNextDiff.isVisible()) {
                this.nextDifference(null);
                return;
            }
        }
        boolean timeSeries = true;
        if (this._table.getTableType().startsWith("paired")) {
            timeSeries = false;
        }
        if (this._findDialog == null) {
            f3Key = false;
            this._findDialog = new TableFindDialog((Frame)this, false, timeSeries, this);
            this._findDialog.setLocationRelativeTo(this);
        }
        if (f3Key) {
            this._findDialog.findNext();
        } else {
            this._findDialog.pack();
            this._findDialog.setVisible(true);
        }
    }

    @Override
    public boolean selectFirstRecord(String match, boolean wrap, boolean wholeWord, boolean searchTimes) {
        int startingRow = this._table.getSelectedRow();
        if (startingRow < 0) {
            startingRow = 0;
        }
        if ((startingRow = this._table.convertRowIndexToModel(startingRow)) < 0) {
            startingRow = 0;
        }
        int startingColumn = this._table.getSelectedColumn() + 1;
        return this.search(match, wholeWord, searchTimes, true, startingRow, startingColumn);
    }

    @Override
    public boolean selectLastRecord(String match, boolean wholeWord, boolean searchTimes) {
        int startingRow = this._table.getSelectedRow();
        if (startingRow < 0) {
            startingRow = 0;
        }
        if ((startingRow = this._table.convertRowIndexToModel(startingRow)) < 0) {
            startingRow = 0;
        }
        int startingColumn = this._table.getSelectedColumn() - 1;
        return this.search(match, wholeWord, searchTimes, false, startingRow, startingColumn);
    }

    protected boolean search(String match, boolean wholeWord, boolean searchTimes, boolean down, int startingRow, int startingColumn) {
        boolean found;
        Dimension rowCol = new Dimension();
        int firstColumn = 1;
        if (!searchTimes && this._table.getTableType().startsWith("time")) {
            firstColumn = 2;
            if (this._showDateTimeAsTwoColumns) {
                firstColumn = 3;
            }
        }
        if (found = this._table.find(match, startingRow, startingColumn, firstColumn, wholeWord, down, rowCol)) {
            this._table.setColumnSelectionInterval(rowCol.width, rowCol.width);
            this._table.setRowSelectionInterval(rowCol.height, rowCol.height, true);
            return true;
        }
        return false;
    }

    public void setShownNextOrdinate(int[] ordinates) {
        if (ordinates == null || ordinates.length == 0) {
            JOptionPane.showMessageDialog(this, "No differences to show.");
            return;
        }
        this._ordinatesDifferent = Arrays.copyOf(ordinates, ordinates.length);
        this._editNextDiff.setEnabled(true);
        this._editNextDiff.setVisible(true);
        this._editCompare.setEnabled(false);
        this._editCompare.setVisible(false);
        this.nextDifference(null);
    }

    protected void nextDifference(ActionEvent event) {
        boolean found;
        if (event != null) {
            boolean f3Key = true;
            if (event.getModifiers() != 0) {
                f3Key = false;
            }
            if (f3Key && !this._editNextDiff.isVisible()) {
                return;
            }
        }
        if (!(found = this.jumpToNextOridnate())) {
            int startingRow = this._table.getSelectedRow();
            if (startingRow < 0) {
                return;
            }
            int opt = JOptionPane.showConfirmDialog(this, "Reached end of data set.\nStart from the beginning?", "Next Difference", 0);
            if (opt == 1) {
                return;
            }
            this._table.setRowSelectionInterval(0, 0, false);
            this.jumpToNextOridnate();
        }
    }

    protected boolean jumpToNextOridnate() {
        if (this._ordinatesDifferent == null) {
            return false;
        }
        int startingRow = this._table.getSelectedRow();
        if (startingRow >= 0) {
            startingRow = this._table.convertRowIndexToModel(startingRow);
        }
        int foundRow = -1;
        for (int i = 0; i < this._ordinatesDifferent.length; ++i) {
            if (this._ordinatesDifferent[i] == startingRow || this._ordinatesDifferent[i] <= startingRow || i > 0 && this._ordinatesDifferent[i] - 1 == this._ordinatesDifferent[i - 1]) continue;
            foundRow = this._ordinatesDifferent[i];
            break;
        }
        if (foundRow > -1) {
            if (foundRow > 0) {
                this._table.setRowSelectionInterval(foundRow - 1, foundRow - 1, true);
                this._table.setRowSelectionInterval(foundRow, foundRow, false);
            } else {
                this._table.setRowSelectionInterval(foundRow, foundRow, true);
            }
            return true;
        }
        return false;
    }

    public void copyAll() {
        this.updateEdits();
        String copyString = this._table.allDataString();
        StringSelection selection = new StringSelection(copyString);
        this._sysClipboard.setContents(selection, null);
    }

    protected void updateEdits() {
        AbstractCellEditor cellEditor = null;
        cellEditor = (AbstractCellEditor)((Object)this._table.getCellEditor());
        if (cellEditor != null) {
            cellEditor.stopCellEditing();
        }
    }

    public void cutSelection() {
        this.updateEdits();
        this._table.cut();
    }

    public void copySelection() {
        this.updateEdits();
        String copyString = this._table.getSelectedDataString();
        StringSelection selection = new StringSelection(copyString);
        this._sysClipboard.setContents(selection, null);
    }

    public void pasteSelection() {
        this.updateEdits();
        this._table.paste();
    }

    void printLongString(PrintJob pjob, Graphics pg, String s) {
        int pageNum = 1;
        int linesForThisPage = 0;
        int linesForThisJob = 0;
        if (!(pg instanceof PrintGraphics)) {
            throw new IllegalArgumentException("Graphics context not PrintGraphics");
        }
        StringReader sr = new StringReader(s);
        LineNumberReader lnr = new LineNumberReader(sr);
        int pageHeight = pjob.getPageDimension().height;
        int pageWidth = pjob.getPageDimension().width;
        Font helv = new Font("Courier", 0, 10);
        pg.setFont(helv);
        FontMetrics fm = pg.getFontMetrics(helv);
        int fontHeight = fm.getHeight();
        int fontDescent = fm.getDescent();
        int curHeight = 0;
        String pathname = "";
        String Header = "";
        boolean first = true;
        try {
            String nextLine;
            do {
                if (first) {
                    pathname = lnr.readLine();
                    Header = lnr.readLine();
                    first = false;
                }
                if ((nextLine = lnr.readLine()) == null) continue;
                if (curHeight + fontHeight > pageHeight - 4 * fontHeight) {
                    Object t = "";
                    t = (String)t + (++pageNum - 1);
                    linesForThisPage = 0;
                    pg.dispose();
                    pg = pjob.getGraphics();
                    if (pg != null) {
                        pg.setFont(helv);
                    }
                    curHeight = 0;
                }
                curHeight += fontHeight;
                if (pg == null) continue;
                if (curHeight - fontHeight == 0) {
                    pg.drawString(pathname, 0, curHeight - fontDescent);
                    pg.drawString(Header, 0, (curHeight += fontHeight) - fontDescent);
                    curHeight += fontHeight;
                }
                pg.drawString(nextLine, 0, curHeight - fontDescent);
                ++linesForThisPage;
                ++linesForThisJob;
            } while (nextLine != null);
        }
        catch (EOFException t) {
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    protected void plot() {
        int numberErrors = this.updateContainers();
        if (numberErrors == 0) {
            this._table.plot(this);
        }
    }

    @Scriptable
    public void setTableTitleText(String text) {
        this._title.setText(text);
    }

    @Scriptable
    public String getTableTitleText() {
        return this._title.getText();
    }

    @Scriptable
    public Title getTableTitle() {
        return this._title;
    }

    public int compareDataSets(int compareType, int precision, double compareValue, boolean ignoreMissing) {
        int[] ordinates = this.getCompareDataSetOrdinates(compareType, precision, compareValue, ignoreMissing);
        if (ordinates == null) {
            return -1;
        }
        return ordinates.length;
    }

    public int[] getCompareDataSetOrdinates(int compareType, int precision, double toleranceOrPrecent, boolean ignoreMissing) {
        DataModel model;
        if (this._tableType == 1) {
            int numberColumns = this._table.getColumnCount();
            int numberRows = this._table.getRowCount();
            if (numberColumns < 2) {
                return null;
            }
            int[] rows = new int[numberRows];
            int numberDifferent = 0;
            int firstRow = this._table.getFirstDataRow();
            int firstColumn = this._table.getFirstDataColumn();
            if (precision > -1) {
                this._table.setPrecision(precision);
            }
            Font font = this._table.getFont();
            font = font.deriveFont(1);
            for (int i = firstRow; i < numberRows; ++i) {
                Object obj = this._table.getValueAt(i, firstColumn);
                boolean diff = false;
                if (obj instanceof HecDouble) {
                    HecDouble prime = (HecDouble)obj;
                    for (int j = firstColumn + 1; j < numberColumns; ++j) {
                        obj = this._table.getValueAt(i, j);
                        HecDouble comp = obj instanceof HecDouble ? (HecDouble)obj : new HecDouble();
                        boolean equal = false;
                        if (precision > -1) {
                            equal = prime.equals(comp);
                        } else if (compareType == 0) {
                            equal = prime.equalsWithinTolerance(comp, 0.0);
                        } else if (compareType == 1) {
                            equal = prime.equalsWithinPercent(comp, toleranceOrPrecent);
                        } else if (compareType == 2) {
                            equal = prime.equalsWithinTolerance(comp, toleranceOrPrecent);
                        }
                        if (ignoreMissing) {
                            if (!prime.isDefined()) {
                                equal = true;
                            }
                            if (!comp.isDefined()) {
                                equal = true;
                            }
                        }
                        if (equal) continue;
                        if (comp.isDefined()) {
                            this._table.setCellForeground(i, j, Color.red);
                            this._table.setCellFont(i, j, font);
                        } else {
                            this._table.setCellBackground(i, j, Color.red);
                        }
                        diff = true;
                    }
                }
                if (!diff) continue;
                rows[numberDifferent] = i;
                ++numberDifferent;
            }
            if (numberDifferent == 0) {
                return new int[0];
            }
            return Arrays.copyOf(rows, numberDifferent);
        }
        if (this._tableType == 2 && (model = this._table.getTableModel()) instanceof PairedDataModel) {
            int count = ((PairedDataModel)model).compareDataSets(precision);
            if (count < 0) {
                return new int[0];
            }
            return new int[count];
        }
        return null;
    }

    public List getContainersForSelectedRows(int[] ordinates) {
        Arrays.sort(ordinates);
        int firstRow = this._table.getFirstDataRow();
        int numberRows = this._table.getRowCount();
        if (this._tableType == 1) {
            TimeSeriesDataModel model = (TimeSeriesDataModel)this._table.getModel();
            model.resetToIrregular();
            Vector oldContainers = this._table.getDataContainers();
            TimeSeriesContainer[] newContainers = new TimeSeriesContainer[oldContainers.size()];
            for (int i = 0; i < oldContainers.size(); ++i) {
                TimeSeriesContainer tsc = (TimeSeriesContainer)oldContainers.elementAt(i);
                tsc = (TimeSeriesContainer)tsc.clone();
                tsc.numberValues = 0;
                tsc.times = new int[numberRows];
                tsc.values = new double[numberRows];
                newContainers[i] = tsc;
            }
            HecTimeArray timeArray = model.getTimeArray();
            int ncols = model.getDataColumnCount();
            int numberHeaderColumns = model.getColumnCount() - model.getDataColumnCount();
            for (int j = 0; j < ordinates.length; ++j) {
                int row = ordinates[j];
                int time = timeArray.element(row - firstRow).value();
                for (int col = 0; col < ncols; ++col) {
                    int pos = col + numberHeaderColumns;
                    Object obj = model.getValue(row, pos);
                    if (!(obj instanceof HecDouble)) continue;
                    int count = newContainers[col].numberValues++;
                    newContainers[col].times[count] = time;
                    newContainers[col].values[count] = ((HecDouble)obj).value();
                }
            }
            for (int i = 0; i < newContainers.length; ++i) {
                newContainers[i].times = Arrays.copyOf(newContainers[i].times, newContainers[i].numberValues);
                newContainers[i].values = Arrays.copyOf(newContainers[i].values, newContainers[i].numberValues);
                if (newContainers[i].numberValues <= 0) continue;
                newContainers[i].startTime = newContainers[i].times[0];
                newContainers[i].endTime = newContainers[i].times[newContainers[i].numberValues - 1];
            }
            return Arrays.asList(newContainers);
        }
        return null;
    }

    public int[] highlightValues(HecDouble value, double tolerance, int compareType) {
        int firstRow = this._table.getFirstDataRow();
        int firstColumn = this._table.getFirstDataColumn();
        int numberColumns = this._table.getColumnCount();
        int numberRows = this._table.getRowCount();
        int[] rows = new int[numberRows];
        int count = 0;
        Font font = this._table.getFont();
        font = font.deriveFont(1);
        for (int i = firstRow; i < numberRows; ++i) {
            for (int j = firstColumn; j < numberColumns; ++j) {
                HecDouble hecDouble;
                Object obj = this._table.getValueAt(i, j);
                if (!(obj instanceof HecDouble) || !this.compareValue(hecDouble = (HecDouble)obj, value.value(), tolerance, compareType)) continue;
                this._table.setCellForeground(i, j, Color.red);
                this._table.setCellFont(i, j, font);
                if (count > 0) {
                    if (rows[count - 1] == i) continue;
                    rows[count++] = i;
                    continue;
                }
                rows[count++] = i;
            }
        }
        return Arrays.copyOf(rows, count);
    }

    protected boolean compareValue(HecDouble value, double val, double tol, int type) {
        if (type == 1) {
            return value.equal(val, tol);
        }
        if (type == 2) {
            return value.greaterThan(val, tol);
        }
        if (type == 3) {
            return value.lessThan(val, tol);
        }
        if (type == 4) {
            return value.greaterThanEqual(val, tol);
        }
        return value.lessThanEqual(val, tol);
    }

    public int compareData(int precision) {
        int numberDifferent = this.compareDataSets(precision, 0, 0.0, false);
        if (numberDifferent == 0) {
            JOptionPane.showMessageDialog(this, "No differences between data sets");
        } else if (numberDifferent > 0) {
            this.repaint();
            JOptionPane.showMessageDialog(this, numberDifferent + " values are different");
        }
        return numberDifferent;
    }

    public JMenu getFileMenu() {
        return this._fileMenu;
    }

    public JMenu getEditMenu() {
        return this._editMenu;
    }

    public JMenu getViewMenu() {
        return this._viewMenu;
    }

    public HecDataTable getTable() {
        return this._table;
    }

    public void maximize() {
        this.setExtendedState(6);
    }

    public void minimize() {
        this.iconify();
    }

    public void iconify() {
        this.setExtendedState(1);
    }

    public void restore() {
        this.setExtendedState(0);
    }

    @Override
    public void setSize(int width, int height) {
        super.setSize(width, height);
        if (this.isVisible() && this._table != null) {
            this._table.getTableModel().fireTableStructureChanged();
            this._table.setMlHeaderRenderer();
            this.repaint();
        }
    }

    public void close() {
        this.terminate();
    }

    private void selectPDCurves() {
        PairedDataCurveSelector pdSelector = new PairedDataCurveSelector(this);
        Vector v = this._table.getDataContainers();
        if (pdSelector.setPairedData(v)) {
            pdSelector.setVisible(true);
        }
    }

    class SymWindow
    extends WindowAdapter {
        SymWindow() {
        }

        @Override
        public void windowClosing(WindowEvent event) {
            Object object = event.getSource();
            if (object == HecDataTableFrame.this) {
                HecDataTableFrame.this.Exit_Action();
            }
        }
    }

    protected class EditMenuListener
    implements MenuListener {
        protected EditMenuListener() {
        }

        @Override
        public void menuCanceled(MenuEvent event) {
        }

        @Override
        public void menuDeselected(MenuEvent event) {
        }

        @Override
        public void menuSelected(MenuEvent event) {
            HecDataTableFrame.this.setEditSelection();
        }
    }

    protected class FileMenuListener
    implements MenuListener {
        protected FileMenuListener() {
        }

        @Override
        public void menuCanceled(MenuEvent event) {
        }

        @Override
        public void menuDeselected(MenuEvent event) {
        }

        @Override
        public void menuSelected(MenuEvent event) {
            HecDataTableFrame.this._saveItem.setEnabled(HecDataTableFrame.this._table.hasDataChanged());
        }
    }

    private final class MyQualityCallback
    implements HecDataTableQualityEditor.QualityCallback {
        private MyQualityCallback() {
        }

        @Override
        public boolean hasQuality() {
            return HecDataTableFrame.this._table.hasQuality();
        }

        @Override
        public int getQualityStyle() {
            int retval = TimeSeriesQualityColumn.QUALITY_STYLE_NONE;
            if (HecDataTableFrame.this._table != null && this.hasQuality()) {
                retval = _qualityStyle;
            }
            return retval;
        }

        @Override
        public void updateQuality(IntUnaryOperator qualityFunction) {
            HecDataTableFrame.this._table.applyQuality(qualityFunction);
        }

        @Override
        public boolean isEditMode() {
            return HecDataTableFrame.this._allowEditing.getState();
        }

        @Override
        public JComponent getMenuComponent() {
            return HecDataTableFrame.this._editMenu;
        }
    }
}

