/*
 * Decompiled with CFR 0.152.
 */
package hec.dataTable;

import hec.dataTable.TimeSeriesQualityColumn;
import java.awt.Font;
import java.util.function.IntUnaryOperator;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import mil.army.usace.hec.data.timeseries.Quality;

final class HecDataTableQualityEditor {
    private static final String TOOLTIP_TEXT_NO_QUALITY = "Quality is turned off. Go to View Menu -> Quality to turn on and enable ";
    private static final String TOOLTIP_TEXT_CLEAR_QUALITY = "Clears all quality flags for the selected rows";
    private static final String TOOLTIP_TEXT_CLEAR_MISSING_QUALITY = "Clears the missing flag for the selected rows";
    private final JMenuItem _qualityClear = new JMenuItem("Clear Quality");
    private final JMenuItem _qualityClearMissing = new JMenuItem("Clear Missing Quality");
    private final JPopupMenu.Separator _qualitySeparator = new JPopupMenu.Separator();
    private final QualityCallback _qualityCallback;

    HecDataTableQualityEditor(QualityCallback qualityCallback) {
        this._qualityCallback = qualityCallback;
        if (this._qualityCallback.hasQuality()) {
            this.addMenuItems();
        }
        this.initListeners();
    }

    private void addMenuItems() {
        JComponent component = this._qualityCallback.getMenuComponent();
        component.add(this._qualitySeparator);
        component.add(this._qualityClear);
        component.add(this._qualityClearMissing);
        this._qualityClear.setFont(this._qualityCallback.getMenuItemFont());
        this._qualityClearMissing.setFont(this._qualityCallback.getMenuItemFont());
    }

    private void initListeners() {
        this._qualityClear.addActionListener(e -> this._qualityCallback.updateQuality(Quality::clearQuality_int));
        this._qualityClearMissing.addActionListener(e -> this._qualityCallback.updateQuality(Quality::clearMissing_int));
    }

    void updateQualityMenuItems() {
        int qualityStyle = this._qualityCallback.getQualityStyle();
        if (qualityStyle == TimeSeriesQualityColumn.QUALITY_STYLE_NONE) {
            this._qualityClearMissing.setToolTipText(TOOLTIP_TEXT_NO_QUALITY + this._qualityClearMissing.getText());
            this._qualityClear.setToolTipText(TOOLTIP_TEXT_NO_QUALITY + this._qualityClear.getText());
        } else {
            this._qualityClearMissing.setToolTipText(TOOLTIP_TEXT_CLEAR_MISSING_QUALITY);
            this._qualityClear.setToolTipText(TOOLTIP_TEXT_CLEAR_QUALITY);
        }
        this._qualityClearMissing.setEnabled(qualityStyle != TimeSeriesQualityColumn.QUALITY_STYLE_NONE);
        this._qualityClear.setEnabled(qualityStyle != TimeSeriesQualityColumn.QUALITY_STYLE_NONE);
        boolean editMode = this._qualityCallback.isEditMode();
        this._qualityClearMissing.setVisible(editMode);
        this._qualityClear.setVisible(editMode);
        this._qualitySeparator.setVisible(editMode);
    }

    static interface QualityCallback {
        public int getQualityStyle();

        public boolean hasQuality();

        public void updateQuality(IntUnaryOperator var1);

        public boolean isEditMode();

        public JComponent getMenuComponent();

        default public Font getMenuItemFont() {
            return new JMenuItem().getFont();
        }
    }
}

