/*
 * Decompiled with CFR 0.152.
 */
package hec.dataTable;

import hec.dataTable.DataModel;
import hec.dataTable.HecDataTable;
import hec.dataTable.TimeSeriesDataModel;
import hec.heclib.util.HecDouble;
import hec.heclib.util.HecTime;
import hec.heclib.util.intContainer;
import hec.io.DataContainer;
import hec.io.PairedDataContainer;
import hec.io.TimeSeriesCollectionContainer;
import hec.io.TimeSeriesContainer;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import java.util.Vector;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.CreationHelper;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import rma.util.RMAIO;

public class HecDataTableToExcel {
    Vector _tables = new Vector();
    File _xlFile = null;

    public static HecDataTableToExcel newTable() {
        return new HecDataTableToExcel();
    }

    public Workbook createXlsFile(String xlsFilename) throws Exception {
        Object wb = null;
        try {
            this._xlFile = new File(xlsFilename);
            String extention = RMAIO.getFileExtension(xlsFilename);
            wb = extention.length() > 0 && extention.equalsIgnoreCase(".xls") ? new HSSFWorkbook() : new XSSFWorkbook();
        }
        catch (Exception e) {
            throw new Exception(e);
        }
        return wb;
    }

    public Workbook createXlsxFile(String xlsxFilename) throws Exception {
        Object wb = null;
        try {
            this._xlFile = new File(xlsxFilename);
            String extention = RMAIO.getFileExtension(xlsxFilename);
            wb = extention.length() > 0 && extention.equalsIgnoreCase(".xls") ? new HSSFWorkbook() : new XSSFWorkbook();
        }
        catch (Exception e) {
            throw new Exception(e);
        }
        return wb;
    }

    protected boolean readEditedSheets() throws Exception {
        Workbook workbook = null;
        if (this._xlFile == null) {
            throw new Exception("No Excel File");
        }
        try {
            FileInputStream inputS = new FileInputStream(this._xlFile);
            workbook = WorkbookFactory.create((InputStream)inputS);
        }
        catch (Exception e) {
            System.out.println("No Excel File");
            throw new Exception(e);
        }
        try {
            for (int tableNumber = 0; tableNumber < this._tables.size(); ++tableNumber) {
                Sheet sheet = workbook.getSheetAt(tableNumber);
                HecDataTable table = (HecDataTable)this._tables.elementAt(tableNumber);
                DataModel model = table.getTableModel();
                HecDouble doubleTemp = new HecDouble();
                for (int j = 0; j < model.getRowCount(); ++j) {
                    Row row1 = sheet.getRow(j);
                    for (int i = 1; i < model.getColumnCount(); ++i) {
                        Cell cell = row1.getCell(i);
                        Object obj = model.getValueAt(j, i);
                        if (!(obj instanceof HecDouble) || cell.getCellType() != CellType.NUMERIC) continue;
                        double value = cell.getNumericCellValue();
                        doubleTemp.set((HecDouble)obj);
                        short precision = cell.getCellStyle().getDataFormat();
                        if (precision > doubleTemp.precision()) {
                            doubleTemp.setPrecision(precision);
                        }
                        doubleTemp.set(value);
                        model.setValueAt(doubleTemp, j, i);
                    }
                }
            }
        }
        catch (Exception e) {
            throw new Exception(e);
        }
        return true;
    }

    protected void createSheets(Workbook writableWorkbook, Vector jTables) throws Exception {
        if (writableWorkbook == null) {
            throw new Exception("Workbook not created");
        }
        HecTime hecTime = new HecTime();
        Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
        CreationHelper createHelper = writableWorkbook.getCreationHelper();
        CellStyle cStyle_ddMmmyyyy = writableWorkbook.createCellStyle();
        cStyle_ddMmmyyyy.setDataFormat(createHelper.createDataFormat().getFormat("ddMmmyyyy"));
        CellStyle cStyle_ddMmmyyyy_hhmm = writableWorkbook.createCellStyle();
        cStyle_ddMmmyyyy_hhmm.setDataFormat(createHelper.createDataFormat().getFormat("ddMmmyyyy  hhmm"));
        CellStyle cStyle0 = writableWorkbook.createCellStyle();
        cStyle0.setDataFormat(createHelper.createDataFormat().getFormat("0"));
        CellStyle cStyle1 = writableWorkbook.createCellStyle();
        cStyle1.setDataFormat(createHelper.createDataFormat().getFormat("0.0"));
        CellStyle cStyle2 = writableWorkbook.createCellStyle();
        cStyle2.setDataFormat(createHelper.createDataFormat().getFormat("0.00"));
        CellStyle cStyle3 = writableWorkbook.createCellStyle();
        cStyle3.setDataFormat(createHelper.createDataFormat().getFormat("0.000"));
        CellStyle cStyle4 = writableWorkbook.createCellStyle();
        cStyle4.setDataFormat(createHelper.createDataFormat().getFormat("0.0000"));
        CellStyle cStyle5 = writableWorkbook.createCellStyle();
        cStyle5.setDataFormat(createHelper.createDataFormat().getFormat("0.00000"));
        CellStyle cStyle6 = writableWorkbook.createCellStyle();
        cStyle6.setDataFormat(createHelper.createDataFormat().getFormat("0.000000"));
        CellStyle cellStyle = writableWorkbook.createCellStyle();
        cellStyle.setAlignment(HorizontalAlignment.RIGHT);
        try {
            for (int tableNumber = 0; tableNumber < jTables.size(); ++tableNumber) {
                int rowCount;
                Sheet sheet = writableWorkbook.createSheet("Sheet" + (tableNumber + 1));
                HecDataTable table = (HecDataTable)jTables.elementAt(tableNumber);
                DataModel model = table.getTableModel();
                boolean useDayHourFormat = false;
                if (model instanceof TimeSeriesDataModel) {
                    intContainer min = new intContainer();
                    intContainer max = new intContainer();
                    ((TimeSeriesDataModel)model).getMinMaxIntervals(min, max);
                    if (min.value < 1440) {
                        useDayHourFormat = true;
                    }
                }
                if ((rowCount = model.getRowCount()) > 65000) {
                    throw new Exception("Workbook not created. The maximum number of rows imported to an Excel worksheet is 65,000.\nCurrent row number is: " + rowCount + ".");
                }
                for (int j = 0; j < rowCount; ++j) {
                    Row row = sheet.createRow(j);
                    for (int i = 0; i < model.getColumnCount(); ++i) {
                        String s;
                        Cell cell = row.createCell(i);
                        Object obj = model.getValueAt(j, i);
                        if (obj instanceof HecDouble) {
                            HecDouble hecDouble = (HecDouble)obj;
                            if (hecDouble.isDefined()) {
                                cell.setCellValue(hecDouble.value());
                                if (hecDouble.precision() == 0) {
                                    cell.setCellStyle(cStyle0);
                                    continue;
                                }
                                if (hecDouble.precision() == 1) {
                                    cell.setCellStyle(cStyle1);
                                    continue;
                                }
                                if (hecDouble.precision() == 2) {
                                    cell.setCellStyle(cStyle2);
                                    continue;
                                }
                                if (hecDouble.precision() == 3) {
                                    cell.setCellStyle(cStyle3);
                                    continue;
                                }
                                if (hecDouble.precision() == 4) {
                                    cell.setCellStyle(cStyle4);
                                    continue;
                                }
                                if (hecDouble.precision() == 5) {
                                    cell.setCellStyle(cStyle5);
                                    continue;
                                }
                                if (hecDouble.precision() != 6) continue;
                                cell.setCellStyle(cStyle6);
                                continue;
                            }
                            cell.setCellValue("");
                            cell.setCellStyle(cellStyle);
                            continue;
                        }
                        if (i == 0) {
                            try {
                                int value = obj instanceof Integer ? (Integer)obj : Integer.parseInt(obj.toString().trim());
                                row.createCell(i).setCellValue((double)value);
                                continue;
                            }
                            catch (Exception value) {
                                // empty catch block
                            }
                        }
                        if (i == 1 && (s = obj.toString()).length() > 9) {
                            hecTime.setUndefined();
                            int status = hecTime.set(s);
                            if (status == 0) {
                                if (!hecTime.isTimeDefined()) {
                                    hecTime.setTime("0000");
                                }
                                Date d = hecTime.getJavaDate(0);
                                cal.setTime(d);
                                cell.setCellValue(cal);
                                if (useDayHourFormat) {
                                    cell.setCellStyle(cStyle_ddMmmyyyy_hhmm);
                                    continue;
                                }
                                cell.setCellStyle(cStyle_ddMmmyyyy);
                                continue;
                            }
                        }
                        cell.setCellValue(obj.toString());
                        cell.setCellStyle(cellStyle);
                    }
                }
                for (int p = 0; p < model.getColumnCount(); ++p) {
                    sheet.autoSizeColumn(p);
                }
            }
        }
        catch (Exception e) {
            throw new Exception(e);
        }
    }

    protected void writeWookbook(Workbook writableWorkbook) throws Exception {
        try {
            FileOutputStream fileOut = new FileOutputStream(this._xlFile.getPath());
            writableWorkbook.write((OutputStream)fileOut);
            fileOut.close();
        }
        catch (Exception e) {
            throw new Exception(e);
        }
    }

    protected void createTables(List dataSets) throws Exception {
        if (dataSets == null || dataSets.size() == 0) {
            throw new Exception("No data provided");
        }
        Object obj = dataSets.get(0);
        if (obj instanceof TimeSeriesContainer) {
            HecDataTable dataTable = new HecDataTable(null);
            dataTable.setData(dataSets, false, 0);
            dataTable.setDateTimeAsTwoColumns(false);
            dataTable.setDateStyle(0);
            if (((TimeSeriesContainer)obj).interval > 1400) {
                dataTable.setShowTimes(false);
            } else {
                dataTable.setShowTimes(true);
            }
            dataTable.setShowFullDefinition(true);
            this._tables.add(dataTable);
        } else if (obj instanceof PairedDataContainer) {
            Vector v1 = this.orderPairedDataContainers(dataSets);
            for (int k = 0; k < v1.size(); ++k) {
                HecDataTable dataTable = new HecDataTable(null);
                Vector v2 = (Vector)v1.elementAt(k);
                dataTable.setData(v2, false, 0);
                dataTable.setShowFullDefinition(true);
                this._tables.add(dataTable);
            }
        } else if (obj instanceof TimeSeriesCollectionContainer) {
            HecDataTable dataTable = new HecDataTable(null);
            dataTable.setData(dataSets, false, 0);
            dataTable.setDateTimeAsTwoColumns(false);
            dataTable.setDateStyle(0);
            this._tables.add(dataTable);
        } else {
            throw new Exception("Unknown data type");
        }
    }

    public Vector orderPairedDataContainers(List dataSets) {
        Vector v1 = new Vector();
        for (int j = 0; j < dataSets.size(); ++j) {
            boolean inVect = false;
            PairedDataContainer pdc = (PairedDataContainer)dataSets.get(j);
            block1: for (int k = 0; k < v1.size(); ++k) {
                Vector v2 = (Vector)v1.elementAt(k);
                for (int n = 0; n < v2.size(); ++n) {
                    PairedDataContainer p = (PairedDataContainer)v2.elementAt(n);
                    if (!p.xunits.equalsIgnoreCase(pdc.xunits) || !p.xtype.equalsIgnoreCase(pdc.xtype)) continue;
                    v2.add(pdc);
                    inVect = true;
                    continue block1;
                }
            }
            if (inVect) continue;
            Vector<PairedDataContainer> v = new Vector<PairedDataContainer>();
            v.add(pdc);
            v1.add(v);
        }
        return v1;
    }

    public Vector getEditedContainers() throws Exception {
        Vector<DataContainer> changedDataContainers = new Vector<DataContainer>();
        try {
            this.readEditedSheets();
        }
        catch (Exception e) {
            System.out.println(e.toString());
            throw new Exception(e);
        }
        int[] errorCodes = new int[3];
        for (int i = 0; i < this._tables.size(); ++i) {
            HecDataTable table = (HecDataTable)this._tables.elementAt(i);
            table.updateContainers(errorCodes);
            DataModel model = table.getTableModel();
            Vector containers = model.getDataContainers();
            for (int j = 0; j < containers.size(); ++j) {
                DataContainer dc = (DataContainer)containers.elementAt(j);
                changedDataContainers.add(dc);
            }
        }
        return changedDataContainers;
    }

    public void createExcelFile(Vector dataSets, String excelFilename) throws Exception {
        List[] list = new List[]{dataSets};
        this.createExcelFile(list, excelFilename);
    }

    public void createExcelFile(List[] dataSets, String excelFilename) throws Exception {
        Workbook writableWorkbook = null;
        try {
            writableWorkbook = this.createXlsxFile(excelFilename);
        }
        catch (Exception e) {
            StringBuffer errorMessage = new StringBuffer();
            errorMessage.append("Unable to access file ");
            errorMessage.append(excelFilename);
            errorMessage.append("\n");
            errorMessage.append(e.toString());
            System.out.println(errorMessage.toString());
            throw new Exception(errorMessage.toString());
        }
        if (writableWorkbook == null) {
            throw new Exception("Unable to access file " + excelFilename);
        }
        boolean createdOne = false;
        for (int i = 0; i < dataSets.length; ++i) {
            if (dataSets[i] == null || dataSets[i].size() <= 0) continue;
            this.createTables(dataSets[i]);
            createdOne = true;
        }
        if (!createdOne) {
            throw new Exception("No Data provided");
        }
        try {
            this.createSheets(writableWorkbook, this._tables);
            this.writeWookbook(writableWorkbook);
        }
        catch (Exception e) {
            StringBuffer errorMessage = new StringBuffer();
            errorMessage.append("Error in file ");
            errorMessage.append(excelFilename);
            errorMessage.append("\n");
            errorMessage.append(e.toString());
            System.out.println(errorMessage.toString());
            throw new Exception(errorMessage.toString());
        }
    }

    public void runExcel(Vector dataSets) throws Exception {
        List[] list = new List[]{dataSets};
        this.runExcel(list);
    }

    public void runExcel(List[] dataSets) throws Exception {
        String excelFilename = "C:\\HecDssExcel.xlsx";
        try {
            File file = File.createTempFile("HecDssExcel", ".xlsx");
            excelFilename = file.getCanonicalPath();
        }
        catch (Exception e) {
            StringBuffer errorMessage = new StringBuffer();
            errorMessage.append("Unable to create temporary file ");
            errorMessage.append(excelFilename);
            errorMessage.append("\n");
            errorMessage.append(e.toString());
            System.out.println(e.toString());
            throw new Exception(errorMessage.toString());
        }
        this.runExcel(dataSets, excelFilename);
    }

    public void runExcel(Vector dataSets, String excelFilename) throws Exception {
        List[] list = new List[]{dataSets};
        this.runExcel(list, excelFilename);
    }

    public void runExcel(List[] dataSets, String excelFilename) throws Exception {
        try {
            this.createExcelFile(dataSets, excelFilename);
        }
        catch (Exception e) {
            throw new Exception(e);
        }
        String[] cmd = new String[]{"rundll32", "url.dll,FileProtocolHandler", excelFilename};
        Process process = null;
        System.out.println("exec:" + cmd[0] + " " + cmd[1] + " " + cmd[2]);
        try {
            process = Runtime.getRuntime().exec(cmd);
        }
        catch (Exception e) {
            StringBuffer errorMessage = new StringBuffer();
            errorMessage.append("Error in executing Excel.\n");
            System.out.println(e.toString());
            throw new Exception(errorMessage.toString());
        }
    }
}

