/*
 * Decompiled with CFR 0.152.
 */
package hec.dataTable;

import hec.dataTable.SavableDataFrame;
import hec.heclib.util.HecDouble;
import hec.heclib.util.HecDoubleArray;
import hec.heclib.util.HecTime;
import hec.io.PairedDataContainer;
import java.util.Iterator;
import java.util.Vector;

public class PairedDataCurve {
    protected PairedDataContainer _pairedDataContainer = null;
    protected HecDoubleArray _xArray = null;
    protected Vector<HecDoubleArray> _yArrays;
    protected Vector<HecDoubleArray> _allYCurves;
    protected Vector<String> _labels = new Vector();
    protected Vector<String> _parameters = null;
    protected Vector<String> _units = null;
    protected boolean _dataChanged = false;
    int _numberHeaderRows = 3;
    boolean _isExtendable = false;
    boolean _isEditable = false;
    int _numberBlankRows = 0;
    private Vector<Boolean> _visibleCurves;
    private int _colCount = -1;

    public PairedDataCurve(PairedDataContainer pairedDataContainer) {
        this.setData(pairedDataContainer);
    }

    public int setData(PairedDataContainer pairedDataContainer) {
        int i;
        this._pairedDataContainer = pairedDataContainer;
        this._xArray = new HecDoubleArray(this._pairedDataContainer.numberOrdinates);
        if (this._pairedDataContainer.numberOrdinates > 0) {
            this._xArray.set(this._pairedDataContainer.xOrdinates);
        }
        if (this._pairedDataContainer.xprecision != -1) {
            this._xArray.setPrecision(this._pairedDataContainer.xprecision);
        } else {
            int pre = this._xArray.estimatePrecision();
            this._xArray.setPrecision(pre);
        }
        this._visibleCurves = new Vector(this._pairedDataContainer.numberCurves);
        for (i = 0; i < this._pairedDataContainer.numberCurves; ++i) {
            this._visibleCurves.add(Boolean.TRUE);
        }
        if (this._pairedDataContainer.curveVisible != null) {
            for (i = 0; i < this._pairedDataContainer.curveVisible.length; ++i) {
                this._visibleCurves.set(i, this._pairedDataContainer.curveVisible[i]);
            }
        }
        this.countVisibleColumns();
        this._yArrays = new Vector(this._colCount);
        this._allYCurves = new Vector(this._colCount);
        if (this._pairedDataContainer.parameters != null && this._parameters == null) {
            this._parameters = new Vector();
        }
        if (this._pairedDataContainer.units != null && this._units == null) {
            this._units = new Vector();
        }
        for (i = 0; i < this._pairedDataContainer.numberCurves; ++i) {
            HecDoubleArray da = new HecDoubleArray(this._pairedDataContainer.numberOrdinates);
            if (this._pairedDataContainer.numberOrdinates > 0) {
                da.set(this._pairedDataContainer.yOrdinates[i]);
                if (this._pairedDataContainer.yprecision != -1) {
                    da.setPrecision(this._pairedDataContainer.yprecision);
                } else {
                    int pre = da.estimatePrecision();
                    da.setPrecision(pre);
                }
            }
            if (this._visibleCurves.get(i).booleanValue()) {
                this._yArrays.add(da);
                if (this._pairedDataContainer.labelsUsed) {
                    this._labels.addElement(this._pairedDataContainer.labels[i]);
                } else {
                    this._labels.addElement("");
                }
                int ipos = i + 1;
                if (this._pairedDataContainer.parameters != null) {
                    if (ipos < this._pairedDataContainer.parameters.length) {
                        this._parameters.addElement(this._pairedDataContainer.parameters[ipos]);
                    } else {
                        this._parameters.addElement("");
                    }
                }
                if (this._pairedDataContainer.units != null) {
                    if (ipos < this._pairedDataContainer.units.length) {
                        this._units.addElement(this._pairedDataContainer.units[ipos]);
                    } else {
                        this._units.addElement("");
                    }
                }
            }
            this._allYCurves.add(da);
        }
        this.checkPrecision();
        return 0;
    }

    private void countVisibleColumns() {
        if (this._visibleCurves == null || this._visibleCurves.size() == 0) {
            this._colCount = this._yArrays != null ? this._yArrays.size() : 0;
        }
        this._colCount = 0;
        for (int i = 0; i < this._visibleCurves.size(); ++i) {
            if (!this._visibleCurves.get(i).booleanValue()) continue;
            ++this._colCount;
        }
    }

    public int getColumnCount() {
        if (this._colCount < 0) {
            return this._yArrays.size();
        }
        return this._colCount;
    }

    public int getNumberValues() {
        return this.getRowCount();
    }

    public int getRowCount() {
        if (this._xArray == null) {
            return 0;
        }
        return this._xArray.numberElements();
    }

    public String getXParameter() {
        if (this._pairedDataContainer.xparameter != null && this._pairedDataContainer.xparameter.length() > 0) {
            return this._pairedDataContainer.xparameter;
        }
        if (this._pairedDataContainer.parameters != null && this._pairedDataContainer.parameters[0].length() > 0) {
            return this._pairedDataContainer.parameters[0];
        }
        return "X parameter";
    }

    public String getColumnName(int col) {
        if (this._pairedDataContainer != null) {
            StringBuffer sb = new StringBuffer();
            if (this._pairedDataContainer.location.length() > 0) {
                sb.append(this._pairedDataContainer.location);
                sb.append("\n");
            }
            if (this._parameters != null) {
                sb.append(this._parameters.get(col));
            } else if (this._pairedDataContainer.yparameter.length() > 0) {
                sb.append(this._pairedDataContainer.yparameter);
            }
            String name = sb.toString();
            return name;
        }
        return "";
    }

    public String getNominalName() {
        return this._pairedDataContainer.fullName;
    }

    public String getName() {
        String name = this._pairedDataContainer.location + "-" + this._pairedDataContainer.xparameter + "-" + this._pairedDataContainer.yparameter;
        return name;
    }

    public PairedDataContainer getDataContainer() {
        return this._pairedDataContainer;
    }

    public Object getValueAt(int row, int column) {
        if (column < 0 || column >= this.getColumnCount()) {
            return null;
        }
        if (row < 0 || row >= this.getRowCount()) {
            return null;
        }
        if (row == 0) {
            return this._labels.elementAt(column);
        }
        if (row == 1 && this._numberHeaderRows >= 2) {
            if (this._units != null) {
                return this._units.get(column);
            }
            if (column == 0) {
                return this._pairedDataContainer.yunits;
            }
            return "";
        }
        if (row == 2 && this._numberHeaderRows >= 3) {
            if (column == 0) {
                return this._pairedDataContainer.ytype;
            }
            return "";
        }
        return this.getHecDouble(row -= this._numberHeaderRows, column);
    }

    public HecDouble getXValue(int row) {
        return this._xArray.element(row);
    }

    public Object getHecDouble(int row, int column) {
        HecDouble value = this._yArrays.elementAt(column).element(row);
        if (value.value() > 1000000.0 && this._pairedDataContainer.numberCurves > 1 && this._pairedDataContainer.labelsUsed && this._pairedDataContainer.labels[0].toLowerCase().indexOf("minut") > -1) {
            HecTime htime = new HecTime();
            htime.set((int)value.value());
            return htime.toString();
        }
        return value;
    }

    public HecDoubleArray getXArray() {
        return this._xArray;
    }

    public void setYAttribute(String value, int row, int column) {
        if (row == 0) {
            this._labels.setElementAt(value, column);
            this._dataChanged = true;
        } else if (row == 1 && this._numberHeaderRows >= 2) {
            if (column == 0) {
                this._pairedDataContainer.yunits = value;
                this._dataChanged = true;
            }
        } else if (row == 2 && this._numberHeaderRows >= 3 && column == 0) {
            this._pairedDataContainer.ytype = value;
            this._dataChanged = true;
        }
    }

    public void setXAttribute(String value, int row) {
        if (row == 1 && this._numberHeaderRows >= 2) {
            this._pairedDataContainer.xunits = value;
            this._dataChanged = true;
        } else if (row == 2 && this._numberHeaderRows >= 3) {
            this._pairedDataContainer.xtype = value;
            this._dataChanged = true;
        }
    }

    public void setValue(HecDouble number, int row, int column) {
        this._yArrays.elementAt(column).set(row, number);
        this._dataChanged = true;
    }

    public void setXValue(HecDouble number, int row) {
        this._xArray.set(row, number);
        this._dataChanged = true;
    }

    public boolean isCellEditable(int row, int column) {
        if (!this._isEditable) {
            return false;
        }
        if (column == 0) {
            return false;
        }
        if (column == 1 && row == 0) {
            return false;
        }
        return column <= 2 || row != 1 || this._numberHeaderRows < 2;
    }

    public void checkPrecision() {
        if (this._xArray == null) {
            return;
        }
        if (this._xArray.precision() > -1) {
            return;
        }
        int estPrec = this._xArray.estimatePrecision();
        this._xArray.setPrecision(estPrec);
        for (int i = 0; i < this._yArrays.size(); ++i) {
            estPrec = this._yArrays.elementAt(i).estimatePrecision();
            this._yArrays.elementAt(i).setPrecision(estPrec);
        }
    }

    public void numberOfPairedCurvesChanged(int newNumber) {
        if (newNumber != this._allYCurves.size()) {
            if (newNumber > this._allYCurves.size()) {
                int numbAdd = newNumber - this._allYCurves.size();
                int size = this._xArray.numberElements();
                for (int i = 0; i < numbAdd; ++i) {
                    HecDoubleArray yCurve = new HecDoubleArray(size);
                    this._yArrays.addElement(yCurve);
                    this._allYCurves.add(yCurve);
                    this._visibleCurves.add(Boolean.TRUE);
                    this._labels.addElement("");
                }
            } else {
                int oldSize;
                for (int i = oldSize = this._yArrays.size(); i > newNumber; --i) {
                    HecDoubleArray removedCurve = this._yArrays.remove(i - 1);
                    this._visibleCurves.remove(i - 1);
                    this._allYCurves.remove(removedCurve);
                }
            }
            this._pairedDataContainer.numberCurves = newNumber;
            this._colCount = newNumber;
        }
        int[] ierr = new int[1];
        this.updateContainer(ierr);
    }

    public void addColumn(int curveCol, boolean append) {
        if (append) {
            ++curveCol;
        }
        HecDoubleArray da = new HecDoubleArray(this._pairedDataContainer.numberOrdinates);
        this._yArrays.add(curveCol, da);
        this._labels.add(curveCol, "");
        this._allYCurves.add(curveCol, da);
        this._visibleCurves.add(curveCol, Boolean.TRUE);
        ++this._colCount;
        int[] ierr = new int[1];
        this.updateContainer(ierr);
    }

    public void insertRowsBefore(int startRow, int numberRows) {
        int newSize = this._xArray.numberElements() + numberRows;
        this._xArray.resize(newSize, startRow);
        for (int i = 0; i < this._allYCurves.size(); ++i) {
            HecDoubleArray yCurve = this._allYCurves.elementAt(i);
            yCurve.resize(newSize, startRow);
        }
        this._dataChanged = true;
    }

    public void appendRows(int numberRows) {
        int newSize = this._xArray.numberElements() + numberRows;
        this._xArray.resize(newSize);
        for (int i = 0; i < this._allYCurves.size(); ++i) {
            HecDoubleArray yCurve = this._allYCurves.elementAt(i);
            yCurve.resize(newSize);
        }
        int newEnd = this.getRowCount() - 1;
        int start = newEnd - numberRows;
        if (start < 0) {
            start = 0;
        }
        this._dataChanged = true;
    }

    public void deleteRows(int startRow, int numberRows) {
        int newSize = this._xArray.numberElements() - numberRows;
        this._xArray.resize(newSize, startRow);
        for (int i = 0; i < this._allYCurves.size(); ++i) {
            HecDoubleArray yCurve = this._allYCurves.elementAt(i);
            yCurve.resize(newSize, startRow);
        }
        this._dataChanged = true;
    }

    public void deleteColumn(int curveCol) {
        int idx;
        HecDoubleArray removedDataArray = this._allYCurves.remove(curveCol);
        if (removedDataArray != null && (idx = this._yArrays.indexOf(removedDataArray)) > -1) {
            this._yArrays.remove(removedDataArray);
            this._visibleCurves.remove(idx);
        }
        int[] ierr = new int[1];
        this.updateContainer(ierr);
        this.countVisibleColumns();
    }

    public void setDecimalPosition(int position) {
        if (this._xArray != null) {
            this._xArray.setPrecision(position);
        }
        for (int i = 0; i < this._yArrays.size(); ++i) {
            this._yArrays.elementAt(i).setPrecision(position);
        }
        if (position == -1) {
            this.checkPrecision();
        }
    }

    public int getDecimalPosition() {
        int pos = -1;
        if (this._xArray != null) {
            pos = this._xArray.precision();
        }
        for (int i = 0; i < this._yArrays.size(); ++i) {
            int iprec = this._yArrays.elementAt(i).precision();
            if (iprec <= pos) continue;
            pos = iprec;
        }
        return pos;
    }

    public boolean hasDataChanged() {
        return this._dataChanged;
    }

    public void setDataChanged(boolean dataChanged) {
        this._dataChanged = dataChanged;
    }

    public void save(Object parent) {
        if (parent instanceof SavableDataFrame) {
            int[] firstError = new int[1];
            this.updateContainer(firstError);
            ((SavableDataFrame)parent).save(this._pairedDataContainer);
            this._dataChanged = false;
        }
    }

    public void saveAs(Object parent) {
        if (parent instanceof SavableDataFrame) {
            int[] firstError = new int[1];
            this.updateContainer(firstError);
            ((SavableDataFrame)parent).saveAs(this._pairedDataContainer);
            this._dataChanged = false;
        }
    }

    public int updateContainer(int[] firstError) {
        this._pairedDataContainer.numberCurves = this._allYCurves.size();
        this._pairedDataContainer.xOrdinates = new double[this._xArray.numberElements()];
        this._pairedDataContainer.yOrdinates = new double[this._pairedDataContainer.numberCurves][this._xArray.numberElements()];
        int count = 0;
        for (int i = 0; i < this._xArray.numberElements(); ++i) {
            if (!this._xArray.isDefined(i)) continue;
            this._pairedDataContainer.xOrdinates[count] = this._xArray.element(i).value();
            boolean defined = false;
            for (int j = 0; j < this._pairedDataContainer.numberCurves; ++j) {
                HecDoubleArray da = this._allYCurves.elementAt(j);
                if (!da.value(i).isDefined()) continue;
                defined = true;
                this._pairedDataContainer.yOrdinates[j][count] = da.value(i).value();
            }
            if (!defined) continue;
            ++count;
        }
        this._pairedDataContainer.numberOrdinates = count;
        if (count != this._xArray.numberElements()) {
            double[] x = this._pairedDataContainer.xOrdinates;
            double[][] y = this._pairedDataContainer.yOrdinates;
            this._pairedDataContainer.xOrdinates = new double[count];
            this._pairedDataContainer.yOrdinates = new double[this._pairedDataContainer.numberCurves][count];
            for (int i = 0; i < count; ++i) {
                this._pairedDataContainer.xOrdinates[i] = x[i];
                for (int j = 0; j < this._pairedDataContainer.numberCurves; ++j) {
                    this._pairedDataContainer.yOrdinates[j][i] = y[j][i];
                }
            }
        }
        Iterator<String> labelsIter = null;
        if (this._labels != null) {
            labelsIter = this._labels.iterator();
        }
        this._pairedDataContainer.labelsUsed = false;
        if (this._pairedDataContainer.labels == null || this._pairedDataContainer.labels.length != this._pairedDataContainer.numberCurves) {
            this._pairedDataContainer.labels = new String[this._pairedDataContainer.numberCurves];
        }
        for (int i = 0; i < this._pairedDataContainer.numberCurves; ++i) {
            String label = null;
            if (this._visibleCurves.get(i).booleanValue()) {
                if (labelsIter != null && labelsIter.hasNext()) {
                    label = labelsIter.next();
                }
                this._pairedDataContainer.labels[i] = label;
            }
            if (label == null || label.isEmpty()) continue;
            this._pairedDataContainer.labelsUsed = true;
        }
        if (!this._pairedDataContainer.labelsUsed) {
            this._pairedDataContainer.labels = null;
        }
        this._pairedDataContainer.xprecision = this._xArray.precision();
        this._pairedDataContainer.yprecision = -1;
        Iterator<HecDoubleArray> yIter = null;
        if (this._yArrays != null) {
            yIter = this._yArrays.iterator();
        }
        for (int i = 0; i < this._pairedDataContainer.numberCurves; ++i) {
            int precision;
            if (!this._visibleCurves.get(i).booleanValue()) continue;
            HecDoubleArray da = null;
            if (yIter != null && yIter.hasNext()) {
                da = yIter.next();
            }
            if (da == null || (precision = da.precision()) <= this._pairedDataContainer.yprecision) continue;
            this._pairedDataContainer.yprecision = precision;
        }
        firstError[0] = 0;
        return 0;
    }
}

