/*
 * Decompiled with CFR 0.152.
 */
package hec.dataTable;

import hec.dataTable.HecDataTableFrame;
import hec.io.PairedDataContainer;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import rma.swing.ButtonCmdPanel;
import rma.swing.ButtonCmdPanelListener;
import rma.swing.RmaInsets;
import rma.swing.RmaJComboBox;
import rma.swing.RmaJDialog;
import rma.swing.list.RmaListModel;
import rma.swing.tree.CheckBoxNode;
import rma.swing.tree.CheckBoxTreeRenderer;
import rma.swing.tree.NodeSelectionListener;
import rma.swing.tree.RmaJTree;

public class PairedDataCurveSelector
extends RmaJDialog {
    private HecDataTableFrame _parent;
    private RmaJComboBox _pdcCombo;
    private RmaJTree _selectorTree;
    private JButton _selectAllBtn;
    private JButton _selectNoneBtn;
    private ButtonCmdPanel _cmdPanel;
    private DefaultMutableTreeNode _root;
    private PairedDataContainer _selectedPdc;
    private Vector _containers;

    public PairedDataCurveSelector(HecDataTableFrame parent) {
        super((Frame)parent, false);
        this._parent = parent;
        this.buildControls();
        this.addListeners();
        this.pack();
        this.setLocationRelativeTo(this.getParent());
    }

    protected void buildControls() {
        this.getContentPane().setLayout(new GridBagLayout());
        this.setTitle("Select Curves");
        JLabel label = new JLabel("Record:");
        label.setDisplayedMnemonic('R');
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = -1;
        gbc.gridy = -1;
        gbc.gridwidth = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.INSETS5505;
        this._pdcCombo = new RmaJComboBox();
        label.setLabelFor(this._pdcCombo);
        gbc.gridx = -1;
        gbc.gridy = -1;
        gbc.gridwidth = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.INSETS5505;
        this.getContentPane().add((Component)this._pdcCombo, gbc);
        this._selectorTree = new RmaJTree();
        this._selectorTree.setCellRenderer(new CheckBoxTreeRenderer());
        this._selectorTree.setRowHeight(this._selectorTree.getRowHeight() + 5);
        this._selectorTree.setRootVisible(false);
        this._selectorTree.setShowsRootHandles(true);
        gbc.gridx = -1;
        gbc.gridy = -1;
        gbc.gridwidth = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.insets = RmaInsets.INSETS5505;
        this.getContentPane().add((Component)new JScrollPane(this._selectorTree), gbc);
        JPanel buttonPanel = new JPanel(new GridBagLayout());
        gbc.gridx = -1;
        gbc.gridy = -1;
        gbc.gridwidth = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.anchor = 11;
        gbc.fill = 2;
        gbc.insets = RmaInsets.INSETS5555;
        this.getContentPane().add((Component)buttonPanel, gbc);
        this._selectAllBtn = new JButton("Select All");
        gbc.gridx = -1;
        gbc.gridy = -1;
        gbc.gridwidth = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.INSETS5505;
        buttonPanel.add((Component)this._selectAllBtn, gbc);
        this._selectNoneBtn = new JButton("Select None");
        gbc.gridx = -1;
        gbc.gridy = -1;
        gbc.gridwidth = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.INSETS5505;
        buttonPanel.add((Component)this._selectNoneBtn, gbc);
        this._cmdPanel = new ButtonCmdPanel(14);
        gbc.gridx = -1;
        gbc.gridy = -1;
        gbc.gridwidth = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.anchor = 16;
        gbc.fill = 2;
        gbc.insets = RmaInsets.INSETS5555;
        this.getContentPane().add((Component)this._cmdPanel, gbc);
    }

    private void addListeners() {
        this._pdcCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PairedDataCurveSelector.this.pdcComboSelected();
            }
        });
        this._selectorTree.addMouseListener(new NodeSelectionListener(this._selectorTree));
        this._selectAllBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PairedDataCurveSelector.this.selectTreeNodes(true);
            }
        });
        this._selectNoneBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PairedDataCurveSelector.this.selectTreeNodes(false);
            }
        });
        this._cmdPanel.addCmdPanelListener(new ButtonCmdPanelListener(){

            @Override
            public void buttonCmdActionPerformed(ActionEvent e) {
                switch (e.getID()) {
                    case 2: {
                        PairedDataCurveSelector.this.saveForm();
                        break;
                    }
                    case 8: {
                        if (!PairedDataCurveSelector.this.saveForm()) break;
                        PairedDataCurveSelector.this.setVisible(false);
                        break;
                    }
                    case 4: {
                        PairedDataCurveSelector.this.setVisible(false);
                    }
                }
            }
        });
    }

    protected void selectTreeNodes(boolean selected) {
        int cnt = this._root.getChildCount();
        for (int i = 0; i < cnt; ++i) {
            CheckBoxNodeImpl node = (CheckBoxNodeImpl)this._root.getChildAt(i);
            node.setSelected(selected);
        }
    }

    protected boolean saveForm() {
        if (this._selectedPdc != null) {
            this._selectedPdc.curveVisible = new boolean[this._selectedPdc.numberCurves];
            Enumeration<TreeNode> en = this._root.breadthFirstEnumeration();
            if (en.hasMoreElements()) {
                en.nextElement();
            }
            while (en.hasMoreElements()) {
                CheckBoxNodeImpl node = (CheckBoxNodeImpl)en.nextElement();
                int curveIndex = node.getCurveIndex();
                if (curveIndex == -1) continue;
                this._selectedPdc.curveVisible[curveIndex] = node.isSelected();
            }
            if (this.haveVisibleCurve()) {
                this._parent.setData(this._containers);
                return true;
            }
            JOptionPane.showMessageDialog(this, "There has to be at least one curve visible", "No Visible Curves", 2);
            return false;
        }
        return true;
    }

    private boolean haveVisibleCurve() {
        for (int i = 0; i < this._containers.size(); ++i) {
            PairedDataContainer pdc = (PairedDataContainer)this._containers.get(i);
            if (pdc.curveVisible == null || pdc.curveVisible.length == 0) {
                return true;
            }
            for (int j = 0; j < pdc.curveVisible.length; ++j) {
                if (!pdc.curveVisible[j]) continue;
                return true;
            }
        }
        return false;
    }

    protected void pdcComboSelected() {
        if (this.isModified()) {
            // empty if block
        }
        this._selectedPdc = (PairedDataContainer)this._pdcCombo.getSelectedItem();
        this.fillTree();
        this.setModified(false);
    }

    private void fillTree() {
        this._root = new DefaultMutableTreeNode("root");
        double scale = Math.log10(this._selectedPdc.numberCurves);
        if (scale < 1.397) {
            for (int i = 0; i < this._selectedPdc.numberCurves; ++i) {
                String label = this._selectedPdc.labelsUsed ? this._selectedPdc.labels[i] : String.valueOf(i + 1);
                CheckBoxNodeImpl node = new CheckBoxNodeImpl(label, this._selectorTree, i);
                this._root.add(node);
                this.selectNode(node, this._selectedPdc, i);
            }
        } else if (scale < 2.397) {
            for (int x = 0; x < this._selectedPdc.numberCurves; x += 10) {
                CheckBoxNodeImpl groupingNode = new CheckBoxNodeImpl("Curve " + String.valueOf(x + 1) + " to " + String.valueOf(x + 10), this._selectorTree, -1);
                this._root.add(groupingNode);
                for (int i = 0; i < 10; ++i) {
                    String label = this._selectedPdc.labelsUsed ? this._selectedPdc.labels[x + i] : String.valueOf(x + i + 1);
                    CheckBoxNodeImpl node = new CheckBoxNodeImpl(label, this._selectorTree, x + i);
                    groupingNode.add(node);
                    this.selectNode(node, this._selectedPdc, x + i);
                }
            }
        }
        DefaultTreeModel newModel = new DefaultTreeModel(this._root);
        this._selectorTree.setModel(newModel);
    }

    private void selectNode(CheckBoxNodeImpl node, PairedDataContainer pdc, int i) {
        if (pdc.curveVisible != null) {
            if (pdc.curveVisible.length <= i) {
                node.setSelected(pdc.curveVisible[i]);
            } else {
                node.setSelected(true);
            }
        } else {
            node.setSelected(true);
        }
    }

    public boolean setPairedData(Vector v) {
        ArrayList<PairedDataContainer> containers = new ArrayList<PairedDataContainer>();
        this._containers = v;
        for (int i = 0; i < v.size(); ++i) {
            if (!(v.get(i) instanceof PairedDataContainer)) continue;
            PairedDataContainer container = (PairedDataContainer)v.get(i);
            if (container.numberCurves <= 1) continue;
            containers.add(container);
        }
        RmaListModel model = new RmaListModel(true, containers);
        this._pdcCombo.setModel(model);
        if (model.getSize() > 0) {
            this._pdcCombo.setSelectedIndex(0);
        }
        return containers.size() > 0;
    }

    public class CheckBoxNodeImpl
    extends DefaultMutableTreeNode
    implements CheckBoxNode {
        protected boolean _selected;
        private JTree _tree;
        private int _selectionMode;
        private boolean _enabled;
        private int _curveIndex;

        public CheckBoxNodeImpl(Object userObj, JTree tree, int curveIndex) {
            super(userObj);
            this._selectionMode = 0;
            this._tree = tree;
            this._curveIndex = curveIndex;
        }

        @Override
        public int getSelectionMode() {
            return this._selectionMode;
        }

        @Override
        public boolean isSelected() {
            if (this.isLeaf()) {
                return this._selected;
            }
            boolean selected = true;
            int cnt = this.getChildCount();
            for (int i = 0; i < cnt; ++i) {
                TreeNode child = this.getChildAt(i);
                if (!(child instanceof CheckBoxNode) || ((CheckBoxNode)((Object)child)).isSelected()) continue;
                selected = false;
                break;
            }
            return selected;
        }

        @Override
        public void setSelected(boolean selected) {
            TreeModel model;
            this._selected = selected;
            if (this._tree != null && (model = this._tree.getModel()) instanceof DefaultTreeModel) {
                DefaultTreeModel dtm = (DefaultTreeModel)model;
                dtm.nodeChanged(this);
            }
            int cnt = this.getChildCount();
            for (int i = 0; i < cnt; ++i) {
                TreeNode child = this.getChildAt(i);
                if (!(child instanceof CheckBoxNode)) continue;
                ((CheckBoxNode)((Object)child)).setSelected(selected);
            }
            PairedDataCurveSelector.this.setModified(true);
        }

        public void setEnabled(boolean enabled) {
            this._enabled = enabled;
        }

        public boolean isEnabled() {
            return this._enabled;
        }

        public JTree getTree() {
            return this._tree;
        }

        public int getCurveIndex() {
            return this._curveIndex;
        }
    }
}

