/*
 * Decompiled with CFR 0.152.
 */
package hec.dataTable;

import hec.dataTable.DataModel;
import hec.dataTable.PairedDataCurve;
import hec.dataTable.SavableDataFrame;
import hec.heclib.util.HecDouble;
import hec.heclib.util.HecDoubleArray;
import hec.heclib.util.intArrayContainer;
import hec.io.PairedDataContainer;
import java.util.Arrays;
import java.util.List;
import java.util.Vector;
import javax.swing.JOptionPane;

public class PairedDataModel
extends DataModel {
    protected HecDoubleArray _xArray = null;
    protected Vector<PairedDataCurve> _pairedModels = null;
    protected Vector _pairedModelColumns = null;
    protected String _units = "";
    protected String _type = "";
    protected StringBuffer _compareMessage = null;

    public PairedDataModel() {
        this.setNumberHeaderRows(3);
    }

    public int setData(List dataSets, boolean showCommas) {
        this._showCommas = showCommas;
        this._dataColumns = new Vector();
        this._xArray = new HecDoubleArray();
        this._pairedModels = new Vector();
        this._pairedModelColumns = new Vector();
        boolean haveData = false;
        int numberColumns = 0;
        for (int i = 0; i < dataSets.size(); ++i) {
            if (!(dataSets.get(i) instanceof PairedDataContainer)) continue;
            PairedDataContainer pairedDataContainer = (PairedDataContainer)dataSets.get(i);
            PairedDataCurve pairedDataCurve = new PairedDataCurve(pairedDataContainer);
            this._units = pairedDataContainer.xunits;
            this._type = pairedDataContainer.xtype;
            this._pairedModels.addElement(pairedDataCurve);
            for (int j = 0; j < pairedDataCurve.getColumnCount(); ++j) {
                this._dataColumns.add(new Integer(j));
                this._pairedModelColumns.add(pairedDataCurve);
            }
            if (pairedDataCurve.getNumberValues() > 0) {
                haveData = true;
            }
            numberColumns += pairedDataCurve.getColumnCount();
        }
        this.orderData();
        if (haveData) {
            return 0;
        }
        return -1;
    }

    protected void resetTable() {
        this._dataColumns = new Vector();
        this._pairedModelColumns = new Vector();
        for (int i = 0; i < this._pairedModels.size(); ++i) {
            PairedDataCurve pairedDataCurve = this._pairedModels.get(i);
            for (int j = 0; j < pairedDataCurve.getColumnCount(); ++j) {
                this._dataColumns.add(new Integer(j));
                this._pairedModelColumns.add(pairedDataCurve);
            }
        }
        this.orderData();
        this.fireTableStructureChanged();
    }

    @Override
    public Vector getDataSets() {
        Vector<PairedDataContainer> dataContainers = new Vector<PairedDataContainer>();
        if (this._dataColumns == null) {
            return dataContainers;
        }
        for (int i = 0; i < this._pairedModels.size(); ++i) {
            PairedDataContainer pdc = this._pairedModels.elementAt(i).getDataContainer();
            dataContainers.add(pdc);
        }
        return dataContainers;
    }

    @Override
    public int getColumnCount() {
        return this._map.length + 2;
    }

    @Override
    public int getDataColumnCount() {
        return this._map.length;
    }

    @Override
    public int getRowCount() {
        return this._xArray.numberElements() + this.getNumberHeaderRows();
    }

    public PairedDataCurve inColumn(int i) {
        if (i < 0 || i >= this._pairedModelColumns.size()) {
            return null;
        }
        return (PairedDataCurve)this._pairedModelColumns.get(i);
    }

    protected int orderData() {
        int i;
        int total = 0;
        int[] columnRowPosition = new int[this._dataColumns.size()];
        for (i = 0; i < this._dataColumns.size(); ++i) {
            total += this.inColumn(i).getNumberValues();
            columnRowPosition[i] = 0;
        }
        this._xArray.setSize(total);
        this._map = new intArrayContainer[this._dataColumns.size()];
        for (i = 0; i < this._dataColumns.size(); ++i) {
            this._map[i] = new intArrayContainer(total, -2);
        }
        HecDouble min = new HecDouble();
        int xpos = 0;
        while (true) {
            int j;
            int i2;
            boolean done = true;
            for (i2 = 0; i2 < this._dataColumns.size(); ++i2) {
                j = columnRowPosition[i2];
                if (j >= this.inColumn(i2).getNumberValues()) continue;
                min = this.inColumn(i2).getXValue(j);
                done = false;
                break;
            }
            if (done) break;
            for (i2 = 0; i2 < this._dataColumns.size(); ++i2) {
                j = columnRowPosition[i2];
                if (j >= this.inColumn(i2).getNumberValues() || !this.inColumn(i2).getXValue(j).lessThan(min)) continue;
                min = this.inColumn(i2).getXValue(j);
            }
            this._xArray.element(xpos).set(min);
            for (i2 = 0; i2 < this._dataColumns.size(); ++i2) {
                j = columnRowPosition[i2];
                if (j < this.inColumn(i2).getNumberValues()) {
                    if (this.inColumn(i2).getXValue(j).equals(min)) {
                        this.map(i2, xpos, columnRowPosition[i2]);
                        int n = i2;
                        columnRowPosition[n] = columnRowPosition[n] + 1;
                        continue;
                    }
                    this.map(i2, xpos, -1);
                    continue;
                }
                this.map(i2, xpos, -1);
            }
            ++xpos;
        }
        if (xpos < total) {
            this._xArray.resize(xpos);
        }
        return xpos;
    }

    protected void reMap(int column) {
        this.reMap(column, 0);
    }

    protected void reMap(int column, int row) {
        int i;
        PairedDataCurve dataColumn = this.inColumn(column);
        HecDoubleArray curveXArray = dataColumn.getXArray();
        int n = curveXArray.lastDefined();
        HecDouble lastColumnValue = curveXArray.element(n);
        for (i = row; i < this._xArray.numberElements(); ++i) {
            int columnIndex;
            HecDouble xValue = this._xArray.element(i);
            this._map[column].array[i] = xValue.isDefined() ? (columnIndex = curveXArray.index(xValue, false)) : -1;
            if (i > curveXArray.numberElements() && xValue.greaterThan(lastColumnValue)) break;
        }
        if (this._xArray.numberElements() < this._map[column].array.length) {
            for (i = this._xArray.numberElements(); i < this._map[column].array.length; ++i) {
                this._map[column].array[i] = -2;
            }
        }
    }

    @Override
    public String getColumnName(int col) {
        if (col == 0) {
            return "  \nOrdinate";
        }
        if (col == 1) {
            return "  \n" + this.inColumn(0).getXParameter();
        }
        return this.inColumn(col -= 2).getColumnName(this.columnCurveNumber(col));
    }

    @Override
    public String getNominalName() {
        return this.inColumn(0).getNominalName();
    }

    @Override
    public Object getValueAt(int row, int column) {
        if (column < 0 || column >= this.getColumnCount()) {
            return null;
        }
        if (row < 0 || row >= this.getRowCount()) {
            return null;
        }
        if (row == 0) {
            if (column == 0) {
                return "Labels";
            }
            if (column == 1) {
                return "";
            }
        }
        if (row == 1 && this.getNumberHeaderRows() >= 2) {
            if (column == 0) {
                return "Units";
            }
            if (column == 1) {
                return this._units;
            }
        }
        if (row == 2 && this.getNumberHeaderRows() >= 3) {
            if (column == 0) {
                return "Type";
            }
            if (column == 1) {
                return this._type;
            }
        }
        if (column == 0) {
            return row - this.getNumberHeaderRows() + 1;
        }
        if (column == 1) {
            HecDouble value = this._xArray.element(row -= this.getNumberHeaderRows());
            value.setShowCommas(this._showCommas);
            return value;
        }
        Object value = this.getModelValue(row, column);
        if (value instanceof HecDouble) {
            ((HecDouble)value).setShowCommas(this._showCommas);
        }
        return value;
    }

    public Object getModelValue(int row, int column) {
        if (column == 1) {
            HecDouble value = this._xArray.element(row);
            return value;
        }
        PairedDataCurve curve = (PairedDataCurve)this._pairedModelColumns.elementAt(column -= 2);
        int col = this.columnCurveNumber(column);
        if (row < this.getNumberHeaderRows()) {
            return curve.getValueAt(row, col);
        }
        int r = this.unMap(row -= this.getNumberHeaderRows(), column);
        if (r == -1) {
            return new HecDouble();
        }
        return curve.getHecDouble(r, col);
    }

    public int setModelValue(Object value, int row, int column) {
        Object obj;
        PairedDataCurve curve = (PairedDataCurve)this._pairedModelColumns.elementAt(column -= 2);
        int col = this.columnCurveNumber(column);
        int r = this.unMap(row, column);
        if (r == -1) {
            if (value.toString().trim().length() == 0) {
                return 0;
            }
            int curveRow = this.unMapToNextValidRow(row, column);
            if (curveRow != -1) {
                curve.insertRowsBefore(curveRow, 1);
                curve.setXValue(this._xArray.element(row), curveRow);
            }
            for (int i = 0; i < this._pairedModelColumns.size(); ++i) {
                PairedDataCurve pdc = (PairedDataCurve)this._pairedModelColumns.elementAt(i);
                if (pdc != curve) continue;
                this.map(i, row, -1);
                this.reMap(i);
            }
            r = this.unMap(row, column);
            if (r == -1) {
                return -1;
            }
        }
        if (!((obj = this.inColumn(column).getHecDouble(r, col)) instanceof HecDouble)) {
            return -1;
        }
        HecDouble number = (HecDouble)obj;
        int status = 0;
        if (value instanceof HecDouble) {
            number.set((HecDouble)value);
        } else {
            status = number.set(value.toString());
        }
        if (status != 0 && value.toString().length() > 0) {
            String message = "Invalid number: " + value.toString() + ";  ordinate = " + row;
            System.out.println(message);
            JOptionPane.showMessageDialog(null, message, "", 2);
            return -1;
        }
        curve.setValue(number, r, col);
        return 0;
    }

    public Class getSortColumnClass(int columnIndex) {
        if (columnIndex < 1) {
            return Integer.class;
        }
        return Double.class;
    }

    @Override
    public Object getSortValueAt(int row, int column) {
        if (column == 0) {
            if (row <= 0 && row < this.getNumberHeaderRows()) {
                return new Integer(0);
            }
            int ordinate = row - this.getNumberHeaderRows() + 1;
            return new Integer(ordinate);
        }
        if (row < this.getNumberHeaderRows()) {
            return new Integer(0);
        }
        Object obj = this.getModelValue(row -= this.getNumberHeaderRows(), column);
        if (obj instanceof HecDouble) {
            return new Double(((HecDouble)obj).value());
        }
        return new Double(0.0);
    }

    protected int columnCurveNumber(int column) {
        int col = (Integer)this._dataColumns.elementAt(column);
        return col;
    }

    public void setXAttribute(String value, int row) {
        if (row == 1) {
            this._units = value;
        } else if (row == 2) {
            this._type = value;
        }
        for (int i = 0; i < this._pairedModels.size(); ++i) {
            PairedDataCurve curve = this._pairedModels.elementAt(i);
            curve.setXAttribute(value, row);
        }
    }

    public int setXValue(String value, int row) {
        int rowsLeft;
        HecDouble number;
        int status;
        if (row >= this._xArray.numberElements()) {
            this._xArray.resize(row + 1);
        }
        if ((status = (number = this._xArray.element(row)).set(value)) != 0 && value.length() > 0) {
            String message = "Invalid number: " + value.toString() + ";  ordinate = " + row;
            System.out.println(message);
            JOptionPane.showMessageDialog(null, message, "", 2);
            return -1;
        }
        for (int i = 0; i < this._pairedModels.size(); ++i) {
            PairedDataCurve curve = this._pairedModels.elementAt(i);
            curve.setXValue(number, row);
        }
        if (this._isExtendable && this._numberBlankRows > 0 && (rowsLeft = this._xArray.numberElements() - row - 1) < this._numberBlankRows) {
            int numb = this._numberBlankRows - rowsLeft;
            this.appendRows(numb);
        }
        return 0;
    }

    public void setYAttribute(String value, int row, int column) {
        PairedDataCurve curve = (PairedDataCurve)this._pairedModelColumns.elementAt(column -= 2);
        int col = this.columnCurveNumber(column);
        if (row <= this.getNumberHeaderRows()) {
            curve.setYAttribute(value, row, col);
        }
    }

    @Override
    public int setValue(Object value, int row, int column) {
        if (column < 1 || column >= this.getColumnCount()) {
            return -1;
        }
        if (row < 0 || row >= this.getRowCount()) {
            return -1;
        }
        if (row < this.getNumberHeaderRows()) {
            if (column == 1) {
                this.setXAttribute(value.toString(), row);
                return 0;
            }
            this.setYAttribute(value.toString(), row, column);
            return 0;
        }
        row -= this.getNumberHeaderRows();
        if (column == 1) {
            this.setXValue(value.toString(), row);
            return 0;
        }
        return this.setModelValue(value, row, column);
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        if (!this._isEditable) {
            return false;
        }
        if (column == 0) {
            return false;
        }
        if (column == 1 && row == 0) {
            return false;
        }
        return column <= 2 || row != 1 || this.getNumberHeaderRows() < 2;
    }

    @Override
    public void setExtendable(boolean extendable, int numberBlankRows) {
        super.setExtendable(extendable, numberBlankRows);
        if (extendable && numberBlankRows > 0) {
            if (this._hasBeenExtended) {
                return;
            }
            this.appendRows(numberBlankRows);
            this._hasBeenExtended = true;
        }
    }

    public void insertRowsBefore(int initialRow, int numberRows) {
        int startRow = initialRow - this.getNumberHeaderRows();
        if (startRow < 0) {
            startRow = 0;
        }
        int begSize = this._xArray.numberElements();
        int newSize = begSize + numberRows;
        this._xArray.resize(newSize, startRow);
        for (int column = 0; column < this._pairedModels.size(); ++column) {
            PairedDataCurve curve = this._pairedModels.elementAt(column);
            curve.insertRowsBefore(startRow, numberRows);
        }
        for (int i = 0; i < this._pairedModelColumns.size(); ++i) {
            this.increaseMap(i, numberRows);
            this.reMap(i);
        }
        int newEnd = startRow + numberRows;
        this.fireTableRowsInserted(startRow, newEnd);
    }

    @Override
    public void appendRows(int numberRows) {
        int begSize = this._xArray.numberElements();
        this._xArray.resize(begSize + numberRows);
        for (int column = 0; column < this._pairedModelColumns.size(); ++column) {
            this.increaseMap(column, numberRows);
        }
        for (int i = 0; i < this._pairedModels.size(); ++i) {
            PairedDataCurve curve = this._pairedModels.elementAt(i);
            curve.appendRows(numberRows);
        }
        int newEnd = this.getRowCount() - 1;
        int start = newEnd - numberRows;
        if (start < 0) {
            start = 0;
        }
        this.fireTableRowsInserted(start, newEnd);
    }

    public void deleteRows(int[] selectedRows) {
        int i;
        int i2 = 0;
        while (i2 < selectedRows.length) {
            int n = i2++;
            selectedRows[n] = selectedRows[n] - this.getNumberHeaderRows();
        }
        int startRow = selectedRows[0];
        if (startRow < 0) {
            return;
        }
        Arrays.sort(selectedRows);
        int[] rows = new int[selectedRows.length];
        for (int i3 = 0; i3 < selectedRows.length; ++i3) {
            rows[i3] = selectedRows[selectedRows.length - i3 - 1];
        }
        Object pdc = null;
        for (i = 0; i < rows.length; ++i) {
            int begSize = this._xArray.numberElements();
            this._xArray.resize(begSize - 1, rows[i]);
            for (int j = this._pairedModelColumns.size() - 1; j >= 0; --j) {
                int r;
                PairedDataCurve curve = (PairedDataCurve)this._pairedModelColumns.elementAt(j);
                Integer integer = (Integer)this._dataColumns.elementAt(j);
                if (integer != 0 || (r = this.unMap(rows[i], j)) < 0) continue;
                curve.deleteRows(r, 1);
            }
        }
        for (i = 0; i < this._pairedModelColumns.size(); ++i) {
            this.reMap(i);
        }
    }

    @Override
    public boolean canDeleteColumn(int col) {
        if (col < 2) {
            return false;
        }
        PairedDataCurve curve = (PairedDataCurve)this._pairedModelColumns.elementAt(col -= 2);
        int number = curve.getColumnCount();
        return number >= 2;
    }

    @Override
    public boolean canInsertColumn(int col, boolean append) {
        if (col < 2) {
            return append;
        }
        return true;
    }

    @Override
    public void deleteColumn(int col) {
        PairedDataCurve curve = (PairedDataCurve)this._pairedModelColumns.elementAt(col -= 2);
        int number = curve.getColumnCount();
        if (number < 2) {
            return;
        }
        int curveCol = (Integer)this._dataColumns.elementAt(col);
        curve.deleteColumn(curveCol);
        Vector data = this.getDataSets();
        this.setData(data, this._showCommas);
    }

    @Override
    public void addColumn(int col, boolean append) {
        PairedDataCurve curve = (PairedDataCurve)this._pairedModelColumns.elementAt(col -= 2);
        int curveCol = (Integer)this._dataColumns.elementAt(col);
        curve.addColumn(curveCol, append);
        Vector data = this.getDataSets();
        this.setData(data, this._showCommas);
    }

    @Override
    public void setDecimalPosition(int position) {
        if (this._xArray != null) {
            this._xArray.setPrecision(position);
        }
        for (int column = 0; column < this._pairedModels.size(); ++column) {
            this.setDecimalPosition(column, position);
        }
    }

    @Override
    public void setDecimalPosition(int column, int position) {
        this._pairedModels.elementAt(column).setDecimalPosition(position);
    }

    @Override
    public int getDecimalPosition() {
        int pos = -1;
        if (this._xArray != null) {
            pos = this._xArray.precision();
        }
        for (int column = 0; column < this._pairedModels.size(); ++column) {
            int iprec = this.getDecimalPosition(column);
            if (iprec <= pos) continue;
            pos = iprec;
        }
        return pos;
    }

    @Override
    public int getDecimalPosition(int column) {
        return this._pairedModels.elementAt(column).getDecimalPosition();
    }

    @Override
    public boolean hasDataChanged() {
        for (int i = 0; i < this._pairedModels.size(); ++i) {
            PairedDataCurve curve = this._pairedModels.elementAt(i);
            if (!curve.hasDataChanged()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void setDataChanged(boolean dataChanged) {
        int i;
        for (i = 0; i < this._pairedModels.size(); ++i) {
            PairedDataCurve curve = this._pairedModels.elementAt(i);
            curve.setDataChanged(dataChanged);
        }
        for (i = 0; i < this._dataColumns.size(); ++i) {
            this.inColumn(i).setDataChanged(dataChanged);
        }
    }

    @Override
    public int updateContainers(int[] firstError) {
        for (int i = 0; i < this._pairedModels.size(); ++i) {
            PairedDataCurve curve = this._pairedModels.elementAt(i);
            int error = curve.updateContainer(firstError);
            if (error == 0) continue;
            return error;
        }
        return 0;
    }

    @Override
    public void save(Object parent) {
        if (parent instanceof SavableDataFrame) {
            for (int i = 0; i < this._pairedModels.size(); ++i) {
                PairedDataCurve curve = this._pairedModels.elementAt(i);
                if (!curve.hasDataChanged()) continue;
                curve.save(parent);
            }
        }
    }

    @Override
    public void saveAs(Object parent) {
        if (parent instanceof SavableDataFrame) {
            for (int i = 0; i < this._pairedModels.size(); ++i) {
                PairedDataCurve curve = this._pairedModels.elementAt(i);
                curve.saveAs(parent);
            }
        }
    }

    public void numberOfPairedCurvesChanged(int newNumber) {
        for (int i = 0; i < this._pairedModels.size(); ++i) {
            PairedDataCurve curve = this._pairedModels.elementAt(i);
            curve.numberOfPairedCurvesChanged(newNumber);
        }
        this.resetTable();
    }

    public int compareDataSets(int precision) {
        int i;
        int count = 0;
        this._compareMessage = new StringBuffer();
        Vector containers = this.getDataSets();
        if (containers.size() < 2) {
            this._compareMessage.append("\nCannot compare a single data set.");
            return -2;
        }
        PairedDataContainer pdc = (PairedDataContainer)containers.elementAt(0);
        HecDoubleArray xoridnates = new HecDoubleArray(pdc.xOrdinates);
        if (precision > -1) {
            xoridnates.setPrecision(precision);
        } else if (pdc.xprecision > -1) {
            xoridnates.setPrecision(pdc.xprecision);
        }
        HecDoubleArray[] yordinates = new HecDoubleArray[pdc.numberCurves];
        for (i = 0; i < pdc.numberCurves; ++i) {
            yordinates[i] = new HecDoubleArray(pdc.yOrdinates[i]);
            if (precision > -1) {
                yordinates[i].setPrecision(precision);
                continue;
            }
            if (pdc.yprecision <= -1) continue;
            yordinates[i].setPrecision(pdc.yprecision);
        }
        for (i = 1; i < containers.size(); ++i) {
            HecDouble hd2;
            int diff;
            PairedDataContainer pdc2 = (PairedDataContainer)containers.elementAt(i);
            if (pdc.numberCurves != pdc2.numberCurves) {
                diff = Math.abs(pdc.numberCurves - pdc2.numberCurves);
                this._compareMessage.append("\nNumber of Curves differ by " + diff + ":");
                this._compareMessage.append("\nData set 1: " + pdc.numberCurves + ", data set 2: " + pdc2.numberCurves);
                count += diff;
            }
            if (pdc.numberOrdinates != pdc2.numberOrdinates) {
                diff = Math.abs(pdc.numberOrdinates - pdc2.numberOrdinates);
                this._compareMessage.append("\nNumber of Ordinates differ by " + diff + ":");
                this._compareMessage.append("\nData set 1: " + pdc.numberOrdinates + ", data set 2: " + pdc2.numberOrdinates);
                count += diff;
            }
            if (!pdc.xtype.equals(pdc2.xtype)) {
                this._compareMessage.append("\nX Axis types differ:");
                this._compareMessage.append("\nData set 1: " + pdc.xtype + ", data set 2: " + pdc2.xtype);
            }
            if (!pdc.ytype.equals(pdc2.ytype)) {
                this._compareMessage.append("\nY Axis types differ:");
                this._compareMessage.append("\nData set 1: " + pdc.ytype + ", data set 2: " + pdc2.ytype);
            }
            if (!pdc.xunits.equals(pdc2.xunits)) {
                this._compareMessage.append("\nX Units differ:");
                this._compareMessage.append("\nData set 1: " + pdc.xunits + ", data set 2: " + pdc2.xunits);
            }
            if (!pdc.yunits.equals(pdc2.yunits)) {
                this._compareMessage.append("\nY Units differ:");
                this._compareMessage.append("\nData set 1: " + pdc.yunits + ", data set 2: " + pdc2.yunits);
            }
            if (pdc.switchXyAxis != pdc2.switchXyAxis) {
                this._compareMessage.append("\nY Axis switched differ:");
                this._compareMessage.append("\nData set 1: " + pdc.switchXyAxis + ", data set 2: " + pdc2.switchXyAxis);
            }
            if (count > 0) {
                return count;
            }
            HecDoubleArray xoridnates2 = new HecDoubleArray(pdc2.xOrdinates);
            if (precision > -1) {
                xoridnates2.setPrecision(precision);
            } else if (pdc2.xprecision > -1) {
                xoridnates2.setPrecision(pdc2.xprecision);
            }
            for (int j = 0; j < xoridnates.numberElements(); ++j) {
                HecDouble hd1 = xoridnates.element(j);
                if (hd1.equals(hd2 = xoridnates2.element(j))) continue;
                ++count;
            }
            HecDoubleArray[] yordinates2 = new HecDoubleArray[pdc2.numberCurves];
            for (int j = 0; j < pdc2.numberCurves; ++j) {
                yordinates2[j] = new HecDoubleArray(pdc2.yOrdinates[j]);
                if (precision > -1) {
                    yordinates2[j].setPrecision(precision);
                    continue;
                }
                if (pdc2.yprecision <= -1) continue;
                yordinates2[j].setPrecision(pdc2.yprecision);
            }
            for (int k = 0; k < pdc.numberCurves; ++k) {
                for (int j = 0; j < yordinates[k].numberElements(); ++j) {
                    HecDouble hd1 = yordinates[k].element(j);
                    if (hd1.equals(hd2 = yordinates2[k].element(j))) continue;
                    ++count;
                }
            }
        }
        return count;
    }

    public String getCompareMessage() {
        if (this._compareMessage != null) {
            return this._compareMessage.toString();
        }
        return "";
    }

    @Override
    public Vector getDataContainers() {
        Vector<PairedDataContainer> pdcs = new Vector<PairedDataContainer>();
        for (int i = 0; i < this._pairedModels.size(); ++i) {
            PairedDataCurve pdCurve = this._pairedModels.get(i);
            PairedDataContainer pdc = pdCurve.getDataContainer();
            if (pdcs.contains(pdc)) continue;
            pdcs.add(pdc);
        }
        return pdcs;
    }
}

