/*
 * Decompiled with CFR 0.152.
 */
package hec.dataTable;

import java.awt.Frame;
import javax.swing.JOptionPane;
import rma.swing.FindDialog;
import rma.swing.FindListener;

public class TableFindDialog
extends FindDialog {
    protected boolean _foundOne = false;
    protected String _previousMatch = "";

    public TableFindDialog(Frame parent, boolean modal, boolean timeSeries, FindListener findListener) {
        super(parent, modal);
        this._findListener = findListener;
        this.SEARCH_TYPES = new Object[]{"Down", "Up"};
        this.buildControls();
        if (timeSeries) {
            this._caseSensitiveCheckBox.setText("Search date/time also");
        } else {
            this._caseSensitiveCheckBox.setVisible(false);
        }
    }

    @Override
    public void close() {
        super.close();
    }

    @Override
    public void findNext() {
        try {
            String match = this._matchTextField.getText();
            if (!this._previousMatch.equals(match)) {
                this._foundOne = false;
                this._previousMatch = match;
            }
            boolean wholeWord = this._wholeWordCheckBox.isSelected();
            boolean caseSensitive = this._caseSensitiveCheckBox.isSelected();
            Object searchType = this._searchTypeCombo.getSelectedItem();
            boolean found = searchType.equals("All") ? this._findListener.selectFirstRecord(match, true, wholeWord, caseSensitive) : (searchType.equals("Up") ? this._findListener.selectLastRecord(match, wholeWord, caseSensitive) : this._findListener.selectFirstRecord(match, false, wholeWord, caseSensitive));
            if (!found) {
                if (this._foundOne) {
                    JOptionPane.showMessageDialog(this, "Finished searching the data set");
                } else {
                    JOptionPane.showMessageDialog(this, match + " not found");
                }
            } else {
                this._foundOne = true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

