/*
 * Decompiled with CFR 0.152.
 */
package hec.dataTable;

import hec.dataTable.SavableDataFrame;
import hec.io.TextContainer;
import hec.util.GeneralTableEditor;
import hec.util.GeneralTableModel;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Vector;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import rma.swing.SearchableJEditorPane;

public class TextTable
extends GeneralTableEditor {
    protected SearchableJEditorPane _textPane;
    protected TextContainer _textContainer;
    protected Font _font;
    protected Object _parent;

    public TextTable(Object parent, TextContainer textContainer) {
        this._textContainer = textContainer;
        this._parent = parent;
        this.setup();
    }

    protected void setup() {
        String[] labels;
        int numberRows = 0;
        int numberColumns = 0;
        Vector<String[]> rows = null;
        this.setTitle(this._textContainer.fullName);
        if (this._textContainer.textTable != null) {
            numberRows = this._textContainer.textTable.length;
            numberColumns = this._textContainer.textTable[0].length;
            rows = new Vector<String[]>(numberRows);
            for (int r = 0; r < numberRows; ++r) {
                String[] row = new String[numberColumns];
                if (this._textContainer.textTable != null) {
                    for (int c2 = 0; c2 < numberColumns; ++c2) {
                        row[c2] = this._textContainer.textTable[r][c2];
                    }
                }
                rows.add(row);
            }
        }
        if ((labels = this._textContainer.labels) == null) {
            labels = new String[numberColumns];
            for (int c3 = 0; c3 < numberColumns; ++c3) {
                labels[c3] = "Column " + Integer.toString(c3);
            }
        }
        this.initialize(labels, rows);
        if (this._textContainer.text != null && this._textContainer.text.length() > 0) {
            this._textPane.setText(this._textContainer.text + "\n");
        }
        if (this._parent instanceof SavableDataFrame) {
            this.setEditable(true);
            if (this._table != null) {
                this._table.setEditable(true);
            }
        } else {
            this.setEditable(false);
            this._save.setEnabled(false);
            this._saveAs.setEnabled(false);
        }
        this.pack();
        this.setSize(450, 250);
        if (this._parent instanceof Component) {
            this.setLocationRelativeTo((Component)this._parent);
        }
    }

    @Override
    protected void build() {
        GridBagConstraints gbc;
        this._table.setRowHeight(20);
        this._textPane = new SearchableJEditorPane();
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        if (this._textContainer.textTable != null && this._textContainer.text != null) {
            JSplitPane _splitPane = new JSplitPane(0);
            _splitPane.setDividerSize(4);
            this._font = new Font("Courier New", 0, 12);
            this._textPane.setContentType("text/plain");
            this._textPane.setFont(this._font);
            _splitPane.add((Component)new JScrollPane(this._textPane), "top");
            _splitPane.add((Component)new JScrollPane(this._table), "bottom");
            _splitPane.setDividerLocation(0.5);
            GridBagConstraints gbc2 = new GridBagConstraints();
            gbc2.weightx = 1.0;
            gbc2.weighty = 1.0;
            gbc2.anchor = 18;
            gbc2.fill = 1;
            panel.add((Component)_splitPane, gbc2);
        } else if (this._textContainer.textTable != null) {
            gbc = new GridBagConstraints();
            gbc.weightx = 1.0;
            gbc.weighty = 1.0;
            gbc.anchor = 18;
            gbc.fill = 1;
            panel.add((Component)new JScrollPane(this._table), gbc);
        } else {
            this._font = new Font("Courier New", 0, 12);
            this._textPane.setText(this._textContainer.text + "\n\n");
            this._textPane.setContentType("text/plain");
            this._textPane.setFont(this._font);
            gbc = new GridBagConstraints();
            gbc.weightx = 1.0;
            gbc.weighty = 1.0;
            gbc.anchor = 18;
            gbc.fill = 1;
            panel.add((Component)new JScrollPane(this._textPane), gbc);
        }
        this.getContentPane().setLayout(new GridBagLayout());
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.gridwidth = 2;
        gbc.anchor = 18;
        gbc.fill = 1;
        this.getContentPane().add((Component)panel, gbc);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                TextTable.this.cancelButton();
            }
        });
        ListSelectionModel selectionModel = this._table.getSelectionModel();
        selectionModel.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                TextTable.this.cellChanged();
            }
        });
        this.buildMenu();
    }

    @Override
    protected void buildMenu() {
        super.buildMenu();
        JMenuItem menuItem = new JMenuItem("Save to Disk...");
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TextTable.this.saveToDisk();
            }
        });
        this._fileMenu.add(menuItem);
    }

    public TextContainer saveToContainer() {
        TextContainer textContainer = (TextContainer)this._textContainer.clone();
        textContainer.text = this._textPane.getText();
        if (textContainer.text != null && textContainer.text.length() == 0) {
            textContainer.text = null;
        }
        if (this._table != null) {
            int numberColumns = this._table.getColumnCount();
            int numberRows = this._table.getRowCount();
            if (numberColumns > 0 && numberRows > 0) {
                textContainer.textTable = new String[numberRows][numberColumns];
                for (int i = 0; i < numberRows; ++i) {
                    for (int j = 0; j < numberColumns; ++j) {
                        textContainer.textTable[i][j] = this._table.getCell(i, j).toString();
                    }
                }
            } else {
                textContainer.textTable = null;
            }
        }
        return textContainer;
    }

    protected void saveToDisk() {
        super.save(true);
    }

    @Override
    protected boolean save(boolean saveAs) {
        if (this._parent instanceof SavableDataFrame) {
            this.stopEditing();
            TextContainer tc = this.saveToContainer();
            if (this._table != null) {
                this._table.setModified(false);
                GeneralTableModel tm = (GeneralTableModel)this._table.getModel();
                tm.setDataChanged(false);
            }
            if (saveAs) {
                return ((SavableDataFrame)this._parent).saveAs(tc);
            }
            return ((SavableDataFrame)this._parent).save(tc);
        }
        return false;
    }
}

