/*
 * Decompiled with CFR 0.152.
 */
package hec.dataTable;

import hec.heclib.util.HecTime;
import hec.heclib.util.HecTimeArray;
import hec.io.TimeSeriesContainer;
import java.util.TimeZone;

public abstract class TimeSeriesColumnBase {
    public String columnName = "  \nValue";
    public TimeSeriesContainer _timeSeriesContainer;
    protected HecTimeArray _times;
    protected boolean _dataChanged;
    private final Integer _intialStartTime;
    private final Integer _intialEndTime;

    public abstract String getValue(int var1, boolean var2);

    protected abstract Object getObject(int var1);

    public TimeSeriesColumnBase(TimeSeriesContainer dataSet) {
        this._timeSeriesContainer = dataSet;
        this._times = new HecTimeArray();
        if (this._timeSeriesContainer.times != null) {
            if (dataSet.timeGranularitySeconds <= 60) {
                this._times.set(this._timeSeriesContainer.times, dataSet.julianBaseDate);
            } else {
                this._times.set(dataSet.times, dataSet.timeGranularitySeconds, dataSet.julianBaseDate);
            }
        }
        if (this._timeSeriesContainer.times != null && this._timeSeriesContainer.times.length > 0) {
            this._intialStartTime = this._timeSeriesContainer.times[0];
            this._intialEndTime = this._timeSeriesContainer.times[this._timeSeriesContainer.times.length - 1];
        } else {
            this._intialStartTime = null;
            this._intialEndTime = null;
        }
        this._dataChanged = false;
    }

    public String getName() {
        if (this._timeSeriesContainer != null) {
            String name;
            if (this._timeSeriesContainer.profileLabel != null && this._timeSeriesContainer.profileLabel.length() > 1) {
                return this._timeSeriesContainer.profileLabel;
            }
            StringBuffer sb = new StringBuffer();
            if (this._timeSeriesContainer.location.length() > 0) {
                sb.append(this._timeSeriesContainer.location);
                if (this._timeSeriesContainer.subLocation.length() > 0) {
                    sb.append("-");
                    sb.append(this._timeSeriesContainer.subLocation);
                }
            }
            sb.append("\n");
            if (this._timeSeriesContainer.parameter.length() > 0) {
                sb.append(this._timeSeriesContainer.parameter);
                if (this._timeSeriesContainer.subParameter.length() > 0) {
                    sb.append("-");
                    sb.append(this._timeSeriesContainer.subParameter);
                }
            }
            sb.append("\n");
            if (this._timeSeriesContainer.version.length() > 0) {
                sb.append(this._timeSeriesContainer.version);
                if (this._timeSeriesContainer.subVersion.length() > 0) {
                    sb.append("-");
                    sb.append(this._timeSeriesContainer.subVersion);
                }
            }
            if ((name = sb.toString()).length() > 2) {
                return name;
            }
        }
        return this.columnName;
    }

    public TimeSeriesContainer getDataContainer() {
        return this._timeSeriesContainer;
    }

    public void appendRows(int numberRows) {
        int startRow = this._times.numberElements();
        this._times.resizeWithInterval(startRow, numberRows, this._timeSeriesContainer.interval);
    }

    public void insertRowsBefore(int startRow, int numberRows) {
        this._times.resizeWithInterval(startRow, numberRows, this._timeSeriesContainer.interval);
    }

    public void insertRowsBefore(int startRow, int numberRows, HecTimeArray newTimes) {
        this._times.resize(this._times.numberElements() + numberRows, startRow);
        if (newTimes != null) {
            for (int i = 0; i < numberRows; ++i) {
                HecTime t = newTimes.element(i);
                if (!t.isDefined()) continue;
                this._times.set(startRow + i, t);
            }
        }
    }

    public void deleteRows(int startRow, int numberRows) {
        int numberElements = this._times.numberElements() - numberRows;
        this._times.resize(numberElements, startRow);
        this._dataChanged = true;
    }

    public void initializeEntryStartTime() {
        if (this._timeSeriesContainer.startTime != 0) {
            if (this._timeSeriesContainer.interval > 0) {
                int size = this._times.numberElements();
                if (size == 0) {
                    this.extendDataSet(new HecTime(this._timeSeriesContainer.getStartTime()));
                } else {
                    HecTime startTime = new HecTime(this._times.element(0));
                    if (!startTime.isDefined()) {
                        startTime.set(this._timeSeriesContainer.getStartTime());
                    }
                    for (int i = 0; i < size; ++i) {
                        this._times.set(i, startTime);
                        this._times.elementAt(i).increment(i, this._timeSeriesContainer.interval);
                    }
                }
            } else if (!this._times.element(0).isDefined()) {
                HecTime startTime = new HecTime();
                startTime.set(this._timeSeriesContainer.getStartTime());
                this._times.set(0, startTime);
            }
        }
    }

    public int updateContainer(int numberExtendedRows, int[] firstError, boolean trimMissing) {
        return 0;
    }

    public boolean isEditable() {
        return true;
    }

    public int getNumberValues() {
        return this._timeSeriesContainer.numberValues;
    }

    public HecTime getTimeAt(int i) {
        if (!this.isValidElement(i)) {
            return new HecTime();
        }
        return this._times.element(i);
    }

    public void setTimeAt(HecTime time, int row) {
        if (this.isValidElement(row)) {
            this._times.set(row, time);
        }
        this._dataChanged = true;
    }

    public boolean isValidTime(HecTime tableTime) {
        HecTime dataTime;
        int columnOffset;
        if (this._timeSeriesContainer.interval == 0) {
            return tableTime.isDefined();
        }
        if (this._timeSeriesContainer.startTime == 0) {
            return false;
        }
        int tableOffset = tableTime.getIntervalOffset(this._timeSeriesContainer.interval);
        return tableOffset == (columnOffset = (dataTime = this._times.numberElements() > 0 && this._times.element(0).isDefined() ? this._times.element(0) : new HecTime(this._timeSeriesContainer.startTime, 1)).getIntervalOffset(this._timeSeriesContainer.interval));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean extendDataSet(HecTime time) {
        int currentNumber = this._times.numberElements() - 1;
        if (currentNumber < 0) {
            if (this._timeSeriesContainer.startTime == 0) return false;
            this._times.setSize(1);
            this._times.setElementAt(new HecTime(this._timeSeriesContainer.startTime, 1), 0);
            if (this._timeSeriesContainer.numberValues == 0) {
                this._timeSeriesContainer.numberValues = 1;
                this._timeSeriesContainer.values = new double[1];
                this._timeSeriesContainer.times = new int[1];
                this._timeSeriesContainer.times[0] = this._timeSeriesContainer.startTime;
            }
        }
        if (this._timeSeriesContainer.interval > 0) {
            if (time.lessThan(this._times.element(0))) {
                int numberIntervals = time.computeNumberIntervals(this._times.element(0), this._timeSeriesContainer.interval);
                this.insertRowsBefore(0, numberIntervals);
                return true;
            } else {
                if (!time.greaterThan(this._times.element(currentNumber))) return false;
                int numberIntervals = this._times.element(currentNumber).computeNumberIntervals(time, this._timeSeriesContainer.interval);
                this.appendRows(numberIntervals);
            }
            return true;
        } else if (time.lessThan(this._times.element(0))) {
            this.insertRowsBefore(0, 1);
            return true;
        } else {
            int idx = this._times.lastDefined();
            if (idx < 0) {
                return false;
            }
            if (!time.greaterThan(this._times.element(idx))) return false;
            this.appendRows(1);
            this._times.setElementAt((HecTime)time.clone(), ++idx);
        }
        return true;
    }

    public HecTimeArray getTimeArray() {
        return this._times;
    }

    public String getUnits() {
        return "";
    }

    public String getType() {
        return "";
    }

    public String getVersion(TimeZone viewTimeZone) {
        return "";
    }

    public int setValue(int row, Object str, StringBuffer errorMessage) {
        if (this.isValidElement(row)) {
            return 0;
        }
        return -1;
    }

    public void setUnits(String units) {
    }

    public void setType(String type) {
    }

    protected void setTimeZone(TimeZone zone) {
        this._times.setTimeZone(zone);
    }

    public void setDescription(int partNumber, String value) {
        if (partNumber == 0) {
            this._timeSeriesContainer.watershed = value;
        } else if (partNumber == 1) {
            this._timeSeriesContainer.location = value;
        } else if (partNumber == 2) {
            this._timeSeriesContainer.parameter = value;
        } else if (partNumber != 3 && partNumber == 4) {
            this._timeSeriesContainer.version = value;
        }
    }

    public String getDescription(int partNumber) {
        if (partNumber == 0) {
            return this._timeSeriesContainer.watershed;
        }
        if (partNumber == 1) {
            Object loc = this._timeSeriesContainer.location;
            if (this._timeSeriesContainer.subLocation.length() > 0) {
                loc = (String)loc + "-" + this._timeSeriesContainer.subLocation;
            }
            return loc;
        }
        if (partNumber == 2) {
            Object param = this._timeSeriesContainer.parameter;
            if (this._timeSeriesContainer.subParameter.length() > 0) {
                param = (String)param + "-" + this._timeSeriesContainer.subParameter;
            }
            return param;
        }
        if (partNumber != 3 && partNumber == 4) {
            Object vers = this._timeSeriesContainer.version;
            if (this._timeSeriesContainer.subVersion.length() > 0) {
                vers = (String)vers + "-" + this._timeSeriesContainer.subVersion;
            }
            return vers;
        }
        return "";
    }

    protected boolean isValidElement(int i) {
        if (i < 0) {
            return false;
        }
        return i < this.getNumberValues();
    }

    public boolean hasDataChanged() {
        return this._dataChanged;
    }

    public boolean hasQuality() {
        if (this._timeSeriesContainer == null) {
            return false;
        }
        return this._timeSeriesContainer.quality != null || this._timeSeriesContainer.quality7 != null;
    }

    public String getFullName() {
        if (this._timeSeriesContainer != null) {
            return this._timeSeriesContainer.fullName;
        }
        return "";
    }

    public void setDataChanged(boolean changed) {
        this._dataChanged = changed;
    }

    public Integer getInitialStartTime() {
        return this._intialStartTime;
    }

    public Integer getInitialEndTime() {
        return this._intialEndTime;
    }
}

