/*
 * Decompiled with CFR 0.152.
 */
package hec.dataTable;

import hec.dataTable.TimeSeriesColumnBase;
import hec.heclib.util.HecDouble;
import hec.heclib.util.HecDoubleArray;
import hec.heclib.util.HecTime;
import hec.heclib.util.HecTimeArray;
import hec.io.TimeSeriesContainer;
import java.time.ZoneId;
import java.util.TimeZone;
import javax.swing.JOptionPane;
import mil.army.usace.hec.data.timeseries.VersionDate;
import mil.army.usace.hec.data.timeseries.VersionDateFormatter;

public class TimeSeriesDataColumn
extends TimeSeriesColumnBase {
    protected HecDoubleArray _values = new HecDoubleArray();
    private String _originalTimeZone;

    public TimeSeriesDataColumn(TimeSeriesContainer dataSet) {
        super(dataSet);
        TimeZone timeZone;
        if (dataSet.values != null) {
            this._values.set(dataSet.values);
        }
        if (dataSet.precision != -1) {
            this._values.setPrecision(dataSet.precision);
        }
        if (dataSet.times != null) {
            this._times.set(dataSet.times, dataSet.timeGranularitySeconds, dataSet.julianBaseDate);
        }
        if (dataSet.timeZoneID != null && dataSet.timeZoneID.length() > 0 && (timeZone = TimeZone.getTimeZone(dataSet.timeZoneID)) != null) {
            this._times.setTimeZone(timeZone);
        }
        this.checkPrecision();
    }

    @Override
    public int updateContainer(int numberExtendedRows, int[] firstError, boolean trimMissing) {
        int[] timesStuff;
        int j;
        int i;
        int numberValid;
        int last;
        int first = 0;
        if (trimMissing) {
            last = this._values.lastDefined();
        } else {
            last = this._values.numberElements() - numberExtendedRows - 1;
            if (last < this._values.lastDefined()) {
                last = this._values.lastDefined();
            } else if (last > this._values.lastDefined() && !this._times.element(last).isDefined()) {
                last = this._times.lastDefined();
            }
        }
        if (last < 0) {
            return 0;
        }
        int[] oldTimes = this._timeSeriesContainer.times;
        int[] oldQuality = this._timeSeriesContainer.quality;
        int[][] oldQuality7 = this._timeSeriesContainer.quality7;
        int[][] oldnotes = this._timeSeriesContainer.inotes;
        String[] oldCnotes = this._timeSeriesContainer.cnotes;
        this._timeSeriesContainer.numberValues = numberValid = last - first + 1;
        if (numberValid < this._values.numberElements()) {
            this._values.resize(numberValid);
        }
        if (numberValid < this._times.numberElements()) {
            this._times.resize(numberValid);
        }
        this._timeSeriesContainer.julianBaseDate = 0;
        this._timeSeriesContainer.timeGranularitySeconds = 60;
        TimeZone storeTimeZone = null;
        TimeZone viewTimezone = this._times.getViewTimeZone();
        if (viewTimezone != null && this._timeSeriesContainer.timeZoneID != null) {
            storeTimeZone = TimeZone.getTimeZone(this._timeSeriesContainer.timeZoneID);
            this._times.setViewTimeZone(storeTimeZone);
        }
        HecTime htime = this._timeSeriesContainer.getStartTime();
        if (this._times.element(first).lessThan(htime)) {
            this._timeSeriesContainer.setStartTime(this._times.element(first));
        }
        htime = this._timeSeriesContainer.getEndTime();
        if (this._times.element(last).greaterThan(htime)) {
            this._timeSeriesContainer.setEndTime(this._times.element(last));
        }
        int numberErrors = 0;
        this._timeSeriesContainer.set(this._values.getDoubleArray(), this._times);
        if (storeTimeZone != null) {
            this._times.setViewTimeZone(viewTimezone);
        }
        if (numberErrors > 0) {
            return numberErrors;
        }
        if (this._timeSeriesContainer.precision == -1) {
            this._timeSeriesContainer.precision = this._values.precision();
        }
        if (this._timeSeriesContainer.precision < this._values.precision()) {
            this._timeSeriesContainer.precision = this._values.precision();
        }
        if (oldQuality != null) {
            this._timeSeriesContainer.quality = new int[numberValid];
            for (i = 0; i < numberValid; ++i) {
                this._timeSeriesContainer.quality[i] = 0;
            }
        }
        if (oldQuality7 != null) {
            this._timeSeriesContainer.quality7 = new int[numberValid][this._timeSeriesContainer.sizeEachQuality7];
            for (i = 0; i < numberValid; ++i) {
                for (j = 0; j < this._timeSeriesContainer.sizeEachQuality7; ++j) {
                    this._timeSeriesContainer.quality7[i][j] = 0;
                }
            }
        }
        if (oldnotes != null) {
            this._timeSeriesContainer.inotes = new int[numberValid][this._timeSeriesContainer.sizeEachNote];
            for (i = 0; i < numberValid; ++i) {
                for (j = 0; j < this._timeSeriesContainer.sizeEachNote; ++j) {
                    this._timeSeriesContainer.inotes[i][j] = 0;
                }
            }
        }
        if (oldCnotes != null) {
            this._timeSeriesContainer.cnotes = new String[numberValid];
            for (i = 0; i < numberValid; ++i) {
                this._timeSeriesContainer.cnotes[i] = "";
            }
        }
        HecTimeArray newTimes = new HecTimeArray();
        newTimes.set(this._times);
        HecTime time = new HecTime();
        if (oldTimes != null) {
            for (int i2 = 0; i2 < oldTimes.length; ++i2) {
                int j2;
                time.set(oldTimes[i2]);
                int pos = newTimes.index(time, true, this._timeSeriesContainer.interval);
                if (oldQuality != null && pos > -1 && pos < this._timeSeriesContainer.quality.length && i2 < oldQuality.length) {
                    this._timeSeriesContainer.quality[pos] = oldQuality[i2];
                }
                if (oldQuality7 != null && pos > -1 && pos < this._timeSeriesContainer.quality7.length && i2 < oldQuality7.length) {
                    for (j2 = 0; j2 < this._timeSeriesContainer.sizeEachQuality7; ++j2) {
                        this._timeSeriesContainer.quality7[pos][j2] = oldQuality7[i2][j2];
                    }
                }
                if (oldnotes != null && pos > -1 && pos < this._timeSeriesContainer.inotes.length && i2 < oldnotes.length) {
                    for (j2 = 0; j2 < this._timeSeriesContainer.sizeEachNote; ++j2) {
                        this._timeSeriesContainer.inotes[pos][j2] = oldnotes[i2][j2];
                    }
                }
                if (oldCnotes == null || pos <= -1 || pos >= this._timeSeriesContainer.cnotes.length || i2 >= oldCnotes.length) continue;
                this._timeSeriesContainer.cnotes[pos] = oldCnotes[i2];
            }
        }
        if ((timesStuff = TimeSeriesContainer.getJulianDateAndTimeGranularity(this._times, this._timeSeriesContainer.values.length)) != null) {
            this._timeSeriesContainer.julianBaseDate = timesStuff[0];
            this._timeSeriesContainer.timeGranularitySeconds = timesStuff[1];
        }
        if (this._timeSeriesContainer.endTime != this._timeSeriesContainer.times[this._timeSeriesContainer.times.length - 1]) {
            this._timeSeriesContainer.endTime = this._timeSeriesContainer.times[this._timeSeriesContainer.times.length - 1];
        }
        if (this._times.hasTimeZone()) {
            TimeZone zone = this._times.getTimeZone();
            this._timeSeriesContainer.timeZoneID = zone.getID();
            this._timeSeriesContainer.timeZoneRawOffset = zone.getRawOffset();
        } else {
            this._timeSeriesContainer.timeZoneID = null;
        }
        return 0;
    }

    @Override
    public int getNumberValues() {
        return this._values.numberElements();
    }

    @Override
    public String getUnits() {
        return this._timeSeriesContainer.units;
    }

    @Override
    public String getType() {
        return this._timeSeriesContainer.type;
    }

    @Override
    public String getVersion(TimeZone viewTimeZone) {
        String versionDate = "";
        if (this._timeSeriesContainer.getVersionDate() != null) {
            if (viewTimeZone == null) {
                viewTimeZone = TimeZone.getTimeZone("UTC");
            }
            ZoneId zoneId = viewTimeZone.toZoneId();
            versionDate = VersionDateFormatter.format((VersionDate)this._timeSeriesContainer.getVersionDate(), (ZoneId)zoneId);
        }
        return versionDate;
    }

    @Override
    public String getValue(int i, boolean showCommas) {
        return this.getObject(i).toString();
    }

    @Override
    protected Object getObject(int position) {
        if (!this.isValidElement(position) || !this._values.element(position).isDefined()) {
            int precision = this._values.precision();
            HecDouble hecDouble = new HecDouble();
            hecDouble.setPrecision(precision);
            return hecDouble;
        }
        return this._values.element(position);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int setValue(int row, Object obj, StringBuffer errorMessage) {
        String str = obj.toString();
        int status = 0;
        if (!this.isValidElement(row)) return -1;
        int element = row;
        HecDouble d = this._values.element(row);
        if (str == null) {
            d.setUndefined();
        } else if (str.length() == 0) {
            d.setUndefined();
        } else {
            if (obj instanceof HecDouble) {
                d.set((HecDouble)obj);
            } else {
                status = d.set(str);
            }
            if (d.value() == -901.0) {
                d.setUndefined();
            }
        }
        if (status != 0 && (str.equals("M") || str.equals("-M-"))) {
            d.setUndefined();
            status = 0;
        }
        if (status == 0) {
            this._values.set(element, d);
            this._dataChanged = true;
            return status;
        } else {
            String message = "Invalid number: " + str + ";  ordinate = " + row;
            System.out.println(message);
            if (errorMessage != null) {
                if (errorMessage.length() >= 10) return status;
                errorMessage.append(message);
                return status;
            } else {
                JOptionPane.showMessageDialog(null, message, "Table error", 2);
                return -1;
            }
        }
    }

    @Override
    public void setUnits(String units) {
        this._timeSeriesContainer.units = units;
        this._dataChanged = true;
    }

    @Override
    public void setType(String type) {
        this._timeSeriesContainer.type = type;
        this._dataChanged = true;
    }

    public HecDoubleArray getDataArray() {
        return this._values;
    }

    public void setDecimalPosition(int position) {
        if (this._values != null) {
            this._values.setPrecision(position);
            if (position == -1) {
                this.checkPrecision();
            }
        }
    }

    public int getDecimalPosition() {
        if (this._values != null) {
            return this._values.precision();
        }
        return -1;
    }

    public void checkPrecision() {
        if (this._values == null) {
            return;
        }
        if (this._values.precision() > -1) {
            return;
        }
        String units = this._timeSeriesContainer.units;
        if (units != null && (units = units.toUpperCase()).startsWith("INCH")) {
            this._values.setPrecision(2);
            return;
        }
        int estPrec = this._values.estimatePrecision();
        this._values.setPrecision(estPrec);
    }

    @Override
    public void appendRows(int numberRows) {
        super.appendRows(numberRows);
        this._values.resize(this._values.numberElements() + numberRows);
    }

    @Override
    public void insertRowsBefore(int startRow, int numberRows) {
        super.insertRowsBefore(startRow, numberRows);
        this._values.resize(this._values.numberElements() + numberRows, startRow);
    }

    @Override
    public void insertRowsBefore(int startRow, int numberRows, HecTimeArray newTimes) {
        super.insertRowsBefore(startRow, numberRows, newTimes);
        this._values.resize(this._values.numberElements() + numberRows, startRow);
    }

    @Override
    public void deleteRows(int startRow, int numberRows) {
        super.deleteRows(startRow, numberRows);
        this._values.resize(this._values.numberElements() - numberRows, startRow);
    }

    public String getOriginalTimeZoneId() {
        return this._originalTimeZone;
    }

    public void setOriginalTimeZoneId(String originalTimeZone) {
        this._originalTimeZone = originalTimeZone;
    }
}

