/*
 * Decompiled with CFR 0.152.
 */
package hec.dataTable;

import hec.data.TimeSeriesDataEditorListener;
import hec.data.TimeWindowMap;
import hec.dataTable.DataModel;
import hec.dataTable.HecDataTable;
import hec.dataTable.SavableDataFrame;
import hec.dataTable.TimeSeriesColumnBase;
import hec.dataTable.TimeSeriesDataColumn;
import hec.dataTable.TimeSeriesNotesColumn;
import hec.dataTable.TimeSeriesQualityColumn;
import hec.heclib.dss.DSSPathname;
import hec.heclib.dss.HecTimeSeries;
import hec.heclib.util.HecDouble;
import hec.heclib.util.HecTime;
import hec.heclib.util.HecTimeArray;
import hec.heclib.util.intArrayContainer;
import hec.heclib.util.intContainer;
import hec.io.TimeSeriesCollectionContainer;
import hec.io.TimeSeriesContainer;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.Vector;
import java.util.function.IntUnaryOperator;
import javax.swing.JOptionPane;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import rma.util.RMAConst;
import rma.util.RMAIO;

public class TimeSeriesDataModel
extends DataModel {
    protected static TimeZone _viewTimeZone = null;
    protected boolean _dateTimeAsTwoColumns = true;
    protected boolean _allIrregular = false;
    protected boolean _allSameInterval = false;
    protected boolean _timePattern = false;
    protected int _qualityStyle;
    protected static int _defaultDateStyle = 7;
    protected int _dateStyle = 7;
    protected int _undefinedStyle = 0;
    protected boolean _reverseOrder = false;
    protected String _timeZoneID = null;
    protected int _timeZoneRawOffset = 0;
    protected HecTimeArray _time;
    protected int _unitsRow = 0;
    protected int _typeRow = 1;
    protected int _versionRow = 2;
    private int[] _originalTimes;
    private boolean _bVersionRow = false;

    public TimeSeriesDataModel() {
        this.setNumberHeaderRows(2);
        this._dateStyle = _defaultDateStyle;
    }

    public static void setGlobalViewTimeZone(TimeZone viewTimeZone) {
        _viewTimeZone = viewTimeZone;
    }

    public static TimeZone getGlobalViewTimeZone() {
        return _viewTimeZone;
    }

    private static boolean stringIsNullOrEmpty(String string) {
        return string == null || string.isEmpty();
    }

    public int setData(List dataSets, boolean showCommas, int qualityStyle) {
        TimeZone timeZone;
        this._showCommas = showCommas;
        this._qualityStyle = qualityStyle;
        this._dataColumns = new Vector();
        this._time = new HecTimeArray();
        boolean haveData = false;
        int numberTimePattern = 0;
        for (int i = 0; i < dataSets.size(); ++i) {
            TimeSeriesQualityColumn timeSeriesQualityColumn;
            TimeSeriesDataColumn timeSeriesDataColumn;
            TimeSeriesContainer timeSeriesContainer;
            int j;
            if (dataSets.get(i) instanceof TimeSeriesCollectionContainer) {
                TimeSeriesCollectionContainer tscc = (TimeSeriesCollectionContainer)dataSets.get(i);
                TimeSeriesContainer[] tscArray = tscc.get();
                for (j = 0; j < tscArray.length; ++j) {
                    timeSeriesContainer = tscArray[j];
                    String originalTimeZone = timeSeriesContainer.timeZoneID;
                    if (TimeSeriesDataModel.stringIsNullOrEmpty(this._timeZoneID) && !TimeSeriesDataModel.stringIsNullOrEmpty(timeSeriesContainer.timeZoneID)) {
                        this._timeZoneID = timeSeriesContainer.timeZoneID;
                        this._timeZoneRawOffset = timeSeriesContainer.timeZoneRawOffset;
                    } else if (!(TimeSeriesDataModel.stringIsNullOrEmpty(this._timeZoneID) && TimeSeriesDataModel.stringIsNullOrEmpty(timeSeriesContainer.timeZoneID) || !TimeSeriesDataModel.stringIsNullOrEmpty(this._timeZoneID) && TimeSeriesDataModel.stringIsNullOrEmpty(timeSeriesContainer.timeZoneID) || timeSeriesContainer.timeZoneID == null || this._timeZoneID.equals(timeSeriesContainer.timeZoneID))) {
                        timeSeriesContainer = this.convertTimeZone(timeSeriesContainer, this._timeZoneID, this._timeZoneRawOffset);
                    }
                    timeSeriesDataColumn = new TimeSeriesDataColumn(timeSeriesContainer);
                    timeSeriesDataColumn.setOriginalTimeZoneId(originalTimeZone);
                    if (timeSeriesDataColumn.getNumberValues() > 0) {
                        haveData = true;
                    }
                    this._dataColumns.addElement(timeSeriesDataColumn);
                    if (timeSeriesDataColumn.hasQuality() && qualityStyle > 0) {
                        timeSeriesQualityColumn = new TimeSeriesQualityColumn(timeSeriesContainer, qualityStyle);
                        this._dataColumns.addElement(timeSeriesQualityColumn);
                    }
                    if (timeSeriesContainer.fullName.indexOf("/TS-P") <= 0 || timeSeriesContainer.fullName.toUpperCase().indexOf("/TS-PATTERN") <= 0) continue;
                    ++numberTimePattern;
                }
                continue;
            }
            timeSeriesContainer = (TimeSeriesContainer)dataSets.get(i);
            String originalTimeZone = timeSeriesContainer.timeZoneID;
            if (TimeSeriesDataModel.stringIsNullOrEmpty(this._timeZoneID) && !TimeSeriesDataModel.stringIsNullOrEmpty(timeSeriesContainer.timeZoneID)) {
                this._timeZoneID = timeSeriesContainer.timeZoneID;
                this._timeZoneRawOffset = timeSeriesContainer.timeZoneRawOffset;
            } else if (!(TimeSeriesDataModel.stringIsNullOrEmpty(this._timeZoneID) && TimeSeriesDataModel.stringIsNullOrEmpty(timeSeriesContainer.timeZoneID) || !TimeSeriesDataModel.stringIsNullOrEmpty(this._timeZoneID) && TimeSeriesDataModel.stringIsNullOrEmpty(timeSeriesContainer.timeZoneID) || timeSeriesContainer.timeZoneID == null || this._timeZoneID.equals(timeSeriesContainer.timeZoneID))) {
                timeSeriesContainer = this.convertTimeZone(timeSeriesContainer, this._timeZoneID, this._timeZoneRawOffset);
            }
            if (timeSeriesContainer.numberDepths > 0) {
                Vector<TimeSeriesContainer> containers = HecTimeSeries.expandProfileContainer(timeSeriesContainer);
                for (j = 0; j < containers.size(); ++j) {
                    TimeSeriesContainer tsc = containers.get(j);
                    timeSeriesDataColumn = new TimeSeriesDataColumn(tsc);
                    timeSeriesDataColumn.setOriginalTimeZoneId(originalTimeZone);
                    if (tsc.numberValues > 0) {
                        haveData = true;
                    }
                    this._dataColumns.addElement(timeSeriesDataColumn);
                    if (!timeSeriesDataColumn.hasQuality() || qualityStyle <= 0) continue;
                    timeSeriesQualityColumn = new TimeSeriesQualityColumn(tsc, qualityStyle);
                    this._dataColumns.addElement(timeSeriesQualityColumn);
                }
            } else {
                TimeSeriesDataColumn timeSeriesDataColumn2 = new TimeSeriesDataColumn(timeSeriesContainer);
                timeSeriesDataColumn2.setOriginalTimeZoneId(originalTimeZone);
                if (timeSeriesDataColumn2.getNumberValues() > 0) {
                    haveData = true;
                }
                this._dataColumns.addElement(timeSeriesDataColumn2);
                if (timeSeriesDataColumn2.hasQuality() && qualityStyle > 0) {
                    TimeSeriesQualityColumn timeSeriesQualityColumn2 = new TimeSeriesQualityColumn(timeSeriesContainer, qualityStyle);
                    this._dataColumns.addElement(timeSeriesQualityColumn2);
                }
                if (timeSeriesContainer.fullName.indexOf("/TS-P") > 0 && timeSeriesContainer.fullName.toUpperCase().indexOf("/TS-PATTERN") > 0) {
                    ++numberTimePattern;
                }
            }
            if (timeSeriesContainer.inotes == null && timeSeriesContainer.cnotes == null) continue;
            TimeSeriesNotesColumn timeSeriesNotesColumn = new TimeSeriesNotesColumn(timeSeriesContainer);
            this._dataColumns.addElement(timeSeriesNotesColumn);
        }
        if (numberTimePattern == dataSets.size()) {
            this._timePattern = true;
        }
        if (this._timeZoneID != null && (timeZone = TimeZone.getTimeZone(this._timeZoneID)) != null) {
            timeZone.setRawOffset(this._timeZoneRawOffset);
            if (!this._timeZoneID.equals(timeZone.getID())) {
                timeZone.setID(this._timeZoneID);
            }
            this._time.setTimeZone(timeZone);
        }
        this._bVersionRow = this.requiresVersionRow();
        this.orderTimeSeries();
        this._time.setViewTimeZone(_viewTimeZone);
        this._time.showTimeAsBeginningOfDay(this._showTimeAsBeginning);
        this.checkIntervals();
        this._originalTimes = this._time.getIntArray();
        if (haveData) {
            return 0;
        }
        return -1;
    }

    private boolean requiresVersionRow() {
        for (Object dataColumn : this._dataColumns) {
            TimeSeriesContainer timeSeriesContainer;
            if (!(dataColumn instanceof TimeSeriesColumnBase) || (timeSeriesContainer = ((TimeSeriesColumnBase)dataColumn).getDataContainer()).getVersionDate() == null || !timeSeriesContainer.getVersionDate().getVersionDate().isPresent()) continue;
            return true;
        }
        return false;
    }

    protected TimeSeriesContainer convertTimeZone(TimeSeriesContainer tsc, String timeZoneID, int timeZoneRawOffset) {
        HecTime time;
        TimeSeriesContainer ntsc = (TimeSeriesContainer)tsc.clone();
        TimeZone fromTimeZone = TimeZone.getTimeZone(tsc.timeZoneID);
        TimeZone timeZone = TimeZone.getTimeZone(timeZoneID);
        for (int j = 0; j < tsc.times.length; ++j) {
            time = HecTime.convertToTimeZone(tsc.times[j], fromTimeZone, timeZone);
            ntsc.times[j] = time.value();
        }
        time = HecTime.convertToTimeZone(tsc.startTime, fromTimeZone, timeZone);
        ntsc.startTime = time.value();
        time = HecTime.convertToTimeZone(tsc.endTime, fromTimeZone, timeZone);
        ntsc.endTime = time.value();
        ntsc.timeZoneID = timeZoneID;
        ntsc.timeZoneRawOffset = timeZoneRawOffset;
        return ntsc;
    }

    @Override
    public Vector getDataContainers() {
        Vector<TimeSeriesContainer> containers = new Vector<TimeSeriesContainer>();
        for (int i = 0; i < this._dataColumns.size(); ++i) {
            String originalTimeZone;
            TimeSeriesColumnBase columnBase = (TimeSeriesColumnBase)this._dataColumns.elementAt(i);
            if (!(columnBase instanceof TimeSeriesDataColumn)) continue;
            TimeSeriesContainer tsc = columnBase.getDataContainer();
            if (this._timeZoneID != null && (originalTimeZone = ((TimeSeriesDataColumn)columnBase).getOriginalTimeZoneId()) != null && !this._timeZoneID.equals(originalTimeZone)) {
                tsc = this.convertTimeZone(tsc, originalTimeZone, this._timeZoneRawOffset);
            }
            containers.add(tsc);
        }
        return containers;
    }

    public void setDateTimeAsTwoColumns(boolean dateTimeAsTwoColumns) {
        this._dateTimeAsTwoColumns = dateTimeAsTwoColumns;
    }

    public boolean getDateTimeAsTwoColumns() {
        return this._dateTimeAsTwoColumns;
    }

    public static void setDefaultDateStyle(int dateStyle) {
        _defaultDateStyle = dateStyle;
    }

    public static int getDefaultDateStyle() {
        return _defaultDateStyle;
    }

    public void setDateStyle(int dateStyle) {
        this._dateStyle = dateStyle;
    }

    public int getDateStyle() {
        return this._dateStyle;
    }

    public HecTimeArray getTimeArray() {
        return this._time;
    }

    @Override
    public void setShowFullDefinition(boolean showFullDefinition) {
        super.setShowFullDefinition(showFullDefinition);
        if (showFullDefinition) {
            this.setNumberHeaderRows(7);
            this._unitsRow = 5;
            this._typeRow = 6;
            this._versionRow = 7;
            this._bVersionRow = this.requiresVersionRow();
        } else {
            this.setNumberHeaderRows(2);
            this._unitsRow = 0;
            this._typeRow = 1;
            this._versionRow = 2;
            this._bVersionRow = this.requiresVersionRow();
        }
    }

    @Override
    public Vector getDataSets() {
        Vector<TimeSeriesContainer> dataContainers = new Vector<TimeSeriesContainer>();
        if (this._dataColumns == null) {
            return dataContainers;
        }
        for (int i = 0; i < this._dataColumns.size(); ++i) {
            TimeSeriesColumnBase base = this.inColumn(i);
            if (base instanceof TimeSeriesQualityColumn) continue;
            TimeSeriesContainer tsc = base._timeSeriesContainer;
            dataContainers.addElement(tsc);
        }
        return dataContainers;
    }

    public Vector getDataColumns() {
        return this._dataColumns;
    }

    @Override
    public int getColumnCount() {
        int number = this._dataColumns.size() + 2;
        if (this._dateTimeAsTwoColumns) {
            ++number;
        }
        return number;
    }

    @Override
    public int getRowCount() {
        return this._time.numberElements() + this.getNumberHeaderRows();
    }

    @Override
    public String getColumnName(int column) {
        if (column == 0) {
            return "  \nOrdinate";
        }
        if (column == 1) {
            if (this._dateTimeAsTwoColumns) {
                return "  \nDate";
            }
            return "  \nDate / Time";
        }
        if (column == 2 && this._dateTimeAsTwoColumns) {
            return "  \nTime";
        }
        column -= 2;
        if (this._dateTimeAsTwoColumns) {
            --column;
        }
        return this.inColumn(column).getName();
    }

    @Override
    public String getNominalName() {
        if (this._dataColumns.size() == 0) {
            return "";
        }
        return this.inColumn(0).getFullName();
    }

    @Override
    public String getName() {
        if (this._dataColumns.size() == 0) {
            return "";
        }
        TimeSeriesContainer tsc = this.inColumn((int)0)._timeSeriesContainer;
        StringBuffer sb = new StringBuffer();
        if (tsc.location.length() > 0) {
            sb.append(tsc.location);
            if (tsc.subLocation.length() > 0) {
                sb.append("-");
                sb.append(tsc.subLocation);
            }
        }
        sb.append("-");
        if (tsc.parameter.length() > 0) {
            sb.append(tsc.parameter);
            if (tsc.subParameter.length() > 0) {
                sb.append("-");
                sb.append(tsc.subParameter);
            }
        }
        String name = sb.toString();
        return name;
    }

    @Override
    public void setDecimalPosition(int position) {
        for (int i = 0; i < this._dataColumns.size(); ++i) {
            this.setDecimalPosition(i, position);
        }
    }

    @Override
    public void setDecimalPosition(int column, int position) {
        if (this.inColumn(column) instanceof TimeSeriesDataColumn) {
            ((TimeSeriesDataColumn)this.inColumn(column)).setDecimalPosition(position);
        }
    }

    @Override
    public int getDecimalPosition() {
        int number = -1;
        for (int i = 0; i < this._dataColumns.size(); ++i) {
            int numb = this.getDecimalPosition(i);
            if (numb <= number) continue;
            number = numb;
        }
        return number;
    }

    @Override
    public int getDecimalPosition(int column) {
        int number = -1;
        if (this.inColumn(column) instanceof TimeSeriesDataColumn) {
            number = ((TimeSeriesDataColumn)this.inColumn(column)).getDecimalPosition();
        }
        return number;
    }

    @Override
    public int getDataColumnCount() {
        return this._dataColumns.size();
    }

    public void setUndefinedStyle(int undefinedStyle) {
        this._undefinedStyle = undefinedStyle;
    }

    public int getUndefinedStyle() {
        return this._undefinedStyle;
    }

    public boolean hasQuality() {
        for (int i = 0; i < this._dataColumns.size(); ++i) {
            if (!this.inColumn(i).hasQuality()) continue;
            return true;
        }
        return false;
    }

    @Override
    protected TableCellRenderer getCellRenderer(HecDataTable table, int row, int column) {
        if (row < this.getNumberHeaderRows()) {
            return this._headerRenderer;
        }
        if (column == 0) {
            return this._integerRenderer;
        }
        return this._integerRenderer;
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        int interval;
        TimeSeriesColumnBase dataColumn;
        if (!this._isEditable) {
            return false;
        }
        if (this._bVersionRow && row == this._versionRow) {
            return false;
        }
        if (column == 0) {
            return false;
        }
        if (column == 1) {
            if (row - this.getNumberHeaderRows() < 0) {
                return false;
            }
            return this._allIrregular;
        }
        if (column == 2 && this._dateTimeAsTwoColumns) {
            if (row - this.getNumberHeaderRows() < 0) {
                return false;
            }
            return this._allIrregular;
        }
        if (row < this.getNumberHeaderRows()) {
            return true;
        }
        row -= this.getNumberHeaderRows();
        column -= 2;
        if (this._dateTimeAsTwoColumns) {
            --column;
        }
        if (!(dataColumn = this.inColumn(column)).isEditable()) {
            return false;
        }
        int r = this.unMap(row, column);
        if (r == -1 && (interval = dataColumn._timeSeriesContainer.interval) > 0) {
            return this.isValidTime(row, column);
        }
        return true;
    }

    private TimeSeriesColumnBase inColumn(int i) {
        if (i < 0 || i >= this._dataColumns.size()) {
            return new TimeSeriesDataColumn(new TimeSeriesContainer());
        }
        return (TimeSeriesColumnBase)this._dataColumns.get(i);
    }

    public String getToolTipText(int row, int column) {
        int r;
        row -= this.getNumberHeaderRows();
        column -= 2;
        if (this._dateTimeAsTwoColumns) {
            --column;
        }
        if ((r = this.unMap(row, column)) == -1) {
            return "";
        }
        TimeSeriesColumnBase col = this.inColumn(column);
        if (col instanceof TimeSeriesQualityColumn) {
            return ((TimeSeriesQualityColumn)col).getQualityToolTip(r);
        }
        return col.getValue(r, this._showCommas);
    }

    protected int orderTimeSeries() {
        int i;
        int total = 0;
        int[] columnRowPosition = new int[this._dataColumns.size()];
        for (i = 0; i < this._dataColumns.size(); ++i) {
            total += this.inColumn(i).getNumberValues();
            columnRowPosition[i] = 0;
        }
        this._time.setSize(total);
        this._map = new intArrayContainer[this._dataColumns.size()];
        for (i = 0; i < this._dataColumns.size(); ++i) {
            this._map[i] = new intArrayContainer(total, -2);
        }
        HecTime min = new HecTime();
        int itime = 0;
        while (true) {
            int j;
            int i2;
            boolean done = true;
            for (i2 = 0; i2 < this._dataColumns.size(); ++i2) {
                j = columnRowPosition[i2];
                if (j >= this.inColumn(i2).getNumberValues()) continue;
                min = this.inColumn(i2).getTimeAt(j);
                done = false;
                break;
            }
            if (done) break;
            for (i2 = 0; i2 < this._dataColumns.size(); ++i2) {
                j = columnRowPosition[i2];
                if (j >= this.inColumn(i2).getNumberValues() || !this.inColumn(i2).getTimeAt(j).lessThan(min)) continue;
                min = this.inColumn(i2).getTimeAt(j);
            }
            this._time.set(itime, min);
            for (i2 = 0; i2 < this._dataColumns.size(); ++i2) {
                j = columnRowPosition[i2];
                if (j < this.inColumn(i2).getNumberValues()) {
                    if (this.inColumn(i2).getTimeAt(j).equalTo(min)) {
                        this.map(i2, itime, columnRowPosition[i2]);
                        int n = i2;
                        columnRowPosition[n] = columnRowPosition[n] + 1;
                        continue;
                    }
                    this.map(i2, itime, -1);
                    continue;
                }
                this.map(i2, itime, -1);
            }
            ++itime;
        }
        if (itime < total) {
            this._time.resize(itime);
        }
        return itime;
    }

    protected void reMap(int column) {
        this.reMap(column, 0);
    }

    protected void reMap(int column, int row) {
        int i;
        TimeSeriesColumnBase dataColumn = this.inColumn(column);
        HecTimeArray columnTimes = dataColumn.getTimeArray();
        int n = columnTimes.lastDefined();
        HecTime lastColumnTime = columnTimes.element(n);
        for (i = row; i < this._time.numberElements(); ++i) {
            int columnTimeIndex;
            HecTime timeSeq = this._time.elementAt(i);
            this._map[column].array[i] = timeSeq.isDefined() ? (columnTimeIndex = columnTimes.index(timeSeq, true, dataColumn._timeSeriesContainer.interval)) : -1;
            if (i > columnTimes.numberElements() && timeSeq.greaterThan(lastColumnTime)) break;
        }
        if (this._time.numberElements() < this._map[column].array.length) {
            for (i = this._time.numberElements(); i < this._map[column].array.length; ++i) {
                this._map[column].array[i] = -2;
            }
        }
    }

    @Override
    protected boolean isQualityColumn(int column) {
        column -= 2;
        if (this._dateTimeAsTwoColumns) {
            --column;
        }
        if (column >= this._dataColumns.size()) {
            return false;
        }
        Object obj = this._dataColumns.get(column);
        return obj instanceof TimeSeriesQualityColumn;
    }

    protected boolean hasQualityColumn(int column) {
        if (++column >= this._dataColumns.size()) {
            return false;
        }
        Object obj = this._dataColumns.get(column);
        return obj instanceof TimeSeriesQualityColumn;
    }

    public void setReverseOrder(boolean reverseOrder) {
        this._reverseOrder = reverseOrder;
    }

    public boolean getReverseOrder() {
        return this._reverseOrder;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (columnIndex == 0) {
            if (this._showFullDefinition && rowIndex < this._unitsRow) {
                if (rowIndex == 0) {
                    return "A";
                }
                if (rowIndex == 1) {
                    return "B";
                }
                if (rowIndex == 2) {
                    return "C";
                }
                if (rowIndex == 3) {
                    return "E";
                }
                if (rowIndex == 4) {
                    return "F";
                }
            }
            if (rowIndex == this._unitsRow && rowIndex < this.getNumberHeaderRows()) {
                return "Units";
            }
            if (rowIndex == this._typeRow && rowIndex < this.getNumberHeaderRows()) {
                return "Type";
            }
            if (this._bVersionRow && rowIndex == this._versionRow && rowIndex < this.getNumberHeaderRows()) {
                return "Version Date";
            }
            int ordinate = rowIndex - this.getNumberHeaderRows() + 1;
            if (ordinate <= this._time.numberElements()) {
                return ordinate;
            }
            return "";
        }
        if (columnIndex == 1) {
            return this.getTime(rowIndex, columnIndex);
        }
        if (columnIndex == 2 && this._dateTimeAsTwoColumns) {
            if (rowIndex < this.getNumberHeaderRows()) {
                return "";
            }
            return this.getTime(rowIndex, columnIndex);
        }
        if (rowIndex < this.getNumberHeaderRows()) {
            columnIndex -= 2;
            if (this._dateTimeAsTwoColumns) {
                --columnIndex;
            }
            if (rowIndex < this._unitsRow) {
                return this.inColumn(columnIndex).getDescription(rowIndex);
            }
            if (rowIndex == this._unitsRow) {
                return this.inColumn(columnIndex).getUnits();
            }
            if (rowIndex == this._typeRow) {
                return this.inColumn(columnIndex).getType();
            }
            if (this._bVersionRow && rowIndex == this._versionRow) {
                return this.inColumn(columnIndex).getVersion(this._time.getViewTimeZone());
            }
        }
        return this.getValue(rowIndex, columnIndex);
    }

    public Class getSortColumnClass(int columnIndex) {
        TimeSeriesColumnBase colBase;
        if (columnIndex < 2) {
            return Integer.class;
        }
        if (columnIndex == 2 && this._dateTimeAsTwoColumns) {
            return Integer.class;
        }
        columnIndex -= 2;
        if (this._dateTimeAsTwoColumns) {
            --columnIndex;
        }
        if ((colBase = this.inColumn(columnIndex)) instanceof TimeSeriesQualityColumn || colBase == null) {
            return String.class;
        }
        return Double.class;
    }

    @Override
    public Object getSortValueAt(int row, int column) {
        if (column == 0) {
            if (row <= 0 && row < this.getNumberHeaderRows()) {
                return new Integer(0);
            }
            int ordinate = row - this.getNumberHeaderRows() + 1;
            return new Integer(ordinate);
        }
        if ((column == 1 || column == 2 && this._dateTimeAsTwoColumns) && this._time.numberElements() > (row -= this.getNumberHeaderRows())) {
            HecTime time = this._time.element(row);
            if (column == 2) {
                return new Integer(time.minutesSinceMidnight());
            }
            return new Integer(time.value());
        }
        if (row < this.getNumberHeaderRows()) {
            return new Integer(0);
        }
        Object obj = this.getObject(row, column);
        if (obj instanceof HecDouble) {
            return new Double(((HecDouble)obj).value());
        }
        return obj.toString();
    }

    protected Object getValue(int row, int column) {
        Object obj = this.getObject(row, column);
        if (obj instanceof HecDouble) {
            HecDouble hecDouble = (HecDouble)obj;
            hecDouble.setShowCommas(this._showCommas);
            if (!hecDouble.isDefined()) {
                if (this._undefinedStyle == 1) {
                    int precision = hecDouble.precision();
                    return new HecDouble(-901.0, precision).string();
                }
                if (this._undefinedStyle == 2) {
                    return "M";
                }
                if (this._undefinedStyle == 3) {
                    return "-M-";
                }
            }
            return hecDouble;
        }
        return obj.toString();
    }

    protected Object getObject(int row, int column) {
        int r;
        row -= this.getNumberHeaderRows();
        column -= 2;
        if (this._dateTimeAsTwoColumns) {
            --column;
        }
        if (this._reverseOrder) {
            row = this._time.numberElements() - row - 1;
        }
        if ((r = this.unMap(row, column)) == -1) {
            return new HecDouble();
        }
        Object obj = this.inColumn(column).getObject(r);
        return obj;
    }

    private Object getTime(int row, int column) {
        if (row == 2 && row < this.getNumberHeaderRows()) {
            if (this._time.hasViewTimeZone()) {
                return HecTimeArray.getZoneDisplayString(this._time.getViewTimeZone());
            }
            return "";
        }
        if ((row -= this.getNumberHeaderRows()) < 0) {
            return "";
        }
        if (this._time.numberElements() > row) {
            if (this._reverseOrder) {
                row = this._time.numberElements() - row - 1;
            }
            HecTime htime = (HecTime)this._time.element(row).clone();
            htime.setDefaultDateStyle(this._dateStyle);
            if (this._timePattern) {
                String date = htime.date();
                if (date.length() > 8) {
                    date = date.substring(0, 6);
                }
                if (this._dateTimeAsTwoColumns) {
                    if (column == 1) {
                        return date;
                    }
                } else {
                    if (this._showTimes && htime.isTimeDefined()) {
                        String time = htime.time();
                        return date + "   " + time;
                    }
                    return date;
                }
            }
            if (this._dateTimeAsTwoColumns) {
                if (column == 1) {
                    htime.setDefaultDateStyle(this._dateStyle + 1000);
                    return htime;
                }
                if (this._showTimes && htime.isTimeDefined()) {
                    return htime.time();
                }
                return "";
            }
            if (this._showTimes) {
                htime.setDefaultDateStyle(this._dateStyle);
                return htime;
            }
            htime.setDefaultDateStyle(this._dateStyle + 1000);
            return htime;
        }
        return "";
    }

    private int setTime(String dateTime, int row, int column) {
        if (dateTime == null) {
            return 0;
        }
        if (row == 2 && row < this.getNumberHeaderRows()) {
            String oldValue = ((String)this.getValueAt(row, column)).trim();
            if (oldValue.equals(dateTime)) {
                return 0;
            }
            if (oldValue.length() == 0) {
                this.setTimeZone(null);
            } else {
                TimeZone tz = TimeZone.getTimeZone(dateTime);
                String id = tz.getID();
                if (id.equalsIgnoreCase("GMT") && !id.equalsIgnoreCase(dateTime)) {
                    String message = "Invalid time zone: " + dateTime;
                    if (this._firstPasteError != null) {
                        if (this._firstPasteError.length() < 10) {
                            this._firstPasteError.append(message);
                        }
                    } else {
                        JOptionPane.showMessageDialog(null, message, "Table error", 2);
                        return -1;
                    }
                }
                if (id.equalsIgnoreCase("Custom")) {
                    tz.setID(dateTime);
                }
                this.setTimeZone(tz);
            }
            return 0;
        }
        row -= this.getNumberHeaderRows();
        if (this._reverseOrder) {
            row = this._time.numberElements() - row - 1;
        }
        if (this._time.numberElements() > row) {
            String message;
            int status = 0;
            HecTime time = new HecTime(this._time.element(row));
            if (!this._dateTimeAsTwoColumns) {
                if (this.isOnlyTime(dateTime)) {
                    status = time.setTime(dateTime);
                } else {
                    status = time.set(dateTime);
                    if (time.time() == null || time.time().isEmpty() && !dateTime.isEmpty()) {
                        time.setTime("2400");
                    }
                }
            } else {
                status = column == 1 ? (this.isOnlyTime(dateTime) ? time.setTime(dateTime) : time.setDate(dateTime)) : time.setTime(dateTime);
            }
            if (status != 0 && dateTime.trim().length() == 0) {
                status = 0;
            }
            if (status != 0) {
                message = "Invalid date / time: " + dateTime;
                if (row >= this.getRowCount()) {
                    time.setUndefined();
                    this._time.set(row, time);
                }
                if (this._firstPasteError != null) {
                    if (this._firstPasteError.length() < 10) {
                        this._firstPasteError.append(message);
                    }
                } else {
                    JOptionPane.showMessageDialog(null, message, "Table error", 2);
                    this.fireTableDataChanged();
                    return status;
                }
            }
            if (time.timeIncrement() == 1 && time.isDefined() && row > 0) {
                if (this._time.element(row - 1).isDefined() && time.lessThan(this._time.element(row - 1))) {
                    message = "Date / time is not ascending:\n" + time.toString() + " (row " + (row + 1) + ") occurs before\n" + this._time.element(row - 1).toString() + " (row " + row + ")";
                    if (this._firstPasteError != null) {
                        if (this._firstPasteError.length() < 10) {
                            this._firstPasteError.append(message);
                        }
                    } else {
                        JOptionPane.showMessageDialog(null, message, "Table error", 2);
                        return -1;
                    }
                }
                if (this._time.numberElements() > row + 1 && this._time.element(row + 1).isDefined() && time.greaterThan(this._time.element(row + 1))) {
                    message = "Date / time is not ascending:\n" + time.toString() + " (row " + (row + 1) + ") occurs after\n" + this._time.element(row + 1).toString() + " (row " + (row + 2) + ")";
                    if (this._firstPasteError != null) {
                        if (this._firstPasteError.length() < 10) {
                            this._firstPasteError.append(message);
                        }
                    } else {
                        JOptionPane.showMessageDialog(null, message, "", 2);
                        return -1;
                    }
                }
            }
            this._time.set(row, time);
            for (int n = 0; n < this._dataColumns.size(); ++n) {
                int r = this.unMap(row, n);
                if (r == -1) {
                    if (row > 0) {
                        int rmap = this.unMap(row - 1, n);
                        if (rmap != -1) {
                            ++rmap;
                        }
                        this.map(n, row, rmap);
                    } else {
                        this.map(n, row, 0);
                    }
                    r = this.unMap(row, n);
                }
                if (r == -1) continue;
                TimeSeriesColumnBase dataColumn = this.inColumn(n);
                dataColumn.setTimeAt(time, r);
            }
        }
        return 0;
    }

    private boolean isOnlyTime(String dateTime) {
        int length = dateTime.length();
        return dateTime.contains(":") && length == 5 || length == 4 || length == 3 && !dateTime.contains("/") && !dateTime.contains("-");
    }

    private void setTimeZone(TimeZone zone) {
        this._time.setTimeZone(zone);
        for (int i = 0; i < this._dataColumns.size(); ++i) {
            TimeSeriesColumnBase columnBase = (TimeSeriesColumnBase)this._dataColumns.get(i);
            columnBase.setTimeZone(zone);
        }
    }

    @Override
    public void showTimeAsBeginningOfDay(boolean showTimeAsBeginning) {
        if (this._time != null) {
            this._time.showTimeAsBeginningOfDay(showTimeAsBeginning);
        }
        super.showTimeAsBeginningOfDay(showTimeAsBeginning);
    }

    @Override
    public int setValue(Object ovalue, int row, int column) {
        int rowsLeft;
        int r;
        String svalue = ovalue.toString();
        if (column == 0) {
            return -1;
        }
        if (this._pasteMode && this._allIrregular && column == 1 && svalue.trim().length() > 11) {
            StringTokenizer stringTokenizer = new StringTokenizer(svalue);
            int numb = stringTokenizer.countTokens();
            if (numb > 1) {
                Object date = null;
                String time = null;
                String val = null;
                String first = stringTokenizer.nextToken();
                if (numb == 2) {
                    date = first;
                    time = stringTokenizer.nextToken();
                } else if ((first.length() <= 2 || Character.isLetter(first.charAt(0))) && numb >= 3) {
                    if (numb == 3) {
                        return this.setTime(svalue, row, column);
                    }
                    String monthStr = stringTokenizer.nextToken();
                    String yearStr = stringTokenizer.nextToken();
                    yearStr = RMAIO.removeChar(yearStr, ',');
                    date = first + " " + monthStr + " " + yearStr;
                    time = stringTokenizer.nextToken();
                    if (numb == 5) {
                        val = stringTokenizer.nextToken();
                    }
                } else if (numb == 3) {
                    date = first;
                    time = stringTokenizer.nextToken();
                    val = stringTokenizer.nextToken();
                }
                if (date != null) {
                    this.setTime((String)date, row, column++);
                }
                if (time != null) {
                    int istat = this.setTime(time, row, column++);
                    if (val == null) {
                        return istat;
                    }
                }
                if (val != null) {
                    svalue = val;
                }
            }
        } else {
            if (column == 1) {
                return this.setTime(svalue, row, column);
            }
            if (column == 2 && this._dateTimeAsTwoColumns) {
                return this.setTime(svalue, row, column);
            }
        }
        column -= 2;
        if (this._dateTimeAsTwoColumns) {
            --column;
        }
        if (this._showFullDefinition && row < this._unitsRow) {
            this.inColumn(column).setDescription(row, svalue);
        }
        if (row == this._unitsRow && row < this.getNumberHeaderRows()) {
            this.inColumn(column).setUnits(svalue);
            if (this.hasQualityColumn(column)) {
                this.inColumn(column + 1).setUnits(svalue);
            }
            return 0;
        }
        if (row == this._typeRow && row < this.getNumberHeaderRows()) {
            this.inColumn(column).setType(svalue);
            if (this.hasQualityColumn(column)) {
                this.inColumn(column + 1).setType(svalue);
            }
            return 0;
        }
        row -= this.getNumberHeaderRows();
        if (this._reverseOrder) {
            row = this._time.numberElements() - row - 1;
        }
        if ((r = this.unMap(row, column)) == -1) {
            if (svalue.trim().length() == 0) {
                return 0;
            }
            if (this.isValidTime(row, column)) {
                this.extendDataSet(row, column);
                r = this.unMap(row, column);
            }
        }
        if (r == -1) {
            return -1;
        }
        int status = this.inColumn(column).setValue(r, ovalue, this._firstPasteError);
        if (this._isExtendable && this._numberBlankRows > 0 && (rowsLeft = this._time.numberElements() - row - 1) < this._numberBlankRows && svalue.length() > 0) {
            int number = this._numberBlankRows - rowsLeft;
            this.appendRows(number);
        }
        return status;
    }

    protected boolean isValidTime(int row, int column) {
        if (row < 0) {
            return false;
        }
        if (this._time.numberElements() > row) {
            HecTime tableTime = this._time.element(row);
            TimeSeriesColumnBase dataColumn = this.inColumn(column);
            return dataColumn.isValidTime(tableTime);
        }
        return false;
    }

    protected boolean extendDataSet(int row, int column) {
        if (!this.isValidTime(row, column)) {
            return false;
        }
        TimeSeriesColumnBase dataColumn = this.inColumn(column);
        dataColumn.extendDataSet(this._time.element(row));
        this.reMap(column, row);
        if (dataColumn instanceof TimeSeriesDataColumn) {
            if (this.hasQualityColumn(column) && (dataColumn = this.inColumn(++column)) != null) {
                dataColumn.extendDataSet(this._time.element(row));
                this.reMap(column, row);
            }
        } else if (dataColumn instanceof TimeSeriesQualityColumn && --column >= 0 && (dataColumn = this.inColumn(column)) != null) {
            dataColumn.extendDataSet(this._time.element(row));
            this.reMap(column, row);
        }
        return true;
    }

    @Override
    public void setColumnWidths(TableColumnModel columnModel) {
        int start;
        columnModel.getColumn(0).setPreferredWidth(60);
        if (this._dateTimeAsTwoColumns) {
            columnModel.getColumn(1).setPreferredWidth(90);
            columnModel.getColumn(2).setPreferredWidth(80);
            start = 3;
        } else {
            columnModel.getColumn(1).setPreferredWidth(130);
            start = 2;
        }
        for (int i = start; i < columnModel.getColumnCount(); ++i) {
            columnModel.getColumn(i).setPreferredWidth(90);
        }
    }

    @Override
    public boolean hasDataChanged() {
        for (int i = 0; i < this._dataColumns.size(); ++i) {
            if (!this.inColumn(i).hasDataChanged()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void setDataChanged(boolean dataChanged) {
        for (int i = 0; i < this._dataColumns.size(); ++i) {
            this.inColumn(i).setDataChanged(dataChanged);
        }
    }

    @Override
    public void setExtendable(boolean extendable, int numberBlankRows) {
        if (extendable) {
            intContainer minInterval = new intContainer();
            intContainer maxInterval = new intContainer();
            this.getMinMaxIntervals(minInterval, maxInterval);
            if (maxInterval.value != minInterval.value) {
                return;
            }
        }
        super.setExtendable(extendable, numberBlankRows);
        if (extendable && numberBlankRows > 0 && this._dataColumns.size() > 0) {
            if (this._hasBeenExtended) {
                return;
            }
            this.appendRows(numberBlankRows);
            int nRows = this.getRowCount();
            this.fireTableRowsInserted(nRows, nRows + numberBlankRows);
            this._hasBeenExtended = true;
        }
    }

    public void getMinMaxIntervals(intContainer min, intContainer max) {
        max.value = 0;
        min.value = 10000000;
        for (int column = 0; column < this._dataColumns.size(); ++column) {
            TimeSeriesColumnBase dataColumn = this.inColumn(column);
            if (dataColumn._timeSeriesContainer.interval > max.value) {
                max.value = dataColumn._timeSeriesContainer.interval;
            }
            if (dataColumn._timeSeriesContainer.interval >= min.value) continue;
            min.value = dataColumn._timeSeriesContainer.interval;
        }
    }

    @Override
    public void appendRows(int numberRows) {
        this.appendRows(numberRows, null);
    }

    public void appendRows(int numberRows, HecTimeArray newTimes) {
        int newEnd;
        int start;
        TimeSeriesColumnBase dataColumn;
        int column;
        HecTime t;
        int i;
        int begSize = this._time.numberElements();
        int end = begSize - numberRows - 1;
        intContainer minInterval = new intContainer();
        intContainer maxInterval = new intContainer();
        this.getMinMaxIntervals(minInterval, maxInterval);
        if (maxInterval.value == 0) {
            this._time.resize(begSize + numberRows);
            if (newTimes != null) {
                for (i = 0; i < numberRows; ++i) {
                    t = newTimes.element(i);
                    if (!t.isDefined()) continue;
                    this._time.set(begSize + i, t);
                }
            }
            for (column = 0; column < this._dataColumns.size(); ++column) {
                this.increaseMap(column, numberRows);
                dataColumn = this.inColumn(column);
                dataColumn.appendRows(numberRows);
            }
        } else if (maxInterval.value == minInterval.value) {
            this._time.resize(begSize + numberRows);
            for (i = begSize; i < begSize + numberRows; ++i) {
                t = new HecTime();
                t.set(this._time.elementAt(0));
                this._time.setElementAt(t, i);
                this._time.elementAt(i).increment(i, maxInterval.value);
            }
            for (column = 0; column < this._dataColumns.size(); ++column) {
                dataColumn = this.inColumn(column);
                this.increaseMap(column, numberRows);
                dataColumn.appendRows(numberRows);
            }
        }
        if ((start = (newEnd = this.getRowCount() - 1) - numberRows) < 0) {
            start = 0;
        }
        this.fireTableRowsInserted(start, newEnd);
    }

    protected void checkIntervals() {
        intContainer minInterval = new intContainer();
        intContainer maxInterval = new intContainer();
        this.getMinMaxIntervals(minInterval, maxInterval);
        if (maxInterval.value == 0) {
            this._allIrregular = true;
            this._allSameInterval = false;
        } else if (maxInterval.value == minInterval.value) {
            this._allIrregular = false;
            this._allSameInterval = true;
        } else {
            this._allIrregular = false;
            this._allSameInterval = false;
        }
    }

    public boolean isAllIrregular() {
        return this._allIrregular;
    }

    public void insertRowsBefore(int initialRow, int numberRows) {
        this.insertRowsBefore(initialRow, numberRows, null);
    }

    public void resetToIrregular() {
        for (int column = 0; column < this._dataColumns.size(); ++column) {
            TimeSeriesColumnBase dataColumn = this.inColumn(column);
            dataColumn._timeSeriesContainer.interval = -1;
            if (!dataColumn._timeSeriesContainer.fullName.endsWith("/")) continue;
            DSSPathname path = new DSSPathname(dataColumn._timeSeriesContainer.fullName);
            String ePart = HecTimeSeries.getAppropriateIrregularBlock(dataColumn._timeSeriesContainer.times);
            path.setEPart(ePart);
            dataColumn._timeSeriesContainer.fullName = path.pathname();
        }
        this._allIrregular = true;
        this._allSameInterval = false;
    }

    public void insertRowsBefore(int initialRow, int numberRows, HecTimeArray newTimes) {
        int startRow = initialRow - this.getNumberHeaderRows();
        if (startRow < 0) {
            startRow = 0;
        }
        int begSize = this._time.numberElements();
        if (this._allIrregular) {
            this._time.resize(begSize + numberRows, startRow);
            if (newTimes != null) {
                for (int i = 0; i < numberRows; ++i) {
                    HecTime t = newTimes.element(i);
                    if (!t.isDefined()) continue;
                    this._time.set(startRow + i, t);
                }
            }
            for (int column = 0; column < this._dataColumns.size(); ++column) {
                this.increaseMap(column, numberRows);
                TimeSeriesColumnBase dataColumn = this.inColumn(column);
                dataColumn.insertRowsBefore(startRow, numberRows, newTimes);
                this.reMap(column);
            }
        } else if (this._allSameInterval) {
            if (startRow != 0) {
                System.out.println("Can only insert before at first row");
                return;
            }
            TimeSeriesColumnBase dataColumn = this.inColumn(0);
            int interval = dataColumn._timeSeriesContainer.interval;
            this._time.resizeWithInterval(startRow, numberRows, interval);
            for (int column = 0; column < this._dataColumns.size(); ++column) {
                this.increaseMap(column, numberRows);
                dataColumn = this.inColumn(column);
                dataColumn.insertRowsBefore(startRow, numberRows);
                this.reMap(column);
            }
        } else {
            return;
        }
        int newEnd = startRow + numberRows;
        this.fireTableRowsInserted(startRow, newEnd);
    }

    public void deleteRows(int[] selectedRows) {
        int column;
        int i;
        int i2 = 0;
        while (i2 < selectedRows.length) {
            int n = i2++;
            selectedRows[n] = selectedRows[n] - this.getNumberHeaderRows();
        }
        int startRow = selectedRows[0];
        if (startRow < 0) {
            return;
        }
        Arrays.sort(selectedRows);
        int[] rows = new int[selectedRows.length];
        for (i = 0; i < selectedRows.length; ++i) {
            rows[i] = selectedRows[selectedRows.length - i - 1];
        }
        if (this._allIrregular) {
            for (i = 0; i < rows.length; ++i) {
                int begSize = this._time.numberElements();
                this._time.resize(begSize - 1, rows[i]);
                for (int column2 = 0; column2 < this._dataColumns.size(); ++column2) {
                    int r = this.unMap(rows[i], column2);
                    if (r < 0) continue;
                    TimeSeriesColumnBase dataColumn = this.inColumn(column2);
                    dataColumn.deleteRows(r, 1);
                }
            }
            for (column = 0; column < this._dataColumns.size(); ++column) {
                this.reMap(column);
            }
        } else {
            if (this._allSameInterval) {
                for (column = 0; column < this._dataColumns.size(); ++column) {
                    TimeSeriesColumnBase dataColumn = this.inColumn(column);
                    for (int i3 = 0; i3 < rows.length; ++i3) {
                        dataColumn.setValue(rows[i3], "", null);
                    }
                }
                return;
            }
            return;
        }
    }

    @Override
    public void initializeEntryStartTime() {
        if (this._dataColumns.size() > 0) {
            TimeSeriesColumnBase columnBase = (TimeSeriesColumnBase)this._dataColumns.get(0);
            int start = -2147483647;
            HecTime sTime = new HecTime();
            if (columnBase._timeSeriesContainer.times != null && columnBase._timeSeriesContainer.times.length > 0 && columnBase._timeSeriesContainer.times[0] != 0) {
                start = columnBase._timeSeriesContainer.times[0];
                sTime.set(start);
            } else if (columnBase._timeSeriesContainer.startTime != 0) {
                start = columnBase._timeSeriesContainer.startTime;
                sTime.set(columnBase._timeSeriesContainer.getStartTime());
            }
            if (start != -2147483647) {
                HecTime startTime = new HecTime();
                startTime.set(sTime);
                if (columnBase._timeSeriesContainer.interval > 0) {
                    int size = this._time.numberElements();
                    for (int i = 0; i < size; ++i) {
                        this._time.set(i, startTime);
                        this._time.elementAt(i).increment(i, columnBase._timeSeriesContainer.interval);
                    }
                    columnBase._times.set(this._time);
                } else {
                    this._time.set(0, startTime);
                }
            }
            columnBase.initializeEntryStartTime();
        }
        this.checkIntervals();
        this.fireTableRowsUpdated(0, this.getRowCount());
    }

    @Override
    public int updateContainers(int[] firstError) {
        for (int i = 0; i < this._dataColumns.size(); ++i) {
            TimeSeriesColumnBase columnBase = (TimeSeriesColumnBase)this._dataColumns.get(i);
            int error = columnBase.updateContainer(this._numberBlankRows, firstError, false);
            if (error == 0) continue;
            return error;
        }
        return 0;
    }

    @Override
    public void save(Object parent) {
        Vector<TimeSeriesContainer> dataContainers = new Vector<TimeSeriesContainer>();
        LinkedHashMap<TimeSeriesContainer, TimeWindowMap> dataContainerTimeWindowMap = new LinkedHashMap<TimeSeriesContainer, TimeWindowMap>();
        String path = null;
        Calendar cal = Calendar.getInstance();
        cal.clear();
        if (this._timeZoneID != null) {
            TimeZone singularDataTimeZone = TimeZone.getTimeZone(this._timeZoneID);
            cal.setTimeZone(singularDataTimeZone);
        }
        for (int i = 0; i < this._dataColumns.size(); ++i) {
            String originalTimeZone;
            TimeSeriesColumnBase inColumn = this.inColumn(i);
            if (!inColumn.hasDataChanged()) continue;
            Integer initialStartTime = inColumn.getInitialStartTime();
            Integer initialEndTime = inColumn.getInitialEndTime();
            TimeSeriesContainer tsc = inColumn.getDataContainer();
            if (initialStartTime != null && initialEndTime != null && tsc.times != null && tsc.times.length > 0 && this.isTimeArrayAscending(tsc)) {
                TimeWindowMap timeWindowMap;
                TimeWindowMap timeWindowMap2;
                Date endDate;
                Date startDate;
                int firstDataTime = this.getFirstDataTime(tsc);
                int lastDataTime = this.getLastDataTime(tsc);
                if (initialStartTime < firstDataTime) {
                    HecTime initialStartHecTime = new HecTime(initialStartTime, 11);
                    HecTime firstDataHecTime = new HecTime(firstDataTime, 11);
                    long initialStartTimeInMillis = initialStartHecTime.getTimeInMillis(cal);
                    long firstDataTimeInMillis = firstDataHecTime.getTimeInMillis(cal);
                    startDate = new Date(initialStartTimeInMillis);
                    endDate = new Date(firstDataTimeInMillis);
                    timeWindowMap2 = (TimeWindowMap)dataContainerTimeWindowMap.get(tsc);
                    if (timeWindowMap2 == null) {
                        timeWindowMap2 = new TimeWindowMap();
                        dataContainerTimeWindowMap.put(tsc, timeWindowMap2);
                    }
                    timeWindowMap2.addTimeWindow(startDate, true, endDate, false);
                }
                if (initialEndTime > lastDataTime) {
                    HecTime lastDataHecTime = new HecTime(lastDataTime, 11);
                    HecTime initialEndHecTime = new HecTime(initialEndTime, 11);
                    long lastDataTimeInMillis = lastDataHecTime.getTimeInMillis(cal);
                    long initialEndTimeInMillis = initialEndHecTime.getTimeInMillis(cal);
                    startDate = new Date(lastDataTimeInMillis);
                    endDate = new Date(initialEndTimeInMillis);
                    timeWindowMap2 = (TimeWindowMap)dataContainerTimeWindowMap.get(tsc);
                    if (timeWindowMap2 == null) {
                        timeWindowMap2 = new TimeWindowMap();
                        dataContainerTimeWindowMap.put(tsc, timeWindowMap2);
                    }
                    timeWindowMap2.addTimeWindow(startDate, false, endDate, true);
                }
                if ((timeWindowMap = (TimeWindowMap)dataContainerTimeWindowMap.get(tsc)) == null) {
                    timeWindowMap = new TimeWindowMap();
                    dataContainerTimeWindowMap.put(tsc, timeWindowMap);
                }
                this.addDeletedTimeSlots(tsc, timeWindowMap, cal);
            }
            if (this._timeZoneID != null && inColumn instanceof TimeSeriesDataColumn && (originalTimeZone = ((TimeSeriesDataColumn)inColumn).getOriginalTimeZoneId()) != null && !this._timeZoneID.equals(originalTimeZone)) {
                tsc = this.convertTimeZone(tsc, originalTimeZone, this._timeZoneRawOffset);
            }
            path = tsc.fullName;
            dataContainers.add(tsc);
            inColumn.setDataChanged(false);
        }
        if (parent instanceof SavableDataFrame) {
            int status = 0;
            if (parent instanceof TimeSeriesDataEditorListener) {
                status = ((TimeSeriesDataEditorListener)parent).deleteValues(dataContainerTimeWindowMap);
            }
            if (status >= 0) {
                status = ((SavableDataFrame)parent).save(dataContainers);
            }
            Object message = status < 0 ? "An error occurred during the save operation,\nplease check the console log for error details." : (dataContainers.size() == 1 ? "Saved record:  " + path : dataContainers.size() + " data sets saved.");
            JOptionPane.showMessageDialog((Component)parent, message, "Data Saved", 1);
        }
    }

    private boolean isTimeArrayAscending(TimeSeriesContainer tsc) {
        for (int i = 1; i < tsc.times.length; ++i) {
            if (tsc.times[i - 1] < tsc.times[i]) continue;
            return false;
        }
        return true;
    }

    private int getFirstDataTime(TimeSeriesContainer tsc) {
        int firstDataTime = tsc.times[tsc.times.length - 1];
        for (int i = 0; i < tsc.times.length - 1; ++i) {
            if (tsc.times[i] >= firstDataTime || !RMAConst.isValidValue(tsc.values[i])) continue;
            firstDataTime = tsc.times[i];
        }
        return firstDataTime;
    }

    private int getLastDataTime(TimeSeriesContainer tsc) {
        int lastDataTime = tsc.times[0];
        for (int i = 1; i < tsc.times.length; ++i) {
            if (tsc.times[i] <= lastDataTime || !RMAConst.isValidValue(tsc.values[i])) continue;
            lastDataTime = tsc.times[i];
        }
        return lastDataTime;
    }

    private List<Integer> getDeletedTimeIndexes(TimeSeriesContainer tsc) {
        ArrayList<Integer> removeMe = new ArrayList<Integer>();
        int[] times = Arrays.copyOf(tsc.times, tsc.times.length);
        Arrays.sort(times);
        int loopI = 0;
        for (int i = 0; i < this._originalTimes.length; ++i) {
            int originalTime = this._originalTimes[i];
            while (loopI < times.length && times[loopI] < originalTime) {
                ++loopI;
            }
            if (loopI < times.length && originalTime == times[loopI]) continue;
            removeMe.add(i);
        }
        return removeMe;
    }

    private void addDeletedTimeSlots(TimeSeriesContainer tsc, TimeWindowMap timeWindowMap, Calendar cal) {
        List<Integer> removeMe = this.getDeletedTimeIndexes(tsc);
        int removeStart = -1;
        int removeEnd = -1;
        for (int index : removeMe) {
            if (removeStart == -1) {
                removeStart = index;
                continue;
            }
            if (removeEnd == -1) {
                if (index - removeStart == 1) {
                    removeEnd = index;
                    continue;
                }
                this.addWindow(removeStart, removeStart, timeWindowMap, cal);
                removeStart = index;
                continue;
            }
            if (index - removeEnd == 1) {
                removeEnd = index;
                continue;
            }
            this.addWindow(removeStart, removeEnd, timeWindowMap, cal);
            removeStart = index;
            removeEnd = -1;
        }
        if (removeEnd != -1) {
            this.addWindow(removeStart, removeEnd, timeWindowMap, cal);
        } else if (removeStart != -1) {
            this.addWindow(removeStart, removeStart, timeWindowMap, cal);
        }
    }

    private void addWindow(int start, int end, TimeWindowMap timeWindowMap, Calendar cal) {
        HecTime hecTimeStart = new HecTime(this._originalTimes[start], 11);
        long initialStartTimeInMillis = hecTimeStart.getTimeInMillis(cal);
        Date startDate = new Date(initialStartTimeInMillis);
        HecTime hecTimeEnd = new HecTime(this._originalTimes[end], 11);
        long initialEndTimeInMillis = hecTimeEnd.getTimeInMillis(cal);
        Date endDate = new Date(initialEndTimeInMillis);
        timeWindowMap.addTimeWindow(startDate, true, endDate, true);
    }

    @Override
    public void saveAs(Object parent) {
        TimeSeriesContainer tsc;
        TimeSeriesColumnBase column;
        int i;
        Vector<TimeSeriesContainer> containers = new Vector<TimeSeriesContainer>();
        for (i = 0; i < this._dataColumns.size(); ++i) {
            if (!this.inColumn(i).hasDataChanged() || !((column = this.inColumn(i)) instanceof TimeSeriesDataColumn)) continue;
            tsc = column.getDataContainer();
            containers.add(tsc);
        }
        if (containers.size() == 0) {
            for (i = 0; i < this._dataColumns.size(); ++i) {
                column = this.inColumn(i);
                if (!(column instanceof TimeSeriesDataColumn)) continue;
                tsc = column.getDataContainer();
                containers.add(tsc);
            }
        }
        if (parent instanceof SavableDataFrame) {
            ((SavableDataFrame)parent).saveAs(containers);
        }
    }

    public int getQualityStyle() {
        return this._qualityStyle;
    }

    public void applyQuality(int[] cols, int[] rows, IntUnaryOperator qualityFunction) {
        for (int col : cols) {
            if (col < 0) continue;
            TimeSeriesQualityColumn qualCol = null;
            if (this._dataColumns.get(col) instanceof TimeSeriesQualityColumn) {
                qualCol = (TimeSeriesQualityColumn)this._dataColumns.get(col);
            } else if (this._dataColumns.get(col) instanceof TimeSeriesDataColumn && col + 1 < this._dataColumns.size() && this._dataColumns.get(col + 1) instanceof TimeSeriesQualityColumn) {
                qualCol = (TimeSeriesQualityColumn)this._dataColumns.get(col + 1);
            }
            if (qualCol == null) continue;
            for (int row : rows) {
                qualCol.applyQuality(row, qualityFunction);
            }
        }
    }

    @Override
    public final int getNumberHeaderRows() {
        return super.getNumberHeaderRows() + (this._bVersionRow ? 1 : 0);
    }
}

