/*
 * Decompiled with CFR 0.152.
 */
package hec.dataTable;

import hec.dataTable.TimeSeriesColumnBase;
import hec.heclib.util.HecTime;
import hec.heclib.util.HecTimeArray;
import hec.io.TimeSeriesContainer;
import java.util.TimeZone;
import java.util.function.IntUnaryOperator;
import javax.swing.JOptionPane;
import mil.army.usace.hec.data.timeseries.QualityStringRenderer;

public class TimeSeriesQualityColumn
extends TimeSeriesColumnBase {
    public static int QUALITY_STYLE_NONE = 0;
    public static int QUALITY_STYLE_SYMBOL = 1;
    public static int QUALITY_STYLE_HEX = 2;
    protected int[][] _quality = null;
    protected int sizeEachQuality = 0;
    String _zeros = "00000000";
    int _qualityStyle;

    public TimeSeriesQualityColumn(TimeSeriesContainer dataSet, int qualityStyle) {
        super(dataSet);
        TimeZone timeZone;
        int i;
        if (dataSet.quality != null) {
            this.sizeEachQuality = 1;
            this._quality = new int[dataSet.numberValues][this.sizeEachQuality];
            for (i = 0; i < dataSet.numberValues; ++i) {
                this._quality[i][0] = dataSet.quality[i];
            }
        } else if (dataSet.quality7 != null && dataSet.sizeEachQuality7 > 0) {
            this.sizeEachQuality = dataSet.sizeEachQuality7;
            this._quality = new int[dataSet.numberValues][this.sizeEachQuality];
            for (i = 0; i < dataSet.numberValues; ++i) {
                for (int j = 0; j < this.sizeEachQuality; ++j) {
                    this._quality[i][j] = dataSet.quality7[i][j];
                }
            }
        }
        if (dataSet.times != null) {
            this._times.set(dataSet.times);
        }
        if (dataSet.timeZoneID != null && dataSet.timeZoneID.length() > 0 && (timeZone = TimeZone.getTimeZone(dataSet.timeZoneID)) != null) {
            this._times.setTimeZone(timeZone);
        }
        this._qualityStyle = qualityStyle;
    }

    @Override
    public String getName() {
        if (this._timeSeriesContainer != null) {
            String name = super.getName() + "\nQuality";
            return name;
        }
        return "";
    }

    @Override
    public boolean isEditable() {
        return this._qualityStyle == QUALITY_STYLE_HEX;
    }

    @Override
    public int getNumberValues() {
        return this._quality.length;
    }

    @Override
    public String getValue(int row, boolean showCommas) {
        if (!this.isValidElement(row)) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.sizeEachQuality; ++i) {
            int qual = this._quality[row][i];
            if (this._qualityStyle == QUALITY_STYLE_HEX) {
                StringBuffer hexsb = new StringBuffer(Integer.toHexString(qual));
                int len = hexsb.length();
                if (len < 8) {
                    hexsb.insert(0, this._zeros.substring(len));
                }
                hexsb.insert(4, " ");
                sb.append(hexsb);
            } else {
                StringBuffer qualityString = new StringBuffer();
                qualityString.append(QualityStringRenderer.getSymbolicString((int)qual));
                qualityString.append("  ");
                qualityString.append(QualityStringRenderer.getSymbolicTestsString((int)qual));
                sb.append(qualityString);
            }
            if (i == this.sizeEachQuality - 1) continue;
            sb.append("  ");
        }
        return sb.toString();
    }

    @Override
    protected Object getObject(int position) {
        return this.getValue(position, false);
    }

    public String getQualityToolTip(int row) {
        if (!this.isValidElement(row)) {
            return "";
        }
        StringBuffer tooltip = new StringBuffer();
        tooltip.append("<html>");
        for (int i = 0; i < this.sizeEachQuality; ++i) {
            int qual = this._quality[row][i];
            tooltip.append(QualityStringRenderer.getHtmlStringDescription((int)qual));
            if (i == this.sizeEachQuality - 1) continue;
            tooltip.append("<br>");
        }
        tooltip.append("</html>");
        return tooltip.toString();
    }

    public void applyQuality(int row, IntUnaryOperator qualityFunction) {
        if (this.isValidElement(row)) {
            for (int i = 0; i < this._quality[row].length; ++i) {
                this._quality[row][i] = qualityFunction.applyAsInt(this._quality[row][i]);
            }
            this._dataChanged = true;
        }
    }

    public int setValue(int row, Object obj) {
        String str = obj.toString();
        if (this._qualityStyle != QUALITY_STYLE_HEX) {
            return 0;
        }
        boolean highBit = false;
        StringBuffer sb = new StringBuffer(8);
        for (int i = 0; i < str.length(); ++i) {
            int c2 = str.charAt(i);
            if (i == 0 && c2 == 56) {
                highBit = true;
                c2 = 48;
            }
            if (c2 == 32) continue;
            sb.append((char)c2);
        }
        str = sb.toString();
        for (int j = 0; j < this.sizeEachQuality; ++j) {
            String qual = str.substring(j * 8, j * 8 + 8);
            int value = 0;
            try {
                value = Integer.parseInt(qual, 16);
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(null, "Invalid Hexadecimal Quality: " + str, "", 2);
                return -1;
            }
            if (highBit) {
                int temp = 1;
                value |= (temp <<= 31);
            }
            if (!this.isValidElement(row)) continue;
            this._quality[row][j] = value;
            this._dataChanged = true;
        }
        return 0;
    }

    @Override
    public void appendRows(int numberRows) {
        int origLength = this._quality.length;
        super.appendRows(numberRows);
        this.resize(origLength, numberRows);
    }

    @Override
    public void insertRowsBefore(int startRow, int numberRows) {
        super.insertRowsBefore(startRow, numberRows);
        this.resize(startRow, numberRows);
    }

    @Override
    public void insertRowsBefore(int startRow, int numberRows, HecTimeArray newTimes) {
        super.insertRowsBefore(startRow, numberRows, newTimes);
        this.resize(startRow, numberRows);
    }

    protected void resize(int startRow, int numberRows) {
        int origLength = this._quality.length;
        int newLength = this._quality.length + numberRows;
        int[][] newQual = new int[newLength][this.sizeEachQuality];
        if (numberRows > 0) {
            int y = startRow + numberRows - 1;
            int arrayPos = 0;
            for (int i = 0; i < newLength; ++i) {
                int j;
                if ((i < startRow || i > y) && arrayPos < origLength) {
                    for (j = 0; j < this.sizeEachQuality; ++j) {
                        newQual[i][j] = this._quality[arrayPos][j];
                    }
                    ++arrayPos;
                    continue;
                }
                for (j = 0; j < this.sizeEachQuality; ++j) {
                    newQual[i][j] = 0;
                }
            }
        } else {
            int arrayPos = 0;
            int diff = newLength - origLength;
            for (int i = 0; i < newLength; ++i) {
                arrayPos = i >= startRow ? i - diff : i;
                if (arrayPos >= origLength) continue;
                for (int j = 0; j < this.sizeEachQuality; ++j) {
                    newQual[i][j] = this._quality[arrayPos][j];
                }
            }
        }
        this._quality = newQual;
    }

    @Override
    public int updateContainer(int numberExtendedRows, int[] firstError, boolean trimMissing) {
        this.updateContainer(numberExtendedRows);
        return 0;
    }

    public void updateContainer(int numberExtendedRows) {
        block16: {
            int i;
            if (!this._dataChanged) break block16;
            if (this._timeSeriesContainer.numberValues == this._quality.length && this._quality.length > 0 && this._quality.length == this._times.numberElements()) {
                int i2;
                boolean same = true;
                for (i2 = 0; i2 < this._timeSeriesContainer.numberValues; ++i2) {
                    if (this._timeSeriesContainer.times[i2] == this._times.getTimeInDataTimeZone(i2).value()) continue;
                    same = false;
                    break;
                }
                if (same) {
                    if (this.sizeEachQuality == 1) {
                        this._timeSeriesContainer.quality = new int[this._timeSeriesContainer.numberValues];
                        for (i2 = 0; i2 < this._timeSeriesContainer.numberValues; ++i2) {
                            this._timeSeriesContainer.quality[i2] = this._quality[i2][0];
                        }
                    } else {
                        this._timeSeriesContainer.quality7 = new int[this._timeSeriesContainer.numberValues][this.sizeEachQuality];
                        for (i2 = 0; i2 < this._timeSeriesContainer.numberValues; ++i2) {
                            for (int j = 0; j < this.sizeEachQuality; ++j) {
                                this._timeSeriesContainer.quality7[i2][j] = this._quality[i2][j];
                            }
                        }
                    }
                    return;
                }
            }
            if (this.sizeEachQuality == 1) {
                this._timeSeriesContainer.quality = new int[this._timeSeriesContainer.numberValues];
                for (i = 0; i < this._timeSeriesContainer.numberValues; ++i) {
                    this._timeSeriesContainer.quality[i] = 0;
                }
                HecTimeArray newTimes = new HecTimeArray();
                newTimes.set(this._timeSeriesContainer.times);
                HecTime time = new HecTime();
                for (int i3 = 0; i3 < this._times.numberElements(); ++i3) {
                    time.set(this._times.getTimeInDataTimeZone(i3));
                    int pos = newTimes.index(time, true, this._timeSeriesContainer.interval);
                    if (pos <= -1) continue;
                    this._timeSeriesContainer.quality[pos] = this._quality[i3][0];
                }
            } else {
                this._timeSeriesContainer.quality7 = new int[this._timeSeriesContainer.numberValues][this.sizeEachQuality];
                for (i = 0; i < this._timeSeriesContainer.numberValues; ++i) {
                    for (int j = 0; j < this.sizeEachQuality; ++j) {
                        this._timeSeriesContainer.quality7[i][j] = 0;
                    }
                }
                HecTimeArray newTimes = new HecTimeArray();
                newTimes.set(this._timeSeriesContainer.times);
                HecTime time = new HecTime();
                for (int i4 = 0; i4 < this._times.numberElements(); ++i4) {
                    time.set(this._times.getTimeInDataTimeZone(i4));
                    int pos = newTimes.index(time, true, this._timeSeriesContainer.interval);
                    if (pos <= -1) continue;
                    for (int j = 0; j < this.sizeEachQuality; ++j) {
                        this._timeSeriesContainer.quality7[pos][j] = this._quality[i4][j];
                    }
                }
            }
        }
    }
}

