/*
 * Decompiled with CFR 0.152.
 */
package hec.dataTable;

import hec.dataTable.HecDataTable;
import hec.gfx2d.G2dPanel;
import hec.gfx2d.G2dPropertiesDlg;
import hec.gfx2d.G2dTitle;
import hec.gfx2d.G2dTitlePropertiesPanel;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import rma.swing.DefaultJPanel;
import rma.swing.RmaJMenuLabel;
import rma.swing.print.PageText;

public class Title
extends G2dTitle {
    private HecDataTable _table;
    private JPopupMenu _popupMenu;
    private JMenuItem _editMenuItem;

    public Title(HecDataTable table) {
        super(new G2dPanel());
        this._table = table;
        this.configureControls();
    }

    protected void configureControls() {
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger() || SwingUtilities.isRightMouseButton(e)) {
                    if (Title.this._popupMenu == null) {
                        Title.this.createPopup();
                    }
                    Title.this._popupMenu.show(Title.this, e.getX(), e.getY());
                }
            }
        });
        this.setBorder(null);
    }

    protected void createPopup() {
        if (this._popupMenu != null) {
            return;
        }
        this._popupMenu = new JPopupMenu();
        RmaJMenuLabel menuItem = new RmaJMenuLabel("Title");
        this._popupMenu.add(menuItem);
        this._popupMenu.addSeparator();
        this._editMenuItem = new JMenuItem("Edit Properties...");
        this._popupMenu.add(this._editMenuItem);
        this._editMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Title.this.editPropertiesAction();
            }
        });
    }

    public void editPropertiesAction() {
        Cursor oldCursor = this.getCursor();
        this.setCursor(Cursor.getPredefinedCursor(3));
        G2dTitlePropertiesPanel titlePanel = new G2dTitlePropertiesPanel();
        this._drawProp.text = this.getText();
        titlePanel.setData(this._drawProp);
        G2dPropertiesDlg dlg = null;
        PropertiesOKListener listener = new PropertiesOKListener();
        Window w = SwingUtilities.windowForComponent(this);
        dlg = w instanceof Dialog ? new G2dPropertiesDlg((Dialog)w, false, "Edit Title Properties", new DefaultJPanel[]{titlePanel}) : new G2dPropertiesDlg((Frame)w, false, "Edit Title Properties", new DefaultJPanel[]{titlePanel});
        if (dlg == null) {
            return;
        }
        dlg.addOKListener(listener);
        this.setCursor(oldCursor);
        dlg.setVisible(true);
    }

    @Override
    public String getText() {
        if (this._table != null) {
            PageText title = this._table.getPrintTitle();
            if (title == null) {
                return super.getText();
            }
            return title.getText();
        }
        if (super.getText().length() == 0) {
            Window w = SwingUtilities.windowForComponent(this);
            if (w instanceof Dialog) {
                ((Dialog)w).getTitle();
            } else if (w instanceof Frame) {
                return ((Frame)w).getTitle();
            }
        }
        return super.getText();
    }

    @Override
    public void setText(String text) {
        if (this._table != null) {
            int align = 0;
            switch (this._drawProp.align) {
                case 1: {
                    align = 0;
                    break;
                }
                case 2: {
                    align = 4;
                }
            }
            this._table.setPrintTitle(new PageText(text, align));
        }
        if (this._drawProp != null) {
            this._drawProp.drawTitle = text != null && text.length() >= 1;
        }
        super.setText(text);
    }

    @Override
    public void paintComponent(Graphics g) {
        this.paintGfx(g);
    }

    class PropertiesOKListener
    implements ActionListener {
        PropertiesOKListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (((Title)Title.this)._drawProp.drawTitle) {
                Title.this.setText(((Title)Title.this)._drawProp.text);
            }
            Title.this.revalidate();
            Title.this.repaint();
            ((JComponent)Title.this.getParent()).revalidate();
            Title.this.getParent().repaint();
        }
    }
}

