/*
 * Decompiled with CFR 0.152.
 */
package hec.export;

import hec.appInterface.AppDaddy;
import hec.io.HecFile;
import hec.io.Identifier;
import hec.map.WorldPointHolder;
import hec.map.aishape.AiShapeFieldDescriptor;
import hec.map.aishape.AiShapePoint;
import hec.map.aishape.AiShapePointZ;
import hec.map.aishape.AiShapeWriter;
import hec.map.aishape.Attribute;
import hec.map.aishape.Field;
import hec.map.crs.CoordinateReferenceSystem;
import java.awt.Component;
import java.io.IOException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ProgressMonitor;

public class WorldPointToShapefile {
    ProgressMonitor mProgressMonitor = null;
    private boolean _write3dPoints;

    public WorldPointToShapefile() {
    }

    public WorldPointToShapefile(boolean write3dpoints) {
        this();
        this._write3dPoints = write3dpoints;
    }

    public void setProgressMonitor(ProgressMonitor pm) {
        this.mProgressMonitor = pm;
    }

    public boolean exportToShapefile(Component parent, WorldPointHolder worldPointHolder, Identifier shapefileId) {
        return this.exportToShapefile(parent, worldPointHolder, shapefileId, null);
    }

    public boolean exportToShapefile(Component parent, WorldPointHolder worldPointHolder, Identifier shapefileId, CoordinateReferenceSystem crs) {
        Identifier id;
        int size = worldPointHolder.getPointCount();
        List<AiShapeFieldDescriptor> fieldDescriptors = worldPointHolder.getFieldDescriptors();
        int TEN_PCT_MARK = (int)((double)size * 0.1);
        if (TEN_PCT_MARK == 0) {
            TEN_PCT_MARK = 1;
        }
        if (this.mProgressMonitor != null) {
            this.mProgressMonitor.setMaximum(this.mProgressMonitor.getMaximum() + TEN_PCT_MARK);
            this.mProgressMonitor.setMillisToDecideToPopup(0);
            this.mProgressMonitor.setMillisToPopup(0);
            this.mProgressMonitor.setProgress(1);
        }
        AiShapeWriter writer = new AiShapeWriter();
        writer.setFileOpener(AppDaddy.getWorkspace());
        HecFile f = shapefileId.getFile();
        if (f == null && (id = AppDaddy.getWorkspace().openFile(shapefileId, false)) != null) {
            f = id.getFile();
        }
        String newPath = shapefileId.getPath();
        Identifier id2 = new Identifier(newPath);
        id2.setFile(f);
        writer.setIdentifier(id2);
        int type = 1;
        if (this._write3dPoints) {
            type = 11;
        }
        writer.setShapeType(type);
        try {
            writer.init(fieldDescriptors);
            AiShapePoint point = null;
            for (int ii = 0; ii < size; ++ii) {
                if (ii % TEN_PCT_MARK == 0 && this.mProgressMonitor != null) {
                    this.mProgressMonitor.setNote("Computing " + ii + " of " + size + " points.");
                    this.mProgressMonitor.setProgress(ii);
                }
                List<Field> fields = worldPointHolder.getFields(ii);
                Attribute attr = new Attribute(ii + 1, fields.toArray(new Field[fieldDescriptors.size()]));
                point = this._write3dPoints ? new AiShapePointZ(ii + 1, worldPointHolder.getPointAt(ii)) : new AiShapePoint(ii + 1, worldPointHolder.getPointAt(ii));
                point.setAttribute(attr);
                if (crs != null) {
                    writer.setCoordinateReferenceSystem(crs);
                }
                writer.appendShape(point, attr);
            }
            if (this.mProgressMonitor != null) {
                this.mProgressMonitor.setNote("Writing Shapefile Data");
            }
            writer.closeFiles();
        }
        catch (IOException e) {
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, e.getMessage(), e);
        }
        return true;
    }
}

