/*
 * Decompiled with CFR 0.152.
 */
package hec.export;

import hec.io.Identifier;
import hec.map.MapIdentifier;
import hec.map.WorldRegion;
import hec.map.WorldRegionHolder;
import hec.map.aishape.AiShapeFieldDescriptor;
import hec.map.aishape.AiShapeMap;
import hec.map.aishape.AiShapePolygon;
import hec.map.aishape.Attribute;
import hec.map.aishape.Field;
import hec.map.aishape.SelfIntersectingPolygonException;
import hec.map.crs.CoordinateReferenceSystem;
import java.awt.Color;
import java.awt.Component;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import rma.util.RMAIO;

public class WorldRegionToShapefile {
    public static final String NAME_ID_FIELD = "ID_NAME";
    public static final int IMPACT_AREA_ID_FIELD_LENGTH = 32;
    public static final String BEGINNING_STREAM_STATION_FIELD = "BEG_STAT";
    public static final String ENDING_STREAM_STATION_FIELD = "END_STAT";
    public static final String INDEX_STREAM_STATION_FIELD = "IDX_STAT";
    public static final String DESC_FIELD = "DESC";
    public static final String COLOR_FIELD = "COLOR";
    public static final int COLOR_FIELD_LENGTH = 32;
    public static final String DESCRIPTION = "Description";
    public static final String COLOR = "Color";
    public static final String STREAM_BANK = "Stream bank";
    private static final HashMap _attrFieldMap = new HashMap();

    public static Map getDefaultAttrToFieldMap() {
        return Collections.unmodifiableMap(_attrFieldMap);
    }

    public static boolean exportToShapefile(Component parent, List worldRegionHolderList, Identifier shapefileId) {
        return WorldRegionToShapefile.exportToShapefile(parent, worldRegionHolderList, shapefileId, null);
    }

    public static boolean exportToShapefile(Component parent, List worldRegionHolderList, Identifier shapefileId, CoordinateReferenceSystem crs) {
        AiShapeMap map = new AiShapeMap(new MapIdentifier(shapefileId));
        map.setCoordinateReferenceSystem(crs);
        Vector<AiShapePolygon> shapes = new Vector<AiShapePolygon>(worldRegionHolderList.size());
        Vector<Attribute> attributes = new Vector<Attribute>(worldRegionHolderList.size());
        AiShapeFieldDescriptor impactAreaIdDescriptor = new AiShapeFieldDescriptor(NAME_ID_FIELD, 'C', 32, 0);
        AiShapeFieldDescriptor descDescriptor = new AiShapeFieldDescriptor(DESC_FIELD, 'C', 254, 0);
        AiShapeFieldDescriptor colorDescriptor = new AiShapeFieldDescriptor(COLOR_FIELD, 'C', 32, 0);
        Vector<AiShapeFieldDescriptor> fieldDescriptors = new Vector<AiShapeFieldDescriptor>();
        fieldDescriptors.add(impactAreaIdDescriptor);
        fieldDescriptors.add(descDescriptor);
        fieldDescriptors.add(colorDescriptor);
        for (int ii = 0; ii < worldRegionHolderList.size(); ++ii) {
            WorldRegionHolder wrh = (WorldRegionHolder)worldRegionHolderList.get(ii);
            for (int wr = 0; wr < wrh.getRegionCount(); ++wr) {
                Field[] fields = new Field[fieldDescriptors.size()];
                fields[0] = new Field(wrh.getRegionName(wr), impactAreaIdDescriptor, ii + 1);
                fields[1] = new Field(wrh.getRegionDescription(wr), descDescriptor, ii + 1);
                Color c2 = wrh.getRegionColor(wr);
                String s = RMAIO.color2String(c2);
                fields[2] = new Field(s, colorDescriptor, ii + 1);
                Attribute attr = new Attribute(ii + 1, fields);
                attributes.add(attr);
                WorldRegion region = wrh.getRegion(wr);
                if (region == null) continue;
                Vector<WorldRegion> worldRegions = new Vector<WorldRegion>();
                worldRegions.add(region);
                try {
                    AiShapePolygon poly = new AiShapePolygon(ii + 1, worldRegions);
                    poly.setAttribute(attr);
                    shapes.add(poly);
                    continue;
                }
                catch (SelfIntersectingPolygonException e) {
                    StringBuffer sb = new StringBuffer("Error exporting impact area: ");
                    sb.append(wrh.getRegionName(wr));
                    sb.append(".\nError is: ");
                    sb.append(e.getMessage());
                    RMAIO.postError(parent, sb.toString());
                    return false;
                }
            }
        }
        map.writeData(5, fieldDescriptors, shapes, attributes);
        return true;
    }

    static {
        _attrFieldMap.put(DESCRIPTION, DESC_FIELD);
        _attrFieldMap.put(COLOR, COLOR_FIELD);
    }
}

