/*
 * Decompiled with CFR 0.152.
 */
package hec.geometry;

import hec.data.Parameter;
import hec.data.Units;
import hec.geometry.AxisProp;
import hec.geometry.DefaultRatingFunction;
import hec.geometry.RatingFunction;
import hec.geometry.WorldPt;
import java.awt.Color;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.io.Serializable;
import java.util.EmptyStackException;
import java.util.Observable;
import java.util.Observer;
import java.util.Stack;
import java.util.Vector;
import rma.swing.RmaColor;
import rma.util.RMAIO;

public class Axis
extends Observable
implements AdjustmentListener,
Serializable {
    public static final double DEFAULT_AXIS_MAX = 10.0;
    public static final double DEFAULT_AXIS_MIN = 1.0;
    RatingFunction m_ratingFunction = null;
    boolean m_rateAxis = false;
    protected Vector m_observerList = new Vector();
    protected static final boolean DEBUG = Boolean.getBoolean("DEBUG");
    public static final int XAXIS = 0;
    public static final int YAXIS = 1;
    public static final int LINEAR = 0;
    public static final int TIME = 1;
    public static final int SEASONAL = 2;
    public static final int LOGARITHMIC = 3;
    public static final int PROBABILITY = 4;
    public static final int CATEGORY = 5;
    String _name = new String();
    double _min = 1.0;
    double _max = 10.0;
    double _zoom = 1.0;
    double _origin = 500.0;
    boolean _isReversed = false;
    int _localRange = 100;
    boolean _defaultExtents = true;
    double _defaultMax = 10.0;
    double _defaultMin = 1.0;
    double _dataMax = 10.0;
    double _dataMin = 1.0;
    protected AxisProp _axisProp = new AxisProp();
    double _majortic = 2.0;
    double _minortic = 0.5;
    int _numTicLabelLevels = -1;
    double _actmin = 1.0;
    double _actmax = 10.0;
    double _scale = 1.0;
    double _thpow = 0.0;
    double _thscl = 1.0;
    int _sigfig = 1;
    int _parameterId = -1;
    int _dataUnitSystem = 0;
    int _displayUnitSystem = 0;
    int _oldDisplayUnitSystem = 0;
    double _parameterScale = 1.0;
    Color _ticColor = new Color(0, 0, 0);
    Color _ticTextColor = new Color(0, 0, 0);
    public static final String COMPUTED_SCALE = "COMPUTED_SCALE";
    public static final String NEW_ZOOM = "NEW_ZOOM";
    public static final String LABEL_CHANGE = "LABEL_CHANGE";
    private transient Stack _labelStack = new Stack();
    private String _unit = "";

    public Axis(String n) {
        this._name = n;
    }

    public int getType() {
        return 0;
    }

    public void setMinMax(double min, double max) {
        this._max = max;
        this._min = min;
        this.computeScaling(this._min, this._max);
    }

    public void setScaleLimits(double min, double max) {
        this.setMinMax(min, max);
        this.computeTicInterval();
        this.setChanged();
        this.setAutomaticMinimumOff();
        this.setAutomaticMaximumOff();
        this.notifyObservers(NEW_ZOOM);
    }

    public double getOrigin() {
        return this._origin;
    }

    public double getScaleMin() {
        return this.getMin();
    }

    public double getScaleMax() {
        return this.getMax();
    }

    public void setViewLimits(double min, double max) {
        this.zoomIn(min, max);
        this.setAutomaticViewMinimumOff();
        this.setAutomaticViewMaximumOff();
    }

    public double getViewMin() {
        return this.getActMin();
    }

    public double getViewMax() {
        return this.getActMax();
    }

    public void unZoom() {
        this.zoomIn(this._min, this._max);
        this.zoomByFactor(2.0);
    }

    public void setRatingFunction(RatingFunction f) {
        this.setRatingFunction(f, false);
    }

    public void setRatingFunction(RatingFunction f, boolean axisObjectRating) {
        this.m_ratingFunction = f;
        this.m_rateAxis = axisObjectRating;
    }

    public RatingFunction getRatingFunction() {
        return this.m_ratingFunction;
    }

    public boolean rateAxis() {
        return this.m_rateAxis;
    }

    protected double getRatedValue(double baseValue) {
        if (this.m_ratingFunction == null) {
            return baseValue;
        }
        return this.m_ratingFunction.getRatedValue(baseValue);
    }

    protected double getUnRatedValue(double ratedValue) {
        if (this.m_ratingFunction == null) {
            return ratedValue;
        }
        return this.m_ratingFunction.getBaseValue(ratedValue);
    }

    public Vector getObserverList() {
        return (Vector)this.m_observerList.clone();
    }

    @Override
    public synchronized void addObserver(Observer o) {
        super.addObserver(o);
        if (o != null && !this.m_observerList.contains(o)) {
            this.m_observerList.add(o);
        }
    }

    @Override
    public synchronized void deleteObserver(Observer o) {
        super.deleteObserver(o);
        if (o != null) {
            this.m_observerList.remove(o);
        }
    }

    @Override
    public synchronized void deleteObservers() {
        super.deleteObservers();
        this.m_observerList.removeAllElements();
    }

    public int getOldDisplayUnitSystem() {
        return this._oldDisplayUnitSystem;
    }

    public void setDisplayUnitSystem(int system) {
        this._oldDisplayUnitSystem = this._displayUnitSystem;
        this._displayUnitSystem = system;
    }

    public void setDataUnitSystem(int system) {
        this._dataUnitSystem = system;
        this._oldDisplayUnitSystem = system;
    }

    public void setParameterId(int id) {
        this._parameterId = id;
    }

    public void setDisplayScaleFactor(int paramId, double scale) {
        if (paramId == this._parameterId) {
            this._parameterScale = scale;
        }
    }

    public int getDisplayUnitSystem() {
        return this._displayUnitSystem;
    }

    public int getDataUnitSystem() {
        return this._dataUnitSystem;
    }

    public int getParameterId() {
        return this._parameterId;
    }

    public boolean isReversed() {
        return this._isReversed;
    }

    public String getDisplayUnitsString(int system) {
        if (!Units.isValidUnitsSystem(system)) {
            if (DEBUG) {
                System.out.println("WARNING <Axis.getDisplayUnitsString()> : Invalid Unit System : " + system);
                System.out.println("WARNING <Axis.getDisplayUnitsString()> : Returning Blank String");
            }
            return this._unit;
        }
        Object unitsStr = Parameter.getUnitsStringForSystem(this._parameterId, system);
        if (this._parameterId == Parameter.PARAMID_CURENCY) {
            unitsStr = (String)unitsStr + Math.round(1.0 / this._parameterScale);
        }
        return unitsStr;
    }

    public void setAxisProp(AxisProp prop) {
        double wmin;
        if (prop == null) {
            return;
        }
        this.setReversed(prop.isReversed);
        this.setNumTicLabelLevels(prop.numTicLabelLayers);
        double wmax = prop.automax ? this.getMax() : prop.max;
        double d = wmin = prop.automin ? this.getMin() : prop.min;
        if (wmin > wmax) {
            double temp = wmin;
            wmin = wmax;
            wmax = temp;
            boolean tempBool = prop.automax;
            prop.automax = prop.automin;
            prop.automin = tempBool;
        }
        this.setWorldExtents(wmin, wmax);
        if (!prop.autoviewmax || !prop.autoviewmin) {
            double vmax = prop.autoviewmax ? this.getMax() : prop.actmax;
            double vmin = prop.autoviewmin ? this.getMin() : prop.actmin;
            this.zoomInUnMod(vmin, vmax);
        }
        this.setNumTicLabelLevels(prop.numTicLabelLayers);
        this._defaultExtents = prop.isDefaultLimits;
        this.m_rateAxis = prop.rateData;
        if (prop.ratingFunction != null) {
            this.m_ratingFunction = new DefaultRatingFunction();
            ((DefaultRatingFunction)this.m_ratingFunction).setRatingFunction(prop.ratingFunction[0], prop.ratingFunction[1]);
        } else {
            this.m_ratingFunction = null;
        }
        this._majortic = prop.majortic;
        this._minortic = prop.minortic;
        this.getAxisProp();
        this._axisProp.automax = prop.automax;
        this._axisProp.automin = prop.automin;
        this._axisProp.autoviewmax = prop.autoviewmax;
        this._axisProp.autoviewmin = prop.autoviewmin;
        this._axisProp.autocomputeMajorTics = prop.autocomputeMajorTics;
        this._axisProp.autocomputeMinorTics = prop.autocomputeMinorTics;
        if (prop.label != null) {
            this.setLabel(prop.label);
        }
    }

    protected void setDefaultExtents(double min, double max) {
        if (!this.isValidMinMax(min, max)) {
            return;
        }
        this._defaultMin = min;
        this._defaultMax = max;
    }

    public double getThousScale() {
        return this._thscl;
    }

    public double getThousPow() {
        return this._thpow;
    }

    public int getSigFig() {
        return this._sigfig;
    }

    public void setMaximumFactionDigits(int numDigits) {
        this._sigfig = numDigits;
    }

    public int computeScrollPosition() {
        double max = this.getMax();
        double min = this.getMin();
        double actmax = this.getActMax();
        double actmin = this.getActMin();
        double ratedMax = this.getRatedValue(max);
        double ratedMin = this.getRatedValue(min);
        double worldRange = ratedMax - ratedMin;
        int ival = this.getReversed() ? (int)((ratedMax - this.getRatedValue(actmax)) / worldRange * 10000.0) : (int)((this.getRatedValue(actmin) - ratedMin) / worldRange * 10000.0);
        return ival;
    }

    @Override
    public void adjustmentValueChanged(AdjustmentEvent e) {
        if ((e.getAdjustmentType() & 0x259) > 0) {
            int ival = e.getValue();
            if (this._isReversed) {
                this._origin = this._max - (double)ival / 10000.0 * (this._max - this._min) - (this._actmax - this._actmin) * 0.5;
            } else {
                double maxRange = 10000.0;
                double thumPos = ival;
                this._origin = thumPos / maxRange * (this._max - this._min) + this._min + (this._actmax - this._actmin) * 0.5;
            }
            this.computeScaling(this._actmin, this._actmax);
            this._axisProp.actmax = this._actmax;
            this._axisProp.actmin = this._actmin;
            this.computeAutoViewValues();
            this.setChanged();
            this.notifyObservers(COMPUTED_SCALE);
        }
    }

    public void updateRatedFunctionScroll(Axis baseAxis, AdjustmentEvent e) {
        RatingFunction rf = this.getRatingFunction();
        if (rf == null) {
            this.adjustmentValueChanged(e);
            return;
        }
        if (baseAxis == null) {
            return;
        }
        double vmax = rf.getBaseValue(baseAxis.getActMax());
        double vmin = rf.getBaseValue(baseAxis.getActMin());
        double amax = this.getMax();
        double amin = this.getMin();
        int ival = e.getValue();
        this._origin = this.isReversed() ? amax - (double)ival / 10000.0 * (amax - amin) - (vmax - vmin) * 0.5 : (double)ival / 10000.0 * (amax - amin) + amin + (vmax - vmin) * 0.5;
        double wview = this.getRatedValue(vmax) - this.getRatedValue(vmin);
        if (wview == 0.0) {
            throw new RuntimeException("WORLD VIEW EQUAL TO ZERO in computeScaling(double,double)");
        }
        this._scale = (double)this._localRange / wview;
        this._axisProp.actmax = this._actmax = vmax;
        this._axisProp.actmin = this._actmin = vmin;
        this.computeAutoViewValues();
        this.setChanged();
        this.notifyObservers(COMPUTED_SCALE);
    }

    public void zoomInUnMod(double wmin, double wmax) {
        double imax;
        double imin;
        if (!this._isReversed) {
            imin = this.w2lE(wmin);
            imax = this.w2lE(wmax);
        } else {
            imin = this.w2lE(wmax);
            imax = this.w2lE(wmin);
        }
        if (this._localRange < 0 || imax <= imin) {
            return;
        }
        double factor = Math.abs(imax - imin) / (double)this._localRange;
        this._origin = (wmax + wmin) / 2.0;
        double zm = this._zoom * factor;
        if (zm < 1.0E-5) {
            zm = 1.0E-5;
        }
        if (zm > 1.0) {
            zm = 1.0;
        }
        this._zoom = zm;
        this.computeScaling(wmin, wmax);
        this.computeTicInterval();
        this.setChanged();
        this.notifyObservers(NEW_ZOOM);
    }

    public void zoomIn(double wmin, double wmax) {
        double imax;
        double imin;
        if (!this._isReversed) {
            imin = this.w2lE(wmin);
            imax = this.w2lE(wmax);
        } else {
            imin = this.w2lE(wmax);
            imax = this.w2lE(wmin);
        }
        if (this._localRange < 0) {
            return;
        }
        double factor = Math.abs(imax - imin) / (double)this._localRange;
        this._origin = (wmax + wmin) / 2.0;
        double zm = this._zoom * factor;
        if (zm < 1.0E-5) {
            zm = 1.0E-5;
        }
        if (zm > 1.0) {
            zm = 1.0;
        }
        this._zoom = zm;
        this.computeScaling(wmin, wmax);
        this.computeTicInterval();
        this.computeAutoViewValues();
        this._axisProp.actmax = this._actmax;
        this._axisProp.actmin = this._actmin;
        this.setChanged();
        this.notifyObservers(NEW_ZOOM);
    }

    public void zoomIn(int imin, int imax) {
        double t2;
        if (this._localRange < 0 || imax <= imin) {
            return;
        }
        double t1 = this.l2w(imax);
        if (Math.abs(t1 - (t2 = this.l2w(imin))) < 1.0E-6) {
            return;
        }
        double factor = (double)(imax - imin) / (double)this._localRange;
        int x = (imax + imin) / 2;
        this._origin = (t2 + t1) / 2.0;
        double zm = this._zoom * factor;
        if (zm < 1.0E-5) {
            zm = 1.0E-5;
        }
        if (zm > 1.0) {
            zm = 1.0;
        }
        this._zoom = zm;
        if (t1 < t2) {
            this.computeScaling(t1, t2);
        } else {
            this.computeScaling(t2, t1);
        }
        this.computeTicInterval();
        this.computeAutoViewValues();
        this._axisProp.actmax = this._actmax;
        this._axisProp.actmin = this._actmin;
        this.setChanged();
        this.notifyObservers(NEW_ZOOM);
    }

    public void zoomByFactor(double factor) {
        double rAMax = this.getRatedValue(this._actmax);
        double rAMin = this.getRatedValue(this._actmin);
        factor = factor * (rAMax - rAMin) / (this._actmax - this._actmin);
        factor = this.getRatedValue(factor);
        if (this._localRange < 0) {
            return;
        }
        double zm = this._zoom * factor;
        if (zm < 1.0E-5) {
            zm = 1.0E-5;
        }
        if (zm > 1.0) {
            zm = 1.0;
        }
        this._zoom = zm;
        this.computeScaling();
        this.computeTicInterval();
        this._axisProp.actmax = this._actmax;
        this._axisProp.actmin = this._actmin;
        this.computeAutoViewValues();
        this.setChanged();
        this.notifyObservers(NEW_ZOOM);
    }

    protected void computeAutoViewValues() {
        this._axisProp.autoviewmax = Math.abs(this._actmax - this._max) <= 1.0E-6;
        this._axisProp.autoviewmin = Math.abs(this._actmin - this._min) <= 1.0E-6;
    }

    @Deprecated
    public void setReversedOn() {
        this.setReversed(true);
    }

    @Deprecated
    public void setReversedOff() {
        this.setReversed(false);
    }

    public void setReversed(boolean r) {
        this._isReversed = r;
        this._axisProp.isReversed = r;
    }

    public boolean getReversed() {
        return this.isReversed();
    }

    public void setNumTicLabelLevels(int r) {
        this._numTicLabelLevels = r;
    }

    public int getNumTicLabelLevels() {
        return this._numTicLabelLevels;
    }

    public void setLabel(String label) {
        this._axisProp.label = label;
        this.setChanged();
        this.notifyObservers(LABEL_CHANGE);
    }

    public String getLabel() {
        if (this._axisProp.label != null && this._axisProp.label.length() > 0) {
            return this._axisProp.label;
        }
        return this.getName();
    }

    public void pushLabel() {
        this._labelStack.push(this._axisProp.label);
    }

    public void popLabel() {
        try {
            this.setLabel((String)this._labelStack.pop());
        }
        catch (EmptyStackException emptyStackException) {
            // empty catch block
        }
    }

    public String getName() {
        return this._name;
    }

    public void setName(String n) {
        this._name = n;
    }

    public String getScaledLabel() {
        if (this._thpow == 0.0) {
            return this.getLabel();
        }
        return this.getLabel() + " x10^" + Integer.toString((int)this._thpow);
    }

    public double getZoom() {
        return this._zoom;
    }

    public double getWorldRange() {
        return this._max - this._min;
    }

    public void invalidateWorldExtents() {
        this._defaultExtents = true;
        this._axisProp.isDefaultLimits = true;
    }

    boolean isValidMinMax(double min, double max) {
        return !Double.isInfinite(min) && !Double.isNaN(min) && !Double.isInfinite(max) && !Double.isNaN(max);
    }

    public void setWorldExtents(double min, double max) {
        if (!this.isValidMinMax(min, max)) {
            return;
        }
        if (Math.abs(max - min) <= 1.0E-10 * Math.abs(max)) {
            if (max == 0.0) {
                max = 1.0;
            } else {
                double mag = Math.floor(0.4342944819 * Math.log(Math.abs(max)));
                double x = Math.exp(2.302585093 * mag);
                if (x > 10.0) {
                    x = 10.0;
                }
                max += x;
            }
        }
        this._min = this._axisProp.automin ? min : this._axisProp.min;
        this._max = this._axisProp.automax ? max : this._axisProp.max;
        this._dataMin = min;
        this._dataMax = max;
        this.computeNiceMinMax();
        if (this._axisProp.autoviewmin) {
            this._actmin = this._min;
            this._axisProp.actmin = this._min;
        } else {
            this._actmin = this._axisProp.actmin;
        }
        if (this._axisProp.autoviewmax) {
            this._actmax = this._max;
            this._axisProp.actmax = this._max;
        } else {
            this._actmax = this._axisProp.actmax;
        }
        this._origin = (this._min + this._max) * 0.5;
        this._zoom = 1.0;
        this._defaultExtents = false;
        this.computeScaling();
        this.computeTicInterval();
        this.setChanged();
        this.notifyObservers(COMPUTED_SCALE);
        this.setChanged();
        this.notifyObservers(NEW_ZOOM);
    }

    void setWorldMaxExtent(double max) {
        this.setWorldExtents(this._min, max);
    }

    public void setWorldMinExtent(double min) {
        this.setWorldExtents(min, this._max);
    }

    public void growWorldExtents(double min, double max) {
        if (!this.isValidMinMax(min, max)) {
            return;
        }
        if (this._defaultExtents) {
            this.setWorldExtents(min, max);
            return;
        }
        if (this._dataMin > min) {
            this._dataMin = min;
        }
        if (this._dataMax < max) {
            this._dataMax = max;
        }
        this.computeNiceMinMax();
        if (!this._axisProp.automin) {
            this._min = this._axisProp.min;
        }
        if (!this._axisProp.automax) {
            this._max = this._axisProp.max;
        }
        this._origin = (this._min + this._max) * 0.5;
        this._actmin = this._axisProp.autoviewmin ? this._min : this._axisProp.actmin;
        this._actmax = this._axisProp.autoviewmax ? this._max : this._axisProp.actmax;
        this._zoom = 1.0;
        this._defaultExtents = false;
        this.computeScaling(this._actmin, this._actmax);
        this.computeTicInterval();
        this.setChanged();
        this.notifyObservers(COMPUTED_SCALE);
        this.setChanged();
        this.notifyObservers(NEW_ZOOM);
    }

    public WorldPt getWorldExtents() {
        return new WorldPt(this._min, this._max);
    }

    public double getMin() {
        return this._min;
    }

    public double getMax() {
        return this._max;
    }

    public double getDataMax() {
        return this._dataMax;
    }

    public double getDataMin() {
        return this._dataMin;
    }

    public double getActMin() {
        return this._actmin;
    }

    public double getActMax() {
        return this._actmax;
    }

    public double getMajorTic() {
        return this._majortic;
    }

    public double getMinorTic() {
        return this._minortic;
    }

    public AxisProp getAxisProp() {
        this._axisProp.type = this.getType();
        this._axisProp.actmax = this._actmax;
        this._axisProp.actmin = this._actmin;
        this._axisProp.name = this._name;
        this._axisProp.label = this.getScaledLabel();
        this._axisProp.max = this._max;
        this._axisProp.min = this._min;
        this._axisProp.majortic = this._majortic;
        this._axisProp.minortic = this._minortic;
        this._axisProp.numTicLabelLayers = this._numTicLabelLevels;
        this._axisProp.isReversed = this._isReversed;
        if (this.m_rateAxis) {
            this._axisProp.rateData = this.m_rateAxis;
            this._axisProp.ratingFunction = null;
        } else if (this.m_ratingFunction != null && this.m_ratingFunction instanceof DefaultRatingFunction) {
            DefaultRatingFunction df = (DefaultRatingFunction)this.m_ratingFunction;
            double[][] f = new double[][]{df.getBaseValues(), df.getRatedValues()};
            this._axisProp.ratingFunction = f;
            this._axisProp.rateData = false;
        }
        return this._axisProp;
    }

    public void computeScaling(double min, double max) {
        if (this._localRange <= 0) {
            return;
        }
        double wview = max - min;
        if (wview == 0.0) {
            throw new RuntimeException("WORLD VIEW EQUAL TO ZERO in computeScaling(double,double)");
        }
        this._scale = (double)this._localRange / wview;
        double w = (double)this._localRange / this._scale;
        this._actmin = this._origin - w * 0.5;
        if (this._actmin < this._min) {
            this._actmin = this._min;
            this._origin = this._actmin + w * 0.5;
        }
        this._actmax = this._actmin + w;
        if (this._actmax > this._max) {
            this._actmax = this._max;
            this._origin = this._actmax - w * 0.5;
            this._actmin = this._actmax - w;
        }
        if ((wview = this.getRatedValue(max) - this.getRatedValue(min)) == 0.0) {
            throw new RuntimeException("WORLD VIEW EQUAL TO ZERO in computeScaling(double,double)");
        }
        this._scale = (double)this._localRange / wview;
    }

    public void computeScaling() {
        if (this._localRange <= 0) {
            return;
        }
        double wview = (this._max - this._min) * this._zoom;
        if (wview == 0.0) {
            throw new RuntimeException("WORLD VIEW EQUAL TO ZERO in computeScaling()");
        }
        this._scale = (double)this._localRange / wview;
        double w = (double)this._localRange / this._scale;
        this._actmin = this._origin - w * 0.5;
        if (this._actmin < this._min) {
            this._actmin = this._min;
            this._origin = this._actmin + w * 0.5;
        }
        this._actmax = this._actmin + w;
        if (this._actmax > this._max) {
            this._actmax = this._max;
            this._origin = this._actmax - w * 0.5;
            this._actmin = this._actmax - w;
        }
        if ((wview = (this.getRatedValue(this._max) - this.getRatedValue(this._min)) * this._zoom) == 0.0) {
            throw new RuntimeException("WORLD VIEW EQUAL TO ZERO in computeScaling()");
        }
        this._scale = (double)this._localRange / wview;
    }

    public void computeScaling(int iview) {
        this._localRange = iview;
        this.computeScaling(this._actmin, this._actmax);
    }

    public int w2l(double w) {
        if (this._isReversed) {
            return (int)((this.getRatedValue(this._actmax) - this.getRatedValue(w)) * this._scale);
        }
        return (int)((this.getRatedValue(w) - this.getRatedValue(this._actmin)) * this._scale);
    }

    public double w2lE(double w) {
        if (this._isReversed) {
            return (this.getRatedValue(this._actmax) - this.getRatedValue(w)) * this._scale;
        }
        return (this.getRatedValue(w) - this.getRatedValue(this._actmin)) * this._scale;
    }

    public double l2w(int l) {
        double val = this._isReversed ? this.getRatedValue(this._actmax) - (double)l / this._scale : (double)l / this._scale + this.getRatedValue(this._actmin);
        return this.getUnRatedValue(val);
    }

    public double l2wE(double l) {
        double val = this._isReversed ? this.getRatedValue(this._actmax) - l / this._scale : l / this._scale + this.getRatedValue(this._actmin);
        return this.getUnRatedValue(val);
    }

    public void computeNiceMinMax() {
        double tmin;
        double c2;
        this._thpow = 0.0;
        this._thscl = 1.0;
        double delta = this._dataMax - this._dataMin;
        double l = Math.floor(0.4342944819 * Math.log(delta));
        double b = Math.exp(2.302585093 * l);
        if (b == 0.0) {
            new RuntimeException("B value is 0 in computeTicInterval");
        }
        if ((c2 = delta / b) > 10.0) {
            this._majortic = b * 2.0;
            this._sigfig = (int)(-l + 0.0 + this._thpow);
        } else if (c2 <= 10.0 && c2 > 5.0) {
            this._majortic = b;
            this._sigfig = (int)(-l + 0.0 + this._thpow);
        } else if (c2 <= 5.0 && c2 > 2.5) {
            this._majortic = b * 0.5;
            this._sigfig = (int)(-l + 1.0 + this._thpow);
        } else if (c2 <= 2.5 && c2 > 1.0) {
            this._majortic = b * 0.2;
            this._sigfig = (int)(-l + 1.0 + this._thpow);
        } else if (c2 <= 1.0 && c2 > 0.5) {
            this._majortic = b * 0.1;
            this._sigfig = (int)(-l + 1.0 + this._thpow);
        } else if (c2 <= 0.5 && c2 > 0.25) {
            this._majortic = b * 0.05;
            this._sigfig = (int)(-l + 2.0 + this._thpow);
        } else if (c2 <= 0.25 && c2 > 0.1) {
            this._majortic = b * 0.02;
            this._sigfig = (int)(-l + 2.0 + this._thpow);
        } else if (c2 <= 0.1 && c2 > 0.05) {
            this._majortic = b * 0.01;
            this._sigfig = (int)(-l + 2.0 + this._thpow);
        } else {
            this._majortic = b;
            this._sigfig = (int)(-l + 0.0 + this._thpow);
        }
        if (this._sigfig < 0) {
            this._sigfig = 0;
        }
        try {
            this._majortic = Double.parseDouble(RMAIO.setPrecision2(this._majortic, this._sigfig));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (!this._axisProp.autocomputeMajorTics) {
            this._majortic = this._axisProp.majortic;
        }
        this._min = (tmin = (double)((long)(this._dataMin / this._majortic)) * this._majortic) <= this._dataMin ? tmin : tmin - this._majortic;
        double tmax = (double)((long)(this._dataMax / this._majortic)) * this._majortic;
        this._max = tmax >= this._dataMax ? tmax : tmax + this._majortic;
    }

    public void computeTicInterval() {
        double c2;
        this._thpow = 0.0;
        this._thscl = 1.0;
        double delta = this._actmax - this._actmin;
        double l = Math.floor(0.4342944819 * Math.log(delta));
        double b = Math.exp(2.302585093 * l);
        if (b == 0.0) {
            new RuntimeException("B value is 0 in computeTicInterval");
        }
        if ((c2 = delta / b) > 10.0) {
            this._majortic = b * 2.0;
            this._minortic = b * 0.5;
            this._sigfig = (int)(-l + 0.0 + this._thpow);
        } else if (c2 <= 10.0 && c2 > 5.0) {
            this._majortic = b;
            this._minortic = b * 0.2;
            this._sigfig = (int)(-l + 0.0 + this._thpow);
        } else if (c2 <= 5.0 && c2 > 2.0) {
            this._majortic = b * 0.5;
            this._minortic = b * 0.1;
            this._sigfig = (int)(-l + 1.0 + this._thpow);
        } else if (c2 <= 2.0 && c2 > 1.0) {
            this._majortic = b * 0.2;
            this._minortic = b * 0.05;
            this._sigfig = (int)(-l + 1.0 + this._thpow);
        } else if (c2 <= 1.0 && c2 > 0.5) {
            this._majortic = b * 0.1;
            this._minortic = b * 0.02;
            this._sigfig = (int)(-l + 1.0 + this._thpow);
        } else if (c2 <= 0.5 && c2 > 0.2) {
            this._majortic = b * 0.05;
            this._minortic = b * 0.01;
            this._sigfig = (int)(-l + 2.0 + this._thpow);
        } else if (c2 <= 0.2 && c2 > 0.1) {
            this._majortic = b * 0.02;
            this._minortic = b * 0.005;
            this._sigfig = (int)(-l + 2.0 + this._thpow);
        } else if (c2 <= 0.1 && c2 > 0.05) {
            this._majortic = b * 0.01;
            this._minortic = b * 0.002;
            this._sigfig = (int)(-l + 2.0 + this._thpow);
        } else {
            this._majortic = b;
            this._minortic = b * 0.25;
            this._sigfig = (int)(-l + 0.0 + this._thpow);
        }
        if (this._sigfig < 0) {
            this._sigfig = 0;
        }
        this._majortic = RMAIO.parseDouble(RMAIO.setPrecision2(this._majortic, this._sigfig), 2.0);
        this._minortic = RMAIO.parseDouble(RMAIO.setPrecision2(this._minortic, this._sigfig), 0.5);
        if (!this._axisProp.autocomputeMajorTics) {
            this._majortic = this._axisProp.majortic;
        }
        if (!this._axisProp.autocomputeMinorTics) {
            this._minortic = this._axisProp.minortic;
        }
    }

    public Color getTicColor() {
        return this._ticColor;
    }

    public String getTicColorString() {
        return RmaColor.color2String(this._ticColor);
    }

    public void setTicColor(String colorString) {
        this.setTicColor(RmaColor.parseColorString(colorString));
    }

    public void setTicColor(Color c2) {
        this._ticColor = c2;
    }

    public Color getTicTextColor() {
        return this._ticTextColor;
    }

    public String getTicTextColorString() {
        return RmaColor.color2String(this._ticTextColor);
    }

    public void setTicTextColor(String colorString) {
        this.setTicTextColor(RmaColor.parseColorString(colorString));
    }

    public void setTicTextColor(Color c2) {
        this._ticTextColor = c2;
    }

    public void setUseDefaultLimitsOn() {
        this._axisProp.isDefaultLimits = true;
    }

    public void setUseDefaultLimitsOff() {
        this._axisProp.isDefaultLimits = false;
    }

    public boolean isUsingDefaultLimits() {
        return this._axisProp.isDefaultLimits;
    }

    public void setMinimumLimit(double min) {
        this._axisProp.setMinScaleValue(min);
        this._min = min;
    }

    public void setMaximumLimit(double max) {
        this._axisProp.setMaxScaleValue(max);
        this._max = max;
    }

    public void setMajorTicInterval(double interval) {
        this._axisProp.setMajorTicInterval(interval);
        this._majortic = interval;
    }

    public void setMinorTicInterval(double interval) {
        this._axisProp.setMinorTicInterval(interval);
        this._minortic = interval;
    }

    public void setNumberOfTicLabelLayers(int layers) {
        this._axisProp.setNumTicLevels(layers);
    }

    public void setActualMaximumValue(double value) {
        this._axisProp.setActualMaxScaleValue(value);
        this._actmax = value;
    }

    public void setOrigin(double origin) {
        this._origin = origin;
    }

    public void setActualMinimumValue(double value) {
        this._axisProp.setActualMinScaleValue(value);
        this._actmin = value;
    }

    public void setAutomaticMaximumOn() {
        this._axisProp.setAutomaticMax(true);
    }

    public void setAutomaticMaximumOff() {
        this._axisProp.setAutomaticMax(false);
    }

    public void setAutomaticMinimumOn() {
        this._axisProp.setAutomaticMin(true);
    }

    public boolean isUsingAutomaticMinimum() {
        return this._axisProp.automin;
    }

    public void setAutomaticMinimumOff() {
        this._axisProp.setAutomaticMin(false);
    }

    public void setAutomaticViewMaximumOn() {
        this._axisProp.setAutomaticViewMax(true);
    }

    public boolean isUsingAutomaticMaximum() {
        return this._axisProp.automax;
    }

    public void setAutomaticViewMaximumOff() {
        this._axisProp.setAutomaticViewMax(false);
    }

    public boolean isUsingAutomaticViewMaximum() {
        return this._axisProp.autoviewmax;
    }

    public void setAutomaticViewMinimumOn() {
        this._axisProp.setAutomaticViewMin(true);
    }

    public void setAutomaticViewMinimumOff() {
        this._axisProp.setAutomaticViewMin(false);
    }

    public boolean isUsingAutomaticViewMinimum() {
        return this._axisProp.autoviewmin;
    }

    public void setComputeMajorTics(boolean state) {
        this._axisProp.setAutoComputeMajorTics(state);
    }

    @Deprecated
    public void setComputeMajorTicsOn() {
        this.setComputeMajorTics(true);
    }

    @Deprecated
    public void setComputeMajorTicsOff() {
        this.setComputeMajorTics(false);
    }

    public boolean isComputingMajorTics() {
        return this._axisProp.autocomputeMajorTics;
    }

    public void setComputeMinorTics(boolean state) {
        this._axisProp.setAutoComputeMinorTics(state);
    }

    @Deprecated
    public void setComputeMinorTicsOn() {
        this.setComputeMinorTics(true);
    }

    @Deprecated
    public void setComputeMinorTicsOff() {
        this.setComputeMinorTics(false);
    }

    public boolean isComputingMinorTics() {
        return this._axisProp.autocomputeMinorTics;
    }

    public void growToGlyphBounds(double min, double max) {
        double vmax = this._axisProp.automax ? max : this._axisProp.max;
        double vmin = this._axisProp.automin ? min : this._axisProp.min;
        this.growWorldExtents(vmin, vmax);
        vmax = !this._axisProp.autoviewmax ? this._axisProp.actmax : this._actmax;
        vmin = !this._axisProp.autoviewmin ? this._axisProp.actmin : this._actmin;
        this.zoomInUnMod(vmin, vmax);
    }

    public void setUnit(String unit) {
        this._unit = unit;
    }
}

