/*
 * Decompiled with CFR 0.152.
 */
package hec.geometry;

import hec.geometry.Axis;
import hec.geometry.AxisIterator;
import hec.geometry.CategoryAxis;
import hec.geometry.LogAxis;
import hec.geometry.LogAxisIterator;
import hec.geometry.ProbabilityAxis;
import hec.geometry.ProbabilityAxisIterator;
import hec.geometry.SeasonalAxis;
import hec.geometry.SeasonalAxisIterator;
import hec.geometry.TSAxis;
import hec.geometry.TSAxisIterator;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import rma.util.lookup.Lookup;

public class AxisFactory {
    static Map<Axis, AxisFactoryService> factoryServiceLookup = new HashMap<Axis, AxisFactoryService>();

    public static Axis createAxis(int type, String n) {
        if (type == 0) {
            return new Axis(n);
        }
        if (type == 1) {
            return new TSAxis(n);
        }
        if (type == 2) {
            return new SeasonalAxis(n);
        }
        if (type == 3) {
            return new LogAxis(n);
        }
        if (type == 4) {
            return new ProbabilityAxis(n);
        }
        if (type == 5) {
            return new CategoryAxis(n);
        }
        Collection lookupAll = Lookup.getDefault().lookupAll(AxisFactoryService.class);
        for (AxisFactoryService axisFactoryService : lookupAll) {
            Optional<Axis> createAxis = axisFactoryService.createAxis(type, n);
            if (!createAxis.isPresent()) continue;
            Axis axis = createAxis.get();
            factoryServiceLookup.put(axis, axisFactoryService);
            return axis;
        }
        return null;
    }

    public static AxisIterator createAxisIterator(Axis ax, double del) {
        Optional<AxisIterator> iterator;
        AxisFactoryService afService = factoryServiceLookup.get(ax);
        if (afService != null && (iterator = afService.createAxisIterator(ax, del)).isPresent()) {
            return iterator.get();
        }
        Collection lookupAll = Lookup.getDefault().lookupAll(AxisFactoryService.class);
        for (AxisFactoryService axisFactoryService : lookupAll) {
            Optional<AxisIterator> iterator2 = axisFactoryService.createAxisIterator(ax, del);
            if (!iterator2.isPresent()) continue;
            return iterator2.get();
        }
        if (ax instanceof TSAxis) {
            return new TSAxisIterator((TSAxis)ax, del);
        }
        if (ax instanceof SeasonalAxis) {
            return new SeasonalAxisIterator((TSAxis)((SeasonalAxis)ax), del);
        }
        if (ax instanceof LogAxis) {
            return new LogAxisIterator((LogAxis)ax, del);
        }
        if (ax instanceof ProbabilityAxis) {
            return new ProbabilityAxisIterator((ProbabilityAxis)ax, del);
        }
        return new AxisIterator(ax, del);
    }

    public static interface AxisFactoryService {
        public Optional<Axis> createAxis(int var1, String var2);

        public Optional<AxisIterator> createAxisIterator(Axis var1, double var2);
    }
}

