/*
 * Decompiled with CFR 0.152.
 */
package hec.geometry;

import hec.geometry.Axis;
import rma.util.RMAIO;

public class AxisIterator {
    Axis _axis;
    double _delta = 1.0;
    double _curval = 0.0;
    double _min = 0.0;
    double _max = 1.0;
    double _thscl = 1.0;
    int _sigfig = 0;

    public AxisIterator(Axis ax, double del) {
        if (del == 0.0) {
            del = 0.1;
        }
        this._axis = ax;
        this._delta = del;
        this.reset();
    }

    public void iterateMinorScale() {
    }

    public void reset() {
        this._min = this._axis.getActMin();
        this._max = this._axis.getActMax();
        this._thscl = this._axis.getThousScale();
        this.computeSigFigures();
        double istart = Math.ceil(this._min / this._delta) - 1.0;
        this._curval = istart * this._delta;
    }

    public int getSigFig() {
        return this._sigfig;
    }

    private void computeSigFigures() {
        double c2;
        double l = Math.floor(0.4342944819 * Math.log(this._delta));
        double b = Math.exp(2.302585093 * l);
        if (b == 0.0) {
            new RuntimeException("B value is 0 in computeTicInterval");
        }
        this._sigfig = (c2 = this._delta / b) > 10.0 ? (int)(-l + 0.0) : (c2 <= 10.0 && c2 >= 5.0 ? (int)(-l + 0.0) : (c2 < 5.0 && c2 > 1.0 ? (int)(-l + 1.0) : (c2 <= 1.0 && c2 >= 0.5 ? (int)(-l + 2.0) : (c2 < 0.05 && c2 > 0.1 ? (int)(-l + 2.0) : (c2 < 0.01 && c2 > 0.005 ? (int)(-l + 2.0) : (int)(-l + 0.0))))));
        if (this._sigfig < 0) {
            this._sigfig = 0;
        }
    }

    public double getInterval() {
        return this._delta;
    }

    public void setInterval(double del) {
        if (del == 0.0) {
            del = 0.1;
        }
        this._delta = del;
        this.reset();
    }

    public void setLocalInterval(int del) {
        if (del == 0) {
            del = 1;
        }
        this._delta = this._axis.l2w(del);
        this.reset();
    }

    public boolean next() {
        this._curval += this._delta;
        return !(this._curval > this._max);
    }

    public double getValue() {
        return this._curval;
    }

    public double getScaledValue() {
        return this._curval / this._thscl;
    }

    public int getLocalValue() {
        return this._axis.w2l(this._curval);
    }

    public int getLocalInterval() {
        return Math.abs(this._axis.w2l(this._curval + this._delta) - this._axis.w2l(this._curval));
    }

    public String getValueString() {
        return RMAIO.setPrecision2(this._curval / this._thscl, this._sigfig);
    }
}

