/*
 * Decompiled with CFR 0.152.
 */
package hec.geometry;

import hec.geometry.ScaleProperties;
import hec.gfx2d.PropertiesSerializer;
import hec.io.AsciiSerializable;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.lang.reflect.Field;
import java.util.StringTokenizer;
import rma.util.RMAIO;

public class AxisProp
implements ScaleProperties,
AsciiSerializable {
    private static final String DEFAULT_NAME = new String();
    private static final String DEFAULT_LABEL = null;
    private static final boolean IS_DEFAULT_LIMITS = true;
    private static final double DEFAULT_MIN = 1.0;
    private static final double DEFAULT_MAX = 10.0;
    public static final boolean DEFAULT_IS_REVERSED = false;
    private static final double DEFAULT_MAJORTIC_INTERVAL = 10.0;
    private static final double DEFAULT_MINORTIC_INTERVAL = 1.0;
    private static final int DEFAULT_AXIS_TYPE = 0;
    private static final int DEFAULT_NUM_TIC_LAYERS = -1;
    private static final double DEFAULT_ACT_MIN = 1.0;
    private static final double DEFAULT_ACT_MAX = 10.0;
    private static final boolean DEFAULT_AUTO_MAX = true;
    private static final boolean DEFAULT_AUTO_MIN = true;
    private static final boolean DEFAULT_AUTOVIEW_MAX = true;
    private static final boolean DEFAULT_AUTOVIEW_MIN = true;
    private static final boolean DEFAULT_AUTOCOMPUTE_MAJOR_TIC = true;
    private static final boolean DEFAULT_AUTOCOMPUTE_MINOR_TIC = true;
    public String name = DEFAULT_NAME;
    public String label = null;
    public boolean isDefaultLimits = true;
    public double min = 1.0;
    public double max = 10.0;
    public boolean isReversed = false;
    public double majortic = 10.0;
    public double minortic = 1.0;
    public int type = 0;
    public int numTicLabelLayers = -1;
    public double actmax = 10.0;
    public double actmin = 1.0;
    public boolean automax = true;
    public boolean automin = true;
    public boolean autoviewmax = true;
    public boolean autoviewmin = true;
    public boolean autocomputeMajorTics = true;
    public boolean autocomputeMinorTics = true;
    public double[][] ratingFunction = null;
    public boolean rateData = false;
    public boolean swapAxis;
    public boolean canSwapAxis = false;

    public AxisProp() {
    }

    public AxisProp(AxisProp dp) {
        this.set(dp);
    }

    @Override
    public boolean canSwapXYAxis() {
        return this.canSwapAxis;
    }

    @Override
    public boolean swapXYAxis() {
        return this.swapAxis;
    }

    @Override
    public void setSwapXYAxis(boolean b) {
        this.swapAxis = b;
    }

    public void writeProperties(BufferedWriter writer, String endTag) {
        if (writer == null) {
            return;
        }
        PropertiesSerializer.incrementRecursion();
        String indent = PropertiesSerializer.getIndent();
        if (this.name != DEFAULT_NAME) {
            RMAIO.fout(writer, indent + "name=" + this.name);
        }
        if (this.label != DEFAULT_LABEL && this.label != null) {
            RMAIO.fout(writer, indent + "label=" + this.label);
        }
        if (!this.isDefaultLimits) {
            RMAIO.fout(writer, indent + "isDefaultLimits=" + this.isDefaultLimits);
        }
        if (this.min != 1.0) {
            RMAIO.fout(writer, indent + "min=" + this.min);
        }
        if (this.max != 10.0) {
            RMAIO.fout(writer, indent + "max=" + this.max);
        }
        if (this.isReversed) {
            RMAIO.fout(writer, indent + "isReversed=" + this.isReversed);
        }
        if (this.majortic != 10.0) {
            RMAIO.fout(writer, indent + "majortic=" + this.majortic);
        }
        if (this.minortic != 1.0) {
            RMAIO.fout(writer, indent + "minortic=" + this.minortic);
        }
        if (this.type != 0) {
            RMAIO.fout(writer, indent + "type=" + this.type);
        }
        if (this.numTicLabelLayers != -1) {
            RMAIO.fout(writer, indent + "numTicLabelLayers=" + this.numTicLabelLayers);
        }
        if (this.actmax != 10.0) {
            RMAIO.fout(writer, indent + "actmax=" + this.actmax);
        }
        if (this.actmin != 1.0) {
            RMAIO.fout(writer, indent + "actmin=" + this.actmin);
        }
        if (!this.automax) {
            RMAIO.fout(writer, indent + "automax=" + this.automax);
        }
        if (!this.automin) {
            RMAIO.fout(writer, indent + "automin=" + this.automin);
        }
        if (!this.autoviewmax) {
            RMAIO.fout(writer, indent + "autoviewmax=" + this.autoviewmax);
        }
        if (!this.autoviewmin) {
            RMAIO.fout(writer, indent + "autoviewmin=" + this.autoviewmin);
        }
        if (!this.autocomputeMajorTics) {
            RMAIO.fout(writer, indent + "autocomputeMajorTics=" + this.autocomputeMajorTics);
        }
        if (!this.autocomputeMinorTics) {
            RMAIO.fout(writer, indent + "autocomputeMinorTics=" + this.autocomputeMinorTics);
        }
        if (this.ratingFunction != null) {
            StringBuffer buff = new StringBuffer();
            for (int i = 0; i < this.ratingFunction.length; ++i) {
                buff.append(i == 0 ? "RatingX=" : "RatingY=");
                for (int j = 0; j < this.ratingFunction[0].length; ++j) {
                    buff.append(this.ratingFunction[i == 0 ? 1 : 0][j]);
                    buff.append(',');
                }
                buff = new StringBuffer(buff.substring(0, buff.length() - 1));
                buff.append("\n").append(indent);
            }
            if (buff != null) {
                RMAIO.fout(writer, indent + buff.substring(0, buff.length() - 1));
            }
        }
        if (this.rateData) {
            RMAIO.fout(writer, indent + "RateVsLeftAxis=" + Boolean.toString(this.rateData));
        }
        PropertiesSerializer.decrementRecursion();
        indent = PropertiesSerializer.getIndent();
        RMAIO.fout(writer, indent + endTag);
    }

    public void readProperties(BufferedReader in, String endTag) {
        if (in == null) {
            return;
        }
        String line = "";
        String param = "";
        String type = "";
        try {
            while ((line = in.readLine()) != null) {
                line.trim();
                param = RMAIO.getParam(line, "=");
                type = RMAIO.getType(line, "=");
                if (!type.equalsIgnoreCase(endTag)) {
                    if (type.equalsIgnoreCase("name")) {
                        this.name = param;
                        continue;
                    }
                    if (type.equalsIgnoreCase("label")) {
                        this.label = param;
                        continue;
                    }
                    if (type.equalsIgnoreCase("isDefaultLimits")) {
                        this.isDefaultLimits = Boolean.valueOf(param);
                        continue;
                    }
                    if (type.equalsIgnoreCase("min")) {
                        this.min = Double.valueOf(param);
                        this.isDefaultLimits = false;
                        continue;
                    }
                    if (type.equalsIgnoreCase("max")) {
                        this.max = Double.valueOf(param);
                        this.isDefaultLimits = false;
                        continue;
                    }
                    if (type.equalsIgnoreCase("isReversed")) {
                        this.isReversed = Boolean.valueOf(param);
                        continue;
                    }
                    if (type.equalsIgnoreCase("majortic")) {
                        this.majortic = Double.valueOf(param);
                        continue;
                    }
                    if (type.equalsIgnoreCase("minortic")) {
                        this.minortic = Double.valueOf(param);
                        continue;
                    }
                    if (type.equalsIgnoreCase("type")) {
                        this.type = Integer.valueOf(param);
                        continue;
                    }
                    if (type.equalsIgnoreCase("numTicLabelLayers")) {
                        this.numTicLabelLayers = Integer.valueOf(param);
                        if (this.numTicLabelLayers >= 0 && this.numTicLabelLayers <= 3) continue;
                        this.numTicLabelLayers = 2;
                        continue;
                    }
                    if (type.equalsIgnoreCase("actmax")) {
                        this.actmax = Double.valueOf(param);
                        this.isDefaultLimits = false;
                        continue;
                    }
                    if (type.equalsIgnoreCase("actmin")) {
                        this.actmin = Double.valueOf(param);
                        this.isDefaultLimits = false;
                        continue;
                    }
                    if (type.equalsIgnoreCase("automax")) {
                        this.automax = Boolean.valueOf(param);
                        continue;
                    }
                    if (type.equalsIgnoreCase("automin")) {
                        this.automin = Boolean.valueOf(param);
                        continue;
                    }
                    if (type.equalsIgnoreCase("autoviewmax")) {
                        this.autoviewmax = Boolean.valueOf(param);
                        continue;
                    }
                    if (type.equalsIgnoreCase("autoviewmin")) {
                        this.autoviewmin = Boolean.valueOf(param);
                        continue;
                    }
                    if (type.equalsIgnoreCase("autocomputeMajorTics")) {
                        this.autocomputeMajorTics = Boolean.valueOf(param);
                        continue;
                    }
                    if (type.equalsIgnoreCase("autocomputeMinorTics")) {
                        this.autocomputeMinorTics = Boolean.valueOf(param);
                        continue;
                    }
                    if (type.equalsIgnoreCase("RatingX")) {
                        this.readRatingFunction(in, line);
                        continue;
                    }
                    if (!type.equalsIgnoreCase("RateVsLeftAxis")) continue;
                    this.rateData = Boolean.valueOf(param);
                    this.ratingFunction = null;
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            System.out.println("Error in readProperties(BufferedReader)");
            return;
        }
    }

    public void readRatingFunction(BufferedReader reader, String line) {
        String param = RMAIO.getParam(line, "=");
        StringTokenizer strTok = new StringTokenizer(param, ",", false);
        double[][] f = new double[2][strTok.countTokens()];
        int ctr = 0;
        while (strTok.hasMoreTokens()) {
            f[1][ctr++] = RMAIO.parseDouble(strTok.nextToken());
        }
        try {
            line = reader.readLine();
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            this.ratingFunction = null;
            this.rateData = false;
            return;
        }
        param = RMAIO.getParam(line, "=");
        strTok = new StringTokenizer(param, ",", false);
        ctr = 0;
        while (strTok.hasMoreTokens() && ctr < f[1].length) {
            f[0][ctr++] = RMAIO.parseDouble(strTok.nextToken());
        }
        this.ratingFunction = f;
        this.rateData = false;
    }

    public Object getClone() {
        try {
            return this.clone();
        }
        catch (CloneNotSupportedException e) {
            return new AxisProp(this);
        }
    }

    public void set(AxisProp dp) {
        this.name = dp.name;
        this.label = dp.label;
        this.isDefaultLimits = dp.isDefaultLimits;
        this.min = dp.min;
        this.max = dp.max;
        this.isReversed = dp.isReversed;
        this.majortic = dp.majortic;
        this.minortic = dp.minortic;
        this.type = dp.type;
        this.numTicLabelLayers = dp.numTicLabelLayers;
        this.automax = dp.automax;
        this.automin = dp.automin;
        this.actmax = dp.actmax;
        this.actmin = dp.actmin;
        this.autoviewmax = dp.autoviewmax;
        this.autoviewmin = dp.autoviewmin;
        this.autocomputeMajorTics = dp.autocomputeMajorTics;
        this.autocomputeMinorTics = dp.autocomputeMinorTics;
        this.rateData = dp.rateData;
        this.ratingFunction = dp.ratingFunction;
    }

    @Override
    public double getMajorTicInterval() {
        return this.majortic;
    }

    @Override
    public double getMaxScaleValue() {
        return this.max;
    }

    @Override
    public double getMinScaleValue() {
        return this.min;
    }

    @Override
    public double getMinorTicInterval() {
        return this.minortic;
    }

    @Override
    public void setMajorTicInterval(double interval) {
        this.majortic = interval;
    }

    @Override
    public void setMaxScaleValue(double val) {
        this.max = val;
        if (this.max < this.actmax) {
            this.actmax = val;
        }
    }

    @Override
    public void setMinScaleValue(double val) {
        this.min = val;
        if (this.min > this.actmin) {
            this.actmin = val;
        }
    }

    @Override
    public void setMinorTicInterval(double interval) {
        this.minortic = interval;
    }

    @Override
    public void setActualMaxScaleValue(double val) {
        this.actmax = val;
        if (this.actmax > this.max) {
            this.actmax = this.max;
        }
    }

    @Override
    public void setActualMinScaleValue(double val) {
        this.actmin = val;
        if (this.actmin < this.min) {
            this.actmin = this.min;
        }
    }

    @Override
    public double getActualMinScaleValue() {
        return this.actmin;
    }

    @Override
    public double getActualMaxScaleValue() {
        return this.actmax;
    }

    @Override
    public boolean isAutomaticMin() {
        return this.automin;
    }

    @Override
    public boolean isAutomaticMax() {
        return this.automax;
    }

    @Override
    public void setAutomaticMin(boolean m) {
        this.automin = m;
    }

    @Override
    public void setAutomaticMax(boolean m) {
        this.automax = m;
    }

    @Override
    public boolean isAutomaticViewMax() {
        return this.autoviewmax;
    }

    @Override
    public boolean isAutomaticViewMin() {
        return this.autoviewmin;
    }

    @Override
    public void setAutomaticViewMax(boolean m) {
        this.autoviewmax = m;
    }

    @Override
    public void setAutomaticViewMin(boolean m) {
        this.autoviewmin = m;
    }

    @Override
    public boolean isReversed() {
        return this.isReversed;
    }

    @Override
    public void setReversed(boolean m) {
        this.isReversed = m;
    }

    @Override
    public boolean isAutoComputeMajorTics() {
        return this.autocomputeMajorTics;
    }

    @Override
    public boolean isAutoComputeMinorTics() {
        return this.autocomputeMinorTics;
    }

    @Override
    public void setAutoComputeMajorTics(boolean m) {
        this.autocomputeMajorTics = m;
    }

    @Override
    public void setAutoComputeMinorTics(boolean m) {
        this.autocomputeMinorTics = m;
    }

    @Override
    public int getNumTicLevels() {
        return this.numTicLabelLayers;
    }

    @Override
    public void setNumTicLevels(int level) {
        if (level < 1 || level > 3) {
            return;
        }
        this.numTicLabelLayers = level;
    }

    @Override
    public Object getFieldObject(Field fld) {
        try {
            Object obj = fld.get(this);
            return obj;
        }
        catch (IllegalAccessException e) {
            return null;
        }
    }

    @Override
    public boolean setFieldObject(Field fld, Object fobj) {
        try {
            fld.set(this, fobj);
            return true;
        }
        catch (IllegalAccessException e) {
            return false;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }
}

