/*
 * Decompiled with CFR 0.152.
 */
package hec.geometry;

import hec.geometry.DefaultRatingFunction;
import hec.geometry.WorldRect;
import hec.gfx2d.G2dData;
import hec.gfx2d.G2dObject;
import java.util.Hashtable;
import rma.lang.RmaMath;
import rma.util.RMAConst;
import rma.util.RMASort;

public class DataObjectRating
extends DefaultRatingFunction {
    public DataObjectRating(G2dObject baseValue, G2dObject ratedValue) {
        this.computeRating(baseValue, ratedValue);
    }

    private void computeRating(G2dObject baseValue, G2dObject ratedValue) {
        double[] baseValuesX = baseValue.getXValues();
        double[] baseValuesY = baseValue.getYValues(0);
        if (baseValuesX == null || baseValuesY == null) {
            return;
        }
        double[] ratedValuesX = ratedValue.getXValues();
        double[] ratedValuesY = ratedValue.getYValues(0);
        if (ratedValuesX == null || ratedValuesY == null) {
            return;
        }
        double[] timet = new double[ratedValuesX.length + baseValuesX.length];
        double[] newBaseValues = new double[ratedValuesX.length + baseValuesX.length];
        double[] newRatedValues = new double[ratedValuesX.length + baseValuesX.length];
        int ptr1 = 0;
        int ptr2 = 0;
        int i = 0;
        Hashtable duplicates = new Hashtable();
        int numUniqueItems = 0;
        for (i = 0; i < timet.length && (ptr1 < baseValuesX.length || ptr2 < ratedValuesX.length); ++i) {
            double value;
            if (ptr1 >= baseValuesX.length || ratedValuesX[ptr2] < baseValuesX[ptr1]) {
                timet[i] = ratedValuesX[ptr2];
                if (!this.checkDuplicate(duplicates, ratedValuesY[ptr2])) {
                    newRatedValues[numUniqueItems] = value = RMAConst.isValidValue(ratedValuesY[ptr2]) ? ratedValuesY[ptr2] : Double.MIN_VALUE;
                    newBaseValues[numUniqueItems] = Double.MIN_VALUE;
                    ++numUniqueItems;
                }
                ++ptr2;
                continue;
            }
            if (ptr2 >= ratedValuesX.length || ratedValuesX[ptr2] > baseValuesX[ptr1]) {
                timet[i] = baseValuesX[ptr1];
                if (!this.checkDuplicate(duplicates, baseValuesY[ptr1])) {
                    value = RMAConst.isValidValue(baseValuesY[ptr2]) ? baseValuesY[ptr2] : Double.MIN_VALUE;
                    newRatedValues[numUniqueItems] = Double.MIN_VALUE;
                    newBaseValues[numUniqueItems] = value;
                    ++numUniqueItems;
                }
                ++ptr1;
                continue;
            }
            timet[i] = baseValuesX[ptr1];
            if (!this.checkDuplicate(duplicates, baseValuesY[ptr1])) {
                newRatedValues[numUniqueItems] = value = RMAConst.isValidValue(ratedValuesY[ptr2]) ? ratedValuesY[ptr2] : Double.MIN_VALUE;
                newBaseValues[numUniqueItems] = value = RMAConst.isValidValue(baseValuesY[ptr1]) ? baseValuesY[ptr1] : Double.MIN_VALUE;
                ++numUniqueItems;
            }
            ++ptr1;
            ++ptr2;
        }
        if (numUniqueItems < timet.length) {
            timet = this.shortenArrays(timet, numUniqueItems);
            newRatedValues = this.shortenArrays(newRatedValues, numUniqueItems);
            newBaseValues = this.shortenArrays(newBaseValues, numUniqueItems);
        }
        this.fillInMissingValues(timet, newBaseValues, Double.MIN_VALUE);
        this.fillInMissingValues(timet, newRatedValues, Double.MIN_VALUE);
        this.m_baseValues = newBaseValues;
        this.m_ratedValues = newRatedValues;
        RMASort.quickSort(this.m_baseValues, this.m_ratedValues, true);
    }

    private boolean checkDuplicate(Hashtable duplicates, double v) {
        Double d = new Double(v);
        if (duplicates.get(d) == null) {
            duplicates.put(d, d);
            return false;
        }
        return true;
    }

    private void fillInMissingValues(double[] baseValues, double[] interpValues, double missing) {
        for (int i = 0; i < baseValues.length; ++i) {
            if (interpValues[i] != missing) continue;
            int index1 = this.findPreviousGoodIndex(interpValues, i, missing);
            int index2 = this.findNextGoodIndex(interpValues, i, missing);
            double x1 = index1 != -1 ? baseValues[index1] : baseValues[i];
            double x2 = index2 != -1 ? baseValues[index2] : baseValues[i];
            double y1 = index1 != -1 ? interpValues[index1] : 0.0;
            double y2 = index2 != -1 ? interpValues[index2] : 0.0;
            interpValues[i] = RmaMath.linearInterpolate(x1, y1, x2, y2, baseValues[i]);
        }
    }

    private int findNextGoodIndex(double[] values, int start, double missing) {
        for (int i = start; i < values.length; ++i) {
            if (values[i] == missing) continue;
            return i;
        }
        return -1;
    }

    private int findPreviousGoodIndex(double[] values, int start, double missing) {
        for (int i = start; i >= 0; --i) {
            if (values[i] == missing) continue;
            return i;
        }
        return -1;
    }

    public double[] shortenArrays(double[] input, int newSize) {
        double[] temp = input;
        input = new double[newSize];
        System.arraycopy(temp, 0, input, 0, newSize);
        return input;
    }

    public static void main(String[] args) {
        double[] x1 = new double[]{1.0, 3.0, 5.0, 7.0, 9.0, 11.0, 13.0, 15.0};
        double[] x2 = new double[]{2.0, 4.0, 6.0, 8.0, 10.0, 12.0, 14.0, 16.0};
        double[] y1 = new double[]{10.0, 20.0, 30.0, 40.0, 50.0, 60.0, 70.0, 80.0};
        double[] y2 = new double[]{15.0, 25.0, 35.0, 45.0, 55.0, 65.0, 75.0, 85.0};
        DataObjectRating do2 = new DataObjectRating(new TestObject(x1, y1), new TestObject(x2, y2));
    }

    public static class TestObject
    extends G2dData {
        double[] m_x;
        double[] m_y;

        public TestObject(double[] x, double[] y) {
            this.m_x = x;
            this.m_y = y;
        }

        @Override
        public void load() {
        }

        @Override
        public WorldRect getBounds() {
            return null;
        }

        @Override
        public void unload() {
        }

        @Override
        public int getYAxisType() {
            return 0;
        }

        @Override
        public int getXAxisType() {
            return 0;
        }

        @Override
        public String getYAxisName() {
            return null;
        }

        @Override
        public String getXAxisName() {
            return null;
        }

        @Override
        public double[] getXValues() {
            return this.m_x;
        }

        @Override
        public double[] getYValues(int curveNum) {
            return this.m_y;
        }
    }
}

